/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.FileDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.OCLExpander;
import org.tigris.gef.ocl.TemplateReader;

public class CmdSavePGML
extends Cmd
implements FilenameFilter {
    private static final long serialVersionUID = 5595884484082379585L;
    private static OCLExpander _expander = null;

    public CmdSavePGML() {
        super("SaveAsPGML");
    }

    public CmdSavePGML(String filterPattern) {
        this();
        this.setArg("filterPattern", filterPattern);
    }

    @Override
    public void doIt() {
        try {
            _expander = new OCLExpander(TemplateReader.getInstance().read("/org/tigris/gef/xml/dtd/PGML.tee"));
            Editor ce = Globals.curEditor();
            Diagram d = new Diagram("junk", ce.getGraphModel(), (LayerPerspective)ce.getLayerManager().getActiveLayer());
            FileDialog fd = new FileDialog(ce.findFrame(), "Save Diagram in PGML format", 1);
            fd.setFilenameFilter(this);
            fd.setDirectory(Globals.getLastDirectory());
            fd.setVisible(true);
            String filename = fd.getFile();
            String path = fd.getDirectory();
            Globals.setLastDirectory(path);
            if (filename != null) {
                Globals.showStatus("Writing " + path + filename + "...");
                FileWriter fw = new FileWriter(path + filename);
                System.out.println("Cmd save in PGML...");
                _expander.expand(fw, (Object)d);
                System.out.println("save done");
                Globals.showStatus("Wrote " + path + filename);
                fw.close();
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
            ignore.printStackTrace();
        }
        catch (ExpansionException e) {
            System.out.println("got an Exception");
            e.printStackTrace();
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        System.out.println("checking: " + dir + " " + name);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSave");
    }
}

