/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.util.List;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdSelectNext
extends Cmd {
    private static final long serialVersionUID = -5038323715965138457L;
    public static final String DIR = "Direction";
    public static final String DIR_NEXT = "Next";
    public static final String DIR_PREV = "Previous";

    public CmdSelectNext() {
        this(true);
    }

    public CmdSelectNext(boolean next) {
        this(next ? DIR_NEXT : DIR_PREV);
    }

    public CmdSelectNext(String d) {
        super("Select" + d);
        this.setArg(DIR, d);
    }

    @Override
    public void doIt() {
        Fig newFig = null;
        int offset = 1;
        String dir = (String)this.getArg(DIR);
        if (DIR_PREV.equals(dir)) {
            offset = -1;
        }
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        List diagramContents = ce.getLayerManager().getContents();
        int diagramSize = diagramContents.size();
        int newIndex = diagramSize + 1;
        if (sm.size() == 0) {
            newIndex = 0;
        } else if (sm.size() == 1) {
            Selection curSel = (Selection)sm.selections().firstElement();
            Fig curFig = curSel.getContent();
            int curIndex = diagramContents.indexOf(curFig);
            newIndex = (curIndex + offset + diagramSize) % diagramSize;
        }
        if (diagramSize > newIndex) {
            newFig = (Fig)diagramContents.get(newIndex);
        }
        if (newFig != null) {
            ce.getSelectionManager().select(newFig);
        }
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSelectNext");
    }
}

