/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.util.Localizer;

public class CopyAction
extends AbstractAction {
    private static final long serialVersionUID = 8686090256848797031L;

    public CopyAction() {
    }

    public CopyAction(String name) {
        this(name, false);
    }

    public CopyAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public CopyAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public CopyAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Editor ce = Globals.curEditor();
        Vector copiedElements = ce.getSelectionManager().selections();
        Vector<Fig> figs = new Vector<Fig>();
        Enumeration copies = copiedElements.elements();
        while (copies.hasMoreElements()) {
            Selection s = (Selection)copies.nextElement();
            Fig f = s.getContent();
            if (f instanceof FigEdge) continue;
            f = (Fig)f.clone();
            figs.addElement(f);
        }
        Globals.clipBoard = figs;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdCopy");
    }

    static class SimpleSelection
    implements Transferable,
    ClipboardOwner {
        protected Fig selection;
        protected DataFlavor flavor;

        public SimpleSelection(Fig selection, DataFlavor flavor) {
            this.selection = selection;
            this.flavor = flavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor f) {
            return f.equals(this.flavor);
        }

        @Override
        public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException {
            if (f.equals(this.flavor)) {
                return this.selection;
            }
            throw new UnsupportedFlavorException(f);
        }

        @Override
        public void lostOwnership(Clipboard c, Transferable t) {
            this.selection = null;
        }
    }
}

