/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Guide;
import org.tigris.gef.base.GuideGrid;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.base.LayerGrid;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.ModeDragScroll;
import org.tigris.gef.base.ModeManager;
import org.tigris.gef.base.ModePopup;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigTextEditor;

public class Editor
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 2324579872610012639L;
    public static final int GRIP_SIZE = 8;
    protected ModeManager _modeManager = new ModeManager(this);
    protected Object _document;
    protected SelectionManager _selectionManager = new SelectionManager(this);
    protected LayerManager _layerManager = new LayerManager(this);
    protected Guide _guide = new GuideGrid(8);
    private Fig _curFig = null;
    private Selection _curSel = null;
    private double _scale = 1.0;
    protected boolean _canSelectElements = true;
    private transient boolean _shouldPaint = true;
    private transient JComponent _jComponent;
    private transient int _naturalComponentWidth;
    private transient int _naturalComponentHeight;
    private transient Component _peer_component = null;
    private RenderingHints _renderingHints = new RenderingHints(null);
    private transient JPopupMenu _popup = null;
    private static Log LOG = LogFactory.getLog(Editor.class);
    private FigTextEditor _activeTextEditor = null;
    protected static Rectangle _hitRect = new Rectangle(0, 0, 8, 8);

    public Editor(GraphModel gm, JComponent jComponent) {
        this(gm, jComponent, null);
    }

    public Editor(GraphModel gm) {
        this(gm, null, null);
    }

    public Editor() {
        this(null, null, null);
    }

    public Editor(Diagram d) {
        this(d.getGraphModel(), null, d.getLayer());
    }

    public Editor(GraphModel gm, JComponent jComponent, Layer lay) {
        this._jComponent = jComponent;
        this.defineLayers(gm, lay);
        this.pushMode(new ModeSelect(this));
        this.pushMode(new ModePopup(this));
        this.pushMode(new ModeDragScroll(this));
        Globals.curEditor(this);
        this._renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this._renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    protected void defineLayers(GraphModel gm, Layer lay) {
        this._layerManager.addLayer(new LayerGrid());
        if (lay != null) {
            this._layerManager.addLayer(lay);
        } else if (gm == null) {
            this._layerManager.addLayer(new LayerDiagram("Example"));
        } else {
            this._layerManager.addLayer(new LayerPerspective("untitled", gm));
        }
    }

    public void preSave() {
        this._layerManager.preSave();
    }

    public void postSave() {
        this._layerManager.postSave();
    }

    public void setPopupMenu(JPopupMenu p) {
        this._popup = p;
    }

    public JPopupMenu getPopupMenu() {
        return this._popup;
    }

    public void postLoad() {
        this._layerManager.postLoad();
    }

    public boolean getGridHidden() {
        boolean h = false;
        Layer l = this._layerManager.findLayerNamed("Grid");
        if (l != null) {
            h = l.getHidden();
        }
        return h;
    }

    public void setGridHidden(boolean b) {
        Layer l = this._layerManager.findLayerNamed("Grid");
        if (l != null) {
            l.setHidden(b);
        }
    }

    public Object clone() {
        try {
            Editor ed = (Editor)this.getClass().newInstance();
            ed.getLayerManager().addLayer(this._layerManager.getActiveLayer());
            ed.document(this.document());
            return ed;
        }
        catch (IllegalAccessException ignore) {
            LOG.error((Object)"IllegalAccessException in spawn");
        }
        catch (InstantiationException ignore) {
            LOG.error((Object)"InstantiationException in spawn");
        }
        return null;
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public void pushMode(FigModifyingMode mode) {
        this._modeManager.push(mode);
        mode.setEditor(this);
        Globals.showStatus(mode.instructions());
    }

    public void finishMode() {
        this._modeManager.pop();
        this.pushMode((FigModifyingMode)Globals.mode());
        Globals.clearStatus();
    }

    public LayerManager getLayerManager() {
        return this._layerManager;
    }

    public double getScale() {
        return this._scale;
    }

    public void setScale(double scale) {
        this._scale = scale;
        this._layerManager.setScale(this._scale);
        this._jComponent.setPreferredSize(new Dimension((int)((double)this._naturalComponentWidth * this._scale), (int)((double)this._naturalComponentHeight * this._scale)));
        this.damageAll();
    }

    public boolean canSelectElements() {
        return this._canSelectElements;
    }

    public void setElementsSelectable(boolean selectable) {
        this._canSelectElements = selectable;
    }

    public GraphModel getGraphModel() {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            return ((LayerPerspective)active).getGraphModel();
        }
        return null;
    }

    public void setGraphModel(GraphModel gm) {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            ((LayerPerspective)active).setGraphModel(gm);
        }
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            return ((LayerPerspective)active).getGraphNodeRenderer();
        }
        return null;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer rend) {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            ((LayerPerspective)active).setGraphNodeRenderer(rend);
        }
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            return ((LayerPerspective)active).getGraphEdgeRenderer();
        }
        return null;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer rend) {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            ((LayerPerspective)active).setGraphEdgeRenderer(rend);
        }
    }

    public Enumeration figs() {
        return this._layerManager.elements();
    }

    public void add(Fig f) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding fig " + f));
        }
        this.getLayerManager().add(f);
    }

    public void remove(Fig f) {
        this.getLayerManager().remove(f);
    }

    public final Fig hit(Point p) {
        _hitRect.setLocation(p.x - 4, p.y - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int x, int y) {
        _hitRect.setLocation(x - 4, y - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int x, int y, int w, int h) {
        return this.hit(new Rectangle(x, y, w, h));
    }

    public Fig hit(Rectangle r) {
        Fig f = this.getLayerManager().hit(r);
        return f;
    }

    protected void setUnderMouse(MouseEvent me) {
        int y;
        int x = me.getX();
        Fig f = this.hit(x, y = me.getY());
        if (f != this._curFig) {
            if (this._curFig instanceof MouseListener) {
                ((MouseListener)((Object)this._curFig)).mouseExited(me);
            }
            if (f instanceof MouseListener) {
                ((MouseListener)((Object)f)).mouseEntered(me);
            }
        }
        this._curFig = f;
        if (this._canSelectElements) {
            Selection sel = this._selectionManager.findSelectionAt(x, y);
            if (sel != this._curSel) {
                if (this._curSel != null) {
                    this._curSel.mouseExited(me);
                }
                if (sel != null) {
                    sel.mouseEntered(me);
                }
            }
            this._curSel = sel;
        }
    }

    public Object document() {
        return this._document;
    }

    public void document(Object d) {
        this._document = d;
    }

    public void snap(Point p) {
        if (this._guide != null) {
            this._guide.snap(p);
        }
    }

    public Guide getGuide() {
        return this._guide;
    }

    public void setGuide(Guide g) {
        this._guide = g;
    }

    public void damaged(Rectangle r) {
        this.damaged(r.x, r.y, r.width, r.height);
    }

    public void damaged(int x, int y, int width, int height) {
        this.getJComponent().repaint(0L, x, y, width, height);
    }

    public void damaged(Selection sel) {
        Rectangle bounds = sel.getBounds();
        this.scaleRect(bounds);
        this.damaged(bounds);
    }

    public void damaged(Fig f) {
        this.getJComponent().repaint();
    }

    public void scaleRect(Rectangle bounds) {
        bounds.x = (int)Math.floor((double)bounds.x * this._scale);
        bounds.y = (int)Math.floor((double)bounds.y * this._scale);
        bounds.width = (int)Math.floor((double)bounds.width * this._scale) + 1;
        bounds.height = (int)Math.floor((double)bounds.height * this._scale) + 1;
    }

    public void damageAll() {
        Rectangle r = this._jComponent.getVisibleRect();
        this._jComponent.revalidate();
        this._jComponent.repaint(r.x, r.y, r.width, r.height);
    }

    public synchronized void paint(Graphics g) {
        if (!this.shouldPaint()) {
            return;
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this._renderingHints);
            g2.scale(this._scale, this._scale);
        }
        this.getLayerManager().paint(g);
        if (this._canSelectElements) {
            this._selectionManager.paint(g);
            this._modeManager.paint(g);
        }
    }

    public synchronized void print(Graphics g) {
        this.getLayerManager().paint(g);
    }

    public void scrollToShow(int x, int y) {
    }

    public void scrollToShow(Fig fig) {
        Rectangle bounds = new Rectangle((int)((double)fig.getX() * this._scale), (int)((double)fig.getY() * this._scale), (int)((double)fig.getWidth() * this._scale), (int)((double)fig.getHeight() * this._scale));
        bounds.grow((int)(50.0 * this._scale), (int)(50.0 * this._scale));
        JComponent c = this.getJComponent();
        if (c != null) {
            c.scrollRectToVisible(bounds);
        }
    }

    public SelectionManager getSelectionManager() {
        return this._selectionManager;
    }

    public Fig getCurrentFig() {
        return this._curFig;
    }

    public JComponent getJComponent() {
        return this._jComponent;
    }

    public void setJComponent(JComponent c) {
        this._jComponent = c;
        this._peer_component = null;
    }

    public void setCursor(Cursor c) {
        if (this.getJComponent() != null) {
            this.getJComponent().setCursor(c);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public Frame findFrame() {
        Container c;
        for (c = this._jComponent; c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        return (Frame)c;
    }

    public Image createImage(int w, int h) {
        if (this._jComponent == null) {
            return null;
        }
        if (this._peer_component == null) {
            this._peer_component = this._jComponent;
            while (this._peer_component instanceof JComponent) {
                this._peer_component = this._peer_component.getParent();
            }
        }
        return this._peer_component.createImage(w, h);
    }

    public Color getBackground() {
        if (this._jComponent == null) {
            return Color.lightGray;
        }
        return this._jComponent.getBackground();
    }

    public void setActiveTextEditor(FigTextEditor fte) {
        FigTextEditor oldTextEditor = this._activeTextEditor;
        this._activeTextEditor = fte;
        if (oldTextEditor != null) {
            oldTextEditor.endEditing();
        }
    }

    public FigTextEditor getActiveTextEditor() {
        if (this._activeTextEditor != null) {
            return FigTextEditor.getActiveTextEditor();
        }
        return null;
    }

    public void drawingSizeChanged(Dimension dim) {
        this._naturalComponentWidth = dim.width;
        this._naturalComponentHeight = dim.height;
        if (this._jComponent != null) {
            this._jComponent.setPreferredSize(new Dimension((int)((double)this._naturalComponentWidth * this._scale), (int)((double)this._naturalComponentHeight * this._scale)));
            this._jComponent.revalidate();
        }
    }

    public void addGraphSelectionListener(GraphSelectionListener listener) {
        this._selectionManager.addGraphSelectionListener(listener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener) {
        this._selectionManager.removeGraphSelectionListener(listener);
    }

    public void addModeChangeListener(ModeChangeListener listener) {
        this._modeManager.addModeChangeListener(listener);
    }

    public void removeModeChangeListener(ModeChangeListener listener) {
        this._modeManager.removeModeChangeListener(listener);
    }

    protected MouseEvent translateMouseEvent(MouseEvent me) {
        double xp = me.getX();
        double yp = me.getY();
        me.translatePoint((int)Math.round(xp / this._scale - (double)me.getX()), (int)Math.round(yp / this._scale - (double)me.getY()));
        return me;
    }

    public MouseEvent retranslateMouseEvent(MouseEvent me) {
        double xp = me.getX();
        double yp = me.getY();
        int dx = (int)(xp * this._scale - xp);
        int dy = (int)(yp * this._scale - yp);
        me.translatePoint(dx, dy);
        return me;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.translateMouseEvent(me);
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseClicked(me);
        }
        if (this._canSelectElements) {
            this._selectionManager.mouseClicked(me);
            this._modeManager.mouseClicked(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but rejected as already consumed");
            }
            return;
        }
        this.translateMouseEvent(me);
        FigTextEditor.remove();
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mousePressed(me);
        }
        if (this._canSelectElements) {
            this._selectionManager.mousePressed(me);
            this._modeManager.mousePressed(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.translateMouseEvent(me);
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseReleased(me);
        }
        if (this._canSelectElements) {
            this._selectionManager.mouseReleased(me);
            this._modeManager.mouseReleased(me);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.translateMouseEvent(me);
        Globals.curEditor(this);
        this.pushMode((FigModifyingMode)Globals.mode());
        this.setUnderMouse(me);
        if (this._canSelectElements) {
            this._modeManager.mouseEntered(me);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.translateMouseEvent(me);
        this.setUnderMouse(me);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseExited(me);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.translateMouseEvent(me);
        Globals.curEditor(this);
        this.setUnderMouse(me);
        if (this._canSelectElements) {
            this._selectionManager.mouseDragged(me);
            this._modeManager.mouseDragged(me);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.translateMouseEvent(me);
        Globals.curEditor(this);
        this.setUnderMouse(me);
        if (this._curFig != null && Globals.getShowFigTips()) {
            String tip = this._curFig.getTipString(me);
            if (tip != null && tip.length() > 0 && !tip.endsWith(" ")) {
                tip = tip + " ";
            }
            if (tip != null && this._jComponent instanceof JComponent) {
                this._jComponent.setToolTipText(tip);
            }
        } else {
            this._jComponent.setToolTipText(null);
        }
        if (this._canSelectElements) {
            this._selectionManager.mouseMoved(me);
            this._modeManager.mouseMoved(me);
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        Globals.curEditor(this);
        if (this._canSelectElements) {
            this._selectionManager.keyTyped(ke);
            this._modeManager.keyTyped(ke);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        Globals.curEditor(this);
        if (this._canSelectElements) {
            this._selectionManager.keyPressed(ke);
            this._modeManager.keyPressed(ke);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        Globals.curEditor(this);
        if (this._canSelectElements) {
            this._selectionManager.keyReleased(ke);
            this._modeManager.keyReleased(ke);
        }
    }

    public void executeCmd(Cmd c, InputEvent ie) {
        if (c == null) {
            return;
        }
        try {
            c.doIt();
        }
        catch (Throwable ex) {
            LOG.debug((Object)("While executing " + c + " on event " + ie + " the following error occured:"), ex);
        }
    }

    public void removed(Fig f) {
        this._selectionManager.deselect(f);
        this.remove(f);
    }

    public void setShouldPaint(boolean shouldPaint) {
        this._shouldPaint = shouldPaint;
    }

    public boolean shouldPaint() {
        return this._shouldPaint;
    }

    public Selection getCurrentSelection() {
        return this._curSel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllVariables() {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream("testGefSave.xml");
            ObjectOutputStream s = new ObjectOutputStream(fout);
            this.preSave();
            System.out.println("_modeManager written");
            s.writeObject(this._document);
            System.out.println("_document written");
            s.writeObject(this._selectionManager);
            System.out.println("_selectionManager written");
            s.writeObject(this._layerManager);
            System.out.println("_layerManager written");
            s.writeObject(this._guide);
            System.out.println("_guide written");
            s.writeObject(this._curFig);
            System.out.println("_curFig written");
            s.writeObject(this._curSel);
            System.out.println("_curSel written");
            s.writeObject(this._jComponent);
            System.out.println("_jComponent written");
            s.writeObject(this._peer_component);
            System.out.println("_peer_component written");
            s.writeObject(this._renderingHints);
            System.out.println("_renderingHints written");
            this.postSave();
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

