/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerPolar
extends Layer {
    private static final long serialVersionUID = -7584346767965616421L;
    private int _originX = 0;
    private int _originY = 0;
    private int _spacing = 32;
    private int _style = 0;
    private int NUM_STYLES = 5;
    protected Color _lineColor = new Color(55, 55, 255);
    protected Color _bgColor = null;

    public LayerPolar() {
        super("Grid");
    }

    public LayerPolar(int x, int y, int s) {
        super("Grid");
        this.origin(x, y);
        this.spacing(s);
    }

    public void origin(int x, int y) {
        this._originX = x;
        this._originY = y;
    }

    public void spacing(int s) {
        this._spacing = s;
    }

    public int dist(int x, int y) {
        int sqrd = (this._originX - x) * (this._originX - x) + (this._originY - y) * (this._originY - y);
        return (int)Math.round(Math.sqrt(sqrd));
    }

    public void lineColor(Color c) {
        this._lineColor = c;
    }

    public Color lineColor() {
        return this._lineColor;
    }

    public void bgColor(Color c) {
        this._bgColor = c;
    }

    public Color bgColor() {
        return this._bgColor;
    }

    @Override
    public List getContents() {
        return null;
    }

    @Override
    public Fig presentationFor(Object obj) {
        return null;
    }

    @Override
    public void paintContents(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int clipBot = clip.y + clip.height;
        int clipRight = clip.x + clip.width;
        if (this._bgColor != null) {
            g.setColor(this._bgColor);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        int d1 = this.dist(clip.x, clip.y);
        int d2 = this.dist(clip.x, clipBot);
        int d3 = this.dist(clipRight, clip.y);
        int d4 = this.dist(clipRight, clipBot);
        int maxDist = Math.max(Math.max(d1, d2), Math.max(d3, d4));
        maxDist = maxDist / this._spacing * this._spacing + 1;
        g.setColor(this._lineColor);
        int startX = this._originX;
        int startY = this._originY;
        int limit = 2 * maxDist;
        for (int size = 0; size <= limit; size += this._spacing) {
            g.drawOval(startX, startY, size, size);
            startX -= this._spacing;
            startY -= this._spacing;
            size += this._spacing;
        }
    }

    @Override
    public void adjust() {
        this._style = (this._style + 1) % this.NUM_STYLES;
        switch (this._style) {
            case 0: {
                this.setHidden(false);
                this.origin(0, 0);
                this.spacing(32);
                break;
            }
            case 1: {
                this.setHidden(false);
                this.origin(0, 0);
                this.spacing(16);
                break;
            }
            case 2: {
                this.setHidden(false);
                this.origin(50, 50);
                this.spacing(16);
                break;
            }
            case 3: {
                this.setHidden(false);
                Editor ce = Globals.curEditor();
                if (ce != null) {
                    Dimension d = ce.getJComponent().getSize();
                    this.origin(d.width / 2, d.height / 2);
                } else {
                    this.origin(100, 100);
                }
                this.spacing(16);
                break;
            }
            case 4: {
                this.setHidden(true);
            }
        }
    }
}

