/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class ModeCreateFigPoly
extends ModeCreate {
    private static final long serialVersionUID = 2839607058696197299L;
    protected int _npoints = 0;
    protected int _lastX;
    protected int _lastY;
    protected int _startX;
    protected int _startY;
    protected Handle _handle = new Handle(-1);

    @Override
    public String instructions() {
        return "Click to add a point; Double-click to finish";
    }

    @Override
    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        FigPoly p = new FigPoly(snapX, snapY);
        p.addPoint(snapX, snapY);
        this._startX = this._lastX = snapX;
        this._startY = this._lastY = snapY;
        this._npoints = 2;
        return p;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        if (this._npoints == 0) {
            super.mousePressed(me);
        }
        if (!this.nearLast(x, y)) {
            this.editor.damageAll();
            Point snapPt = new Point(x, y);
            this.editor.snap(snapPt);
            ((FigPoly)this._newItem).addPoint(snapPt.x, snapPt.y);
            ++this._npoints;
            this.editor.damageAll();
        }
        me.consume();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        if (this._npoints > 2 && this.nearLast(x, y)) {
            FigPoly p = (FigPoly)this._newItem;
            this.editor.damageAll();
            this._handle.index = p.getNumPoints() - 1;
            p.moveVertex(this._handle, this._startX, this._startY, true);
            this._npoints = 0;
            this.editor.damageAll();
            this.editor.add(p);
            this.editor.getSelectionManager().select(p);
            this._newItem = null;
            this.done();
            me.consume();
            return;
        }
        this._lastX = x;
        this._lastY = y;
        me.consume();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mouseDragged(me);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        if (this._npoints == 0) {
            me.consume();
            return;
        }
        FigPoly p = (FigPoly)this._newItem;
        this.editor.damageAll();
        Point snapPt = new Point(x, y);
        this.editor.snap(snapPt);
        this._handle.index = p.getNumPoints() - 1;
        p.moveVertex(this._handle, snapPt.x, snapPt.y, true);
        this.editor.damageAll();
        me.consume();
    }

    protected boolean nearLast(int x, int y) {
        return x > this._lastX - 8 && x < this._lastX + 8 && y > this._lastY - 8 && y < this._lastY + 8;
    }
}

