/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.MouseEvent;
import org.tigris.gef.base.ModeCreateFigPoly;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigSpline;

public class ModeCreateFigSpline
extends ModeCreateFigPoly {
    private static final long serialVersionUID = 5038274770338930599L;

    @Override
    public String instructions() {
        return "Click to add a point; Double-click to finish";
    }

    @Override
    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        FigSpline p = new FigSpline(snapX, snapY);
        p.addPoint(snapX, snapY);
        this._startX = this._lastX = snapX;
        this._startY = this._lastY = snapY;
        this._npoints = 2;
        return p;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        if (this._npoints > 2 && this.nearLast(x, y)) {
            FigSpline p = (FigSpline)this._newItem;
            this.editor.damageAll();
            this._handle.index = p.getNumPoints() - 1;
            p.moveVertex(this._handle, this._startX, this._startY, true);
            p.removePoint(this._handle.index);
            this._npoints = 0;
            this.editor.damageAll();
            this.editor.add(p);
            this.editor.getSelectionManager().select(p);
            this._newItem = null;
            this.done();
            me.consume();
            return;
        }
        this._lastX = x;
        this._lastY = y;
        me.consume();
    }
}

