/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class RemovePointAction
extends UndoableAction {
    private static final long serialVersionUID = 5176961969863495315L;
    private int selectedHandle = 0;

    public RemovePointAction(String name, int selectedHandle) {
        this(name, selectedHandle, false);
    }

    public RemovePointAction(String name, Icon icon, int selectedHandle) {
        this(name, icon, selectedHandle, false);
    }

    public RemovePointAction(String name, int selectedHandle, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
        this.selectedHandle = selectedHandle;
    }

    public RemovePointAction(String name, Icon icon, int selectedHandle, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
        this.selectedHandle = selectedHandle;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Fig f = null;
        Selection sel = null;
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        if (sm.selections().isEmpty()) {
            return;
        }
        sel = (Selection)sm.selections().firstElement();
        f = sel.getContent();
        f.removePoint(this.selectedHandle);
        f.endTrans();
    }
}

