/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.SaveGraphicsAction;
import org.tigris.gef.persistence.PostscriptWriter;
import org.tigris.gef.util.Localizer;

public class SavePSAction
extends SaveGraphicsAction {
    private static final long serialVersionUID = 1373664552595812631L;

    public SavePSAction(String name) {
        this(name, false);
    }

    public SavePSAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public SavePSAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public SavePSAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    @Override
    protected void saveGraphics(OutputStream s, Editor ce, Rectangle drawingArea) throws IOException {
        PostscriptWriter ps = new PostscriptWriter(s);
        ps.translate(32, 810);
        double scale = Math.min(535.0 / (double)drawingArea.width, 778.0 / (double)drawingArea.height);
        if (scale < 1.0) {
            ps.scale(scale, scale);
        }
        ps.translate(-drawingArea.x, -drawingArea.y);
        ps.setClip(drawingArea.x, drawingArea.y, drawingArea.width, drawingArea.height);
        ce.print(ps);
        ps.dispose();
    }
}

