/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class ScrollAction
extends UndoableAction {
    private static final long serialVersionUID = -3240224240491643821L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int direction;
    private int magnitude;

    public ScrollAction(int dir) {
        this.direction = dir;
        this.magnitude = 16;
    }

    public ScrollAction(String name, int dir) {
        this(name, dir, false);
    }

    public ScrollAction(String name, Icon icon, int dir) {
        this(name, icon, dir, false);
    }

    public ScrollAction(String name, int dir, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
        this.direction = dir;
        this.magnitude = 16;
    }

    public ScrollAction(String name, Icon icon, int dir, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
        this.direction = dir;
        this.magnitude = 16;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int deltaX = 0;
        int deltaY = 0;
        switch (this.direction) {
            case 1: {
                deltaX = this.magnitude;
                break;
            }
            case 2: {
                deltaX = 0 - this.magnitude;
                break;
            }
            case 3: {
                deltaY = this.magnitude;
                break;
            }
            case 4: {
                deltaY = 0 - this.magnitude;
            }
        }
        System.out.println("Scrolling by " + deltaX + ", " + deltaY);
    }
}

