/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class SelectNearAction
extends UndoableAction {
    private static final long serialVersionUID = -7302592306721995290L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int direction;
    private int magnitude;

    public SelectNearAction(int dir) {
        this(dir, 1);
    }

    public SelectNearAction(int dir, int mag) {
        super("SelectNear" + SelectNearAction.wordFor(dir));
        this.direction = dir;
        this.magnitude = mag;
    }

    private static String wordFor(int d) {
        switch (d) {
            case 1: {
                return "Left";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
        }
        return "";
    }

    public SelectNearAction(String name, int dir) {
        this(name, dir, 1, false);
    }

    public SelectNearAction(String name, int dir, int mag) {
        this(name, dir, mag, false);
    }

    public SelectNearAction(String name, Icon icon, int dir) {
        this(name, icon, dir, 1, false);
    }

    public SelectNearAction(String name, Icon icon, int dir, int mag) {
        this(name, icon, dir, mag, false);
    }

    public SelectNearAction(String name, int dir, boolean localize) {
        this(name, dir, 1, false);
    }

    public SelectNearAction(String name, int dir, int mag, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
        this.direction = dir;
        this.magnitude = mag;
    }

    public SelectNearAction(String name, Icon icon, int dir, boolean localize) {
        this(name, icon, dir, 1, false);
    }

    public SelectNearAction(String name, Icon icon, int dir, int mag, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
        this.direction = dir;
        this.magnitude = mag;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        int dx = 0;
        int dy = 0;
        switch (this.direction) {
            case 1: {
                dx = 0 - this.magnitude;
                break;
            }
            case 2: {
                dx = this.magnitude;
                break;
            }
            case 3: {
                dy = 0 - this.magnitude;
                break;
            }
            case 4: {
                dy = this.magnitude;
            }
        }
        sm.translate(dx, dy);
        sm.endTrans();
    }
}

