/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.ModeManager;
import org.tigris.gef.base.ModeModify;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.base.SelectionResize;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public abstract class SelectionButtons
extends SelectionResize {
    private static final int IMAGE_SIZE = 22;
    private static final int MARGIN = 2;
    private static final Color PRESSED_COLOR = Color.gray.brighter();
    private static final int MAX_PLACINGS = 1;
    private static int numButtonClicks = 0;
    private static boolean showRapidButtons = true;
    private boolean paintButtons = showRapidButtons;
    private int pressedButton = -1;
    private int placeCounter = 0;

    public SelectionButtons(Fig f) {
        super(f);
    }

    public static void toggleShowRapidButtons() {
        showRapidButtons = !showRapidButtons;
    }

    public boolean hitAbove(int x, int y, int w, int h, Rectangle r) {
        return this.intersectsRect(r, x - w / 2, y - h - 2, w, h + 2);
    }

    public boolean hitBelow(int x, int y, int w, int h, Rectangle r) {
        return this.intersectsRect(r, x - w / 2, y, w, h + 2);
    }

    public boolean hitLeft(int x, int y, int w, int h, Rectangle r) {
        return this.intersectsRect(r, x, y - h / 2, w + 2, h);
    }

    public boolean hitRight(int x, int y, int w, int h, Rectangle r) {
        return this.intersectsRect(r, x - w - 2, y - h / 2, w + 2, h);
    }

    public boolean intersectsRect(Rectangle r, int x, int y, int w, int h) {
        return r.x + r.width > x && r.y + r.height > y && r.x < x + w && r.y < y + h;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.paintButtons) {
            return;
        }
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.size() != 1) {
            return;
        }
        ModeManager mm = ce.getModeManager();
        if (mm.includes(ModeModify.class) && this.pressedButton == -1) {
            return;
        }
        this.paintButtons(g);
    }

    public abstract void paintButtons(Graphics var1);

    public void paintButtonAbove(Icon i, Graphics g, int x, int y, int hi) {
        this.paintButton(i, g, x - i.getIconWidth() / 2, y - i.getIconHeight() - 2, hi);
    }

    public void paintButtonBelow(Icon i, Graphics g, int x, int y, int hi) {
        this.paintButton(i, g, x - i.getIconWidth() / 2, y + 2, hi);
    }

    public void paintButtonLeft(Icon i, Graphics g, int x, int y, int hi) {
        this.paintButton(i, g, x + 2, y - i.getIconHeight() / 2, hi);
    }

    public void paintButtonRight(Icon i, Graphics g, int x, int y, int hi) {
        this.paintButton(i, g, x - i.getIconWidth() - 2, y - i.getIconHeight() / 2, hi);
    }

    public void paintButton(Icon i, Graphics g, int x, int y, int hi) {
        int w = i.getIconWidth() + 4;
        int h = i.getIconHeight() + 4;
        if (hi == this.pressedButton) {
            g.setColor(PRESSED_COLOR);
            g.fillRect(x - 2, y - 2, w, h);
        }
        i.paintIcon(null, g, x, y);
        g.translate(x - 2, y - 2);
        Color handleColor = Globals.getPrefs().handleColorFor(this.getContent());
        g.setColor(handleColor.darker());
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(handleColor.brighter().brighter().brighter());
        if (hi != this.pressedButton) {
            g.drawLine(1, h - 3, 1, 1);
            g.drawLine(1, 1, w - 3, 1);
        }
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, h - 1, w - 1, 0);
        g.translate(-x + 2, -y + 2);
    }

    @Override
    public Rectangle getBounds() {
        Fig content = this.getContent();
        return new Rectangle(content.getX() - 44, content.getY() - 44, content.getWidth() + 88, content.getHeight() + 88);
    }

    public void hideButtons() {
        this.paintButtons = false;
    }

    public void buttonClicked(int buttonCode) {
        Point fcCenter;
        Fig content = this.getContent();
        if (buttonCode >= 10) {
            ++numButtonClicks;
        }
        Object newNode = this.getNewNode(buttonCode);
        Editor ce = Globals.curEditor();
        GraphModel gm = ce.getGraphModel();
        if (!(gm instanceof MutableGraphModel)) {
            return;
        }
        MutableGraphModel mgm = (MutableGraphModel)gm;
        if (!mgm.canAddNode(newNode)) {
            return;
        }
        GraphNodeRenderer renderer = ce.getGraphNodeRenderer();
        LayerPerspective lay = (LayerPerspective)ce.getLayerManager().getActiveLayer();
        Fig newFC = renderer.getFigNodeFor(gm, lay, newNode, null);
        Rectangle outputRect = new Rectangle(Math.max(0, content.getX() - 200), Math.max(0, content.getY() - 200), content.getWidth() + 400, content.getHeight() + 400);
        if (buttonCode >= 10 && buttonCode <= 13) {
            int x = 0;
            int y = 0;
            if (buttonCode == 10) {
                x = content.getX();
                y = Math.max(0, content.getY() - 200);
            } else if (buttonCode == 11) {
                x = content.getX();
                y = content.getY() + content.getHeight() + 100;
            } else if (buttonCode == 12) {
                x = content.getX() + content.getWidth() + 100;
                y = content.getY();
            } else if (buttonCode == 13) {
                x = Math.max(0, content.getX() - 200);
                y = content.getY();
            }
            if (!this.placeFig(newFC, lay, x, y, outputRect)) {
                return;
            }
        }
        if (buttonCode != 14) {
            ce.add(newFC);
            mgm.addNode(newNode);
        }
        FigPoly edgeShape = new FigPoly();
        if (buttonCode != 14) {
            fcCenter = content.getCenter();
            edgeShape.addPoint(fcCenter.x, fcCenter.y);
            Point newFCCenter = newFC.getCenter();
            edgeShape.addPoint(newFCCenter.x, newFCCenter.y);
        } else {
            newFC = content;
            fcCenter = content.getCenter();
            Point centerRight = new Point((int)((double)fcCenter.x + content.getSize().getWidth() / 2.0), fcCenter.y);
            int yoffset = (int)(content.getSize().getHeight() / 2.0);
            edgeShape.addPoint(fcCenter.x, fcCenter.y);
            edgeShape.addPoint(centerRight.x, centerRight.y);
            edgeShape.addPoint(centerRight.x + 30, centerRight.y);
            edgeShape.addPoint(centerRight.x + 30, centerRight.y + yoffset);
            edgeShape.addPoint(centerRight.x, centerRight.y + yoffset);
        }
        Object newEdge = null;
        if (buttonCode == 10) {
            newEdge = this.createEdgeAbove(mgm, newNode);
        } else if (buttonCode == 11) {
            newEdge = this.createEdgeUnder(mgm, newNode);
        } else if (buttonCode == 12) {
            newEdge = this.createEdgeRight(mgm, newNode);
        } else if (buttonCode == 13) {
            newEdge = this.createEdgeLeft(mgm, newNode);
        } else if (buttonCode == 14) {
            newEdge = this.createEdgeToSelf(mgm);
        }
        FigEdge fe = (FigEdge)lay.presentationFor(newEdge);
        fe.setBetweenNearestPoints(true);
        edgeShape.setLineColor(Color.black);
        edgeShape.setFilled(false);
        edgeShape.setComplete(true);
        fe.setFig(edgeShape);
        newFC.damage();
        ce.getSelectionManager().select(fe);
        ce.getSelectionManager().select(content);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Handle h = new Handle(-1);
        this.hitHandle(me.getX(), me.getY(), 0, 0, h);
        this.pressedButton = h.index;
        Editor ce = Globals.curEditor();
        ce.damaged(this);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.pressedButton < 10) {
            return;
        }
        Handle h = new Handle(-1);
        this.hitHandle(me.getX(), me.getY(), 0, 0, h);
        if (this.pressedButton == h.index) {
            this.buttonClicked(this.pressedButton);
            me.consume();
        }
        this.pressedButton = -1;
        Editor ce = Globals.curEditor();
        ce.damaged(this);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        super.mouseEntered(me);
        if (showRapidButtons) {
            this.paintButtons = true;
        }
        Editor ce = Globals.curEditor();
        ce.damaged(this);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        super.mouseExited(me);
        this.paintButtons = false;
        Editor ce = Globals.curEditor();
        ce.damaged(this);
    }

    protected boolean placeFig(Fig figToPlace, LayerPerspective layerToPlaceOn, int x, int y, Rectangle bumpRect) {
        if (this.placeCounter > 1) {
            return false;
        }
        ++this.placeCounter;
        figToPlace.setLocation(x, y);
        layerToPlaceOn.bumpOffOtherNodesIn(figToPlace, bumpRect, false, false);
        Fig content = this.getContent();
        if (figToPlace.getX() < 0) {
            return this.placeFig(figToPlace, layerToPlaceOn, content.getX() + content.getWidth() + figToPlace.getWidth() + 100, figToPlace.getY(), bumpRect);
        }
        if (figToPlace.getX() + figToPlace.getWidth() >= 6000) {
            return this.placeFig(figToPlace, layerToPlaceOn, content.getX() - figToPlace.getWidth() - 100, figToPlace.getY(), bumpRect);
        }
        if (figToPlace.getY() + figToPlace.getHeight() >= 6000) {
            return this.placeFig(figToPlace, layerToPlaceOn, figToPlace.getX(), content.getY() - figToPlace.getHeight() - 100, bumpRect);
        }
        if (figToPlace.getY() < 0) {
            return this.placeFig(figToPlace, layerToPlaceOn, figToPlace.getX(), content.getY() + content.getHeight() + figToPlace.getHeight() + 100, bumpRect);
        }
        return true;
    }

    protected abstract Object getNewNode(int var1);

    protected Object createEdgeAbove(MutableGraphModel gm, Object newNode) {
        return null;
    }

    protected Object createEdgeLeft(MutableGraphModel gm, Object newNode) {
        return null;
    }

    protected Object createEdgeRight(MutableGraphModel gm, Object newNode) {
        return null;
    }

    protected Object createEdgeUnder(MutableGraphModel gm, Object newNode) {
        return null;
    }

    protected Object createEdgeToSelf(MutableGraphModel gm) {
        return null;
    }

    protected void setPaintButtons(boolean paint) {
        this.paintButtons = paint;
    }

    protected boolean isPaintButtons() {
        return this.paintButtons;
    }

    protected void setPressedButton(int pressed) {
        this.pressedButton = pressed;
    }

    protected int getPressedButton() {
        return this.pressedButton;
    }
}

