/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.base.SelectionReshape;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class UseReshapeAction
extends UndoableAction {
    private static final long serialVersionUID = -4052325627767476140L;

    public UseReshapeAction(String name) {
        this(name, false);
    }

    public UseReshapeAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public UseReshapeAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public UseReshapeAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        Enumeration sels = ((Vector)sm.selections().clone()).elements();
        while (sels.hasMoreElements()) {
            Fig f;
            Selection s = (Selection)sels.nextElement();
            if (!(s instanceof Selection) || s instanceof SelectionReshape || !(f = s.getContent()).isReshapable()) continue;
            ce.damaged(s);
            sm.removeSelection(s);
            SelectionReshape sr = new SelectionReshape(f);
            sm.addSelection(sr);
            ce.damaged(sr);
        }
    }
}

