/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.base.SelectionResize;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class UseResizeAction
extends UndoableAction {
    private static final long serialVersionUID = 5338653001956870781L;

    public UseResizeAction() {
    }

    public UseResizeAction(String name) {
        this(name, false);
    }

    public UseResizeAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public UseResizeAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public UseResizeAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        Enumeration sels = ((Vector)sm.selections().clone()).elements();
        while (sels.hasMoreElements()) {
            Fig f;
            Selection s = (Selection)sels.nextElement();
            if (!(s instanceof Selection) || s instanceof SelectionResize || !(f = s.getContent()).isReshapable()) continue;
            ce.damaged(s);
            sm.removeSelection(s);
            SelectionResize sr = new SelectionResize(f);
            sm.addSelection(sr);
            ce.damaged(sr);
        }
    }
}

