/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.base.NudgeAction;
import org.tigris.gef.base.SelectNearAction;
import org.tigris.gef.base.SelectNextAction;
import org.tigris.gef.base.ZoomAction;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.ConnectionConstrainer;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.JGraphInternalPane;
import org.tigris.gef.graph.presentation.WheelKeyListenerToggleAction;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigTextEditor;

public class JGraph
extends JPanel
implements Cloneable,
AdjustmentListener,
MouseWheelListener {
    private Editor editor;
    private JGraphInternalPane drawingPane;
    private JScrollPane scrollPane;
    private Dimension defaultSize = new Dimension(6000, 6000);
    private Hashtable _viewPortPositions = new Hashtable();
    private String _currentDiagramId = null;
    private ZoomAction zoomOut = new ZoomAction(0.9);
    private ZoomAction zoomIn = new ZoomAction(1.1);
    static final long serialVersionUID = -5459241816919316496L;

    public JGraph() {
        this(new DefaultGraphModel());
    }

    public JGraph(ConnectionConstrainer cc) {
        this(new DefaultGraphModel(cc));
    }

    public JGraph(Diagram d) {
        this(new Editor(d));
    }

    public JGraph(GraphModel gm) {
        this(new Editor(gm, null));
    }

    public void setTitle(String newTitle) {
        this.scrollPane.setBorder(new TitledBorder(newTitle));
    }

    public JGraph(Editor ed) {
        super(false);
        this.editor = ed;
        this.drawingPane = new JGraphInternalPane(this.editor);
        this.setDrawingSize(this.getDefaultSize());
        this.scrollPane = new JScrollPane(this.drawingPane, 21, 31);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(25);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        this.editor.setJComponent(this.drawingPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.addMouseListener(this.editor);
        this.addMouseMotionListener(this.editor);
        this.addKeyListener(this.editor);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.initKeys();
        this.validate();
        List layerManagerContent = ed.getLayerManager().getContents();
        if (layerManagerContent != null) {
            this.updateDrawingSizeToIncludeAllFigs(Collections.enumeration(layerManagerContent));
        }
        int mask = 10;
        this.establishAlternateMouseWheelListener(this, mask);
    }

    public boolean equals(Object o) {
        if (o instanceof JGraph) {
            JGraph other = (JGraph)o;
            if ((this.getCurrentDiagramId() != null && this.getCurrentDiagramId().equals(other.getCurrentDiagramId()) || this.getCurrentDiagramId() == null && other.getCurrentDiagramId() == null) && this.getEditor().equals(other.getEditor())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getCurrentDiagramId() == null) {
            return 0;
        }
        return this.getCurrentDiagramId().hashCode();
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.drawingPane.addMouseListener(listener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        this.drawingPane.addMouseMotionListener(listener);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.drawingPane.addKeyListener(listener);
    }

    public Object clone() {
        JGraph newJGraph = new JGraph((Editor)this.editor.clone());
        return newJGraph;
    }

    public void initKeys() {
        int shift = 1;
        int alt = 8;
        int meta = 4;
        this.bindKey(new SelectNextAction("Select Next", true), 9, 0);
        this.bindKey(new SelectNextAction("Select Previous", false), 9, shift);
        this.bindKey(new NudgeAction(1), 37, 0);
        this.bindKey(new NudgeAction(2), 39, 0);
        this.bindKey(new NudgeAction(3), 38, 0);
        this.bindKey(new NudgeAction(4), 40, 0);
        this.bindKey(new NudgeAction(1, 8), 37, shift);
        this.bindKey(new NudgeAction(2, 8), 39, shift);
        this.bindKey(new NudgeAction(3, 8), 38, shift);
        this.bindKey(new NudgeAction(4, 8), 40, shift);
        this.bindKey(new NudgeAction(1, 18), 37, alt);
        this.bindKey(new NudgeAction(2, 18), 39, alt);
        this.bindKey(new NudgeAction(3, 18), 38, alt);
        this.bindKey(new NudgeAction(4, 18), 40, alt);
        this.bindKey(new SelectNearAction(1), 37, meta);
        this.bindKey(new SelectNearAction(2), 39, meta);
        this.bindKey(new SelectNearAction(3), 38, meta);
        this.bindKey(new SelectNearAction(4), 40, meta);
    }

    public void bindKey(ActionListener action, int keyCode, int modifiers) {
        this.drawingPane.registerKeyboardAction(action, KeyStroke.getKeyStroke(keyCode, modifiers), 0);
    }

    public Editor getEditor() {
        return this.editor;
    }

    public void setDiagram(Diagram d) {
        if (d == null) {
            return;
        }
        if (this._currentDiagramId != null) {
            this._viewPortPositions.put(this._currentDiagramId, this.scrollPane.getViewport().getViewRect());
        }
        this.setDrawingSize(this.getDefaultSize());
        this.updateDrawingSizeToIncludeAllFigs(d.elements());
        this.editor.getLayerManager().replaceActiveLayer(d.getLayer());
        this.editor.setGraphModel(d.getGraphModel());
        this.editor.getSelectionManager().deselectAll();
        this.editor.setScale(d.getScale());
        String newDiagramId = Integer.toString(d.hashCode());
        if (newDiagramId.equals(this._currentDiagramId)) {
            return;
        }
        this._currentDiagramId = newDiagramId;
        if (this._viewPortPositions.get(this._currentDiagramId) != null) {
            Rectangle rect = (Rectangle)this._viewPortPositions.get(this._currentDiagramId);
            this.scrollPane.getViewport().setViewPosition(new Point(rect.x, rect.y));
        } else {
            this.scrollPane.getViewport().setViewPosition(new Point());
        }
    }

    protected void updateDrawingSizeToIncludeAllFigs(Enumeration iter) {
        if (iter == null) {
            return;
        }
        Dimension drawingSize = new Dimension(this.defaultSize.width, this.defaultSize.height);
        while (iter.hasMoreElements()) {
            Fig fig = (Fig)iter.nextElement();
            Rectangle rect = fig.getBounds();
            Point point = rect.getLocation();
            Dimension dim = rect.getSize();
            if (point.x + dim.width + 5 > drawingSize.width) {
                drawingSize.setSize(point.x + dim.width + 5, drawingSize.height);
            }
            if (point.y + dim.height + 5 <= drawingSize.height) continue;
            drawingSize.setSize(drawingSize.width, point.y + dim.height + 5);
        }
        this.setDrawingSize(drawingSize.width, drawingSize.height);
    }

    public void setDrawingSize(int width, int height) {
        this.setDrawingSize(new Dimension(width, height));
    }

    public void setDrawingSize(Dimension dim) {
        this.editor.drawingSizeChanged(dim);
    }

    public void setGraphModel(GraphModel gm) {
        this.editor.setGraphModel(gm);
    }

    public GraphModel getGraphModel() {
        return this.editor.getGraphModel();
    }

    public void setGraphNodeRenderer(GraphNodeRenderer r) {
        this.editor.setGraphNodeRenderer(r);
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this.editor.getGraphNodeRenderer();
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer r) {
        this.editor.setGraphEdgeRenderer(r);
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this.editor.getGraphEdgeRenderer();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.drawingPane.setVisible(visible);
        if (this.editor.getActiveTextEditor() != null) {
            FigTextEditor.remove();
        }
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public void addGraphSelectionListener(GraphSelectionListener listener) {
        this.getEditor().addGraphSelectionListener(listener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener) {
        this.getEditor().removeGraphSelectionListener(listener);
    }

    public void addModeChangeListener(ModeChangeListener listener) {
        this.getEditor().addModeChangeListener(listener);
    }

    public void removeModeChangeListener(ModeChangeListener listener) {
        this.getEditor().removeModeChangeListener(listener);
    }

    public void select(Fig f) {
        if (f == null) {
            this.deselectAll();
        } else {
            this.editor.getSelectionManager().select(f);
        }
    }

    public void selectByOwner(Object owner) {
        Layer lay = this.editor.getLayerManager().getActiveLayer();
        if (lay instanceof LayerDiagram) {
            this.select(((LayerDiagram)lay).presentationFor(owner));
        }
    }

    public void selectByOwnerOrFig(Object owner) {
        if (owner instanceof Fig) {
            this.select((Fig)owner);
        } else {
            this.selectByOwner(owner);
        }
    }

    public void selectByOwnerOrNoChange(Object owner) {
        Fig f;
        Layer lay = this.editor.getLayerManager().getActiveLayer();
        if (lay instanceof LayerDiagram && (f = ((LayerDiagram)lay).presentationFor(owner)) != null) {
            this.select(f);
        }
    }

    public void deselect(Fig f) {
        this.editor.getSelectionManager().deselect(f);
    }

    public void toggleItem(Fig f) {
        this.editor.getSelectionManager().toggle(f);
    }

    public void deselectAll() {
        this.editor.getSelectionManager().deselectAll();
    }

    public void select(Vector items) {
        this.editor.getSelectionManager().select(items);
    }

    public void toggleItems(Vector items) {
        this.editor.getSelectionManager().toggle(items);
    }

    public Vector selectedFigs() {
        return this.editor.getSelectionManager().getFigs();
    }

    public void setDefaultSize(int width, int height) {
        this.defaultSize = new Dimension(width, height);
    }

    public void setDefaultSize(Dimension dim) {
        this.defaultSize = dim;
    }

    public Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public Point getViewPosition() {
        return this.scrollPane.getViewport().getViewPosition();
    }

    public void setViewPosition(Point p) {
        if (p != null) {
            this.scrollPane.getViewport().setViewPosition(p);
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void establishAlternateMouseWheelListener(MouseWheelListener listener, int mask) {
        WheelKeyListenerToggleAction keyListener = new WheelKeyListenerToggleAction(this.drawingPane, listener, mask);
        this.drawingPane.addKeyListener(keyListener);
    }

    protected String getCurrentDiagramId() {
        return this._currentDiagramId;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        FigTextEditor.getInstance().endEditing();
        this.editor.damageAll();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isAltDown() || e.isControlDown()) {
            if (e.getWheelRotation() < 0) {
                this.zoomOut.actionPerformed(null);
            } else if (e.getWheelRotation() > 0) {
                this.zoomIn.actionPerformed(null);
            }
            e.consume();
        }
    }
}

