/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.svg;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigCircle;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigInk;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.presentation.FigSpline;
import org.tigris.gef.presentation.FigText;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class SvgParser
extends DefaultHandler {
    public static SvgParser SINGLETON = new SvgParser();
    protected Diagram _diagram = null;
    protected int _nestedGroups = 0;
    protected HashMap _figRegistry = null;
    protected Map _ownerRegistry = new HashMap();
    private int _elementState = 0;
    private static final int DEFAULT_STATE = 0;
    private static final int TEXT_STATE = 1;
    private static final int LINE_STATE = 2;
    private static final int POLY_STATE = 3;
    private static final int NODE_STATE = 4;
    private static final int EDGE_STATE = 5;
    private static final int PRIVATE_STATE = 6;
    private static final int PRIVATE_NODE_STATE = 64;
    private static final int PRIVATE_EDGE_STATE = 65;
    private static final int TEXT_NODE_STATE = 14;
    private static final int TEXT_EDGE_STATE = 15;
    private FigLine _currentLine = null;
    private int _x1Int = 0;
    private int _y1Int = 0;
    private FigText _currentText = null;
    private StringBuffer _textBuf = null;
    private FigPoly _currentPoly = null;
    private FigNode _currentNode = null;
    private FigEdge _currentEdge = null;
    private String[] _entityPaths = new String[]{"/org/tigris/gef/xml/dtd/"};

    protected SvgParser() {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if ((this._elementState == 1 || this._elementState == 6 || this._elementState == 14 || this._elementState == 15 || this._elementState == 64 || this._elementState == 65) && this._textBuf != null) {
            this._textBuf.append(ch, start, length);
        }
    }

    protected Color colorByName(String name, Color defaultColor) {
        if (name.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (name.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (name.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (name.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (name.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (name.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (name.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (name.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (name.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (name.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (name.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (name.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (name.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        try {
            return Color.decode(name);
        }
        catch (Exception ex) {
            System.out.println("invalid color code string: " + name);
            return defaultColor;
        }
    }

    private void edgeStateStartElement(String tagName, Attributes attrList) {
        if (!tagName.equals("desc") && !tagName.equals("title")) {
            if (tagName.equals("path")) {
                FigPoly p = this.handlePath(attrList);
                this._currentEdge.setFig(p);
                p.setComplete(true);
                this._currentEdge.calcBounds();
                if (this._currentEdge instanceof FigEdgePoly) {
                    ((FigEdgePoly)this._currentEdge).setInitiallyLaidOut(true);
                }
            } else if (tagName.equals("switch")) {
                this._elementState = 65;
                this._textBuf = new StringBuffer();
            } else if (tagName.equals("text")) {
                this._elementState = 15;
                this._textBuf = new StringBuffer();
                FigText figText = this.handleText(attrList);
            }
        }
    }

    public void endElement(String elementName) {
        switch (this._elementState) {
            case 0: {
                if (!"g".equals(elementName)) break;
                --this._nestedGroups;
                break;
            }
            case 3: {
                if (!elementName.equals("path")) break;
                this._elementState = 0;
                this._currentPoly = null;
                break;
            }
            case 2: {
                if (!elementName.equals("line")) break;
                this._elementState = 0;
                this._currentLine = null;
                break;
            }
            case 1: {
                if (!elementName.equals("text")) break;
                this._currentText.setText(this._textBuf.toString());
                this._elementState = 0;
                this._currentText = null;
                this._textBuf = null;
                break;
            }
            case 14: {
                if (!elementName.equals("text")) break;
                this._currentText.setText(this._textBuf.toString());
                this._elementState = 4;
                this._currentText = null;
                this._textBuf = null;
                break;
            }
            case 15: {
                if (!elementName.equals("text")) break;
                this._currentText.setText(this._textBuf.toString());
                this._elementState = 5;
                this._currentText = null;
                this._textBuf = null;
                break;
            }
            case 4: {
                this._elementState = 0;
                this._currentNode = null;
                this._textBuf = null;
                break;
            }
            case 6: {
                this.privateStateEndElement(elementName);
                this._textBuf = null;
                this._elementState = 0;
                break;
            }
            case 64: {
                this.privateStateEndElement(elementName);
                this._textBuf = null;
                this._elementState = 4;
                break;
            }
            case 65: {
                this.privateStateEndElement(elementName);
                this._textBuf = null;
                this._elementState = 5;
            }
        }
    }

    protected Fig findFig(String uri) {
        Fig f = null;
        if (uri.indexOf(".") == -1) {
            f = (Fig)this._figRegistry.get(uri);
        } else {
            StringTokenizer st = new StringTokenizer(uri, ".");
            String figNum = st.nextToken();
            f = (Fig)this._figRegistry.get(figNum);
            if (f instanceof FigEdge) {
                return ((FigEdge)f).getFig();
            }
            while (st.hasMoreElements()) {
                if (!(f instanceof FigGroup)) continue;
                String subIndex = st.nextToken();
                int i = Integer.parseInt(subIndex);
                f = ((FigGroup)f).getFigAt(i);
            }
        }
        return f;
    }

    protected Object findOwner(String uri) {
        Object own = this._ownerRegistry.get(uri);
        return own;
    }

    protected String[] getEntityPaths() {
        return this._entityPaths;
    }

    protected GraphModel getGraphModelFor(String desc) {
        System.out.println("should be: " + desc);
        return new DefaultGraphModel();
    }

    protected FigCircle handleEllipse(Attributes attrList) {
        FigCircle f = new FigCircle(0, 0, 50, 50);
        this.setAttrs(f, attrList);
        String cx = attrList.getValue("cx");
        String cy = attrList.getValue("cy");
        String rx = attrList.getValue("rx");
        String ry = attrList.getValue("ry");
        int cxInt = cx == null || cx.equals("") ? 0 : Integer.parseInt(cx);
        int cyInt = cy == null || cy.equals("") ? 0 : Integer.parseInt(cy);
        int rxInt = rx == null || rx.equals("") ? 10 : Integer.parseInt(rx);
        int ryInt = ry == null || ry.equals("") ? 10 : Integer.parseInt(ry);
        f.setBounds(cxInt - rxInt, cyInt - ryInt, rxInt * 2, ryInt * 2);
        return f;
    }

    protected Fig handleGroup(Attributes attrList) {
        Fig f = null;
        String clsNameBounds = attrList.getValue("class");
        StringTokenizer st = new StringTokenizer(clsNameBounds, ",;[] ");
        String clsName = this.translateClassName(st.nextToken());
        String xStr = null;
        String yStr = null;
        String wStr = null;
        String hStr = null;
        if (st.hasMoreElements()) {
            xStr = st.nextToken();
            yStr = st.nextToken();
            wStr = st.nextToken();
            hStr = st.nextToken();
        }
        try {
            Class<?> nodeClass = Class.forName(this.translateClassName(clsName));
            f = (Fig)nodeClass.newInstance();
            if (xStr != null && !xStr.equals("")) {
                int x = Integer.parseInt(xStr);
                int y = Integer.parseInt(yStr);
                int w = Integer.parseInt(wStr);
                int h = Integer.parseInt(hStr);
                f.setBounds(x, y, w, h);
            }
            if (f instanceof FigNode) {
                FigNode fn;
                this._currentNode = fn = (FigNode)f;
                this._elementState = 4;
                this._textBuf = new StringBuffer();
            }
            if (f instanceof FigEdge) {
                this._currentEdge = (FigEdge)f;
                this._elementState = 5;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception in handleGroup");
            ex.printStackTrace();
        }
        catch (NoSuchMethodError ex) {
            System.out.println("No constructor() in class " + clsName);
            ex.printStackTrace();
        }
        this.setAttrs(f, attrList);
        return f;
    }

    protected FigLine handleLine(Attributes attrList) {
        this._currentLine = new FigLine(0, 0, 100, 100);
        this.setAttrs(this._currentLine, attrList);
        this._x1Int = 0;
        this._y1Int = 0;
        this._elementState = 2;
        return this._currentLine;
    }

    protected FigPoly handlePath(Attributes attrList) {
        String type = attrList.getValue("class");
        FigPoly f = null;
        if (type.equals("org.tigris.gef.presentation.FigPoly")) {
            f = new FigPoly();
        } else if (type.equals("org.tigris.gef.presentation.FigSpline")) {
            f = new FigSpline();
        } else if (type.equals("org.tigris.gef.presentation.FigInk")) {
            f = new FigInk();
        }
        if (f != null) {
            this.setAttrs(f, attrList);
            this._currentPoly = f;
            this._elementState = 3;
            String path = attrList.getValue("d");
            int x = -1;
            int y = -1;
            try {
                StringReader reader = new StringReader(path);
                StreamTokenizer tokenizer = new StreamTokenizer(reader);
                int tok = tokenizer.nextToken();
                while (tok != -1) {
                    if (tok == -2) {
                        if (x == -1) {
                            x = (int)tokenizer.nval;
                        } else {
                            y = (int)tokenizer.nval;
                        }
                        if (x != -1 && y != -1) {
                            f.addPoint(x, y);
                            x = -1;
                            y = -1;
                        }
                    }
                    tok = tokenizer.nextToken();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return f;
    }

    protected Fig handlePolyLine(Attributes attrList) {
        String clsName = this.translateClassName(attrList.getValue("description"));
        if (clsName != null && clsName.indexOf("FigLine") != -1) {
            return this.handleLine(attrList);
        }
        return this.handlePath(attrList);
    }

    protected FigRect handleRect(Attributes attrList) {
        FigRect f;
        String cornerRadius = attrList.getValue("rx");
        if (cornerRadius == null || cornerRadius.equals("")) {
            f = new FigRect(0, 0, 80, 80);
        } else {
            f = new FigRRect(0, 0, 80, 80);
            int rInt = Integer.parseInt(cornerRadius);
            ((FigRRect)f).setCornerRadius(rInt);
        }
        this.setAttrs(f, attrList);
        return f;
    }

    protected void handleSVG(Attributes attrList) {
        String name = attrList.getValue("id");
        String clsName = attrList.getValue("class");
        try {
            if (clsName != null && !clsName.equals("")) {
                this.initDiagram(clsName);
            }
            if (name != null && !name.equals("")) {
                this._diagram.setName(name);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception in handleSVG");
        }
    }

    protected FigText handleText(Attributes attrList) {
        FigText f = new FigText(100, 100, 90, 45);
        this.setAttrs(f, attrList);
        this._elementState = 1;
        this._textBuf = new StringBuffer();
        this._currentText = f;
        String style = attrList.getValue("style");
        if (style != null) {
            String size;
            String font = this.parseStyle("font", style);
            if (font != null) {
                f.setFontFamily(font);
            }
            if ((size = this.parseStyle("font-size", style)) != null) {
                int s = Integer.parseInt(size);
                f.setFontSize(s);
            }
        }
        return f;
    }

    protected void initDiagram(String diagDescr) {
        String clsName = diagDescr;
        String initStr = null;
        int bar = diagDescr.indexOf("|");
        if (bar != -1) {
            clsName = diagDescr.substring(0, bar);
            initStr = diagDescr.substring(bar + 1);
        }
        String newClassName = this.translateClassName(clsName);
        try {
            Class<?> cls = Class.forName(newClassName);
            this._diagram = (Diagram)cls.newInstance();
            if (initStr != null && !initStr.equals("")) {
                this._diagram.initialize(this.findOwner(initStr));
            }
        }
        catch (Exception ex) {
            System.out.println("could not set diagram type to " + newClassName);
            ex.printStackTrace();
        }
    }

    protected void lineStateStartElement(String tagName, Attributes attrList) {
        if (this._currentLine != null) {
            if (tagName.equals("desc") || tagName.equals("title")) {
                // empty if block
            }
            if (tagName.equals("moveto")) {
                String x1 = attrList.getValue("x");
                String y1 = attrList.getValue("y");
                this._x1Int = x1 == null || x1.equals("") ? 0 : Integer.parseInt(x1);
                this._y1Int = y1 == null || y1.equals("") ? 0 : Integer.parseInt(y1);
                this._currentLine.setX1(this._x1Int);
                this._currentLine.setY1(this._y1Int);
            } else if (tagName.equals("lineto")) {
                String x2 = attrList.getValue("x");
                String y2 = attrList.getValue("y");
                int x2Int = x2 == null || x2.equals("") ? this._x1Int : Integer.parseInt(x2);
                int y2Int = y2 == null || y2.equals("") ? this._y1Int : Integer.parseInt(y2);
                this._currentLine.setX2(x2Int);
                this._currentLine.setY2(y2Int);
            }
        }
    }

    private void nodeStateStartElement(String tagName, Attributes attrList) {
        if (!tagName.equals("desc") && !tagName.equals("title")) {
            if (tagName.equals("switch")) {
                this._textBuf = new StringBuffer();
                this._elementState = 64;
            } else if (tagName.equals("text")) {
                this._textBuf = new StringBuffer();
                this._elementState = 14;
                FigText figText = this.handleText(attrList);
            }
        }
    }

    protected Color parseColor(String name, Color defaultColor) {
        try {
            int start = name.indexOf("rgb", 0);
            if (start != -1) {
                start = name.indexOf("(", start);
                int end = name.indexOf(",", start);
                if (start != -1) {
                    int red = Integer.parseInt(name.substring(++start, end).trim());
                    start = end + 1;
                    end = name.indexOf(",", start);
                    int green = Integer.parseInt(name.substring(start, end).trim());
                    start = end + 1;
                    end = name.indexOf(")", start);
                    int blue = Integer.parseInt(name.substring(start, end).trim());
                    return new Color(red, green, blue);
                }
                return defaultColor;
            }
        }
        catch (Exception ex) {
            System.out.println("invalid rgb() sequence: " + name);
            return defaultColor;
        }
        if (name.equalsIgnoreCase("none")) {
            return null;
        }
        if (name.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (name.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (name.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (name.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (name.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (name.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (name.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (name.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (name.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (name.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (name.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (name.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (name.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        try {
            return Color.decode(name);
        }
        catch (Exception ex) {
            System.out.println("invalid color code string: " + name);
            return defaultColor;
        }
    }

    protected String parseStyle(String field, String style) {
        int start = style.indexOf(field = field + ":", 0);
        if (start != -1) {
            int end = style.indexOf(";", start);
            if (end != -1) {
                return style.substring(start + field.length(), end).trim();
            }
            return style.substring(start + field.length(), style.length() - 1).trim();
        }
        return null;
    }

    private void polyStateStartElement(String tagName, Attributes attrList) {
        if (this._currentPoly != null && !tagName.equals("desc") && !tagName.equals("title")) {
            if (tagName.equals("moveto")) {
                String x1 = attrList.getValue("x");
                String y1 = attrList.getValue("y");
                this._x1Int = x1 == null || x1.equals("") ? 0 : Integer.parseInt(x1);
                this._y1Int = y1 == null || y1.equals("") ? 0 : Integer.parseInt(y1);
                this._currentPoly.addPoint(this._x1Int, this._y1Int);
            } else if (tagName.equals("lineto")) {
                String x2 = attrList.getValue("x");
                String y2 = attrList.getValue("y");
                int x2Int = x2 == null || x2.equals("") ? this._x1Int : Integer.parseInt(x2);
                int y2Int = y2 == null || y2.equals("") ? this._y1Int : Integer.parseInt(y2);
                this._currentPoly.addPoint(x2Int, y2Int);
            }
        }
    }

    private void privateStateEndElement(String tagName) {
        if (this._currentNode != null) {
            if (this._currentEdge != null) {
                this._currentEdge = null;
            }
            this._currentNode.setPrivateData(this._textBuf.toString());
            String body = this._textBuf.toString();
            StringTokenizer st2 = new StringTokenizer(body, "=\"' \t\n");
            Fig encloser = null;
            while (st2.hasMoreElements()) {
                String t = st2.nextToken();
                String v = "no such fig";
                if (st2.hasMoreElements()) {
                    v = st2.nextToken();
                }
                if (t.equals("enclosingFig")) {
                    encloser = this.findFig(v);
                }
                if (!t.equals("text")) continue;
            }
            this._currentNode.setEnclosingFig(encloser);
        }
        if (this._currentEdge != null) {
            Fig spf = null;
            Fig dpf = null;
            FigNode sfn = null;
            FigNode dfn = null;
            String body = this._textBuf.toString();
            StringTokenizer st2 = new StringTokenizer(body, "=\"' \t\n");
            while (st2.hasMoreElements()) {
                String t = st2.nextToken();
                String v = st2.nextToken();
                if (t.equals("sourcePortFig")) {
                    spf = this.findFig(v);
                }
                if (t.equals("destPortFig")) {
                    dpf = this.findFig(v);
                }
                if (t.equals("sourceFigNode")) {
                    sfn = (FigNode)this.findFig(v);
                }
                if (!t.equals("destFigNode")) continue;
                dfn = (FigNode)this.findFig(v);
            }
            this._currentEdge.setSourcePortFig(spf);
            this._currentEdge.setDestPortFig(dpf);
            this._currentEdge.setSourceFigNode(sfn);
            this._currentEdge.setDestFigNode(dfn);
        }
    }

    public synchronized Diagram readDiagram(URL url) {
        try {
            InputStream is = url.openStream();
            String filename = url.getFile();
            System.out.println("=======================================");
            System.out.println("== READING DIAGRAM: " + url);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            this.initDiagram("org.tigris.gef.base.Diagram");
            this._figRegistry = new HashMap();
            SAXParser pc = factory.newSAXParser();
            InputSource source = new InputSource(is);
            source.setSystemId(url.toString());
            pc.parse(source, (DefaultHandler)this);
            source = null;
            is.close();
            return this._diagram;
        }
        catch (Exception ex) {
            System.out.println("Exception in readDiagram");
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = null;
        try {
            URL url = new URL(systemId);
            try {
                source = new InputSource(url.openStream());
                source.setSystemId(systemId);
                if (publicId != null) {
                    source.setPublicId(publicId);
                }
            }
            catch (IOException e) {
                if (systemId.endsWith(".dtd")) {
                    int i = systemId.lastIndexOf(47);
                    ++i;
                    String[] entityPaths = this.getEntityPaths();
                    InputStream is = null;
                    for (int pathIndex = 0; pathIndex < entityPaths.length && is == null; ++pathIndex) {
                        String DTD_DIR = entityPaths[pathIndex];
                        is = this.getClass().getResourceAsStream(DTD_DIR + systemId.substring(i));
                        if (is != null) continue;
                        try {
                            is = new FileInputStream(DTD_DIR.substring(1) + systemId.substring(i));
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        source = new InputSource(is);
                        source.setSystemId(systemId);
                        if (publicId != null) {
                            source.setPublicId(publicId);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (source == null) {
            source = new InputSource();
            source.setSystemId(systemId);
        }
        return source;
    }

    protected void setAttrs(Fig f, Attributes attrList) {
        String style;
        String x;
        String name = attrList.getValue("id");
        if (name != null && !name.equals("")) {
            this._figRegistry.put(name, f);
        }
        if ((x = attrList.getValue("x")) != null && !x.equals("")) {
            String y = attrList.getValue("y");
            String w = attrList.getValue("width");
            String h = attrList.getValue("height");
            int xInt = Integer.parseInt(x);
            int yInt = y == null || y.equals("") ? 0 : Integer.parseInt(y);
            int wInt = w == null || w.equals("") ? 20 : Integer.parseInt(w);
            int hInt = h == null || h.equals("") ? 20 : Integer.parseInt(h);
            f.setBounds(xInt, yInt, wInt, hInt);
        }
        if ((style = attrList.getValue("style")) != null) {
            String fillcolor = this.parseStyle("fill", style);
            if (fillcolor != null && !fillcolor.equals("")) {
                f.setFillColor(this.parseColor(fillcolor, Color.blue));
            }
            if (!(f instanceof FigNode)) {
                String dasharray;
                String strokecolor;
                String linewidth = this.parseStyle("stroke-width", style);
                if (linewidth != null && !linewidth.equals("")) {
                    f.setLineWidth(Integer.parseInt(linewidth));
                }
                if ((strokecolor = this.parseStyle("stroke", style)) != null && !strokecolor.equals("")) {
                    f.setLineColor(this.parseColor(strokecolor, Color.blue));
                }
                if ((dasharray = this.parseStyle("stroke-dash-array", style)) != null && !dasharray.equals("") && !dasharray.equals("1")) {
                    f.setDashed(true);
                }
            }
        }
        this.setOwnerAttr(f, attrList);
    }

    protected void setOwnerAttr(Fig f, Attributes attrList) {
        try {
            String owner = attrList.getValue("href");
            if (owner != null && !owner.equals("")) {
                f.setOwner(this.findOwner(owner));
            }
        }
        catch (Exception ex) {
            System.out.println("could not set owner");
        }
    }

    public void setOwnerRegistry(Map owners) {
        this._ownerRegistry = owners;
    }

    public void startElement(String elementName, Attributes attrList) {
        switch (this._elementState) {
            case 0: {
                if ("g".equals(elementName)) {
                    ++this._nestedGroups;
                    this._diagram.add(this.handleGroup(attrList));
                    break;
                }
                if (elementName.equals("svg")) {
                    this.handleSVG(attrList);
                    break;
                }
                if (this._nestedGroups == 0) {
                    if (elementName.equals("path")) {
                        this._diagram.add(this.handlePolyLine(attrList));
                        break;
                    }
                    if (elementName.equals("ellipse")) {
                        this._diagram.add(this.handleEllipse(attrList));
                        break;
                    }
                    if (elementName.equals("rect")) {
                        this._diagram.add(this.handleRect(attrList));
                        break;
                    }
                    if (elementName.equals("text")) {
                        this._elementState = 1;
                        this._diagram.add(this.handleText(attrList));
                        break;
                    }
                    if (elementName.equals("line") || elementName.equals("line") || elementName.equals("path")) break;
                    System.out.println("unknown top-level tag: " + elementName);
                    break;
                }
                if (this._nestedGroups <= 0) break;
                break;
            }
            case 2: {
                this.lineStateStartElement(elementName, attrList);
                break;
            }
            case 3: {
                this.polyStateStartElement(elementName, attrList);
                break;
            }
            case 4: {
                this.nodeStateStartElement(elementName, attrList);
                break;
            }
            case 5: {
                this.edgeStateStartElement(elementName, attrList);
            }
        }
    }

    protected String translateClassName(String oldName) {
        return oldName;
    }
}

