/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.presentation.Fig;

public class FigDiamond
extends Fig {
    private static final long serialVersionUID = -5625367072029450739L;

    public FigDiamond(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public FigDiamond(int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
    }

    public FigDiamond(int x, int y, int w, int h, boolean resizable) {
        super(x, y, w, h);
        this.setResizable(resizable);
    }

    public FigDiamond(int x, int y, int w, int h, boolean resizable, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
        this.setResizable(resizable);
    }

    @Override
    public List getGravityPoints() {
        ArrayList<Point> ret = new ArrayList<Point>(4);
        ret.add(new Point(this._x + this._w / 2, this._y));
        ret.add(new Point(this._x + this._w, this._y + this._h / 2));
        ret.add(new Point(this._x + this._w / 2, this._y + this._h));
        ret.add(new Point(this._x, this._y + this._h / 2));
        return ret;
    }

    @Override
    public void paint(Object graphicContext) {
        int[] xs = new int[4];
        int[] ys = new int[4];
        xs[0] = this._x + this._w / 2;
        ys[0] = this._y;
        xs[1] = this._x + this._w;
        ys[1] = this._y + this._h / 2;
        xs[2] = this._x + this._w / 2;
        ys[2] = this._y + this._h;
        xs[3] = this._x;
        ys[3] = this._y + this._h / 2;
        Graphics g = (Graphics)graphicContext;
        if (this._filled && this.getFillColor() != null) {
            g.setColor(this.getFillColor());
            g.fillPolygon(xs, ys, 4);
        }
        if (this.getLineWidth() > 0 && this.getLineColor() != null) {
            g.setColor(this.getLineColor());
            g.drawPolygon(xs, ys, 4);
        }
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        sb.append("<path id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("' style='fill:none; stroke-width:").append(this.getLineWidth()).append("; stroke:rgb(").append(this.getLineColor().getRed()).append(",").append(this.getLineColor().getGreen()).append(',').append(this.getLineColor().getBlue()).append(" ;' d='");
        for (int i = 0; i < this.getPoints().length; ++i) {
            if (i == 0) {
                sb.append("M ");
            } else {
                sb.append("L ");
            }
            sb.append(this.getPoint((int)i).x).append(',').append(this.getPoint((int)i).y);
        }
        sb.append(" ' />");
    }
}

