/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.presentation.Fig;

public class FigLine
extends Fig {
    private static final long serialVersionUID = -6961837549764335095L;
    protected int _x1;
    protected int _y1;
    protected int _x2;
    protected int _y2;

    public FigLine(int x1, int y1, int x2, int y2, Color lineColor) {
        this.setX1(x1);
        this.setY1(y1);
        this.setX2(x2);
        this.setY2(y2);
        this.setLineColor(lineColor);
        this.calcBounds();
    }

    public FigLine(int x1, int y1, int x2, int y2) {
        this.setX1(x1);
        this.setY1(y1);
        this.setX2(x2);
        this.setY2(y2);
        this.calcBounds();
    }

    public FigLine() {
        this.setX1(0);
        this.setY1(0);
        this.setX2(0);
        this.setY2(10);
        this.calcBounds();
    }

    public final void setShape(Point p1, Point p2) {
        this.setShape(p1.x, p1.y, p2.x, p2.y);
    }

    public void setShape(int x1, int y1, int x2, int y2) {
        this._x1 = x1;
        this._y1 = y1;
        this._x2 = x2;
        this._y2 = y2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public int getX1() {
        return this._x1;
    }

    public int getY1() {
        return this._y1;
    }

    public int getX2() {
        return this._x2;
    }

    public int getY2() {
        return this._y2;
    }

    public void setX1(int x1) {
        this._x1 = x1;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY1(int y1) {
        this._y1 = y1;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setX2(int x2) {
        this._x2 = x2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY2(int y2) {
        this._y2 = y2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isReshapable() {
        return true;
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    @Override
    public void setPoints(Point[] ps) {
        if (ps.length != 2) {
            throw new IllegalArgumentException("FigLine must have exactly 2 points");
        }
        this._x1 = ps[0].x;
        this._y1 = ps[0].y;
        this._x2 = ps[1].x;
        this._y2 = ps[1].y;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public Point[] getPoints() {
        Point[] ps = new Point[]{new Point(this._x1, this._y1), new Point(this._x2, this._y2)};
        return ps;
    }

    public void setPoints(int i, int x, int y) {
        if (i == 0) {
            this._x1 = x;
            this._y1 = y;
        } else if (i == 1) {
            this._x2 = x;
            this._y2 = y;
        } else {
            throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
        }
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public void setPoint(int i, int x, int y) {
        if (i == 0) {
            this._x1 = x;
            this._y1 = y;
        } else if (i == 1) {
            this._x2 = x;
            this._y2 = y;
        } else {
            throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
        }
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public Point getPoint(int i) {
        if (i == 0) {
            return new Point(this._x1, this._y1);
        }
        if (i == 1) {
            return new Point(this._x2, this._y2);
        }
        throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
    }

    @Override
    public int getNumPoints() {
        return 2;
    }

    @Override
    public int[] getXs() {
        int[] xs = new int[]{this._x1, this._x2};
        return xs;
    }

    @Override
    public int[] getYs() {
        int[] ys = new int[]{this._y1, this._y2};
        return ys;
    }

    @Override
    public int getPerimeterLength() {
        int dxdx = (this._x2 - this._x1) * (this._x2 - this._x1);
        int dydy = (this._y2 - this._y1) * (this._y2 - this._y1);
        return (int)Math.sqrt(dxdx + dydy);
    }

    @Override
    public void stuffPointAlongPerimeter(int dist, Point res) {
        int len = this.getPerimeterLength();
        if (dist <= 0) {
            res.x = this._x1;
            res.y = this._y1;
            return;
        }
        if (dist >= len) {
            res.x = this._x2;
            res.y = this._y2;
            return;
        }
        res.x = this._x1 + (this._x2 - this._x1) * dist / len;
        res.y = this._y1 + (this._y2 - this._y1) * dist / len;
    }

    @Override
    protected void setBoundsImpl(int x, int y, int w, int h) {
        this._x1 = this._w == 0 ? x : x + (this._x1 - this._x) * w / this._w;
        this._y1 = this._h == 0 ? y : y + (this._y1 - this._y) * h / this._h;
        this._x2 = this._w == 0 ? x : x + (this._x2 - this._x) * w / this._w;
        this._y2 = this._h == 0 ? y : y + (this._y2 - this._y) * h / this._h;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public Point connectionPoint(Point anotherPt) {
        return Geometry.ptClosestTo(this._x1, this._y1, this._x2, this._y2, anotherPt);
    }

    @Override
    protected void translateImpl(int dx, int dy) {
        this._x1 += dx;
        this._y1 += dy;
        this._x2 += dx;
        this._y2 += dy;
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", null, null);
    }

    @Override
    public void calcBounds() {
        if (this._x1 < this._x2) {
            this._x = this._x1;
            this._w = this._x2 - this._x1;
        } else {
            this._x = this._x2;
            this._w = this._x1 - this._x2;
        }
        if (this._y1 < this._y2) {
            this._y = this._y1;
            this._h = this._y2 - this._y1;
        } else {
            this._y = this._y2;
            this._h = this._y1 - this._y2;
        }
    }

    @Override
    public void paint(Object g) {
        plotter.drawLine(g, this.getLineWidth(), this.getLineColor(), this._x1, this._y1, this._x2, this._y2, this.getDashed(), this._dashes, this._dashPeriod);
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        sb.append("<line id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("'");
        this.appendSvgStyle(sb);
        sb.append(" x1 = '").append(this.getX1()).append("'").append(" y1 = '").append(this.getY1()).append("'").append(" x2 = '").append(this.getX2()).append("'").append(" y2 = '").append(this.getY2()).append("' />");
    }

    @Override
    public boolean hit(Rectangle r) {
        return this.intersects(r);
    }

    @Override
    public void createDrag(int anchorX, int anchorY, int x, int y, int snapX, int snapY) {
        this._x2 = snapX;
        this._y2 = snapY;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public boolean intersectsPerimeter(Rectangle rect) {
        return this.intersects(rect);
    }

    @Override
    public boolean intersects(Rectangle rect) {
        return rect.intersectsLine(this._x1, this._y1, this._x2, this._y2);
    }
}

