/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.properties.PropCategoryManager;

public class FigRRect
extends FigRect {
    private static final long serialVersionUID = -4984437962118691063L;
    protected int _radius = 16;

    public FigRRect(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public FigRRect(int x, int y, int w, int h, Color lineColor, Color fillColor) {
        super(x, y, w, h, lineColor, fillColor);
    }

    public int getCornerRadius() {
        return this._radius;
    }

    public void setCornerRadius(int r) {
        this._radius = r;
    }

    @Override
    public void paint(Object graphicContext) {
        Graphics g = (Graphics)graphicContext;
        if (this._filled && this._fillColor != null) {
            if (this._lineColor != null && this._lineWidth > 1) {
                this.drawFilledRRectWithWideLine(g);
            } else {
                this.drawFilledRRect(g);
            }
        } else if (this._lineColor != null && this._lineWidth > 1) {
            this.drawEmptyRRectWithWideLine(g);
        } else {
            this.drawEmptyRRect(g);
        }
    }

    private void drawFilledRRect(Graphics g) {
        g.setColor(this._fillColor);
        g.fillRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        if (this._lineColor != null && this._lineWidth == 1) {
            g.setColor(this._lineColor);
            g.drawRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        }
    }

    private void drawFilledRRectWithWideLine(Graphics g) {
        int lineWidth2 = this._lineWidth * 2;
        g.setColor(this._lineColor);
        g.fillRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        g.setColor(this._fillColor);
        g.fillRoundRect(this._x + this._lineWidth, this._y + this._lineWidth, this._w - lineWidth2, this._h - lineWidth2, this._radius, this._radius);
    }

    private void drawEmptyRRect(Graphics g) {
        if (this._lineColor != null && this._lineWidth == 1) {
            g.setColor(this._lineColor);
            g.drawRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        }
    }

    private void drawEmptyRRectWithWideLine(Graphics g) {
        if (this._lineColor != null && this._lineWidth > 1) {
            int xx = this._x;
            int yy = this._y;
            int ww = this._w;
            int hh = this._h;
            g.setColor(this._lineColor);
            for (int i = 0; i < this._lineWidth; ++i) {
                g.drawRoundRect(xx++, yy++, ww, hh, this._radius, this._radius);
                ww -= 2;
                hh -= 2;
            }
        }
    }

    static {
        PropCategoryManager.categorizeProperty("Geometry", "cornerRadius");
    }
}

