/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.persistence.export.FontUtility;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigTextEditor;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;

public class FigText
extends Fig
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 4659312817576456477L;
    public static final int IGNORE = 0;
    public static final int INSERT = 1;
    public static final int END_EDITING = 2;
    private int returnAction = 0;
    private int tabAction = 0;
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int MIN_TEXT_WIDTH = 30;
    private static final char HARD_RETURN = '\n';
    private static final char SOFT_RETURN = '\r';
    private Font _font = new Font("TimesRoman", 0, 10);
    private transient FontMetrics _fm;
    private int _lineHeight;
    private Color _textColor = Color.black;
    private Color _textFillColor = Color.white;
    private boolean _textFilled = false;
    private boolean editable = true;
    private Class _textEditorClass = FigTextEditor.class;
    private boolean _underline = false;
    private boolean wordWrap = false;
    private int _lineSpacing = 0;
    private int _topMargin = 0;
    private int _botMargin = 0;
    private int _leftMargin = 0;
    private int _rightMargin = 0;
    private boolean _expandOnly = false;
    private boolean _editMode = false;
    private int _justification = 0;
    private String _curText;
    private String lineSeparator;
    private static final Log LOG = LogFactory.getLog(FigText.class);

    public FigText(int x, int y, int w, int h, Color textColor, String familyName, int fontSize, boolean expandOnly) {
        super(x, y, w, h);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this._textColor = textColor;
        this._font = new Font(familyName, 0, fontSize);
        this._justification = 2;
        this._curText = "";
        this._expandOnly = expandOnly;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public FigText(int x, int y, int w, int h, Color textColor, String familyName, int fontSize) {
        this(x, y, w, h, textColor, familyName, fontSize, false);
    }

    public FigText(int x, int y, int w, int h, Color textColor, Font font) {
        this(x, y, w, h, textColor, font.getName(), font.getSize());
    }

    public FigText(int x, int y, int w, int h) {
        super(x, y, w, h);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this._justification = 2;
        this._curText = "";
        this._expandOnly = false;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public FigText(int x, int y, int w, int h, boolean expandOnly) {
        super(x, y, w, h);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this._justification = 2;
        this._curText = "";
        this._expandOnly = expandOnly;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public String getJustificationByName() {
        if (this._justification == 0) {
            return "Left";
        }
        if (this._justification == 2) {
            return "Center";
        }
        if (this._justification == 1) {
            return "Right";
        }
        LOG.error((Object)"internal error, unknown text alignment");
        return "Unknown";
    }

    public void setJustificationByName(String justifyString) {
        if (justifyString.equals("Left")) {
            this._justification = 0;
        } else if (justifyString.equals("Center")) {
            this._justification = 2;
        } else if (justifyString.equals("Right")) {
            this._justification = 1;
        }
        this._fm = null;
    }

    protected FontMetrics getFontMetrics() {
        return this._fm;
    }

    public Color getTextColor() {
        return this._textColor;
    }

    public void setTextColor(Color c) {
        this.firePropChange("textColor", this._textColor, c);
        this._textColor = c;
    }

    public Color getTextFillColor() {
        return this._textFillColor;
    }

    public void setTextFillColor(Color c) {
        this.firePropChange("textFillColor", this._textFillColor, c);
        this._textFillColor = c;
    }

    public boolean getTextFilled() {
        return this._textFilled;
    }

    public void setTextFilled(boolean b) {
        this.firePropChange("textFilled", this._textFilled, b);
        this._textFilled = b;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean e) {
        this.firePropChange("editable", this.editable, e);
        this.editable = e;
    }

    public boolean getUnderline() {
        return this._underline;
    }

    public void setUnderline(boolean b) {
        this.firePropChange("underline", this._underline, b);
        this._underline = b;
    }

    public int getJustification() {
        return this._justification;
    }

    public void setJustification(int align) {
        this.firePropChange("justification", this.getJustification(), align);
        this._justification = align;
    }

    public int getLineSpacing() {
        return this._lineSpacing;
    }

    public void setLineSpacing(int s) {
        this.firePropChange("lineSpacing", this._lineSpacing, s);
        this._lineSpacing = s;
        this.calcBounds();
    }

    public int getTopMargin() {
        return this._topMargin;
    }

    public void setTopMargin(int m) {
        this.firePropChange("topMargin", this._topMargin, m);
        this._topMargin = m;
        this.calcBounds();
    }

    public int getBotMargin() {
        return this._botMargin;
    }

    public void setBotMargin(int m) {
        this.firePropChange("botMargin", this._botMargin, m);
        this._botMargin = m;
        this.calcBounds();
    }

    public int getLeftMargin() {
        return this._leftMargin;
    }

    public void setLeftMargin(int m) {
        this.firePropChange("leftMargin", this._leftMargin, m);
        this._leftMargin = m;
        this.calcBounds();
    }

    public int getRightMargin() {
        return this._rightMargin;
    }

    public void setRightMargin(int m) {
        this.firePropChange("rightMargin", this._rightMargin, m);
        this._rightMargin = m;
        this.calcBounds();
    }

    public boolean getExpandOnly() {
        return this._expandOnly;
    }

    public void setExpandOnly(boolean b) {
        this.firePropChange("expandOnly", this._expandOnly, b);
        this._expandOnly = b;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font f) {
        this.firePropChange("font", this._font, f);
        this._font = f;
        this._fm = null;
        this.calcBounds();
    }

    public String getFontFamily() {
        return this._font.getFamily();
    }

    public void setFontFamily(String familyName) {
        Font f = new Font(familyName, this._font.getStyle(), this._font.getSize());
        this.setFont(f);
    }

    public int getFontSize() {
        return this._font.getSize();
    }

    public void setFontSize(int size) {
        Font f = new Font(this._font.getFamily(), this._font.getStyle(), size);
        this.setFont(f);
    }

    public boolean getItalic() {
        return this._font.isItalic();
    }

    public void setItalic(boolean b) {
        int style = (this.getBold() ? 1 : 0) + (b ? 2 : 0);
        Font f = new Font(this._font.getFamily(), style, this._font.getSize());
        this.setFont(f);
    }

    public boolean getBold() {
        return this._font.isBold();
    }

    public void setBold(boolean b) {
        int style = (b ? 1 : 0) + (this.getItalic() ? 2 : 0);
        this.setFont(new Font(this._font.getFamily(), style, this._font.getSize()));
    }

    public void setMultiLine(boolean b) {
        this.returnAction = b ? 1 : 2;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean getMultiLine() {
        return this.returnAction == 1;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setReturnAction(int action) {
        this.returnAction = action;
    }

    public void setTabAction(int action) {
        this.tabAction = action;
    }

    public int getTabAction() {
        return this.tabAction;
    }

    public int getReturnAction() {
        return this.returnAction;
    }

    public void setAllowsTab(boolean b) {
        this.tabAction = b ? 1 : 2;
    }

    public void setWordWrap(boolean b) {
        this.wordWrap = b;
    }

    public boolean getAllowsTab() {
        return this.tabAction == 1;
    }

    public String deleteLastCharFromString(String s) {
        int len = Math.max(s.length() - 1, 0);
        char[] chars = s.toCharArray();
        return new String(chars, 0, len);
    }

    public void deleteLastChar() {
        this._curText = this.deleteLastCharFromString(this._curText);
        this.calcBounds();
    }

    public void append(char c) {
        this.setText(this._curText + c);
    }

    public void append(String s) {
        this.setText(this._curText + s);
    }

    public void setText(String str, Graphics graphics) {
        if (graphics != null) {
            this._fm = graphics.getFontMetrics(this._font);
        }
        this.setText(str);
    }

    public void setText(String s) {
        FigTextEditor editor = FigTextEditor.getInstance();
        String newText = this.encode(s, this.lineSeparator);
        if (editor.isVisible() && editor.getFigText() == this && !this._curText.equals(newText)) {
            editor.cancelEditing();
        }
        this._curText = newText;
        this.calcBounds();
        this._editMode = false;
    }

    void setTextFriend(String str, Graphics graphics) {
        if (graphics != null) {
            this._fm = graphics.getFontMetrics(this._font);
        }
        this.setTextFriend(str);
    }

    void setTextFriend(String s) {
        if (UndoManager.getInstance().isGenerateMementos() && this.getOwner(this) == null) {
            Memento memento = new Memento(){
                String oldText;
                {
                    this.oldText = FigText.this._curText;
                }

                @Override
                public void undo() {
                    FigText.this._curText = this.oldText;
                    FigText.this.redraw();
                }

                @Override
                public void redo() {
                    this.undo();
                }

                @Override
                public void dispose() {
                }
            };
            UndoManager.getInstance().addMemento(memento);
        }
        this._curText = this.encode(s, System.getProperty("line.separator"));
        this.calcBounds();
        this._editMode = false;
    }

    private Object getOwner(Fig fig) {
        Object owner = fig.getOwner();
        if (owner != null) {
            return owner;
        }
        Fig figGroup = fig.getGroup();
        if (figGroup == null) {
            return null;
        }
        return this.getOwner(figGroup);
    }

    public String getText() {
        String text = this.decode(this._curText, this.lineSeparator);
        return text;
    }

    public String getTextFriend() {
        return this.decode(this._curText, System.getProperty("line.separator"));
    }

    public Class getTextEditorClass() {
        return this._textEditorClass;
    }

    public void setTextEditorClass(Class editorClass) {
        this._textEditorClass = editorClass;
    }

    @Override
    public void paint(Object graphicContext) {
        int chunkW;
        String curLine;
        StringTokenizer lines;
        if (!this.isVisible()) {
            return;
        }
        int chunkX = this._x + this._leftMargin;
        int chunkY = this._y + this._topMargin;
        int lineWidth = this.getLineWidth();
        Graphics g = (Graphics)graphicContext;
        if (this.getFilled()) {
            g.setColor(this.getFillColor());
            g.fillRect(this._x, this._y, this._w, this._h);
        }
        if (lineWidth > 0) {
            g.setColor(this.getLineColor());
            if (lineWidth == 1) {
                g.drawRect(this._x, this._y, this._w - lineWidth, this._h - lineWidth);
            } else {
                for (int i = 0; i < lineWidth; ++i) {
                    g.drawLine(this._x + i, this._y + i, this._x + this._w - i, this._y + i);
                    g.drawLine(this._x + this._w - i, this._y + i, this._x + this._w - i, this._y + this._h - i);
                    g.drawLine(this._x + this._w - i, this._y + this._h - i, this._x + i, this._y + this._h - i);
                    g.drawLine(this._x + i, this._y + this._h - i, this._x + i, this._y + i);
                }
            }
        }
        if (this._font != null) {
            g.setFont(this._font);
        }
        this._fm = g.getFontMetrics(this._font);
        int chunkH = this._fm.getHeight() + this._lineSpacing;
        chunkY = this._y + this._topMargin + chunkH;
        if (this._textFilled) {
            g.setColor(this._textFillColor);
            lines = new StringTokenizer(this._curText, "\n\r", true);
            while (lines.hasMoreTokens() && chunkY <= this.getHeight() + this.getY() + this._topMargin - this._botMargin) {
                curLine = lines.nextToken();
                chunkW = this._fm.stringWidth(curLine);
                switch (this._justification) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        chunkX = this._x + (this._w - chunkW) / 2;
                        break;
                    }
                    case 1: {
                        chunkX = this._x + this._w - chunkW - this._rightMargin;
                    }
                }
                if (curLine.charAt(0) == '\n' || curLine.charAt(0) == '\r') {
                    chunkY += chunkH;
                    continue;
                }
                g.fillRect(chunkX, chunkY - chunkH, chunkW, chunkH);
            }
        }
        g.setColor(this._textColor);
        chunkX = this._x + this._leftMargin;
        chunkY = this._y + this._topMargin + chunkH;
        lines = new StringTokenizer(this._curText, "\n\r", true);
        while (lines.hasMoreTokens() && chunkY <= this.getHeight() + this.getY() + this._topMargin - this._botMargin) {
            curLine = lines.nextToken();
            chunkW = this._fm.stringWidth(curLine);
            switch (this._justification) {
                case 0: {
                    break;
                }
                case 2: {
                    chunkX = this._x + (this._w - chunkW) / 2;
                    break;
                }
                case 1: {
                    chunkX = this._x + this._w - chunkW;
                }
            }
            if (this.isHardReturn(curLine) || this.isSoftReturn(curLine)) {
                chunkY += chunkH;
                continue;
            }
            if (this._underline) {
                g.drawLine(chunkX, chunkY + 1, chunkX + chunkW, chunkY + 1);
            }
            this.drawString(g, curLine, chunkX, chunkY);
        }
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        sb.append("<text id ='").append(this.getId()).append("' x='").append(this.getX()).append("' y='").append(this.getY()).append("' transform='translate(").append(this.getFontSize()).append(',').append(this.getFontSize()).append(")'");
        this.appendSvgStyle(sb);
        sb.append(">").append(this.getText()).append("</text>");
    }

    @Override
    protected void appendSvgStyle(StringBuffer sb) {
        sb.append(" style='fill:rgb(").append(this.getFillColor().getRed()).append(",").append(this.getFillColor().getGreen()).append(",").append(this.getFillColor().getBlue()).append(");").append("stroke-width:").append(this.getLineWidth()).append(";").append("stroke:rgb(").append(this.getLineColor().getRed()).append(",").append(this.getLineColor().getGreen()).append(",").append(this.getLineColor().getBlue()).append(");'").append("font:").append(this.getFontFamily()).append("; font-size:").append(this.getFontSize()).append("'");
    }

    protected void drawString(Graphics graphics, String curLine, int xPos, int yPos) {
        graphics.drawString(curLine, xPos, yPos);
    }

    @Override
    public boolean hit(Rectangle r) {
        int cornersHit = this.countCornersContained(r.x, r.y, r.width, r.height);
        return cornersHit > 0;
    }

    public int getMinimumHeight() {
        if (this._fm != null) {
            return this._fm.getHeight();
        }
        if (this._font != null) {
            return this._font.getSize();
        }
        return 0;
    }

    public int getTextBounds(Graphics graphics) {
        if (this._font != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            return fontMetrics.stringWidth(this.getText());
        }
        return 0;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = new Dimension(0, 0);
        this.stuffMinimumSize(d);
        return d;
    }

    public void stuffMinimumSize(Dimension d) {
        if (this._font == null) {
            return;
        }
        int overallW = 0;
        int numLines = 1;
        StringTokenizer lines = new StringTokenizer(this._curText, "\n\r", true);
        while (lines.hasMoreTokens()) {
            String curLine = lines.nextToken();
            int chunkW = this._fm.stringWidth(curLine);
            if (curLine.charAt(0) == '\n' || curLine.charAt(0) == '\r') {
                ++numLines;
                continue;
            }
            overallW = Math.max(chunkW, overallW);
        }
        this._lineHeight = this._fm == null ? this._font.getSize() : this._fm.getHeight();
        int maxDescent = 0;
        int overallH = (this._lineHeight + this._lineSpacing) * numLines + this._topMargin + this._botMargin + maxDescent;
        overallH = Math.max(overallH, this.getMinimumHeight());
        d.width = overallW = Math.max(30, overallW + this._leftMargin + this._rightMargin);
        d.height = overallH;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (this.isStartEditingKey(ke) && this.editable) {
            ke.consume();
            FigTextEditor te = this.startTextEditor(ke);
            if (!Character.isISOControl(ke.getKeyChar())) {
                te.setText(te.getText() + ke.getKeyChar());
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    protected boolean isStartEditingKey(KeyEvent ke) {
        return !Character.isISOControl(ke.getKeyChar());
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        if (me.getClickCount() >= 2 && this.editable) {
            this.startTextEditor(me);
            me.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    public FigTextEditor startTextEditor(InputEvent ie) {
        FigTextEditor te = FigTextEditor.getInstance();
        te.init(this, ie);
        this._editMode = true;
        return te;
    }

    @Override
    public void calcBounds() {
        if (this._font == null) {
            return;
        }
        if (this._fm == null) {
            this._fm = FigTextEditor.getInstance().getFontMetrics(this._font);
        }
        this._lineHeight = this._fm.getHeight();
        int maxDescent = this._fm.getMaxDescent();
        int overallW = 0;
        int numLines = 1;
        StringTokenizer lines = new StringTokenizer(this._curText, "\n\r", true);
        while (lines.hasMoreTokens()) {
            String curLine = lines.nextToken();
            int chunkW = this._fm.stringWidth(curLine);
            if (this.isHardReturn(curLine) || this.isSoftReturn(curLine)) {
                ++numLines;
                continue;
            }
            overallW = Math.max(chunkW, overallW);
        }
        int overallH = (this._lineHeight + this._lineSpacing) * numLines + this._topMargin + this._botMargin + maxDescent;
        overallW = Math.max(30, overallW + this._leftMargin + this._rightMargin);
        if (this._editMode) {
            switch (this._justification) {
                case 0: {
                    break;
                }
                case 2: {
                    if (this._w >= overallW) break;
                    this._x -= (overallW - this._w) / 2;
                    break;
                }
                case 1: {
                    if (this._w >= overallW) break;
                    this._x -= overallW - this._w;
                }
            }
        }
        this._w = this._expandOnly ? Math.max(this._w, overallW) : overallW;
        this._h = this._expandOnly ? Math.max(this._h, overallH) : overallH;
    }

    private String encode(String text, String lineTerminator) {
        StringBuffer buffer = new StringBuffer(text.length());
        int pos = 0;
        int lastPos = 0;
        while ((pos = text.indexOf(lineTerminator, lastPos)) >= 0) {
            buffer.append(text.substring(lastPos, pos)).append('\n');
            lastPos = pos + lineTerminator.length();
        }
        buffer.append(text.substring(lastPos));
        if (this.wordWrap) {
            return this.wordWrap(buffer.toString());
        }
        return buffer.toString();
    }

    private String wordWrap(String text) {
        if (!this.wordWrap) {
            throw new IllegalArgumentException("Attempted to wordwrap while wordwrap off");
        }
        FontMetrics fm = FontUtility.getFontMetrics(this._font);
        StringBuffer buffer = new StringBuffer(text.length());
        int x = 0;
        StringTokenizer st = new StringTokenizer(text, " \n\r", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int tokenWidth = fm.stringWidth(token);
            if (this.isSoftReturn(token)) continue;
            if (this.isHardReturn(token)) {
                buffer.append('\n');
                x = 0;
                continue;
            }
            if (this.isSpace(token)) {
                buffer.append(token);
                x += tokenWidth;
                continue;
            }
            if (x > 0 && x + tokenWidth > this.getWidth()) {
                buffer.append('\r');
                x = 0;
            }
            x = this.appendToken(buffer, token, tokenWidth, fm, x);
        }
        return buffer.toString();
    }

    private int appendToken(StringBuffer sb, String token, int tokenWidth, FontMetrics fm, int x) {
        if (x + tokenWidth <= this.getWidth()) {
            sb.append(token);
            x += tokenWidth;
        } else {
            String part = "";
            int partWidth = 0;
            for (int i = 0; i < token.length(); ++i) {
                part = part + token.charAt(i);
                int lastPartWidth = partWidth;
                partWidth = fm.stringWidth(part);
                if (partWidth <= this.getWidth()) continue;
                String nextPart = "";
                int nextPartWidth = 0;
                if (part.length() > 1) {
                    nextPart = part.substring(part.length() - 1);
                    nextPartWidth = fm.stringWidth(nextPart);
                    part = part.substring(0, part.length() - 1);
                    partWidth = lastPartWidth;
                }
                sb.append(part);
                part = nextPart;
                partWidth = nextPartWidth;
                if (i < token.length() - 1) {
                    sb.append('\r');
                    x = 0;
                    continue;
                }
                x += partWidth;
            }
            if (partWidth > 0) {
                sb.append(part);
                x += partWidth;
            }
        }
        return x;
    }

    private String decode(String text, String lineSeparator) {
        StringBuffer buffer = new StringBuffer(text.length());
        StringTokenizer st = new StringTokenizer(text, "\n\r", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this.isSoftReturn(token)) continue;
            if (this.isHardReturn(token)) {
                buffer.append(lineSeparator);
                continue;
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private boolean isSoftReturn(String text) {
        return text.length() == 1 && text.charAt(0) == '\r';
    }

    private boolean isHardReturn(String text) {
        return text.length() == 1 && text.charAt(0) == '\n';
    }

    private boolean isSpace(String text) {
        return text.length() == 1 && text.charAt(0) == ' ';
    }

    @Override
    protected void setBoundsImpl(int x, int y, int w, int h) {
        if (this._w != w && this.wordWrap) {
            super.setBoundsImpl(x, y, w, h);
            this._curText = this.wordWrap(this._curText);
        } else {
            super.setBoundsImpl(x, y, w, h);
        }
    }

    static {
        PropCategoryManager.categorizeProperty("Text", "font");
        PropCategoryManager.categorizeProperty("Text", "underline");
        PropCategoryManager.categorizeProperty("Text", "expandOnly");
        PropCategoryManager.categorizeProperty("Text", "lineSpacing");
        PropCategoryManager.categorizeProperty("Text", "topMargin");
        PropCategoryManager.categorizeProperty("Text", "botMargin");
        PropCategoryManager.categorizeProperty("Text", "leftMargin");
        PropCategoryManager.categorizeProperty("Text", "rightMargin");
        PropCategoryManager.categorizeProperty("Text", "text");
        PropCategoryManager.categorizeProperty("Style", "justification");
        PropCategoryManager.categorizeProperty("Style", "textFilled");
        PropCategoryManager.categorizeProperty("Style", "textFillColor");
        PropCategoryManager.categorizeProperty("Style", "textColor");
    }
}

