/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.FigText;
import org.tigris.gef.undo.UndoManager;

public class FigTextEditor
extends JTextPane
implements PropertyChangeListener,
DocumentListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 7350660058167121420L;
    private FigText figText;
    private JPanel drawingPanel;
    private JLayeredPane layeredPane;
    private static int _extraSpace = 2;
    private static Border _border = BorderFactory.createLineBorder(Color.gray);
    private static boolean _makeBrighter = false;
    private static Color _backgroundColor = null;
    private static Log LOG = LogFactory.getLog(FigTextEditor.class);
    private static final FigTextEditor INSTANCE = new FigTextEditor();
    private static FigTextEditor _activeTextEditor;

    public static FigTextEditor getInstance() {
        return INSTANCE;
    }

    private FigTextEditor() {
    }

    public static void configure(int extraSpace, Border b, boolean makeBrighter, Color backgroundColor) {
        _extraSpace = extraSpace;
        _border = b;
        _makeBrighter = makeBrighter;
        _backgroundColor = backgroundColor;
    }

    public void init(FigText ft, InputEvent ie) {
        Container awtComp;
        this.setVisible(true);
        this.figText = ft;
        Editor ce = Globals.curEditor();
        this.drawingPanel = (JPanel)ce.getJComponent();
        UndoManager.getInstance().startChain();
        this.figText.firePropChange("editing", false, true);
        this.figText.addPropertyChangeListener(this);
        for (awtComp = this.drawingPanel; !(awtComp instanceof JFrame) && awtComp != null; awtComp = awtComp.getParent()) {
        }
        if (!(awtComp instanceof JFrame)) {
            LOG.warn((Object)"no JFrame");
            return;
        }
        this.layeredPane = ((JFrame)awtComp).getLayeredPane();
        ft.calcBounds();
        Rectangle bbox = ft.getBounds();
        Color figTextBackgroundColor = ft.getFillColor();
        Color myBackground = _makeBrighter && !figTextBackgroundColor.equals(Color.white) ? figTextBackgroundColor.brighter() : (_backgroundColor != null ? _backgroundColor : figTextBackgroundColor);
        this.setBackground(myBackground);
        this.setBorder(_border);
        double scale = ce.getScale();
        bbox.x = (int)Math.round((double)bbox.x * scale);
        bbox.y = (int)Math.round((double)bbox.y * scale);
        if (scale > 1.0) {
            bbox.width = (int)Math.round((double)bbox.width * scale);
            bbox.height = (int)Math.round((double)bbox.height * scale);
        }
        bbox = SwingUtilities.convertRectangle(this.drawingPanel, bbox, this.layeredPane);
        this.setBounds(bbox.x - _extraSpace, bbox.y - _extraSpace, bbox.width + _extraSpace * 2, bbox.height + _extraSpace * 2);
        this.layeredPane.add(this, JLayeredPane.POPUP_LAYER, 0);
        String text = ft.getTextFriend();
        FigTextEditor.remove();
        _activeTextEditor = this;
        this.setText(text);
        this.addKeyListener(this);
        this.requestFocus();
        this.getDocument().addDocumentListener(this);
        ce.setActiveTextEditor(this);
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getDocument().getLength());
        SimpleAttributeSet attr = new SimpleAttributeSet();
        if (ft.getJustification() == 2) {
            StyleConstants.setAlignment(attr, 1);
        }
        if (ft.getJustification() == 1) {
            StyleConstants.setAlignment(attr, 2);
        }
        Font font = ft.getFont();
        StyleConstants.setFontFamily(attr, font.getFamily());
        StyleConstants.setFontSize(attr, font.getSize());
        this.setParagraphAttributes(attr, true);
        if (ie instanceof KeyEvent) {
            this.setSelectionStart(this.getDocument().getLength());
            this.setSelectionEnd(this.getDocument().getLength());
        }
        this.addFocusListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pve) {
        this.updateFigText();
    }

    public void endEditing() {
        if (this.figText == null) {
            return;
        }
        this.updateFigText();
        FigText t = this.figText;
        this.cancelEditingInternal();
        t.firePropChange("editing", true, false);
        Editor ce = Globals.curEditor();
        ce.setActiveTextEditor(null);
    }

    public void cancelEditing() {
        if (this.figText == null) {
            return;
        }
        this.cancelEditingInternal();
    }

    private void cancelEditingInternal() {
        this.removeFocusListener(this);
        this.setVisible(false);
        this.figText.endTrans();
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
        this.figText.removePropertyChangeListener(this);
        this.removeKeyListener(this);
        this.layeredPane.remove(this);
        this.drawingPanel.requestFocus();
        _activeTextEditor = null;
        this.figText = null;
    }

    public static synchronized FigTextEditor getActiveTextEditor() {
        return _activeTextEditor;
    }

    public static synchronized void remove() {
        if (_activeTextEditor != null) {
            FigTextEditor old = _activeTextEditor;
            _activeTextEditor = null;
            old.endEditing();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            if (this.figText.getReturnAction() == 2) {
                this.endEditing();
                ke.consume();
            }
        } else if (ke.getKeyCode() == 9) {
            if (this.figText.getTabAction() == 2) {
                this.endEditing();
                ke.consume();
            }
        } else if (ke.getKeyCode() == 113) {
            this.endEditing();
            ke.consume();
        } else if (ke.getKeyCode() == 27) {
            this.endEditing();
            ke.consume();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateFigText();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateFigText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateFigText();
    }

    protected void updateFigText() {
        if (this.figText == null) {
            return;
        }
        String text = this.getText();
        this.figText.setTextFriend(text, this.getGraphics());
        if (this.figText.getReturnAction() == 1 && this.figText.isWordWrap()) {
            return;
        }
        Rectangle bbox = this.figText.getBounds();
        Editor ce = Globals.curEditor();
        double scale = ce.getScale();
        bbox.x = (int)Math.round((double)bbox.x * scale);
        bbox.y = (int)Math.round((double)bbox.y * scale);
        if (scale > 1.0) {
            bbox.width = (int)Math.round((double)bbox.width * scale);
            bbox.height = (int)Math.round((double)bbox.height * scale);
        }
        bbox = SwingUtilities.convertRectangle(this.drawingPanel, bbox, this.layeredPane);
        this.setBounds(bbox.x - _extraSpace, bbox.y - _extraSpace, bbox.width + _extraSpace * 2, bbox.height + _extraSpace * 2);
        this.setFont(this.figText.getFont());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.endEditing();
    }

    public FigText getFigText() {
        return this.figText;
    }
}

