/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JPanel;
import org.tigris.gef.properties.ui.ColorPickerGrid;

public class ColorEditor
extends JPanel
implements PropertyEditor {
    public Color _color = Color.white;
    private Vector listeners;

    public ColorEditor() {
        this.setLayout(null);
        this.setSize(this.getInsets().left + this.getInsets().right + 20, this.getInsets().top + this.getInsets().bottom + 20);
        this.setForeground(Color.lightGray);
    }

    @Override
    public void setValue(Object c) {
        if (!(c instanceof Color)) {
            return;
        }
        this._color = (Color)c;
        this.repaint();
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this._color;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        g.setColor(Color.lightGray);
        g.draw3DRect(box.x, box.y, box.width - 1, box.height - 1, true);
        g.setColor((Color)this.getValue());
        g.fill3DRect(box.x + 1, box.y + 1, box.width - 2, box.height - 2, true);
    }

    @Override
    public void paint(Graphics g) {
        this.paintValue(g, this.getBounds());
    }

    @Override
    public String getJavaInitializationString() {
        Color c = (Color)this.getValue();
        return "new Color(" + this.getAsText() + ")";
    }

    @Override
    public String getAsText() {
        return "" + this._color.getRed() + ", " + this._color.getBlue() + ", " + this._color.getGreen();
    }

    @Override
    public void setAsText(String text) {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        ColorPickerGrid cpg = new ColorPickerGrid(Color.white);
        cpg.setPEColor(this);
        return cpg;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 400);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    public Frame getFrame() {
        Container c;
        for (c = this; c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        return (Frame)c;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        Vector targets;
        ColorEditor colorEditor = this;
        synchronized (colorEditor) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < targets.size(); ++i) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
            target.propertyChange(evt);
        }
    }
}

