/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;

public class ColorTilePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int TILESIZE = 6;
    protected Vector _colors;
    protected int _selected = 0;
    protected int _nCols;
    protected boolean _allowSelection = true;
    protected ActionListener _onlyListener = null;
    public static Vector _NetscapeColors = null;

    public ColorTilePanel() {
        this(ColorTilePanel.netscapeColors());
    }

    public ColorTilePanel(int nCols) {
        this(ColorTilePanel.netscapeColors(), nCols);
    }

    public ColorTilePanel(Vector cs) {
        this._colors = cs;
        this._nCols = (int)Math.sqrt(cs.size());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public ColorTilePanel(Vector cs, int nCols) {
        this._colors = cs;
        this._nCols = nCols;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Color getColor() {
        return (Color)this._colors.elementAt(this._selected);
    }

    public void setColor(Color c) {
        if (!this._colors.contains(c)) {
            return;
        }
        this.setSelectionIndex(this._colors.indexOf(c));
    }

    public void allowSelection(boolean as) {
        this._allowSelection = as;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        for (int i = 0; i < this._colors.size(); ++i) {
            this.paintTile(g, i);
        }
        this.showSelection(g);
    }

    public void paintTile(Graphics g, int tileNum) {
        g.setColor((Color)this._colors.elementAt(tileNum));
        int col = tileNum % this._nCols;
        int row = tileNum / this._nCols;
        g.fillRect(col * 6, row * 6, 6, 6);
    }

    public void showSelection(Graphics g) {
        Color c = (Color)this._colors.elementAt(this._selected);
        Color sc = c.getRed() + c.getBlue() + c.getGreen() > 382 ? Color.black : Color.white;
        g.setColor(sc);
        g.drawRect(this._selected % this._nCols * 6, this._selected / this._nCols * 6, 5, 5);
    }

    @Override
    public Dimension getMinimumSize() {
        int xSize = 6 * this._nCols;
        int ySize = 6 * (this._colors.size() / this._nCols + 2);
        return new Dimension(xSize, ySize);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean setSelectionIndex(int s) {
        if (s < 0 || s > this._colors.size()) {
            return false;
        }
        if (s == this._selected) {
            return false;
        }
        this._selected = s;
        this.repaint();
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (x > this._nCols * 6 - 1 || y > this._colors.size() / this._nCols * 6 - 1) {
            return;
        }
        int col = x / 6;
        int row = y / 6;
        if (this.setSelectionIndex(col + row * this._nCols)) {
            this.fireActionEvent(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mouseReleased(me);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.mouseReleased(me);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.mouseReleased(me);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    public static Vector netscapeColors() {
        if (_NetscapeColors == null) {
            int[] values = new int[6];
            int nValues = 0;
            values[nValues++] = 0;
            values[nValues++] = 51;
            values[nValues++] = 102;
            values[nValues++] = 153;
            values[nValues++] = 204;
            values[nValues++] = 255;
            _NetscapeColors = new Vector(nValues * nValues * nValues);
            for (int r = 0; r < nValues; ++r) {
                for (int g = 0; g < nValues; ++g) {
                    for (int b = 0; b < nValues; ++b) {
                        Color c = new Color(values[r], values[g], values[b]);
                        _NetscapeColors.addElement(c);
                    }
                }
            }
        }
        return _NetscapeColors;
    }

    public void addActionListener(ActionListener list) {
        this._onlyListener = list;
    }

    public void removeActionListener(ActionListener list) {
        if (this._onlyListener == list) {
            this._onlyListener = null;
        }
    }

    public void fireActionEvent(ActionEvent ae) {
        if (this._onlyListener != null) {
            this._onlyListener.actionPerformed(ae);
        }
    }
}

