/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import org.tigris.gef.presentation.Fig;

public class PropSheet
extends JPanel
implements PropertyChangeListener {
    protected Object _sel = null;
    protected Hashtable _pendingStores = new Hashtable();
    protected Hashtable _pdsEditors = new Hashtable();
    protected Hashtable _editorsPds = new Hashtable();
    protected boolean _autoApply = true;
    protected boolean _ignorePropChanges = false;
    protected String _tabName = "Misc";
    protected Font _propertiesFont = new Font("Dialog", 0, 10);
    protected long _lastUpdateTime = System.currentTimeMillis();
    public static final int MIN_UPDATE = 200;

    public void setSelection(Object s) {
        if (this._sel == s) {
            return;
        }
        if (this._sel instanceof Fig) {
            ((Fig)this._sel).removePropertyChangeListener(this);
        }
        this._sel = s;
        if (this._sel instanceof Fig) {
            ((Fig)this._sel).addPropertyChangeListener(this);
        }
        this.updateComponents();
    }

    public void setAutoApply(boolean aa) {
        this._autoApply = aa;
        if (this._autoApply) {
            this.apply();
        }
    }

    public String getTabName() {
        return this._tabName;
    }

    public void setTabName(String tn) {
        this._tabName = tn;
    }

    public boolean canEdit(Object item) {
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.setSelection(null);
        }
    }

    public Font getPropertiesFont() {
        return this._propertiesFont;
    }

    public void setPropertiesFont(Font f) {
        this._propertiesFont = f;
    }

    public void store(PropertyDescriptor pd, Object value) {
        if (pd == null || value == null) {
            return;
        }
        this._pendingStores.put(pd, value);
        if (this._autoApply) {
            this.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        try {
            this._ignorePropChanges = true;
            if (this._sel != null) {
                Enumeration pending = this._pendingStores.keys();
                while (pending.hasMoreElements()) {
                    PropertyDescriptor pd = (PropertyDescriptor)pending.nextElement();
                    this.applyProperty(pd, this._pendingStores.get(pd));
                }
            }
            if (this._sel instanceof Fig) {
                ((Fig)this._sel).endTrans();
            }
            this._pendingStores.clear();
        }
        finally {
            this.updateComponents();
            this._ignorePropChanges = false;
        }
    }

    protected void applyProperty(PropertyDescriptor pd, Object value) {
        try {
            Object[] args = new Object[]{value};
            args[0] = value;
            Method setter = pd.getWriteMethod();
            setter.invoke(this._sel, args);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof PropertyVetoException) {
                System.out.println("Vetoed; because: " + ex.getTargetException().getMessage());
            } else {
                System.out.println("InvocationTargetException while updating " + pd.getName() + "\n" + ex.getTargetException().toString());
            }
        }
        catch (Exception ex) {
            System.out.println("Unexpected exception while updating " + pd.getName() + "\n" + ex.toString());
        }
    }

    public void revert() {
        this._pendingStores.clear();
        this.updateComponents();
    }

    public void updateComponents() {
    }

    public void updateComponent(PropertyDescriptor pd) {
        this.updateComponents();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this._ignorePropChanges) {
            return;
        }
        String pName = e.getPropertyName();
        Object src = e.getSource();
        if (src == this._sel && !this._ignorePropChanges) {
            long now = System.currentTimeMillis();
            if (this._lastUpdateTime + 200L > now) {
                return;
            }
            this.updateComponents();
            this._lastUpdateTime = now;
        } else {
            PropertyDescriptor pd = (PropertyDescriptor)this._editorsPds.get(src);
            if (pd != null) {
                this.store(pd, ((PropertyEditor)src).getValue());
            }
        }
    }
}

