/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RectangleEditor
extends JPanel
implements PropertyEditor {
    protected Rectangle _rect = null;
    private Vector listeners;
    protected JTextField xField;
    protected JTextField yField;
    protected JTextField wField;
    protected JTextField hField;

    public RectangleEditor() {
        this.setLayout(new GridLayout(1, 4));
        this.setSize(this.getInsets().left + this.getInsets().right + 20, this.getInsets().top + this.getInsets().bottom + 20);
        this.xField = new JTextField("0", 4);
        this.yField = new JTextField("0", 4);
        this.hField = new JTextField("0", 4);
        this.wField = new JTextField("0", 4);
        this.add(this.xField);
        this.add(this.yField);
        this.add(this.hField);
        this.add(this.wField);
    }

    @Override
    public void setValue(Object v) {
        if (!(v instanceof Rectangle)) {
            return;
        }
        this._rect = (Rectangle)v;
        this.updateWidgets();
    }

    @Override
    public Object getValue() {
        return this._rect;
    }

    @Override
    public String getJavaInitializationString() {
        return "new Rectangle(" + this.getAsText() + ")";
    }

    @Override
    public String getAsText() {
        Rectangle r = (Rectangle)this.getValue();
        return "" + r.x + ", " + r.y + ", " + r.width + ", " + r.height;
    }

    @Override
    public void setAsText(String text) {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        Rectangle r = (Rectangle)this.getValue();
        String rectString = "(" + r.x + "," + r.y + ")+(" + r.width + "x" + r.height + " )";
        g.drawString(rectString, box.x + 2, box.x + box.height - 4);
    }

    public void setEnable(boolean enabled) {
        this.xField.setEditable(enabled);
        this.yField.setEditable(enabled);
        this.wField.setEditable(enabled);
        this.hField.setEditable(enabled);
    }

    public void updateWidgets() {
        this.xField.setText(Integer.toString(this._rect.x));
        this.yField.setText(Integer.toString(this._rect.y));
        this.wField.setText(Integer.toString(this._rect.width));
        this.hField.setText(Integer.toString(this._rect.height));
    }

    protected void readFields() {
        try {
            int x = Integer.parseInt(this.xField.getText());
            int y = Integer.parseInt(this.yField.getText());
            int width = Integer.parseInt(this.wField.getText());
            int height = Integer.parseInt(this.hField.getText());
            this.setValue(new Rectangle(x, y, width, height));
        }
        catch (NumberFormatException ignore) {
            this.updateWidgets();
        }
    }

    @Override
    public void processEvent(AWTEvent event) {
        if (event.getSource() != this && (long)event.getID() == 128L) {
            this.readFields();
            return;
        }
        super.processEvent(event);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        Vector targets;
        RectangleEditor rectangleEditor = this;
        synchronized (rectangleEditor) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < targets.size(); ++i) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
            target.propertyChange(evt);
        }
    }
}

