/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.util.StringTokenizer;
import org.tigris.gef.util.Predicate;
import org.tigris.gef.util.PredicateEquals;
import org.tigris.gef.util.PredicateTrue;

public class PredicateStringMatch
implements Predicate {
    public static int MAX_PATS = 10;
    String[] _patterns;
    int _numPats;

    protected PredicateStringMatch(String[] pats, int numPats) {
        this._patterns = pats;
        this._numPats = numPats;
    }

    public static Predicate create(String pat) {
        pat = pat.trim();
        String[] pats = new String[MAX_PATS];
        int numPats = 0;
        if (pat.startsWith("*")) {
            pats[numPats++] = "";
        }
        StringTokenizer st = new StringTokenizer(pat, "*");
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            pats[numPats++] = token;
        }
        if (pat.endsWith("*")) {
            pats[numPats++] = "";
        }
        if (numPats == 0) {
            return PredicateTrue.theInstance();
        }
        if (numPats == 1) {
            return new PredicateEquals(pats[0]);
        }
        return new PredicateStringMatch(pats, numPats);
    }

    @Override
    public boolean predicate(Object o) {
        if (o == null) {
            return false;
        }
        String target = o.toString();
        if (!target.startsWith(this._patterns[0])) {
            return false;
        }
        if (!target.endsWith(this._patterns[this._numPats - 1])) {
            return false;
        }
        for (int i = 0; i < this._numPats; ++i) {
            String p = this._patterns[i];
            int index = (target + "*").indexOf(p);
            if (index == -1) {
                return false;
            }
            target = target.substring(index + p.length());
        }
        return true;
    }
}

