/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.advancedcontrol;

import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import ro.atreides.acces.PlanOrarBean;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class AdvancedControlUtils {
    public static Map<String, PlanOrarBean> processAuth(File file, Component parent) throws IOException, SQLException {
        String line;
        HashMap<String, PlanOrarBean> result = new HashMap<String, PlanOrarBean>();
        Logger.logDebug(Class.class.getName(), "Processing GET_AUTH file : " + file.getAbsolutePath());
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (!Validators.correctString(line.trim())) continue;
            Logger.logDebug(Class.class.getName(), "Processing line : " + line);
            Vector items = Utils.splitString(line, ',');
            String pin = (String)items.get(0);
            String timezoneId = (String)items.get(1);
            PlanOrarBean orarBean = ContracteLogic.getInstance().getPlanOrarByExternalIdNoCommit(timezoneId);
            if (orarBean == null) {
                String mess = "PlanOrar negasit pt external id : " + timezoneId;
                Logger.logError((Object)Class.class.getName(), mess);
                DialogUtils.errorDialog(parent, mess, LangRoAll.atentie);
                continue;
            }
            result.put(pin, orarBean);
        }
        Logger.logDebug(Class.class.getName(), "Finished Processing GET_AUTH file : " + file.getAbsolutePath());
        return result;
    }

    public static Map<String, Date> getExpiryForUsers(File file, Component parent) throws SQLException, IOException, ParseException {
        String line;
        HashMap<String, Date> result = new HashMap<String, Date>();
        Logger.logDebug(Class.class.getName(), "Processing GET_USERS file : " + file.getAbsolutePath());
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (!Validators.correctString(line.trim())) continue;
            Vector items = Utils.splitStringKeepStructure(line, ',', '-');
            String id = (String)items.get(0);
            String card = (String)items.get(1);
            String validFrom = (String)items.get(5);
            String validTo = (String)items.get(6);
            Logger.logDebug(Class.class.getName(), "Processing line : " + line + " ID = " + id + ", card=" + card + ", validFrom=" + validFrom + ", validTo=" + validTo);
            Date stopDate = Formatters.ACCESS_CONTROL_LOGIC_FORMAT.parse(validTo);
            result.put(id, stopDate);
        }
        return result;
    }

    public static Map<String, String> getUsersNames(File file) throws SQLException, IOException {
        String line;
        HashMap<String, String> result = new HashMap<String, String>();
        Logger.logDebug(Class.class.getName(), "Processing UserNames file : " + file.getAbsolutePath());
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (!Validators.correctString(line.trim())) continue;
            Vector items = Utils.splitString(line, ',');
            String id = (String)items.get(0);
            String name = (String)items.get(1);
            result.put(id, name);
        }
        return result;
    }

    public static Map<String, String> getUsersCards(File file, int digits) throws SQLException, IOException {
        String line;
        HashMap<String, String> result = new HashMap<String, String>();
        Logger.logDebug(Class.class.getName(), "Processing UserCards file : " + file.getAbsolutePath());
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (!Validators.correctString(line.trim())) continue;
            Vector items = Utils.splitString(line, ',');
            String id = (String)items.get(0);
            String card = (String)items.get(1);
            String cardFull = Utils.getStringMaxSize(digits, card, Character.valueOf('0'), true);
            result.put(id, cardFull);
        }
        return result;
    }

    public static String getFullOrarForCentrala(String idExternTImezone, String orarDefComplete) {
        String result = "TimezoneId=" + idExternTImezone;
        if (orarDefComplete.trim().startsWith("*")) {
            Vector items = Utils.splitString(orarDefComplete, '=');
            String dayName = (String)items.get(0);
            String orar = (String)items.get(1);
            try {
                String orarCentrala = AdvancedControlUtils.getOrarForCentrala(orar);
                for (UzualTimezoneItems timezoneName : UzualTimezoneItems.values()) {
                    result = result + "\t" + timezoneName.toString() + "=" + orarCentrala;
                }
            }
            catch (ParseException e) {
                Logger.logException(Class.class.getName(), (Exception)e);
            }
        } else {
            Vector days = Utils.splitString(orarDefComplete, ',');
            for (String day : days) {
                Vector items = Utils.splitString(day, '=');
                String dayName = (String)items.get(0);
                String orar = (String)items.get(1);
                try {
                    TimezoneItems existingTz = TimezoneItems.valueOf(dayName);
                    String orarOut = AdvancedControlUtils.getOrarForCentrala(orar);
                    result = result + "\t" + existingTz.toString() + "=" + orarOut;
                }
                catch (Exception e) {
                    Logger.logException(Class.class.getName(), e);
                }
            }
        }
        return result;
    }

    private static String getOrarForCentrala(String day) throws ParseException {
        Vector orarItems = Utils.splitString(day, '-');
        String startS = (String)orarItems.get(0);
        String stopS = (String)orarItems.get(1);
        Calendar calendar = GregorianCalendar.getInstance();
        Date startD = Formatters.TIME_FORMAT.parse(startS);
        calendar.setTimeInMillis(startD.getTime());
        int startH = calendar.get(11);
        int startM = calendar.get(12);
        int start = startH * 100 + startM;
        start <<= 16;
        Date stopD = Formatters.TIME_FORMAT.parse(stopS);
        calendar.setTimeInMillis(stopD.getTime());
        startH = calendar.get(11);
        startM = calendar.get(12);
        int stop = startH * 100 + startM;
        int result = start + stop;
        return result + "";
    }

    public static enum UzualTimezoneItems {
        SunTime1,
        MonTime1,
        TueTime1,
        WedTime1,
        ThuTime1,
        FriTime1,
        SatTime1,
        Hol1Time1,
        Hol2Time1,
        Hol3Time1;

    }

    public static enum TimezoneItems {
        SunTime1,
        SunTime2,
        SunTime3,
        MonTime1,
        MonTime2,
        MonTime3,
        TueTime1,
        TueTime2,
        TueTime3,
        WedTime1,
        WedTime2,
        WedTime3,
        ThuTime1,
        ThuTime2,
        ThuTime3,
        FriTime1,
        FriTime2,
        FriTime3,
        SatTime1,
        SatTime2,
        SatTime3,
        Hol1Time1,
        Hol1Time2,
        Hol1Time3,
        Hol2Time1,
        Hol2Time2,
        Hol2Time3,
        Hol3Time1,
        Hol3Time2,
        Hol3Time3;

    }
}

