/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.contracte;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.acces.PlanOrarBean;
import ro.atreides.acces.contracte.ContractePerioada;
import ro.atreides.acces.contracte.PerioadaEntry;
import ro.atreides.acces.contracte.StatusContractView;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.db.DaoInterface;

public class ContracteDao
implements DaoInterface {
    private PreparedStatement addTipContract;
    private PreparedStatement updateTipContract;
    private PreparedStatement deleteTipContract;
    private PreparedStatement getAllTipContract;
    private PreparedStatement getTipContractById;
    private PreparedStatement getTipContractByIdPlan;
    private PreparedStatement getTipContractByName;
    private PreparedStatement addContract;
    private PreparedStatement getContracte;
    private PreparedStatement updateContract;
    private PreparedStatement deleteContract;
    private PreparedStatement getLastPaymentForContract;
    private PreparedStatement getGrace;
    private PreparedStatement getRenew;
    private PreparedStatement getPeriod;
    private PreparedStatement updateStatusForContract;
    private PreparedStatement getContractByCard;
    private PreparedStatement addComment;
    private PreparedStatement getComments;
    private PreparedStatement createPerioadaAbonament;
    private PreparedStatement setForcedDaysForPerioada;
    private PreparedStatement addPayment;
    private PreparedStatement getCurrentPerioadaForAbonamentClient;
    private PreparedStatement addIntrarePerioadaCurenta;
    private PreparedStatement getTotalPaymentsForPerioadaContract;
    private PreparedStatement getPerioadaById;
    private PreparedStatement setPerioadaStatus;
    private PreparedStatement getAllPerioadeActiveForAbonament;
    private PreparedStatement getAllPerioadeForClient;
    private PreparedStatement updateStopDateForPerioada;
    private PreparedStatement updateStartDateForPerioada;
    private PreparedStatement getClientByIdAbonament;
    private PreparedStatement setCarduriForAbonament;
    private PreparedStatement getPlanOrarByCodExtern;
    private PreparedStatement getPlanOrarById;
    private PreparedStatement getAllPlanOrar;
    private PreparedStatement addPlanOrar;
    private PreparedStatement deletePlanOrar;
    private PreparedStatement updatePlanOrar;
    private PreparedStatement updateTipAbonamentForAbonament;
    private Connection connection;

    public ContracteDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public void updateContract(int idClient, int idAbonament, String card, String cardTemporar, int status, int idPromotie, boolean plataPartiala, int zilePlataPartiala, int id) throws SQLException {
        this.updateContract.setInt(1, idClient);
        this.updateContract.setInt(2, idAbonament);
        this.updateContract.setString(3, card);
        this.updateContract.setString(4, cardTemporar);
        this.updateContract.setInt(5, status);
        if (idPromotie > 0) {
            this.updateContract.setInt(6, idPromotie);
        } else {
            this.updateContract.setNull(6, 4);
        }
        this.updateContract.setInt(7, plataPartiala ? 1 : 0);
        this.updateContract.setInt(8, zilePlataPartiala);
        this.updateContract.setInt(9, id);
        this.updateContract.execute();
    }

    public Timestamp getLastPayment(int idContract) throws SQLException {
        Timestamp result = null;
        this.getLastPaymentForContract.setInt(1, idContract);
        ResultSet rs = this.getLastPaymentForContract.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public void updateTipAbonamentForAbonament(int idAbonament, int tipAbonamentNou) throws SQLException {
        this.updateTipAbonamentForAbonament.setInt(1, tipAbonamentNou);
        this.updateTipAbonamentForAbonament.setInt(2, idAbonament);
        this.updateTipAbonamentForAbonament.execute();
    }

    public int getGraced(int idTipContract) throws SQLException {
        int result = -1;
        this.getGrace.setInt(1, idTipContract);
        ResultSet rs = this.getGrace.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public int getRenew(int idTipContract) throws SQLException {
        int result = -1;
        this.getRenew.setInt(1, idTipContract);
        ResultSet rs = this.getRenew.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public int getPeriod(int idTipContract) throws SQLException {
        int result = -1;
        this.getPeriod.setInt(1, idTipContract);
        ResultSet rs = this.getPeriod.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void updateStatusForContract(int idContract, int newStatus) throws SQLException {
        this.updateStatusForContract.setInt(1, newStatus);
        this.updateStatusForContract.setInt(2, idContract);
        this.updateStatusForContract.execute();
    }

    public void addComment(int idClient, String comment) throws SQLException {
        this.addComment.setInt(1, idClient);
        this.addComment.setString(2, comment);
        this.addComment.execute();
    }

    public Vector getComments(int idClient) throws SQLException {
        Vector<String> comments = new Vector<String>();
        this.getComments.setInt(1, idClient);
        ResultSet rs = this.getComments.executeQuery();
        while (rs.next()) {
            String c = rs.getString(1);
            comments.add(c);
        }
        rs.close();
        return comments;
    }

    public void createPerioadaAbonament(int idAbonamentClient) throws SQLException {
        this.createPerioadaAbonament.setInt(1, idAbonamentClient);
        this.createPerioadaAbonament.execute();
    }

    public void setForcedDaysForPerioada(int nrDays, int idPerioada) throws SQLException {
        this.setForcedDaysForPerioada.setInt(1, nrDays);
        this.setForcedDaysForPerioada.setInt(2, idPerioada);
        this.setForcedDaysForPerioada.execute();
    }

    public void addPayment(int idPerioada, double suma) throws SQLException {
        this.addPayment.setInt(1, idPerioada);
        this.addPayment.setDouble(2, suma);
        this.addPayment.execute();
    }

    public void addIntrarePerioadaCurenta(int idPerioada) throws SQLException {
        this.addIntrarePerioadaCurenta.setInt(1, idPerioada);
        this.addIntrarePerioadaCurenta.execute();
    }

    public ContractePerioada getPerioadaFromRS(ResultSet rs) throws SQLException {
        ContractePerioada result = new ContractePerioada();
        result.setId(rs.getInt("id"));
        result.setIdAbonamentClient(rs.getInt("id_abonamente_clients"));
        result.setStart(rs.getTimestamp("start"));
        result.setStop(rs.getTimestamp("stop"));
        result.setSedinteConsumate(rs.getInt("sedinte_consumate"));
        result.setForcedDays(rs.getInt("forced_days"));
        return result;
    }

    public ContractePerioada getCurrentPerioadaForAbonamentClient(int idAbonamentClient) throws SQLException {
        ContractePerioada result = null;
        this.getCurrentPerioadaForAbonamentClient.setInt(1, idAbonamentClient);
        ResultSet rs = this.getCurrentPerioadaForAbonamentClient.executeQuery();
        if (rs.next()) {
            result = this.getPerioadaFromRS(rs);
        }
        rs.close();
        return result;
    }

    public double getTotalPaymentsForPerioadaContract(int idPerioada) throws SQLException {
        double result = 0.0;
        this.getTotalPaymentsForPerioadaContract.setInt(1, idPerioada);
        ResultSet rs = this.getTotalPaymentsForPerioadaContract.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public ContractePerioada getPerioadaById(int id) throws SQLException {
        ContractePerioada result = null;
        this.getPerioadaById.setInt(1, id);
        ResultSet rs = this.getPerioadaById.executeQuery();
        if (rs.next()) {
            result = this.getPerioadaFromRS(rs);
        }
        rs.close();
        return result;
    }

    public void setPerioadaStatus(int id, int newStatus) throws SQLException {
        this.setPerioadaStatus.setInt(1, newStatus);
        this.setPerioadaStatus.setInt(2, id);
        this.setPerioadaStatus.execute();
    }

    public Vector<ContractePerioada> getAllPerioadeActiveForAbonament(int idAbonament) throws SQLException {
        Vector<ContractePerioada> result = new Vector<ContractePerioada>();
        this.getAllPerioadeActiveForAbonament.setInt(1, idAbonament);
        ResultSet rs = this.getAllPerioadeActiveForAbonament.executeQuery();
        while (rs.next()) {
            ContractePerioada cp = this.getPerioadaFromRS(rs);
            result.add(cp);
        }
        rs.close();
        return result;
    }

    public Vector<PerioadaEntry> getAllPerioadeForClient(int idClient) throws SQLException {
        Vector<PerioadaEntry> result = new Vector<PerioadaEntry>();
        this.getAllPerioadeForClient.setInt(1, idClient);
        ResultSet rs = this.getAllPerioadeForClient.executeQuery();
        while (rs.next()) {
            int nrIntrariFolosite = rs.getInt("nr_intrari_folosite");
            int nrIntrariTotale = rs.getInt("nr_intrari_totale");
            String tipAbonament = rs.getString("nume_abonament");
            Timestamp tstart = rs.getTimestamp("data_start");
            Timestamp tstop = rs.getTimestamp("data_stop");
            int idContract = rs.getInt("id_contract");
            int idPerioada = rs.getInt("id_perioada");
            int idTipContract = rs.getInt("id_tip_contract");
            int plataPartiala = rs.getInt("plata_partiala");
            int zilePlataPartiala = rs.getInt("zile_plata_partiala");
            int status = rs.getInt("abonamente_perioade_status");
            PerioadaEntry pe = new PerioadaEntry(nrIntrariFolosite, nrIntrariTotale, tstart, tstop, idContract, tipAbonament, idPerioada, idTipContract, plataPartiala == 1, zilePlataPartiala, status, rs.getInt("forced_days"));
            result.add(pe);
        }
        return result;
    }

    public PlanOrarBean getPlanOrarById(int id) throws SQLException {
        PlanOrarBean result = null;
        this.getPlanOrarById.setInt(1, id);
        ResultSet rs = this.getPlanOrarById.executeQuery();
        if (rs.next()) {
            PlanOrarBean toAdd;
            result = toAdd = this.getPlanOrarFromRs(rs);
        }
        rs.close();
        return result;
    }

    public PlanOrarBean getPlanOrarByExternalId(String externalId) throws SQLException {
        PlanOrarBean result = null;
        this.getPlanOrarByCodExtern.setString(1, externalId);
        ResultSet rs = this.getPlanOrarByCodExtern.executeQuery();
        if (rs.next()) {
            PlanOrarBean toAdd;
            result = toAdd = this.getPlanOrarFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Vector<PlanOrarBean> getAllPlanOrar() throws SQLException {
        Vector<PlanOrarBean> result = new Vector<PlanOrarBean>();
        ResultSet rs = this.getAllPlanOrar.executeQuery();
        while (rs.next()) {
            PlanOrarBean toAdd = this.getPlanOrarFromRs(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private PlanOrarBean getPlanOrarFromRs(ResultSet rs) throws SQLException {
        PlanOrarBean toAdd = new PlanOrarBean();
        toAdd.setExternalId(rs.getString("external_id"));
        toAdd.setId(rs.getInt("id"));
        toAdd.setLabel(rs.getString("label"));
        toAdd.setOrar(rs.getString("orar_def"));
        toAdd.setLastModified(rs.getTimestamp("last_modified"));
        return toAdd;
    }

    public void addPlanOrar(PlanOrarBean toadd) throws SQLException {
        this.addPlanOrar.setString(1, toadd.getLabel());
        this.addPlanOrar.setString(2, toadd.getExternalId());
        this.addPlanOrar.setString(3, toadd.getOrar());
        this.addPlanOrar.execute();
    }

    public void updatePlanOrar(PlanOrarBean toUpdate) throws SQLException {
        this.updatePlanOrar.setString(1, toUpdate.getLabel());
        this.updatePlanOrar.setString(2, toUpdate.getExternalId());
        this.updatePlanOrar.setString(3, toUpdate.getOrar());
        this.updatePlanOrar.setInt(4, toUpdate.getId());
        this.updatePlanOrar.execute();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.updateTipAbonamentForAbonament = this.connection.prepareStatement("update abonamente_clients set id_abonament = ? where id = ?");
        this.updatePlanOrar = this.connection.prepareStatement("update abonamente_orar set label = ?, external_id = ?, orar_def = ?, last_modified = CURRENT_TIMESTAMP where id = ?");
        this.addPlanOrar = this.connection.prepareStatement("insert into abonamente_orar ( label, external_id, orar_def ) values ( ?,?,?)");
        String getPlanOrar = "select * from abonamente_orar";
        this.getAllPlanOrar = this.connection.prepareStatement(getPlanOrar);
        this.getPlanOrarById = this.connection.prepareStatement(getPlanOrar + " where id = ?");
        this.getPlanOrarByCodExtern = this.connection.prepareStatement(getPlanOrar + " where external_id = ?");
        this.setCarduriForAbonament = this.connection.prepareStatement("update abonamente_clients set card = ?, card_temporar = ? where id_client = ?");
        this.getClientByIdAbonament = this.connection.prepareStatement("select id_client from abonamente_clients where id = ?");
        this.updateStopDateForPerioada = this.connection.prepareStatement("update abonamente_perioade set stop = ? where id = ?");
        this.updateStartDateForPerioada = this.connection.prepareStatement("update abonamente_perioade set start = ? where id = ?");
        this.getAllPerioadeForClient = this.connection.prepareStatement("select abonamente.nume as nume_abonament, abonamente_perioade.start as data_start, abonamente_perioade.stop as data_stop, abonamente_perioade.status as abonamente_perioade_status, abonamente_perioade.sedinte_consumate as nr_intrari_folosite, abonamente_perioade.forced_days as forced_days, abonamente.nr_sedinte as nr_intrari_totale, abonamente_clients.id as id_contract, abonamente_perioade.id as id_perioada, abonamente.id as id_tip_contract, abonamente_clients.plata_partiala, abonamente_clients.zile_plata_partiala from abonamente_clients inner join abonamente_perioade on abonamente_clients.id = abonamente_perioade.id_abonamente_clients inner join abonamente on abonamente_clients.id_abonament = abonamente.id where abonamente_clients.id_client = ? and abonamente_clients.activ = 1 and (abonamente_perioade.status = 1 or abonamente_perioade.status = 6 or abonamente_perioade.status = 2 )");
        this.getAllPerioadeActiveForAbonament = this.connection.prepareStatement("select * from abonamente_perioade where id_abonamente_clients = ? and ( abonamente_perioade.status = 1 or abonamente_perioade.status = 6 ) order by start");
        this.setPerioadaStatus = this.connection.prepareStatement("update abonamente_perioade set status = ? where id = ?");
        this.getPerioadaById = this.connection.prepareStatement("select * from abonamente_perioade where id = ?");
        this.getTotalPaymentsForPerioadaContract = this.connection.prepareStatement("select sum(suma) from abonamente_payments where id_perioade = ?");
        this.addIntrarePerioadaCurenta = this.connection.prepareStatement("update abonamente_perioade set sedinte_Consumate = sedinte_consumate + 1 where id = ?");
        this.getCurrentPerioadaForAbonamentClient = this.connection.prepareStatement("select * from abonamente_perioade where id_abonamente_clients = ? and status = 1 order by start");
        this.createPerioadaAbonament = this.connection.prepareStatement("insert into abonamente_perioade ( id_abonamente_clients, status) values ( ? , 6 ) ");
        this.setForcedDaysForPerioada = this.connection.prepareStatement("update abonamente_perioade set forced_days = ? where id = ?");
        this.addPayment = this.connection.prepareStatement("insert into abonamente_payments ( id_perioade, suma ) values ( ?, ? )");
        this.deleteContract = this.connection.prepareStatement("update abonamente_clients set activ = 0 where id = ?");
        this.getComments = this.connection.prepareStatement("select comment from comments_clienti where id_client = ?");
        this.addComment = this.connection.prepareStatement("insert into comments_clienti ( id_client, comment) values ( ? , ? )");
        this.updateStatusForContract = this.connection.prepareStatement("update abonamente_clients set status = ? where id = ?");
        this.getGrace = this.connection.prepareStatement("select zile_graced from abonamente where id = ?");
        this.getRenew = this.connection.prepareStatement("select zile_renew from abonamente where id = ?");
        this.getPeriod = this.connection.prepareStatement("select zile_abonament from abonamente where id = ?");
        this.getLastPaymentForContract = this.connection.prepareStatement("select dateadd from abonamente_payments inner join abonamente_perioade on ( abonamente_payments.id_perioade = abonamente_perioade.id and abonamente_perioade.status = 1 ) where abonamente_perioade.id_abonamente_clients = ?");
        this.updateContract = this.connection.prepareStatement("update abonamente_clients set id_client = ?, id_abonament = ?, card = ?, card_temporar = ?, status = ? , id_promotie = ?, plata_partiala = ? , zile_plata_partiala = ? where id = ?");
        this.addContract = this.connection.prepareStatement("insert into abonamente_clients ( id_abonament, id_client, card, card_temporar, id_promotie, status, activ, plata_partiala, zile_plata_partiala ) values ( ?, ?, ?, ?, ?, 4, 1, ?, ? )");
        this.addTipContract = this.connection.prepareStatement("insert into abonamente ( nume, zile_abonament, id_produs, zile_renew, zile_graced, nr_sedinte, status ) values ( ?, ?, ?, ?, ?, ?, 1)");
        this.updateTipContract = this.connection.prepareStatement("update abonamente set nume = ?, zile_abonament = ?, id_produs = ?, zile_renew = ?, zile_graced = ?, nr_sedinte = ? where id = ?");
        this.deleteTipContract = this.connection.prepareStatement("update abonamente set status = 2 where id = ?");
        this.getAllTipContract = this.connection.prepareStatement("select * from abonamente where status = 1");
        this.getTipContractById = this.connection.prepareStatement("select * from abonamente where id = ?");
        this.getTipContractByIdPlan = this.connection.prepareStatement("select abonamente.* from abonamente inner join abonamente_orar on abonamente.id_orar = abonamente_orar.id where abonamente_orar.id = ?");
        String s = "select  id_client, abonamente.nume as abonament, abonamente_clients.status as stare, card, card_temporar, abonamente_clients.id as id_abonament, coalesce(abonamente_clients.id_promotie, -1) as id_promotie, coalesce(promotions.label, '') as promotie, abonamente.zile_abonament, abonamente_clients.creationdate, abonamente.id as tip_abonament, abonamente_clients.plata_partiala, abonamente_clients.zile_plata_partiala, abonamente.nr_sedinte as nr_sedinte, ( select max(dateadd) from abonamente_payments inner join abonamente_perioade on abonamente_payments.id_perioade = abonamente_perioade.id where abonamente_clients.id = abonamente_perioade.id_abonamente_clients) as lastpayment from abonamente_clients inner join abonamente on abonamente_clients.id_abonament = abonamente.id left outer join promotions on abonamente_clients.id_promotie = promotions.id";
        this.getTipContractByName = this.connection.prepareStatement("select * from abonamente where nume = ?");
        this.getContracte = this.connection.prepareStatement(s + " where" + " abonamente_clients.activ = " + 1 + " and (id_abonament = ? or ? = " + -1 + " ) " + " and (id_client = ? or ? = " + -1 + " ) " + " and (abonamente_clients.status = ? or ? = " + -1 + " )");
        this.getContractByCard = this.connection.prepareStatement(s + " where" + " abonamente_clients.activ = " + 1 + " and (card = ? or card_temporar = ?)");
    }

    public Vector<StatusContractView> getContract(String card) throws SQLException {
        Vector<StatusContractView> result = new Vector<StatusContractView>();
        this.getContractByCard.setString(1, card);
        this.getContractByCard.setString(2, card);
        ResultSet rs = this.getContractByCard.executeQuery();
        while (rs.next()) {
            StatusContractView scv = this.getFromRS(rs);
            result.add(scv);
        }
        rs.close();
        return result;
    }

    private StatusContractView getFromRS(ResultSet rs) throws SQLException {
        StatusContractView scv = new StatusContractView();
        scv.setCard(rs.getString("card"));
        scv.setId(rs.getInt("id_abonament"));
        scv.setIdPromotie(rs.getInt("id_promotie"));
        scv.setPromotie(rs.getString("promotie"));
        scv.setIdClient(rs.getInt("id_client"));
        scv.setNumeContract(rs.getString("abonament"));
        scv.setStatus(rs.getInt("stare"));
        scv.setIdTipContract(rs.getInt("tip_abonament"));
        scv.setCardTemporar(rs.getString("card_temporar"));
        Timestamp lastPayment = rs.getTimestamp("lastpayment");
        if (lastPayment == null) {
            lastPayment = DateUtils.getStartOfDays();
        }
        scv.setLastPayment(lastPayment);
        scv.setAddDate(rs.getTimestamp("creationdate"));
        scv.setPeriod(rs.getInt("zile_abonament"));
        scv.setNrSedinte(rs.getInt("nr_sedinte"));
        scv.setPlataPartiala(rs.getInt("plata_partiala") == 1);
        scv.setNrZilePlataPartiala(rs.getInt("zile_plata_partiala"));
        scv.compute();
        return scv;
    }

    public Vector<StatusContractView> getContracte(int idClient, int idTipContract, int status) throws SQLException {
        Vector<StatusContractView> result = new Vector<StatusContractView>();
        this.getContracte.setInt(1, idClient);
        this.getContracte.setInt(2, idClient);
        this.getContracte.setInt(3, idTipContract);
        this.getContracte.setInt(4, idTipContract);
        this.getContracte.setInt(5, status);
        this.getContracte.setInt(6, status);
        ResultSet rs = this.getContracte.executeQuery();
        while (rs.next()) {
            StatusContractView scv = this.getFromRS(rs);
            result.add(scv);
        }
        return result;
    }

    public void addContract(int idTipContract, int idClient, int idPromotie, String card, String cardTemporar, boolean plataPartiala, int zilePlataPartiala) throws SQLException {
        this.addContract.setInt(1, idTipContract);
        this.addContract.setInt(2, idClient);
        this.addContract.setString(3, card);
        this.addContract.setString(4, cardTemporar);
        if (idPromotie > 0) {
            this.addContract.setInt(5, idPromotie);
        } else {
            this.addContract.setNull(5, 4);
        }
        this.addContract.setInt(6, plataPartiala ? 1 : 0);
        this.addContract.setInt(7, zilePlataPartiala);
        this.addContract.execute();
    }

    public void setCarduriForClient(int idClient, String card1, String card2) throws SQLException {
        this.setCarduriForAbonament.setString(1, card1);
        this.setCarduriForAbonament.setString(2, card2);
        this.setCarduriForAbonament.setInt(3, idClient);
        this.setCarduriForAbonament.execute();
    }

    public void deleteContract(int id) throws SQLException {
        this.deleteContract.setInt(1, id);
        this.deleteContract.execute();
    }

    public TipContract getTipContractById(int id) throws SQLException {
        TipContract result = null;
        this.getTipContractById.setInt(1, id);
        ResultSet rs = this.getTipContractById.executeQuery();
        if (rs.next()) {
            result = this.getTipContractFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Vector<TipContract> getTipContractByIdPlan(int id) throws SQLException {
        Vector<TipContract> result = new Vector<TipContract>();
        this.getTipContractByIdPlan.setInt(1, id);
        ResultSet rs = this.getTipContractByIdPlan.executeQuery();
        while (rs.next()) {
            TipContract tc = this.getTipContractFromRS(rs);
            result.add(tc);
        }
        rs.close();
        return result;
    }

    public TipContract getTipContractByName(String name) throws SQLException {
        TipContract result = null;
        this.getTipContractByName.setString(1, name);
        ResultSet rs = this.getTipContractByName.executeQuery();
        if (rs.next()) {
            result = this.getTipContractFromRS(rs);
        }
        rs.close();
        return result;
    }

    private TipContract getTipContractFromRS(ResultSet rs) throws SQLException {
        TipContract tc = new TipContract();
        tc.setId(rs.getInt("id"));
        tc.setNume(rs.getString("nume"));
        tc.setPerioada(rs.getInt("zile_abonament"));
        tc.setRenew(rs.getInt("zile_renew"));
        tc.setGraced(rs.getInt("zile_graced"));
        tc.setIdProdus(rs.getInt("id_produs"));
        tc.setNrSedinte(rs.getInt("nr_sedinte"));
        tc.setIdOrar(rs.getInt("id_orar"));
        return tc;
    }

    public Vector getAllTipContract() throws SQLException {
        Vector<TipContract> result = new Vector<TipContract>();
        ResultSet rs = this.getAllTipContract.executeQuery();
        while (rs.next()) {
            TipContract tc = this.getTipContractFromRS(rs);
            result.add(tc);
        }
        rs.close();
        return result;
    }

    public void addTipContract(String nume, int perioada, int idProdus, int renew, int graced, int sedinte) throws SQLException {
        this.addTipContract.setString(1, nume);
        this.addTipContract.setInt(2, perioada);
        this.addTipContract.setInt(3, idProdus);
        this.addTipContract.setInt(4, renew);
        this.addTipContract.setInt(5, graced);
        this.addTipContract.setInt(6, sedinte);
        this.addTipContract.execute();
    }

    public void deleteTipContract(int id) throws SQLException {
        this.deleteTipContract.setInt(1, id);
        this.deleteTipContract.execute();
    }

    public void updateTipContract(String nume, int perioada, int idProdus, int renew, int graced, int sedinte, int id) throws SQLException {
        this.updateTipContract.setString(1, nume);
        this.updateTipContract.setInt(2, perioada);
        this.updateTipContract.setInt(3, idProdus);
        this.updateTipContract.setInt(4, renew);
        this.updateTipContract.setInt(5, graced);
        this.updateTipContract.setInt(6, sedinte);
        this.updateTipContract.setInt(7, id);
        this.updateTipContract.execute();
    }

    public void updateStopDateForPerioada(int idPerioada, Timestamp newStopTIme) throws SQLException {
        this.updateStopDateForPerioada.setTimestamp(1, newStopTIme);
        this.updateStopDateForPerioada.setInt(2, idPerioada);
        this.updateStopDateForPerioada.execute();
    }

    public void updateStartDateForPerioada(int idPerioada, Timestamp newStopTIme) throws SQLException {
        this.updateStartDateForPerioada.setTimestamp(1, newStopTIme);
        this.updateStartDateForPerioada.setInt(2, idPerioada);
        this.updateStartDateForPerioada.execute();
    }

    public int getClientByIdAbonament(int idAbonament) throws SQLException {
        int result = -1;
        this.getClientByIdAbonament.setInt(1, idAbonament);
        ResultSet rs = this.getClientByIdAbonament.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id_client");
        }
        rs.close();
        return result;
    }
}

