/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.contracte;

import java.sql.Timestamp;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;

public class PerioadaEntry
implements Comparable {
    private int intrariConsumate;
    private int intrariTotale;
    private int zilePlataPartiala;
    private int forcedDays;
    private String tipAbonament;
    private int idContract;
    private int id;
    private int idTipContract;
    private int status;
    private Timestamp startTime;
    private Timestamp stopTime;
    private Timestamp payedUntil;
    private boolean plataPartiala;
    private double plataPartialaPayedSum;

    public PerioadaEntry(int intrariFolosite, int intrariTotale, Timestamp tstart, Timestamp tstop, int idContract, String tipAbonament, int idPerioada, int idTipContract, boolean plataPartiala, int zilePlataPartiala, int status, int forcedDays) {
        this.intrariConsumate = intrariFolosite;
        this.intrariTotale = intrariTotale;
        this.startTime = tstart;
        this.stopTime = tstop;
        this.idContract = idContract;
        this.tipAbonament = tipAbonament;
        this.id = idPerioada;
        this.idTipContract = idTipContract;
        this.plataPartiala = plataPartiala;
        this.zilePlataPartiala = zilePlataPartiala;
        this.status = status;
        this.forcedDays = forcedDays;
    }

    public int getForcedDays() {
        return this.forcedDays;
    }

    public int getStatus() {
        return this.status;
    }

    public int compareTo(Object o) {
        PerioadaEntry pe = (PerioadaEntry)o;
        if (this.status == 1 && pe.status == 1) {
            return this.tipAbonament.compareToIgnoreCase(pe.tipAbonament);
        }
        if (this.status == 1 && pe.status == 6) {
            return -1;
        }
        if (this.status == 1 && pe.status == 2) {
            return -1;
        }
        if (this.status == 6 && pe.status == 1) {
            return 1;
        }
        if (this.status == 6 && pe.status == 6) {
            return this.tipAbonament.compareToIgnoreCase(pe.tipAbonament);
        }
        if (this.status == 6 && pe.status == 2) {
            return -1;
        }
        if (this.status == 2 && pe.status == 1) {
            return 1;
        }
        if (this.status == 2 && pe.status == 6) {
            return 1;
        }
        if (this.status == 2 && pe.status == 2) {
            return this.tipAbonament.compareToIgnoreCase(pe.tipAbonament);
        }
        return 0;
    }

    public double getPlataPartialaPayedSum() {
        return this.plataPartialaPayedSum;
    }

    public void setPlataPartialaPayedSum(double plataPartialaPayedSum) {
        this.plataPartialaPayedSum = plataPartialaPayedSum;
    }

    public int getZilePlataPartiala() {
        return this.zilePlataPartiala;
    }

    public void setPayedUntil(Timestamp payedUntil) {
        this.payedUntil = payedUntil;
    }

    public Timestamp getPayedUntil() {
        return this.payedUntil;
    }

    public boolean isPlataPartiala() {
        return this.plataPartiala;
    }

    public void setStopTime(Timestamp stopTime) {
        this.stopTime = stopTime;
    }

    public int getIdTipContract() {
        return this.idTipContract;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getStopTime() {
        return this.stopTime;
    }

    public int getId() {
        return this.id;
    }

    public String getTipAbonament() {
        return this.tipAbonament;
    }

    public String getValabilitate() {
        String perioada = "";
        if (this.startTime != null) {
            perioada = perioada + Formatters.REZERVARI_FORMAT.format(this.startTime) + " ";
        }
        perioada = perioada + "-";
        if (this.stopTime != null) {
            perioada = perioada + Formatters.REZERVARI_FORMAT.format(this.stopTime) + " ";
        }
        if (this.plataPartiala) {
            perioada = perioada + " (" + Utils.getString2Decimals(this.plataPartialaPayedSum);
            if (this.payedUntil != null) {
                perioada = perioada + "=" + Formatters.REZERVARI_FORMAT.format(this.payedUntil);
            }
            perioada = perioada + ")";
        }
        if (this.forcedDays > 0) {
            perioada = perioada + " (" + this.forcedDays + " zile )";
        }
        return perioada;
    }

    public String getIntrari() {
        if (this.intrariTotale > 0) {
            return this.intrariTotale - this.intrariConsumate + "/" + this.intrariTotale + "/" + this.intrariConsumate;
        }
        return "---";
    }

    public int getIdContract() {
        return this.idContract;
    }
}

