/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.soyal;

import ro.atreides.acces.AccesInterface;
import ro.atreides.utils.Logger;

public class RuleFactory {
    private static String[] availableModels = new String[]{"InReader", "OutReader", "FoReader"};

    public static AccesInterface buildAccesInterface(String requested) throws RuntimeException {
        if (requested == null) {
            return null;
        }
        String realType = null;
        String allTypesString = "";
        for (int i = 0; i < availableModels.length; ++i) {
            String current = availableModels[i];
            if (current.equalsIgnoreCase(requested)) {
                realType = current;
            }
            allTypesString = allTypesString + current + ",";
        }
        if (realType == null) {
            RuntimeException ex = new RuntimeException("Modelul cerut nu este disponibil. Va rugam incercati unul dintre : " + allTypesString);
            Logger.logException("EcrFactory", (Exception)ex);
        }
        String packageName = "ro.atreides.acces.soyal.rules";
        AccesInterface result = null;
        try {
            result = (AccesInterface)Class.forName(packageName + "." + realType).newInstance();
        }
        catch (ClassNotFoundException e) {
            Logger.logException("RuleFactory", (Exception)e);
        }
        catch (InstantiationException e) {
            Logger.logException("RuleFactory", (Exception)e);
        }
        catch (IllegalAccessException e) {
            Logger.logException("RuleFactory", (Exception)e);
        }
        catch (RuntimeException e) {
            Logger.logException("RuleFactory", (Exception)e);
        }
        return result;
    }
}

