/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.soyal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.acces.AccesInterface;
import ro.atreides.acces.soyal.RuleFactory;
import ro.atreides.acces.soyal.SoyalOutgoingConnection;
import ro.atreides.acces.soyal.SoyalUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class SoyalLogic
extends Thread {
    private String portName;
    private Hashtable<String, AccesInterface> interfaces = new Hashtable();
    private Hashtable<Integer, Integer> readers = new Hashtable();
    public static final String ACCES_CHANNEL = "SOYAL_IN_OUT_READER";
    private boolean err = false;

    public SoyalLogic(String port, String params, String inReaderTipAbonament) {
        this.portName = port;
        Vector r = Utils.splitString(params, ',');
        for (int i = 0; i < r.size(); ++i) {
            String s = (String)r.elementAt(i);
            Vector parts = Utils.splitString(s, '=');
            String idReader = (String)parts.get(0);
            String classname = (String)parts.get(1);
            String ext = (String)parts.get(2);
            if (!Validators.correctInteger(idReader)) {
                throw new RuntimeException("Parametri incorecti");
            }
            int readerInt = Integer.parseInt(idReader);
            int extInt = Integer.parseInt(ext);
            AccesInterface inter = RuleFactory.buildAccesInterface(classname);
            Vector tipuriAbonament = Utils.splitString(inReaderTipAbonament, ',');
            inter.setTipAbonamente(tipuriAbonament);
            String key = SoyalLogic.buildReaderKey(readerInt, extInt);
            System.out.println("Thread : " + this.getName() + ": Add interface : key = " + key + " class = " + inter.getClass().getName());
            this.interfaces.put(key, inter);
            this.readers.put(readerInt, readerInt);
        }
    }

    public static String buildReaderKey(int idReader, int idExt) {
        return idReader + "_" + idExt;
    }

    public synchronized void setErr(boolean err) {
        this.err = err;
    }

    public synchronized boolean isErr() {
        return this.err;
    }

    @Override
    public void run() {
        if (Validators.correctString(this.portName)) {
            while (true) {
                this.setErr(false);
                Logger.logDebug(this, "(re) initializing port: " + this.portName);
                try {
                    CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)this.portName);
                    SerialPort serialPort = (SerialPort)portId.open("SoyalLogic", 5000);
                    InputStream in = serialPort.getInputStream();
                    final SoyalOutgoingConnection outConnection = new SoyalOutgoingConnection(serialPort, this);
                    final SoyalLogic parentLogic = this;
                    for (final Integer readerId : this.readers.keySet()) {
                        new Thread(){

                            @Override
                            public void run() {
                                String s1 = "Thread : " + this.getName() + ": enter online mode thread for readerId : " + readerId + " STARTED!!";
                                System.out.println(s1);
                                Logger.logInfo(this, s1);
                                while (!parentLogic.isErr()) {
                                    short[] online = SoyalUtils.enterOnlineMode(readerId);
                                    outConnection.addToOutputQueue(online);
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                s1 = "Thread : " + this.getName() + ": enter online mode thread for readerId : " + readerId + " STOPPED!!";
                                System.out.println(s1);
                                Logger.logInfo(this, s1);
                            }
                        }.start();
                        Thread.sleep(100L);
                    }
                    while (!this.isErr()) {
                        try {
                            byte[] byteArr = SoyalUtils.readMessage(in);
                            short[] incomingShort = SoyalUtils.getShortArray(byteArr);
                            boolean xorOK = SoyalUtils.verifyXOR(incomingShort);
                            boolean sumOK = SoyalUtils.verifySUM(incomingShort);
                            if (SoyalUtils.isCardOnlineResponse(incomingShort) && SoyalUtils.isCardOnlineRead(incomingShort)) {
                                System.out.println("Card online READ : " + TextUtils.getHexString(incomingShort, true));
                                int reader = SoyalUtils.getOnlineReader(incomingShort);
                                int ext = SoyalUtils.getOnlineReaderExt(incomingShort);
                                AccesInterface messageProcessor = this.interfaces.get(SoyalLogic.buildReaderKey(reader, ext));
                                if (messageProcessor != null) {
                                    boolean response = messageProcessor.getResponse(incomingShort);
                                    short[] messageBack = response ? SoyalUtils.getAuthOK(reader) : SoyalUtils.getAuthFailed(reader);
                                    if (messageBack != null) {
                                        outConnection.addToOutputQueue(messageBack);
                                    }
                                    SoyalUtils.getEraseEventLog(reader);
                                } else {
                                    System.out.println("Cititor negasit in hashtable");
                                }
                            }
                            Thread.sleep(100L);
                        }
                        catch (IOException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                catch (PortInUseException e) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Acces: port ocupat : \"" + this.portName + "\"", LangRoAll.nuPotContinua);
                    this.setErr(true);
                }
                catch (Exception e) {
                    Logger.logException(this, e);
                    this.setErr(true);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                String s1 = "Soyal Logic : reconnecting !!";
                System.out.println(s1);
                Logger.logInfo(this, s1);
            }
        }
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Acces: port INCORECT : \"" + this.portName + "\"", LangRoAll.nuPotContinua);
    }

    public Hashtable getInterfaces() {
        return this.interfaces;
    }
}

