/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.soyal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import purejavacomm.SerialPort;
import ro.atreides.acces.soyal.SoyalLogic;
import ro.atreides.acces.soyal.SoyalUtils;
import ro.atreides.utils.Logger;

public class SoyalOutgoingConnection
extends Thread {
    private Vector outputQueue = new Vector();
    private SerialPort port;
    private SoyalLogic logic;

    public SoyalOutgoingConnection(SerialPort port, SoyalLogic parentLogic) {
        this.port = port;
        this.logic = parentLogic;
        this.start();
    }

    public void addToOutputQueue(short[] toSend) {
        this.outputQueue.add(toSend);
    }

    @Override
    public void run() {
        String s1 = "SoyalOutgoingConnection STARTED!!";
        System.out.println(s1);
        Logger.logInfo(this, s1);
        try {
            OutputStream out = this.port.getOutputStream();
            while (!this.logic.isErr()) {
                if (this.outputQueue.size() > 0) {
                    short[] toSend = (short[])this.outputQueue.get(0);
                    byte[] byteArr = SoyalUtils.getBytes(toSend);
                    try {
                        out.write(byteArr);
                        out.flush();
                        this.outputQueue.remove(0);
                        continue;
                    }
                    catch (IOException e) {
                        Logger.logException(this, (Exception)e);
                        this.logic.setErr(true);
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
            this.logic.setErr(true);
        }
        catch (Throwable th) {
            Logger.logError((Object)this, th);
            this.logic.setErr(true);
        }
        s1 = "SoyalOutgoingConnection STOPPED!!";
        System.out.println(s1);
        Logger.logInfo(this, s1);
    }
}

