/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.soyal.rules;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.acces.AccesInterface;
import ro.atreides.acces.AccessAlertInterface;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.StatusContractView;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.acces.soyal.SoyalUtils;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.messaging.Messenger;

public class InReader
extends AccesInterface {
    private ConnectionPool pool;
    private Vector<String> tipContracteName = new Vector();
    private AccessAlertInterface alertInterface;
    private String readerName;
    private boolean consumeSedinte;

    public InReader(String readerName, boolean consumeSedinte) {
        this.pool = ConnectionPool.getInstance();
        this.readerName = readerName;
        this.consumeSedinte = consumeSedinte;
    }

    public AccessAlertInterface getAlertInterface() {
        return this.alertInterface;
    }

    public void setAlertInterface(AccessAlertInterface alertInterface) {
        this.alertInterface = alertInterface;
    }

    @Override
    public void setTipAbonamente(Vector<String> abonamenteNames) {
        this.tipContracteName = abonamenteNames;
    }

    private boolean isAccesGranted(StatusContractView statusContractView) {
        return statusContractView.getStatus() == 1 || statusContractView.getStatus() == 2 || statusContractView.getStatus() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResponse(String cardNumber, Date eventDate) {
        Logger.logDebug(this, "receptionat card:" + cardNumber);
        User u = UsersLogic.getInstance().getUserByCodAutentificare(cardNumber);
        if (u != null) {
            Logger.logDebug(this, "Gasit utilizator: " + u.getName());
            String detalii = "";
            try {
                if (PontajLogic.getInstance().isUserCheckedInNoCommit(u.getId())) {
                    detalii = "Intrare fara iesire";
                    UsersLogic.getInstance().addUserLogNoCommit(u.getId(), detalii);
                    Logger.logDebug(this, "Intrare fara iesire: " + u.getName());
                }
                PontajLogic.getInstance().punchUserInNoCommit(u.getId(), detalii);
                this.pool.commit();
                if (this.alertInterface != null) {
                    this.alertInterface.logEntry(u, this.readerName, eventDate);
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.pool.releaseConnection();
            }
        }
        if (this.tipContracteName == null || this.tipContracteName.size() == 0) {
            Logger.logWarning(this, " Nici un tip de abonament configurat pentru clienti !! Nu dau acces !!");
            return false;
        }
        String date = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
        long exp = DateUtils.now() + DateUtils.minutesMillis * 60L * 24L;
        Vector<StatusContractView> contracte = ContracteLogic.getInstance().getStatusContracteByCard(cardNumber);
        if (contracte.size() <= 0) {
            try {
                this.addMessage(4, date + " Card necunoscut " + cardNumber, exp, null);
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
            return false;
        }
        int idClientFailBack = contracte.get(0).getIdClient();
        StatusContractView accesContract = null;
        for (StatusContractView statusContractView : contracte) {
            Logger.logDebug(this, "Analizez " + statusContractView.getNumeContract() + " status : " + statusContractView.getStatus());
            boolean found = false;
            int tipContract = statusContractView.getIdTipContract();
            TipContract tp = ContracteLogic.getInstance().getTipContractById(tipContract);
            Logger.logDebug(this, "Tip contract : " + tp.getNume());
            for (String contractName : this.tipContracteName) {
                if (tp.getNume().equalsIgnoreCase(contractName)) {
                    Logger.logDebug(this, "Matching : contractname=" + contractName + " , tip contract=" + tp.getNume());
                    if (this.isAccesGranted(statusContractView)) {
                        Logger.logDebug(this, "ACCES GRANTED");
                        accesContract = statusContractView;
                        found = true;
                        break;
                    }
                    Logger.logDebug(this, "ACCES DENIED");
                    continue;
                }
                Logger.logDebug(this, "Not matching : contractname=" + contractName + " , tip contract=" + tp.getNume());
            }
            if (!found) continue;
            break;
        }
        if (accesContract == null) {
            try {
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClientFailBack);
                this.addMessage(4, date + " Nici un ab valid pt : " + c.toString() + " card : " + cardNumber, exp, c);
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
            return false;
        }
        boolean result = true;
        Logger.logDebug(this, "Gasit client: " + accesContract.getNumeClient() + " status: " + accesContract.getNumeStatus());
        int idClient = accesContract.getIdClient();
        try {
            Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
            Timestamp lastCheckin = PontajLogic.getInstance().getLastClientCheckInNoCommit(idClient);
            if (lastCheckin == null) {
                Logger.logWarning(this, "lastCheckin is null . Setting to start of days");
                lastCheckin = DateUtils.getStartOfDays();
            }
            Logger.logDebug(this, "Gasit client by id: " + c.toString());
            int seconds = Config.getInstance().getIntNoCommit("abonamenteCheckInSeconds");
            String expiry = null;
            switch (accesContract.getStatus()) {
                case 1: {
                    expiry = ContracteLogic.getInstance().recordClientInNoCommit(accesContract, c, lastCheckin, seconds, cardNumber, this.consumeSedinte);
                    this.addMessage(1, date, c, expiry, exp);
                    break;
                }
                case 2: {
                    expiry = ContracteLogic.getInstance().recordClientInNoCommit(accesContract, c, lastCheckin, seconds, cardNumber, this.consumeSedinte);
                    this.addMessage(2, date, c, expiry, exp);
                    break;
                }
                case 3: {
                    expiry = ContracteLogic.getInstance().recordClientInNoCommit(accesContract, c, lastCheckin, seconds, cardNumber, this.consumeSedinte);
                    this.addMessage(3, date, c, expiry, exp);
                    break;
                }
                case 4: {
                    this.addMessage(4, date, c, null, exp);
                    result = false;
                }
            }
            this.addAlertForClient(c, eventDate);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            result = false;
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    private void addAlertForClient(Client c, Date eventDate) {
        if (this.alertInterface != null) {
            this.alertInterface.logEntry(c, this.readerName, eventDate);
        }
    }

    private void addMessage(int status, String text, long exp, Client c) throws SQLException {
        Hashtable<String, String> items = new Hashtable<String, String>();
        if (c != null) {
            items.put("u", c.getId() + "");
        }
        items.put("s", status + "");
        items.put("t", text);
        String coded = Messenger.codeInfosInMessageText(items);
        Messenger.getInstance().addMessage("SOYAL_IN_OUT_READER", coded, exp);
    }

    private void addMessage(int status, String date, Client c, String endPerioada, long exp) throws SQLException {
        String text = date + " " + c.toString();
        if (endPerioada != null) {
            text = text + " (valabil " + endPerioada + ")";
        }
        this.addMessage(status, text, exp, c);
    }

    @Override
    public boolean getResponse(short[] message) {
        String cardNumber = SoyalUtils.getCardNumberOnline(message);
        return this.getResponse(cardNumber, new Date());
    }
}

