/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti;

import java.text.ParseException;
import java.util.Date;
import ro.atreides.clienti.CnpVerificationInterface;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.Validators;

public class CnpVerificationRealImpl
implements CnpVerificationInterface {
    @Override
    public String verifyCNP(String cnp) {
        int intvalue;
        String currectChar;
        int requestedSize = 13;
        if ((cnp = cnp.trim()).length() != requestedSize) {
            return "CNP: Lungime CNP incorecta";
        }
        String sex = cnp.charAt(0) + "";
        if (!Validators.correctInteger(sex)) {
            return "CNP: Primul caracter CNP incorect";
        }
        String data = cnp.substring(1, 7);
        try {
            Date d = Formatters.CNP_DATE_FORMAT.parse(data);
        }
        catch (ParseException e) {
            return "CNP: Data invalida";
        }
        int[] cheie = new int[]{2, 7, 9, 1, 4, 6, 3, 5, 8, 2, 7, 9};
        int suma = 0;
        for (int i = 0; i < cheie.length; ++i) {
            currectChar = cnp.charAt(i) + "";
            if (!Validators.correctInteger(currectChar)) {
                return "CNP: Caracter incorect la pozitia " + (i + 1);
            }
            intvalue = Integer.parseInt(currectChar);
            suma += intvalue * cheie[i];
        }
        int rest = suma % 11;
        if (rest == 10) {
            rest = 1;
        }
        if (!Validators.correctInteger(currectChar = cnp.charAt(requestedSize - 1) + "")) {
            return "CNP: Caracter incorect la pozitia " + requestedSize;
        }
        intvalue = Integer.parseInt(currectChar);
        if (intvalue != rest) {
            return "CNP: Suma control eronata";
        }
        return null;
    }
}

