/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.FisaCentralizator;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class CentralizatorClientiReport
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.client, "Cod client", "Cont", "Incarcari", "Initial", "Credit", "Debit", "Final"};
    private ReportInterface reportInterface;
    private JComboBox tipCont;
    private Hashtable printCriteria = new Hashtable();
    private JLabel soldInitialLabel;
    private JLabel soldFinalLabel;
    private JLabel creditLabel;
    private JLabel debitLabel;
    private JLabel incarcariLabel;
    private JTextField valoareIncarcare;
    private double soldInitial;
    private double soldFinal;
    private double credit;
    private double debit;
    private double incarcari;
    private JCheckBox clientiFaraTranzactii;
    private JComboBox<Location> locatieCombo;
    private static Comparator clientSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FisaCentralizator c1 = (FisaCentralizator)o1;
            FisaCentralizator c2 = (FisaCentralizator)o2;
            return c1.getNumeClient().compareToIgnoreCase(c2.getNumeClient());
        }
    };
    private static Comparator incarcariSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((FisaCentralizator)o1).getIncarcari());
            Double c2 = new Double(((FisaCentralizator)o2).getIncarcari());
            return c1.compareTo(c2);
        }
    };
    private static Comparator initialSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((FisaCentralizator)o1).getInitial());
            Double c2 = new Double(((FisaCentralizator)o2).getInitial());
            return c1.compareTo(c2);
        }
    };
    private static Comparator creditSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((FisaCentralizator)o1).getCredit());
            Double c2 = new Double(((FisaCentralizator)o2).getCredit());
            return c1.compareTo(c2);
        }
    };
    private static Comparator debitSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((FisaCentralizator)o1).getDebit());
            Double c2 = new Double(((FisaCentralizator)o2).getDebit());
            return c1.compareTo(c2);
        }
    };
    private static Comparator finalSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((FisaCentralizator)o1).getFinalF());
            Double c2 = new Double(((FisaCentralizator)o2).getFinalF());
            return c1.compareTo(c2);
        }
    };

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.printCriteria.clear();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.tipCont)) {
            TipCont tc = (TipCont)this.tipCont.getSelectedItem();
            result.put("tip_cont", tc.getId());
            this.printCriteria.put("tip_cont", tc.getId());
        } else {
            result.put("tip_cont", -1);
        }
        int valIncarcare = 1;
        if (Validators.correctDouble(this.valoareIncarcare.getText())) {
            valIncarcare = Integer.parseInt(this.valoareIncarcare.getText());
        }
        result.put("Val incarcare", valIncarcare);
        this.printCriteria.put("Val incarcare", valIncarcare);
        boolean faraTranzactii = this.clientiFaraTranzactii.isSelected();
        if (faraTranzactii) {
            result.put("Include clienti fara tranzactii", 1);
            this.printCriteria.put("Include clienti fara tranzactii", "");
        }
        if (ComboUtils.anythingButAllSelected(this.locatieCombo)) {
            Location selectedItem = (Location)this.locatieCombo.getSelectedItem();
            result.put(Constants.LOCATIE_KEY, selectedItem);
            this.printCriteria.put(Constants.LOCATIE_KEY, selectedItem);
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ClientLogic.getInstance().getCentralizatorClienti(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FisaCentralizator fc = (FisaCentralizator)o;
                    try {
                        Label label = new Label(0, row, fc.getNumeClient());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, fc.getCont());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, fc.getCodClient());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(3, row, (double)fc.getIncarcari()));
                        sheet.addCell((WritableCell)new Number(4, row, fc.getInitial()));
                        sheet.addCell((WritableCell)new Number(5, row, fc.getCredit()));
                        sheet.addCell((WritableCell)new Number(6, row, fc.getDebit()));
                        sheet.addCell((WritableCell)new Number(7, row, fc.getFinalF()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return CentralizatorClientiReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Centralizator";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FisaCentralizator fc = (FisaCentralizator)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fc.getNumeClient();
                    }
                    case 1: {
                        return fc.getCont();
                    }
                    case 2: {
                        return fc.getCodClient();
                    }
                    case 3: {
                        return fc.getIncarcari() + "";
                    }
                    case 4: {
                        return Utils.getString2Decimals(fc.getInitial());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fc.getCredit());
                    }
                    case 6: {
                        return Utils.getString2Decimals(fc.getDebit());
                    }
                    case 7: {
                        return Utils.getString2Decimals(fc.getFinalF());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Total incarcari"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.incarcariLabel = new JLabel("");
        result.add((Component)this.incarcariLabel, c);
        c.weightx = 0.0;
        ++c.gridx;
        result.add((Component)new JLabel("Sold initial"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.soldInitialLabel = new JLabel("");
        result.add((Component)this.soldInitialLabel, c);
        c.weightx = 0.0;
        ++c.gridx;
        result.add((Component)new JLabel("Credit"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.creditLabel = new JLabel("");
        result.add((Component)this.creditLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Debit"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.debitLabel = new JLabel("");
        result.add((Component)this.debitLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Sold final"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.soldFinalLabel = new JLabel("");
        result.add((Component)this.soldFinalLabel, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        buttonsPanel.add((Component)new JLabel("Cont"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipCont = new JComboBox();
        buttonsPanel.add((Component)this.tipCont, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel("Locatie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.locatieCombo = new JComboBox();
        buttonsPanel.add(this.locatieCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel("Valoare incarcare"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.valoareIncarcare = new JTextField(10);
        this.valoareIncarcare.setText("1");
        buttonsPanel.add((Component)this.valoareIncarcare, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel("Clienti fara tranzactii"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientiFaraTranzactii = new JCheckBox();
        this.clientiFaraTranzactii.setSelected(false);
        buttonsPanel.add((Component)this.clientiFaraTranzactii, c);
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.soldInitialLabel.setText(Utils.getString2Decimals(this.soldInitial));
        this.creditLabel.setText(Utils.getString2Decimals(this.credit));
        this.debitLabel.setText(Utils.getString2Decimals(this.debit));
        this.soldFinalLabel.setText(Utils.getString2Decimals(this.soldFinal));
        this.incarcariLabel.setText(Utils.getString2Decimals(this.incarcari));
    }

    private void computeTotals(Vector items) {
        this.incarcari = 0.0;
        this.soldInitial = 0.0;
        this.credit = 0.0;
        this.debit = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            FisaCentralizator o = (FisaCentralizator)items.elementAt(i);
            this.soldInitial += o.getInitial();
            this.credit += o.getCredit();
            this.debit += o.getDebit();
            this.incarcari += (double)o.getIncarcari();
        }
        this.soldFinal = this.soldInitial + this.credit - this.debit;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.tipCont, ClientLogic.getInstance().getAllConturi(), true);
        ComboUtils.replaceItemsForCombo(this.locatieCombo, RestLogic.getInstance().getLocations());
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 8;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getReportTitle() {
                return CentralizatorClientiReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return CentralizatorClientiReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FisaCentralizator fc = (FisaCentralizator)row;
                switch (column) {
                    case 0: {
                        return fc.getNumeClient();
                    }
                    case 1: {
                        return fc.getCont();
                    }
                    case 2: {
                        return fc.getCodClient();
                    }
                    case 3: {
                        return fc.getIncarcari() + "";
                    }
                    case 4: {
                        return Utils.getString2Decimals(fc.getInitial());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fc.getCredit());
                    }
                    case 6: {
                        return Utils.getString2Decimals(fc.getDebit());
                    }
                    case 7: {
                        return Utils.getString2Decimals(fc.getFinalF());
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 4: {
                        return Utils.getString2Decimals(CentralizatorClientiReport.this.soldInitial);
                    }
                    case 5: {
                        return Utils.getString2Decimals(CentralizatorClientiReport.this.credit);
                    }
                    case 6: {
                        return Utils.getString2Decimals(CentralizatorClientiReport.this.debit);
                    }
                    case 7: {
                        return Utils.getString2Decimals(CentralizatorClientiReport.this.soldFinal);
                    }
                }
                return "";
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return clientSorter;
            }
            case 3: {
                return incarcariSorter;
            }
            case 4: {
                return initialSorter;
            }
            case 5: {
                return creditSorter;
            }
            case 6: {
                return debitSorter;
            }
            case 7: {
                return finalSorter;
            }
        }
        return null;
    }
}

