/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JDialog;
import javax.swing.JFrame;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.utils.Client;
import ro.atreides.utils.gui.table.SwitchToList;

public class ClientEditDialog
extends JDialog {
    private int clientId;
    private String clientName;

    public ClientEditDialog(JFrame parent, ClientLogic logic, Client client, boolean persJuridica, ClientEditPanelProvider panelProvider) {
        this(parent, logic, client, persJuridica, panelProvider, "", "", "", "");
    }

    public ClientEditDialog(JFrame parent, ClientLogic logic, final Client client, boolean persJuridica, ClientEditPanelProvider panelProvider, String telefonMobilAdd, String adresaAdd, String numeAdd, String emailAdd) {
        super(parent, client != null ? "Editare " + client : "Adaugare", true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridy = 0;
        c.gridx = 0;
        if (persJuridica) {
            final PersJuridicaAddEditPanel juridicAddEdit = panelProvider.getPjPanel();
            juridicAddEdit.setLogic(logic);
            if (client != null) {
                juridicAddEdit.setClientToEdit(client);
            } else {
                juridicAddEdit.setNewClientData(telefonMobilAdd, adresaAdd, numeAdd, emailAdd);
                juridicAddEdit.setClientGroup();
            }
            juridicAddEdit.setAction(new SwitchToList(){

                @Override
                public void doAction() {
                    if (client != null) {
                        ClientEditDialog.this.clientId = client.getId();
                    } else {
                        ClientEditDialog.this.clientId = juridicAddEdit.getNewClientId();
                    }
                    ClientEditDialog.this.dispose();
                }
            });
            juridicAddEdit.setActionAtAdauga(true);
            this.add((Component)juridicAddEdit, c);
        } else {
            final PersFizicaAddEditPanel fizicAddEdit = panelProvider.getPfPanel();
            fizicAddEdit.setLogic(logic);
            if (client != null) {
                fizicAddEdit.setClientToEdit(client);
            } else {
                fizicAddEdit.setNewClientData(telefonMobilAdd, adresaAdd, numeAdd, emailAdd);
                fizicAddEdit.setClientGroup();
            }
            fizicAddEdit.setAction(new SwitchToList(){

                @Override
                public void doAction() {
                    if (client != null) {
                        ClientEditDialog.this.clientId = client.getId();
                        ClientEditDialog.this.clientName = fizicAddEdit.getNewClientName();
                    } else {
                        ClientEditDialog.this.clientId = fizicAddEdit.getNewClientId();
                        ClientEditDialog.this.clientName = fizicAddEdit.getNewClientName();
                    }
                    ClientEditDialog.this.dispose();
                }
            });
            fizicAddEdit.setActionAtAdauga(true);
            this.add((Component)fizicAddEdit, c);
        }
        this.pack();
        int width = (int)((double)parent.getWidth() / 1.1);
        int height = (int)((double)parent.getHeight() / 1.1);
        int x = 0;
        int y = 0;
        if (parent != null) {
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            x = parent.getX() + (parentWidth - width) / 2;
            y = parent.getY() + (parentHeight - height) / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setBounds(x, y, width, height);
        this.setVisible(true);
    }

    public int getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        return this.clientName;
    }
}

