/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.utils.Client;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;

public class ClientSelectPanel
extends JPanel {
    private JComboBox angajati;
    private XComboBox clienti;
    private FilterableComboBoxModel clientsComboModel;
    private ClientLogic logic = ClientLogic.getInstance();
    private Client selectedClient;
    private int selected = -1;
    private boolean mustAdd = false;
    private boolean mustEdit = false;
    private JTextField telefon;
    private JComboBox adresa;
    private JDialog dialog;
    private JButton modifica;
    private JButton reloadClients;
    private JButton newClient;
    private JButton ok;

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    private void updateClient(Client c) {
        this.adresa.removeAllItems();
        if (c != null) {
            Vector<String> adrese = c.getAdrese();
            if (c instanceof ClientPersJuridica) {
                ClientPersJuridica c1 = (ClientPersJuridica)c;
                Vector angajatiForCompanie = this.logic.getAnjagati(c1.getIdPersJuridica());
                ComboUtils.replaceItemsForCombo(this.angajati, angajatiForCompanie);
            } else {
                ComboUtils.replaceItemsForCombo(this.angajati, new Vector());
            }
            if (Validators.correctString(c.getCity())) {
                for (String s : adrese) {
                    this.adresa.addItem(c.getCity() + ", " + s);
                }
            } else {
                for (String s : adrese) {
                    this.adresa.addItem(s);
                }
            }
            String text = this.logic.getLastUpdatedStringForClientSelection(c);
            this.modifica.setText(text);
            if (adrese.size() > 0) {
                this.adresa.setSelectedIndex(0);
            }
        } else {
            ComboUtils.replaceItemsForCombo(this.angajati, new Vector());
            this.modifica.setText("");
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public boolean isMustAdd() {
        return this.mustAdd;
    }

    public Client getSelectedClient() {
        return this.selectedClient;
    }

    public ClientSelectPanel(String defaultNumber) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        this.newClient = new JButton("Client nou");
        this.ok = new JButton("OK");
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Telefon"), c);
        c.gridwidth = 3;
        ++c.gridx;
        this.telefon = new JTextField(10);
        this.telefon.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ClientSelectPanel.this.searchByPhoneNumber();
                }
            }
        });
        this.add((Component)this.telefon, c);
        this.telefon.setText(defaultNumber);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.add((Component)this.clienti, c);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Adresa"), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.adresa = new JComboBox();
        this.add((Component)this.adresa, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(LangRoAll.angajat), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.angajati = new JComboBox();
        this.add((Component)this.angajati, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Actualizat"), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.modifica = new JButton("");
        this.add((Component)this.modifica, c);
        this.modifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientSelectPanel.this.mustEdit = true;
                Object client = ClientSelectPanel.this.clienti.getSelectedItem();
                if (client instanceof Client) {
                    ClientSelectPanel.this.selected = ((Client)client).getId();
                    ClientSelectPanel.this.selectedClient = (Client)client;
                } else if (ClientSelectPanel.this.dialog != null) {
                    ClientSelectPanel.this.dialog.dispose();
                }
                if (ComboUtils.anythingButAllSelected(ClientSelectPanel.this.angajati)) {
                    client = ClientSelectPanel.this.angajati.getSelectedItem();
                    ClientSelectPanel.this.selected = ((Client)client).getId();
                    ClientSelectPanel.this.selectedClient = (Client)client;
                }
                if (ClientSelectPanel.this.dialog != null) {
                    ClientSelectPanel.this.dialog.dispose();
                }
            }
        });
        this.clienti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(ClientSelectPanel.this.clienti)) {
                    Client c = (Client)ClientSelectPanel.this.clienti.getSelectedItem();
                    ClientSelectPanel.this.updateClient(c);
                } else {
                    ComboUtils.replaceItemsForCombo(ClientSelectPanel.this.angajati, new Vector());
                }
            }
        });
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 1;
        this.add((Component)this.ok, c);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object client = ClientSelectPanel.this.clienti.getSelectedItem();
                if (client instanceof Client) {
                    ClientSelectPanel.this.selected = ((Client)client).getId();
                    ClientSelectPanel.this.selectedClient = (Client)client;
                } else if (ClientSelectPanel.this.dialog != null) {
                    ClientSelectPanel.this.dialog.dispose();
                }
                if (ComboUtils.anythingButAllSelected(ClientSelectPanel.this.angajati)) {
                    client = ClientSelectPanel.this.angajati.getSelectedItem();
                    ClientSelectPanel.this.selected = ((Client)client).getId();
                    ClientSelectPanel.this.selectedClient = (Client)client;
                }
                if (ClientSelectPanel.this.dialog != null) {
                    ClientSelectPanel.this.dialog.dispose();
                }
            }
        });
        ++c.gridx;
        this.add((Component)this.newClient, c);
        this.newClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientSelectPanel.this.selected = -1;
                ClientSelectPanel.this.mustAdd = true;
                if (ClientSelectPanel.this.dialog != null) {
                    ClientSelectPanel.this.dialog.dispose();
                }
            }
        });
        ++c.gridx;
        this.reloadClients = new JButton(LangRoAll.reincarcaClienti);
        this.reloadClients.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector newClients = ClientLogic.getInstance().refreshAllClient();
                ClientSelectPanel.this.clientsComboModel.refresh(newClients);
            }
        });
        this.add((Component)this.reloadClients, c);
        this.telefon.requestFocus();
        if (Validators.correctString(defaultNumber)) {
            this.searchByPhoneNumber();
        }
    }

    public String getSelectedAdresa() {
        String s = (String)this.adresa.getSelectedItem();
        if (s != null) {
            return s;
        }
        System.out.println("selected item is null");
        return "";
    }

    private void searchByPhoneNumber() {
        String s1 = this.telefon.getText();
        Vector<Client> allFound = ClientLogic.getInstance().getAllByTelefon(s1);
        if (allFound.size() == 1) {
            Client c = allFound.get(0);
            if (c == null && Validators.correctString(s1)) {
                int cod = Integer.parseInt(s1);
                c = ClientLogic.getInstance().getClientById(cod);
            }
            this.updateClient(c);
            this.ok.requestFocus();
            this.clienti.setSelectedItem(c);
        } else if (allFound.size() > 1) {
            this.clienti.clearAllText();
            this.clientsComboModel.refresh(allFound);
            this.clienti.setSelectedItem(null);
            this.clientsComboModel.applyFilters("");
            this.clienti.setPopupVisible(true);
        } else {
            this.newClient.requestFocus();
        }
    }

    public boolean isMustEdit() {
        return this.mustEdit;
    }

    public String getTelephone() {
        return this.telefon.getText();
    }
}

