/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.PartenerGroup;
import ro.atreides.clienti.PersJuridicaViewEntry;
import ro.atreides.clienti.gui.ClientiAddEditPanel;
import ro.atreides.clienti.gui.FinanciarePanel;
import ro.atreides.clienti.gui.SocietatePanel;
import ro.atreides.utils.Client;
import ro.atreides.utils.Country;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.AdresaPanel;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.deversoft.anaf.AnafUtils;
import ro.deversoft.anaf.RmiObserver;
import ro.deversoft.anaf.beans.FoundOrNotBean;

public class PersJuridicaAddEditPanel
extends ClientiAddEditPanel {
    private AdresaPanel adresaPanel;
    private SocietatePanel namePanel;
    private FinanciarePanel financiarePanel;
    private ClientPersJuridica client;
    private int newClientId;
    private MultiboxList multiBoxGroup;
    private JTextField codExternClient;
    private JTextField codExtendFurnizor;
    private JTextField analiticClient;
    private JTextField analiticFurnizor;

    @Override
    public JPanel buildContentPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        this.namePanel = new SocietatePanel();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 4;
        result.add((Component)this.namePanel, c);
        JPanel groupsPanel = this.getGrupPanel();
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 1;
        result.add((Component)groupsPanel, c);
        c.weighty = 1.0;
        c.gridy = 1;
        this.financiarePanel = new FinanciarePanel();
        result.add((Component)this.financiarePanel, c);
        c.gridy = 2;
        JPanel transferPanel = this.getTransferPanel();
        result.add((Component)transferPanel, c);
        this.adresaPanel = new AdresaPanel();
        final LanguageLogic langLogic = LanguageLogic.getInstance();
        this.adresaPanel.setCountries(langLogic.getAllCountries());
        langLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                PersJuridicaAddEditPanel.this.adresaPanel.setCountries(langLogic.getAllCountries());
            }

            @Override
            public String getName() {
                return "PersJuridicaAddEditPanelCountries";
            }
        }, 43);
        c.gridy = 3;
        result.add((Component)this.adresaPanel, c);
        return result;
    }

    private JPanel getGrupPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.grup), c);
        ++c.gridx;
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroups();
        this.multiBoxGroup = new MultiboxList(allItems, 10);
        result.add((Component)this.multiBoxGroup, c);
        result.setBorder(new TitledBorder("Grupuri"));
        return result;
    }

    private JPanel getTransferPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Cod extern furnizor"), c);
        ++c.gridx;
        this.codExtendFurnizor = new JTextField(10);
        result.add((Component)this.codExtendFurnizor, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Analitic furnizor"), c);
        ++c.gridx;
        this.analiticFurnizor = new JTextField(10);
        result.add((Component)this.analiticFurnizor, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cod extern client"), c);
        ++c.gridx;
        this.codExternClient = new JTextField(10);
        result.add((Component)this.codExternClient, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Analitic client"), c);
        ++c.gridx;
        this.analiticClient = new JTextField(10);
        result.add((Component)this.analiticClient, c);
        result.setBorder(new TitledBorder("Transfer date"));
        return result;
    }

    public int getNewClientId() {
        return this.newClientId;
    }

    private boolean validateData() {
        return Validators.correctString(this.namePanel.getCompanyName()) && this.adresaPanel.getIdTara() != -1;
    }

    private void erase(ClientPersJuridica client) {
        if (client != null) {
            this.logic.erasePersJuridicaLocally(client);
        }
    }

    private void clearFields() {
        this.adresaPanel.initFields();
        this.namePanel.initFields();
        this.financiarePanel.resetFields();
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroups();
        this.multiBoxGroup.setSelectedItems(allItems, false);
        this.codExtendFurnizor.setText("");
        this.codExternClient.setText("");
        this.analiticClient.setText("");
        this.analiticFurnizor.setText("");
    }

    private void initialValues(ClientPersJuridica client) {
        this.namePanel.setNume(client.getCompanyName());
        this.namePanel.setCui(client.getCui());
        this.namePanel.setJ(client.getJ());
        this.namePanel.setIban(client.getBankIban());
        this.namePanel.setBanca(client.getBank());
        this.namePanel.setAlias(client.getAlias());
        this.adresaPanel.setOras(client.getCity());
        this.adresaPanel.setAdresa(client.getAddress1());
        Country c = LanguageLogic.getInstance().getCountryById(client.getIdCountry());
        this.adresaPanel.setTara(c);
        this.namePanel.setPunctLucru(client.getPunctDeLucru());
        this.namePanel.setTelFix(client.getTelefonFix());
        this.namePanel.setFax(client.getFax());
        this.namePanel.setTelMobil(client.getTelefonMobil());
        this.namePanel.setEmail(client.getEmail());
        this.namePanel.setWeb(client.getPaginaWeb());
        this.namePanel.setPersContact(client.getPersoanaContact());
        this.financiarePanel.setGarantie(Utils.getString2Decimals(client.getGarantie()));
        this.financiarePanel.setNrZileScadenta(client.getNrZileScadenta() + "");
        this.financiarePanel.setObservatii(client.getObservatii());
        this.financiarePanel.setCredit(Utils.getString2Decimals(client.getCredit()));
        this.financiarePanel.setIdAgent(client.getIdAgent());
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroups();
        this.multiBoxGroup.setSelectedItems(allItems, false);
        Vector<PartenerGroup> selectedItems = ClientLogic.getInstance().getGroupsForPartner(client.getId());
        this.multiBoxGroup.setSelectedItems(selectedItems, true);
        this.codExtendFurnizor.setText(client.getCodFurnizor());
        this.codExternClient.setText(client.getCodClient());
        this.analiticClient.setText(client.getAnaliticClient());
        this.analiticFurnizor.setText(client.getAnaliticFurnizor());
    }

    private void save() {
        String groups = "";
        Vector items = this.multiBoxGroup.getSelectedItems();
        for (int i = 0; i < items.size(); ++i) {
            PartenerGroup pg = (PartenerGroup)items.elementAt(i);
            groups = groups + pg.getId();
            if (i >= items.size() - 1) continue;
            groups = groups + ",";
        }
        int nrZile = 0;
        String s = this.financiarePanel.getNrZileScadenta();
        if (Validators.correctInteger(s)) {
            nrZile = Integer.parseInt(s);
        }
        double credit = 0.0;
        s = this.financiarePanel.getCredit();
        if (Validators.correctDouble(s)) {
            credit = Utils.parseDouble(s);
        }
        double garantie = 0.0;
        s = this.financiarePanel.getGarantie();
        if (Validators.correctDouble(s)) {
            garantie = Utils.parseDouble(s);
        }
        if (this.client != null) {
            this.logic.savePersJuridica(this.client, this.namePanel.getCompanyName(), this.namePanel.getCui(), this.namePanel.getJ(), this.namePanel.getBanca(), this.namePanel.getIban(), this.adresaPanel.getAdresa(), this.adresaPanel.getOras(), this.adresaPanel.getIdTara(), this.namePanel.getPunctLucruField(), this.namePanel.getTelFixField(), this.namePanel.getFaxField(), this.namePanel.getTelMobilField(), this.namePanel.getEmailField(), this.namePanel.getWebField(), this.namePanel.getPersContactField(), garantie, this.financiarePanel.getIdAgent(), this.financiarePanel.getObservatii(), nrZile, credit, groups, this.codExtendFurnizor.getText(), this.analiticFurnizor.getText(), this.codExternClient.getText(), this.analiticClient.getText(), this.namePanel.getAlias());
            this.setObjectToEdit(null);
            this.action.doAction();
        } else {
            this.newClientId = this.logic.addPersJuridica(this.namePanel.getCompanyName(), this.namePanel.getCui(), this.namePanel.getJ(), this.adresaPanel.getAdresa(), this.adresaPanel.getIdTara(), this.adresaPanel.getOras(), this.namePanel.getBanca(), this.namePanel.getIban(), this.namePanel.getPunctLucruField(), this.namePanel.getTelFixField(), this.namePanel.getFaxField(), this.namePanel.getTelMobilField(), this.namePanel.getEmailField(), this.namePanel.getWebField(), this.namePanel.getPersContactField(), garantie, this.financiarePanel.getIdAgent(), this.financiarePanel.getObservatii(), nrZile, credit, groups, this.codExtendFurnizor.getText(), this.analiticFurnizor.getText(), this.codExternClient.getText(), this.analiticClient.getText(), this.namePanel.getAlias(), true);
            if (this.newClientId != -1) {
                this.clearFields();
                this.setObjectToEdit(null);
                if (this.actionAtAdauga) {
                    this.action.doAction();
                }
            }
        }
    }

    public void setObjectToEdit(Object o) {
        super.switchSaveLabels(o);
        if (o != null) {
            PersJuridicaViewEntry ve = (PersJuridicaViewEntry)o;
            this.client = this.logic.getPersJuridicaById(ve.getId());
            this.initialValues(this.client);
        } else {
            this.client = null;
            this.clearFields();
        }
    }

    public void setClientToEdit(Client o) {
        super.switchSaveLabels(o);
        if (o != null) {
            ClientPersJuridica ve = (ClientPersJuridica)o;
            this.client = this.logic.getPersJuridicaById(ve.getIdPersJuridica());
            this.initialValues(this.client);
        } else {
            this.client = null;
            this.clearFields();
        }
    }

    @Override
    public void saveButton() {
        if (this.validateData()) {
            this.save();
        }
    }

    @Override
    public void backButton() {
        this.setObjectToEdit(null);
        this.action.doAction();
    }

    @Override
    public void resetButton() {
        this.clearFields();
    }

    @Override
    public void deleteButton() {
        this.erase(this.client);
        this.setObjectToEdit(null);
        this.action.doAction();
    }

    public void setNewClientData(String telefonMobil, String adresa, String nume, String email) {
        this.namePanel.setTelMobil(telefonMobil);
        this.namePanel.setNume(nume);
        this.namePanel.setEmail(email);
        this.adresaPanel.setAdresa(adresa);
    }

    public void setClientGroup() {
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroups();
        this.multiBoxGroup.setSelectedItems(allItems, false);
        Vector<PartenerGroup> selectedItems = new Vector<PartenerGroup>();
        PartenerGroup pg = this.logic.getParteneriGroupById(2);
        selectedItems.add(pg);
        this.multiBoxGroup.setSelectedItems(selectedItems, true);
    }

    @Override
    public JButton addNewButton() {
        JButton verificaButton = new JButton("Verifica CUI");
        verificaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cui = PersJuridicaAddEditPanel.this.namePanel.getCui().trim();
                if (!Validators.correctString(cui)) {
                    return;
                }
                AnafUtils.invokeAnafCall(cui, new AnafCuiObserver());
            }
        });
        return verificaButton;
    }

    public class AnafCuiObserver
    implements RmiObserver {
        @Override
        public void onUpdate(String requestObject) {
            Object o = AnafUtils.pullFoundBean();
            if (o instanceof FoundOrNotBean) {
                String j;
                String fullText;
                Boolean tvaIncasare;
                Boolean tva;
                String adresa;
                FoundOrNotBean foundOrNotBean = (FoundOrNotBean)o;
                String denumire = foundOrNotBean.getDenumire();
                if (Validators.correctString(denumire)) {
                    PersJuridicaAddEditPanel.this.namePanel.setNume(denumire);
                }
                if (Validators.correctString(adresa = foundOrNotBean.getAdresa())) {
                    String oras = AnafUtils.getCityFromAddress(adresa);
                    if (Validators.correctString(oras)) {
                        PersJuridicaAddEditPanel.this.adresaPanel.setOras(oras);
                    }
                    PersJuridicaAddEditPanel.this.adresaPanel.setAdresa(AnafUtils.getAdressWithoutCity(adresa));
                }
                if ((tva = Boolean.valueOf(foundOrNotBean.isTva())) != null) {
                    PersJuridicaAddEditPanel.this.multiBoxGroup.selectItem("Platitor TVA", tva);
                }
                if ((tvaIncasare = Boolean.valueOf(foundOrNotBean.isTva_la_incasare())) != null) {
                    PersJuridicaAddEditPanel.this.multiBoxGroup.selectItem("Aplica TVA la incasare", tvaIncasare);
                }
                if (Validators.correctString(fullText = foundOrNotBean.getFullText())) {
                    DialogUtils.bigConfirmDialog(GuiUtils.currentFrame, "Date primite de la server:", fullText, "Date extra");
                }
                if (Validators.correctString(j = foundOrNotBean.getJ())) {
                    PersJuridicaAddEditPanel.this.namePanel.setJ(j);
                }
                String codTvaIntracomunitar = foundOrNotBean.getCodTvaIntracomunitar();
            } else if (o instanceof String) {
                String mesaj = (String)o;
                DialogUtils.errorDialog(GuiUtils.currentFrame, mesaj, LangRoAll.eroare);
                PersJuridicaAddEditPanel.this.namePanel.setNume("");
                PersJuridicaAddEditPanel.this.adresaPanel.setAdresa("");
                PersJuridicaAddEditPanel.this.adresaPanel.setOras("");
            }
        }
    }
}

