/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.PersJuridicaViewEntry;
import ro.atreides.utils.gui.table.AbstractTM;

public class PersJuridiceCellRenderer
extends DefaultTableCellRenderer {
    private AbstractTM model;

    public PersJuridiceCellRenderer(AbstractTM model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        PersJuridicaViewEntry se = (PersJuridicaViewEntry)this.model.getData().elementAt(row);
        ClientPersJuridica cpj = se.getClientObject();
        String dateContact = cpj.getDateContact("<br><li>");
        String text = "<html> Detalii:" + dateContact + "</html>";
        this.setToolTipText(text);
        switch (column) {
            case 0: {
                if (se.isSelected()) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                    break;
                }
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                break;
            }
            case 5: {
                int c1 = ClientLogic.getInstance().getDateContactPJWarningImpl().getAlertLevel(se);
                if (c1 == 1) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                } else if (c1 == 2) {
                    this.setBackground(Color.RED);
                    this.setForeground(Color.BLACK);
                } else {
                    this.setBackground(Color.WHITE);
                    this.setForeground(Color.BLACK);
                }
                this.setText(cpj.getProblems());
                break;
            }
            default: {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
        }
        return this;
    }
}

