/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate;

import com.google.gson.Gson;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import jxl.write.WriteException;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.SAXException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.PersJuridicaViewEntry;
import ro.atreides.contabilitate.ContaPrint;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.FacturaEntry;
import ro.atreides.contabilitate.FacturiEntry;
import ro.atreides.contabilitate.GetTotalIncasariCategoriesInterface;
import ro.atreides.contabilitate.ImportFacturaXmlHandler;
import ro.atreides.contabilitate.IncasariClientiEntry;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.NirEntry;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.NirExcelFormulaProcessor;
import ro.atreides.contabilitate.NirExcelProcessor;
import ro.atreides.contabilitate.RaportIntrariEntry;
import ro.atreides.contabilitate.RegistruCasaEntry;
import ro.atreides.contabilitate.TipCheltuiala;
import ro.atreides.contabilitate.TipRegistru;
import ro.atreides.contabilitate.conta.DateIntrare;
import ro.atreides.contabilitate.conta.InformationBean;
import ro.atreides.contabilitate.conta.VariabileIntrareNir;
import ro.atreides.contabilitate.db.CommonsDao;
import ro.atreides.contabilitate.db.FacturaEntriesDao;
import ro.atreides.contabilitate.db.FacturiDao;
import ro.atreides.contabilitate.db.NirEntriesDao;
import ro.atreides.contabilitate.db.NiruriDao;
import ro.atreides.contabilitate.db.RegCasaDao;
import ro.atreides.contabilitate.export.NotaContabila;
import ro.atreides.contabilitate.export.platforma.ExportNirPlatforma;
import ro.atreides.contabilitate.gui.AgedDebtorsEntry;
import ro.atreides.contabilitate.gui.EditNirPanel;
import ro.atreides.contabilitate.gui.IntrariFurnizoriEntry;
import ro.atreides.contabilitate.gui.InvoicedCollectedEntry;
import ro.atreides.contabilitate.gui.InvoicedCollectedEntryCategorii;
import ro.atreides.contabilitate.gui.ProfitFacturiReportEntryDetalii;
import ro.atreides.contabilitate.gui.ProfitReportPanelEntry;
import ro.atreides.contabilitate.gui.ResumeEntry;
import ro.atreides.contabilitate.gui.SituatieParteneriEntry;
import ro.atreides.contabilitate.tvalaincasare.TvaLaIncasareInterface;
import ro.atreides.contabilitate.tvalaincasare.TvaLaIncasareNUSeAplicaImpl;
import ro.atreides.contabilitate.tvalaincasare.TvaLaIncasareSeAplicaImpl;
import ro.atreides.facturi.FacturatEntry;
import ro.atreides.facturi.FacturatKey;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.facturi.IncasareDetaliataEntry;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.FacturiDataProvider;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrintUtils;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.admin.prices.PricePanelEntry;
import ro.atreides.restaurant.logic.PrintEticheteInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.simplestocks.CheckStockInDepositInterface;
import ro.atreides.simplestocks.SimpleStockDiff;
import ro.atreides.simplestocks.SimpleStockLogic;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.ReceptieFromStockInterface;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.StockViewEntry;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ContaExportInterface;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.LanguageProvider;
import ro.atreides.utils.Logger;
import ro.atreides.utils.PlatiEntry;
import ro.atreides.utils.ProductPriceInterface;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.UnitsProvider;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.DocumentInterface;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class ContaLogic
implements CheckStockInDepositInterface {
    private static ContaLogic instance = null;
    private Config config;
    private StockLogic stockLogic;
    private UnitsProvider unitsProvider;
    private LanguageProvider languageProvider;
    private DocumentInterface documentInterface;
    private FacturiDataProvider inter;
    private CheckStockInDepositInterface checkStockInterface;
    private ConnectionPool pool = ConnectionPool.getInstance();
    private ProductPriceInterface priceInterface;
    private ContaExportInterface winmentorExportInterface;
    public static final String TIP_COLECTAT_KEY = "Colectat";
    public static final String AN_RAPORT_KEY = "An";
    public static final String COLLECTAT_IN_LUNA_RESPECTIVA = "in luna respectiva";
    public static final String AFERENT_LUNII_RESPECTIVE = "aferent lunii respective";
    public static final String COLLECTAT_PANA_LA_DATA = "pana la data";
    public static final String COLLECTAT_LA_ZI = "la zi";
    public static final String GROUP_PLATITOR_TVA_KEY = "pers_juridice_groups_platitor_tva";
    private static double totalDatoriiA;
    private static double totalDatoriiB;
    private static double totalDatoriiC;
    private static double totalDatoriiGeneral;

    public TIP_DOCUMENT_NIR getTipDocumentNirFromDb(int tipInDb) {
        if (tipInDb == TIP_DOCUMENT_NIR.Factura.getTip()) {
            return TIP_DOCUMENT_NIR.Factura;
        }
        if (tipInDb == TIP_DOCUMENT_NIR.BonFiscal.getTip()) {
            return TIP_DOCUMENT_NIR.BonFiscal;
        }
        if (tipInDb == TIP_DOCUMENT_NIR.BorderouAchizitii.getTip()) {
            return TIP_DOCUMENT_NIR.BorderouAchizitii;
        }
        return null;
    }

    public ContaExportInterface getWinmentorExportInterface() {
        return this.winmentorExportInterface;
    }

    public void setWinmentorExportInterface(ContaExportInterface winmentorExportInterface) {
        this.winmentorExportInterface = winmentorExportInterface;
    }

    public FacturiDataProvider getInter() {
        return this.inter;
    }

    public void setInter(FacturiDataProvider inter) {
        this.inter = inter;
    }

    public ProductPriceInterface getPriceInterface() {
        return this.priceInterface;
    }

    public void setPriceInterface(ProductPriceInterface priceInterface) {
        this.priceInterface = priceInterface;
    }

    public DocumentInterface getDocumentInterface() {
        return this.documentInterface;
    }

    public void setDocumentInterface(DocumentInterface documentInterface) {
        this.documentInterface = documentInterface;
    }

    private ContaLogic() {
        this.config = Config.getInstance();
        this.stockLogic = StockLogic.getInstance();
        if (LicenseManager.getInstance().isFunctionLicensed("CHECK_STOCK_IN_DEPOSIT_SYSTEM_WIDE")) {
            this.checkStockInterface = new CheckStockInDepositInterface(){

                @Override
                public boolean isStockInDeposit(int idStock, int idMagazie) {
                    Vector<StockViewEntry> existente = ContaLogic.this.stockLogic.getStocksViewsForMagazie(idMagazie, idStock, -1, -1, false, -1, -1);
                    return existente.size() != 0;
                }
            };
        }
    }

    private synchronized RegCasaDao getRegCasaDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        RegCasaDao dao = null;
        while (dao == null) {
            dao = (RegCasaDao)this.pool.getDao(RegCasaDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(RegCasaDao.class.getName(), connection);
        }
        return dao;
    }

    private synchronized CommonsDao getCommonsDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        CommonsDao dao = null;
        while (dao == null) {
            dao = (CommonsDao)this.pool.getDao(CommonsDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(CommonsDao.class.getName(), connection);
        }
        return dao;
    }

    private synchronized FacturaEntriesDao getFacturaEntriesDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        FacturaEntriesDao dao = null;
        while (dao == null) {
            dao = (FacturaEntriesDao)this.pool.getDao(FacturaEntriesDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(FacturaEntriesDao.class.getName(), connection);
        }
        return dao;
    }

    private synchronized FacturiDao getFacturiDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        FacturiDao dao = null;
        while (dao == null) {
            dao = (FacturiDao)this.pool.getDao(FacturiDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(FacturiDao.class.getName(), connection);
        }
        return dao;
    }

    private synchronized NiruriDao getNiruriDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        NiruriDao dao = null;
        while (dao == null) {
            dao = (NiruriDao)this.pool.getDao(NiruriDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(NiruriDao.class.getName(), connection);
        }
        return dao;
    }

    private synchronized NirEntriesDao getNirEntriesDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        NirEntriesDao dao = null;
        while (dao == null) {
            dao = (NirEntriesDao)this.pool.getDao(NirEntriesDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(NirEntriesDao.class.getName(), connection);
        }
        return dao;
    }

    public void init() {
    }

    public void setLanguageProvider(LanguageProvider languageProvider) {
        this.languageProvider = languageProvider;
    }

    public static synchronized ContaLogic getInstance() {
        if (instance == null) {
            instance = new ContaLogic();
        }
        return instance;
    }

    public UnitsProvider getUnitsProvider() {
        return this.unitsProvider;
    }

    public void setUnitsProvider(UnitsProvider unitsProvider) {
        this.unitsProvider = unitsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllTipRegistru(int idLanguage) {
        try {
            Vector vector = this.getRegCasaDao().getAllTipRegistru(idLanguage);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private int addNirNoCommit(int idFactura, int numarNir) throws SQLException {
        this.getNiruriDao().add(idFactura, numarNir);
        return this.pool.requestConnection().getIndentityLocal();
    }

    private int addNirEntryNoCommit(int idNir, int idFacturaEntry, double adaos, double ppu, double pputva, int idMagazie) throws SQLException {
        NirEntry ne = new NirEntry(-1, idNir, idFacturaEntry, adaos, ppu, pputva, idMagazie);
        this.getNirEntriesDao().add(ne);
        int id = this.pool.requestConnection().getIndentityLocal();
        return id;
    }

    private void updateNirNoCommit(Nir toUpdate) throws SQLException {
        this.getNiruriDao().update(toUpdate.getId(), toUpdate.getNumarNir(), toUpdate.getStatus(), toUpdate.getTotal(), toUpdate.getTotalTva(), toUpdate.getTotalGeneral());
    }

    public Nir getNirByIdNoCommit(int id) throws SQLException {
        Nir result = this.getNiruriDao().getById(id);
        return result;
    }

    public Nir getNirByNrNirNoCommit(int nr) throws SQLException {
        Nir result = this.getNiruriDao().getByNrNir(nr);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nir getNirById(int id) {
        try {
            Nir result;
            Nir nir = result = this.getNirByIdNoCommit(id);
            return nir;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Nir nir = null;
            return nir;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private int addFacturaNoCommit(int idFurnizor, String seria, Timestamp dateadd, String auto, boolean transferBased, int idTipCheltuiala, boolean fiscal, int idSocietateaNoastra, int tipFactura, Timestamp scadenta) throws SQLException {
        this.getFacturiDao().add(idFurnizor, seria, dateadd, auto, transferBased, idTipCheltuiala, idSocietateaNoastra, tipFactura, scadenta);
        int result = this.pool.requestConnection().getIndentityLocal();
        return result;
    }

    private int addFacturaEntryNoCommit(int idFactura, int idUnit, String unit, int idProduct, String product, double cantitate, double ppuc, int idTva, int idLot) throws SQLException {
        FacturaEntry fe = new FacturaEntry(-1, idFactura, idUnit, unit, idProduct, product, cantitate, ppuc, idTva, idLot);
        this.getFacturaEntriesDao().add(fe);
        int id = this.pool.requestConnection().getIndentityLocal();
        return id;
    }

    public int getNextNrNirNoCommit(int idSocietateaNoastra, boolean increment, int forcedNumber) throws SQLException {
        String suffix = "";
        if (idSocietateaNoastra > 0) {
            suffix = "_" + idSocietateaNoastra;
        }
        int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(RestLogic.RegistreInterne.NIR.key + suffix, RestLogic.RegistreInterne.NIR.nume + suffix, increment, forcedNumber);
        return nrDoc;
    }

    public int getNextNrNir(int idSocietateaNoastra, boolean increment) {
        return this.getNextNrNir(idSocietateaNoastra, increment, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextNrNir(int idSocietateaNoastra, boolean increment, int forcedNumber) {
        try {
            int n = this.getNextNrNirNoCommit(idSocietateaNoastra, increment, forcedNumber);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = 0;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddNir(Timestamp time) {
        try {
            boolean result;
            boolean bl = result = this.documentInterface.canAddDocument(time);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void addToFisaStocNoCommit(Vector addedQuantities) throws SQLException {
        for (int i = 0; i < addedQuantities.size(); ++i) {
            SimpleStockDiff o = (SimpleStockDiff)addedQuantities.elementAt(i);
            SimpleStockLogic.getInstance().addIntrarePartialaNoCommit(o.getIdStock(), o.getIdMagazie(), o.getQuantity());
        }
    }

    public boolean updateNirExternal(Nir nir, Factura factura, Vector nirEntriesFull, int tipFactura, StockLogic.COMANDA_TYPE comandaType) {
        return this.updateNir(factura.getSerieFactura(), factura.getAuto(), factura.getDateadd(), factura.getIdFurnizor(), nir.getNumarNir(), nirEntriesFull, factura, nir, null, new Vector(), true, nir.getTotal(), nir.getTotalTva(), nir.getTotalGeneral(), factura.getTotal(), factura.getTotalTva(), factura.getTotalGeneral(), 0.0, 0.0, tipFactura, comandaType, new Vector<Integer>(), factura.getDateadd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNir(String serieFactura, String auto, Timestamp data, int idFurnizor, int numarNir, Collection nirFullEntries, Factura factura, Nir nir, Component panel, Vector diffQuantities, boolean fiscal, double total, double totaltva, double totalgeneral, double valoareFactura, double tvaFactura, double totalFactura, double diffValoare, double diffTva, int tipFactura, StockLogic.COMANDA_TYPE comandaType, Vector<Integer> idLoturiToRemove, Timestamp scadenta) {
        boolean result = false;
        try {
            if (!this.documentInterface.canModifyDocument(2, factura.getId())) {
                if (panel != null) {
                    DialogUtils.errorDialog(panel, "Nu puteti modifica aceasta factura", LangRoAll.nuPotContinua);
                }
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                boolean bl = false;
                return bl;
            }
            this.cleanupNirFacturaNoCommit(factura.getId(), nir.getId(), false);
            Timestamp t1 = factura.getDateadd();
            Timestamp t2 = data;
            Timestamp newData = factura.getDateadd();
            if (!DateUtils.sameMinute(t1, t2)) {
                newData = this.documentInterface.getTimeDocument(2, data);
            }
            Logger.logDebugVerbose(this, "Modificare NIR : data veche = '" + Formatters.FULL_TIMESTAMP.format(factura.getDateadd()) + "' data noua = '" + Formatters.FULL_TIMESTAMP.format(newData));
            this.documentInterface.documentDeleted(factura.getDateadd());
            this.documentInterface.documentDeleted(newData);
            factura.setIdFurnizor(idFurnizor);
            factura.setSerieFactura(serieFactura);
            factura.setDateadd(newData);
            factura.setAuto(auto);
            factura.setTipFactura(tipFactura);
            factura.setDataScadenta(scadenta);
            this.getFacturiDao().update(factura);
            int idNir = nir.getId();
            nir.setNumarNir(numarNir);
            this.updateNirNoCommit(nir);
            if (this.config.getBoolean("nirIncarcaFisaStoc")) {
                this.addToFisaStocNoCommit(diffQuantities);
            }
            this.addNirEntriesNoCommit(nirFullEntries, factura.getId(), idNir, idFurnizor, newData);
            this.documentInterface.facturaUpdated(factura.getId(), newData, "Factura " + serieFactura + " ; Nir " + numarNir, fiscal, comandaType);
            this.closeNirNoCommit(idNir, total, totaltva, totalgeneral, valoareFactura, tvaFactura, totalFactura);
            this.getNiruriDao().updateNirDiff(idNir, diffValoare, diffTva);
            this.stockLogic.deleteLotsByIds(idLoturiToRemove);
            this.pool.commit();
            if (panel != null) {
                DialogUtils.okDialog(panel, "Operatie efectuata", LangRoAll.succes);
            }
            result = true;
            GenericListenersLogic.getInstance().notifyListeners(14);
            GenericListenersLogic.getInstance().notifyListeners(16);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reprocessFisaStocForNir(FacturiEntry nv) {
        if (this.config.getBoolean("nirIncarcaFisaStoc")) {
            try {
                int idFactura = nv.getIdFactura();
                Nir nir = this.getNiruriDao().getByFacturaId(idFactura);
                Vector<NirEntryFull> newData = this.getDataForNir(nir.getId());
                Vector<SimpleStockDiff> stockDiffQuantities = new Vector<SimpleStockDiff>();
                for (int i = 0; i < newData.size(); ++i) {
                    NirEntryFull nirEntryFull = newData.elementAt(i);
                    SimpleStockDiff addedDiff = new SimpleStockDiff();
                    addedDiff.setIdMagazie(nirEntryFull.getIdMagazie());
                    addedDiff.setIdStock(nirEntryFull.getIngredientId());
                    addedDiff.setQuantity(nirEntryFull.getCant());
                    stockDiffQuantities.add(addedDiff);
                }
                this.addToFisaStocNoCommit(stockDiffQuantities);
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        }
    }

    public int addNirNoCommit(String serieFactura, String auto, Timestamp data, int idFurnizor, int numarNir, Collection nirFullEntries, boolean transferBased, Vector addedQuantities, boolean fiscal, int idSocietateaNoastra, int tipFactura, StockLogic.COMANDA_TYPE comandaType, Timestamp scadenta) throws SQLException {
        int idFactura = -1;
        Timestamp newData = this.documentInterface.getTimeDocument(2, data);
        idFactura = this.addFacturaNoCommit(idFurnizor, serieFactura, newData, auto, transferBased, -1, fiscal, idSocietateaNoastra, tipFactura, scadenta);
        int idNir = this.addNirNoCommit(idFactura, numarNir);
        if (this.config.getBoolean("nirIncarcaFisaStoc")) {
            this.addToFisaStocNoCommit(addedQuantities);
        }
        this.addNirEntriesNoCommit(nirFullEntries, idFactura, idNir, idFurnizor, data);
        int idDoc = this.documentInterface.facturaAdded(idFactura, newData, "Factura " + serieFactura + " ; Nir " + numarNir, fiscal, comandaType);
        return idNir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNir(String serieFactura, String auto, Timestamp data, int idFurnizor, int numarNir, Collection nirFullEntries, boolean transferBased, Vector addedQuantities, boolean fiscal, double total, double totaltva, double totalgeneral, double valoareFactura, double tvaFactura, double totalFactura, double diffValoare, double diffTva, int idSocietateaNoastra, int tipFactura, StockLogic.COMANDA_TYPE comandaType, Timestamp scadenta) {
        int idNir = -1;
        try {
            idNir = this.addNirNoCommit(serieFactura, auto, data, idFurnizor, numarNir, nirFullEntries, transferBased, addedQuantities, fiscal, idSocietateaNoastra, tipFactura, comandaType, scadenta);
            this.closeNirNoCommit(idNir, total, totaltva, totalgeneral, valoareFactura, tvaFactura, totalFactura);
            this.getNiruriDao().updateNirDiff(idNir, diffValoare, diffTva);
            this.pool.commit();
            GenericListenersLogic.getInstance().notifyListeners(16);
            GenericListenersLogic.getInstance().notifyListeners(14);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            idNir = -1;
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return idNir;
    }

    private String cleanupNirFacturaNoCommit(int idFactura, int idNir, boolean deleteAllLots) throws SQLException {
        boolean allDeletedOk;
        String errors = "";
        if (deleteAllLots && !(allDeletedOk = this.stockLogic.deleteLotsForFactura(idFactura))) {
            errors = "Nu am sters toate loturile asociate , pentru ca sunt folosite. Consultati Raport loturi !";
        }
        this.getNirEntriesDao().deleteByNirId(idNir);
        this.getFacturaEntriesDao().deleteByFacturaId(idFactura);
        return errors;
    }

    private void addNirEntriesNoCommit(Collection nirFullEntries, int idFactura, int idNir, int idFurnizor, Date dataFacturii) throws SQLException {
        for (NirEntryFull element : nirFullEntries) {
            Lot lot;
            int idLotNou = element.getIdLot();
            if (idLotNou <= 0) {
                lot = element.getLot();
                if (lot != null && Validators.correctString(lot.getNr()) && lot.getExpirare() != null) {
                    idLotNou = this.stockLogic.addLotNoCommit(idFurnizor, lot.getNr(), lot.getExpirare(), dataFacturii, element.getIngredientId());
                    element.setIdLot(idLotNou);
                }
            } else {
                lot = element.getLot();
                if (lot != null && Validators.correctString(lot.getNr()) && lot.getExpirare() != null) {
                    Lot existingLot = this.stockLogic.getLotByIdNoCommit(idLotNou);
                    if (existingLot != null) {
                        existingLot.setIdFurnizor(idFurnizor);
                        existingLot.setNr(lot.getNr());
                        existingLot.setExpirare(lot.getExpirare());
                        existingLot.setIdStock(element.getIngredientId());
                        existingLot.setReceptie(dataFacturii);
                        this.stockLogic.updateLotNoCommit(existingLot);
                    } else {
                        idLotNou = this.stockLogic.addLotNoCommit(idFurnizor, lot.getNr(), lot.getExpirare(), dataFacturii, element.getIngredientId());
                        element.setIdLot(idLotNou);
                    }
                }
            }
            int idFacturaEntry = this.addFacturaEntryNoCommit(idFactura, element.getIdUnit(), element.getUm(), element.getIngredientId(), element.getDenumireProdus(), element.getCant(), element.getPpuc(), element.getIdTva(), idLotNou);
            this.addNirEntryNoCommit(idNir, idFacturaEntry, element.getAdaosProcentOriginal(), element.getPpuvOriginal(), element.getPpuvtvaOriginal(), element.getIdMagazie());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<NirEntryFull> getDataForNir(int idNir) {
        Vector<NirEntryFull> result = new Vector();
        try {
            result = this.getDataForNirNoCommit(idNir);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<NirEntryFull> getDataForNirNoCommit(int idNir) throws SQLException {
        Vector<NirEntryFull> result = new Vector<NirEntryFull>();
        int i = 1;
        Vector<NirEntryFull> nirItems = this.getCommonsDao().getByNirId(idNir, this.languageProvider.getCurrentUserLanguage());
        for (NirEntryFull element : nirItems) {
            element.setNrCrt(i);
            element.compute();
            result.add(element);
            ++i;
        }
        return result;
    }

    public void closeNirNoCommit(int idNir, double total, double totaltva, double totalgeneral, double valoareFactura, double tvaFactura, double totalFactura) throws SQLException {
        int idFactura = this.getNiruriDao().getFacturaIdNoCommit(idNir);
        Factura f = this.getFacturiDao().getByIdNoCommit(idFactura);
        f.setTotal(valoareFactura);
        f.setTotalTva(tvaFactura);
        f.setTotalGeneral(totalFactura);
        this.getFacturiDao().update(f);
        Nir toClose = this.getNirByIdNoCommit(idNir);
        toClose.setStatus(1);
        toClose.setTotal(total);
        toClose.setTotalTva(totaltva);
        toClose.setTotalGeneral(totalgeneral);
        this.updateNirNoCommit(toClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNir(int idNir, double total, double totaltva, double totalgeneral, double valoareFactura, double tvaFactura, double totalFactura) {
        if (idNir != -1) {
            try {
                this.closeNirNoCommit(idNir, total, totaltva, totalgeneral, valoareFactura, tvaFactura, totalFactura);
                this.pool.requestConnection().commitTransaction();
                GenericListenersLogic.getInstance().notifyListeners(16);
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        }
    }

    public String pdfNir(int idFactura, String societate) {
        String path = null;
        try {
            Nir r = this.getNiruriDao().getByFacturaId(idFactura);
            Vector<NirEntryFull> entries = this.getDataForNir(r.getId());
            String foFile = this.prepareNirPrint(r.getId(), entries, societate);
            path = this.pdfNir(foFile, r.getId());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String excelNirCuFormule(int idFactura) {
        String result = null;
        try {
            String outputFile = FileUtils.buildCurrentDataDir("");
            Nir r = this.getNiruriDao().getByFacturaId(idFactura);
            Vector<NirEntryFull> entries = this.getDataForNir(r.getId());
            Factura f = this.getFacturiDao().getByIdNoCommit(idFactura);
            int idFurnizor = f.getIdFurnizor();
            Client fur = ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
            try {
                outputFile = outputFile + File.separator + "Nir_" + Formatters.DATE_FORMAT.format(f.getDateadd()) + "_" + "_nr_" + r.getNumarNir() + ".xls";
                File f1 = new File(outputFile);
                String data = Formatters.DATE_FORMAT_RO.format(f.getDateadd());
                NirExcelFormulaProcessor nirFP = new NirExcelFormulaProcessor(fur.toString() + "_" + data + "_" + f.getSerieFactura(), Config.getInstance().getString("societate"), f.getSerieFactura(), r.getNumarNir() + "", fur.toString(), data, "", Config.getInstance().getString("comisiaReceptie"));
                ExcelUtils.writeExcel(f1, entries, nirFP, new Hashtable());
                result = outputFile;
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (WriteException e) {
                Logger.logException(this, (Exception)((Object)e));
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excelNir(int idFactura, File path) {
        try {
            Nir r = this.getNiruriDao().getByFacturaId(idFactura);
            Vector<NirEntryFull> entries = this.getDataForNir(r.getId());
            Factura f = this.getFacturiDao().getByIdNoCommit(idFactura);
            int idFurnizor = f.getIdFurnizor();
            Client fur = ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
            try {
                ExcelUtils.writeExcel(path, entries, new NirExcelProcessor(fur.toString() + "_" + f.getDateadd() + "_" + f.getSerieFactura(), EditNirPanel.columns), new Hashtable());
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (WriteException e) {
                Logger.logException(this, (Exception)((Object)e));
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFactura(int idFactura, Component parent) {
        try {
            Nir nir = this.getNiruriDao().getByFacturaId(idFactura);
            if (!this.documentInterface.canModifyDocument(2, nir.getIdFactura())) {
                DialogUtils.errorDialog(parent, "Nu puteti sterge aceasta factura", LangRoAll.nuPotContinua);
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                boolean bl = false;
                return bl;
            }
            Factura f = this.getFacturaById(idFactura);
            UsersLogic.getInstance().addBOUserLogNoCommit("Sters factura " + f.getSerieFactura() + " nir " + nir.getNumarNir() + " din : " + Formatters.DATE_AND_TIME_FORMAT.format(f.getDateadd()) + " total : " + Utils.getString2Decimals(f.getTotalGeneral()));
            if (this.config.getBoolean("nirIncarcaFisaStoc")) {
                Vector<NirEntryFull> nirData = this.getDataForNir(nir.getId());
                Vector<SimpleStockDiff> toEraseFromFisaStoc = new Vector<SimpleStockDiff>();
                for (int i = 0; i < nirData.size(); ++i) {
                    NirEntryFull nirEntryFull = nirData.elementAt(i);
                    SimpleStockDiff ssd = new SimpleStockDiff();
                    ssd.setIdMagazie(nirEntryFull.getIdMagazie());
                    ssd.setIdStock(nirEntryFull.getIngredientId());
                    ssd.setQuantity(-nirEntryFull.getCant());
                    toEraseFromFisaStoc.add(ssd);
                }
                this.addToFisaStocNoCommit(toEraseFromFisaStoc);
            }
            this.cleanupNirFacturaNoCommit(idFactura, nir.getId(), true);
            this.getNiruriDao().delete(nir);
            this.getFacturiDao().delete(idFactura);
            this.documentInterface.documentDeleted(f.getDateadd());
            GenericListenersLogic.getInstance().notifyListeners(14);
            GenericListenersLogic.getInstance().notifyListeners(16);
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public double computeTotalFactura(Collection nirEntries) {
        double result = 0.0;
        for (NirEntryFull element : nirEntries) {
            result += element.getTotalFactura();
        }
        return result;
    }

    public double computeTvaFactura(Collection nirEntries) {
        double result = 0.0;
        for (NirEntryFull element : nirEntries) {
            result += element.getTvaFurnizorTotal();
        }
        return result;
    }

    public double computeValoareFactura(Collection nirEntries) {
        double result = 0.0;
        for (NirEntryFull element : nirEntries) {
            result += element.getValoareCumparare();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareNirPrint(int idNir, Collection nirEntries, String societate) {
        try {
            String foFile;
            int idFactura = this.getNiruriDao().getFacturaIdNoCommit(idNir);
            Factura f = this.getFacturiDao().getByIdNoCommit(idFactura);
            Nir nir = this.getNirByIdNoCommit(idNir);
            int idFurnizor = f.getIdFurnizor();
            Client fur = ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
            this.pool.commit();
            String string = foFile = ContaPrint.makeFoFile(nirEntries, "A", this.config, nir, f, fur, this, societate);
            return string;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String pdfNir(String foFile, int idNir) {
        try {
            Factura result = null;
            Nir nir = null;
            try {
                int idFactura = this.getNiruriDao().getFacturaIdNoCommit(idNir);
                result = this.getFacturiDao().getByIdNoCommit(idFactura);
                nir = this.getNirByIdNoCommit(idNir);
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                String string = null;
                return string;
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            File dir = new File("data");
            dir.mkdirs();
            File destinationFile = new File(FileUtils.buildCurrentDataDir(".") + File.separator + "Nir_" + nir.getNumarNir() + "_" + Formatters.DATE_FORMAT_RO.format(result.getDateadd()) + ".pdf");
            PrintUtils.printPdf(foFile, destinationFile.getAbsolutePath());
            Hashtable<String, Object> toSend = new Hashtable<String, Object>();
            toSend.put("factura", result);
            toSend.put("nir", nir);
            toSend.put("filePath", destinationFile.getAbsolutePath());
            Factura factura = result;
            String furnizor = ClientLogic.getInstance().getClientById(factura.getIdFurnizor()).toString();
            SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
            SimpleDateFormat formatHour = new SimpleDateFormat("hh:mm");
            String data = formatSimple.format(factura.getDateadd());
            double totalGeneral = FloatUtils.roundDouble(factura.getTotalGeneral(), VpConfig.getInstance().facturareRoundDecimals);
            String nodeTitle = "Factura Marfa " + furnizor + " " + totalGeneral;
            String nodeDescription = "";
            nodeDescription = nodeDescription + "Furnizor : " + furnizor + "<br/>";
            nodeDescription = nodeDescription + "Data : " + data + "<br/>";
            nodeDescription = nodeDescription + "Total : " + totalGeneral + "<br/>";
            nodeDescription = nodeDescription + "Numar Nir : " + nir.getNumarNir() + "<br/>";
            toSend.put("node_title", nodeTitle);
            toSend.put("node_description", nodeDescription);
            Vector<String> nodeFiles = new Vector<String>();
            nodeFiles.add(destinationFile.getAbsolutePath());
            toSend.put("node_files", nodeFiles);
            GenericListenersLogic.getInstance().notifyObjectListeners(66, toSend);
            return destinationFile.getAbsolutePath();
        }
        catch (FileNotFoundException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reproceseazaFactura(int idFactura, Timestamp timeDocument, String document, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) {
        boolean result = false;
        try {
            result = this.reproceseazaFacturaNoCommit(idFactura, timeDocument, document, fiscal, comandaType);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    public boolean reproceseazaFacturaNoCommit(int idFactura, Timestamp timeDocument, String document, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        boolean result = false;
        Nir r = this.getNirByFacturaIdNoCommit(idFactura);
        if (r != null) {
            result = this.addFacturaToStockNoCommit(r.getIdFactura(), timeDocument, document, fiscal, comandaType);
        }
        return result;
    }

    private boolean addFacturaToStockNoCommit(int idFactura, Timestamp dataFactura, String document, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        Factura f = this.getFacturiDao().getByIdNoCommit(idFactura);
        if (f.isTransferBased()) {
            return true;
        }
        Nir nir = this.getNiruriDao().getByFacturaId(idFactura);
        Vector<NirEntryFull> nirEntries = this.getDataForNirNoCommit(nir.getId());
        boolean result = true;
        for (NirEntryFull e : nirEntries) {
            double quantity = e.getCant();
            double valIntrarePa = e.getPpuc() * quantity;
            double valIntrarePv = e.getPpuvtva() * quantity;
            Stock s = this.stockLogic.getStockById(e.getIngredientId());
            if (!s.isDescarcaStoc()) continue;
            if (this.isGestiuneCMP()) {
                this.computeCMPForStockAfterData(e.getIngredientId(), dataFactura);
            }
            this.stockLogic.addFisaMagazieIntrareNoCommit(e.getIngredientId(), e.getIdMagazie(), 2, document, dataFactura, e.getPpuc(), e.getPpuvtva(), e.getCant(), valIntrarePa, valIntrarePv, e.getDenumireProdus(), e.getCodBare(), fiscal, comandaType, e.getIdLot());
        }
        return result;
    }

    public void computeCMPForStockAfterData(int idStock, Timestamp date) throws SQLException {
        this.stockLogic.deleteStockCMPsForStockAfterData(idStock, date);
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, date);
        result.put(Constants.STOP_KEY, DateUtils.getEndOfDays());
        result.put("id_stock_key", Integer.valueOf(idStock));
        result.put("facturi_furnizor_key", Integer.valueOf(-1));
        Vector entries = this.getRaportIntrariNoCommit(result, 2, false);
        Collections.sort(entries, new Comparator<RaportIntrariEntry>(){

            @Override
            public int compare(RaportIntrariEntry o1, RaportIntrariEntry o2) {
                return o1.getDateadd().compareTo(o2.getDateadd());
            }
        });
        for (RaportIntrariEntry entry : entries) {
            Timestamp d = entry.getDateadd();
            double q = entry.getCantitate();
            double v = entry.getValoareCumparare();
            this.stockLogic.processStockCmpForStock(d, idStock, q, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllFacturi() {
        try {
            Vector<Factura> result;
            Vector<Factura> vector = result = this.getFacturiDao().getAll();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void deleteAllNirs() throws SQLException {
        this.getNirEntriesDao().deleteAll();
        this.getNiruriDao().deleteAll();
        this.getFacturaEntriesDao().deleteAll();
        this.getFacturiDao().deleteAll();
    }

    public void deleteAllNiruri(Timestamp start, Timestamp stop) throws SQLException {
    }

    public String printPdfRegistruCasa(Vector items, String casaName, String data, double incasari, double plati, double soldVechi, double soldNou) {
        try {
            String folder = FileUtils.buildCurrentDataDir(".");
            File destinationFile = new File(folder + File.separator + "RegCasa_" + casaName + "_" + data + ".pdf");
            String socEscaped = TextUtils.escapeForXML(this.config.getString("societate"));
            String foFile = ContaPrint.makeRegCasaFoFile(items, socEscaped, data, casaName, incasari, plati, soldVechi, soldNou);
            PrintUtils.printPdf(foFile, destinationFile.getAbsolutePath());
            return destinationFile.getAbsolutePath();
        }
        catch (UnsupportedOperationException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        return null;
    }

    public Hashtable getDetalierePlataPerProduse(int idFacturaEmisa, double platimAcum, int what) {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        boolean detaliereByDefault = this.config.getBoolean("platiDetalierePerProduseByDefault");
        if (detaliereByDefault) {
            IncasareDetaliataEntry incasareDetaliataEntry;
            int i;
            double restDePlata = 0.0;
            Vector detaliiIncasare = FacturiLogic.getInstance().getDetaliiIncasare(idFacturaEmisa, what);
            for (i = 0; i < detaliiIncasare.size(); ++i) {
                incasareDetaliataEntry = (IncasareDetaliataEntry)detaliiIncasare.elementAt(i);
                restDePlata += incasareDetaliataEntry.getRest();
            }
            for (i = 0; i < detaliiIncasare.size(); ++i) {
                incasareDetaliataEntry = (IncasareDetaliataEntry)detaliiIncasare.elementAt(i);
                double incasamAcum = incasareDetaliataEntry.getRest() * platimAcum / restDePlata;
                result.put(incasareDetaliataEntry.getIdEntry(), incasamAcum);
            }
        }
        return result;
    }

    public void addIncasare(double total, String nrAct, String anexa, String explicatii, int tipRegistru, Date data, Vector facturiEmise, boolean fiscal, int idTva) {
        this.addRegCasaEntry(nrAct, anexa, explicatii, total, 0.0, tipRegistru, data, facturiEmise, new Vector(), fiscal, idTva);
    }

    public Map buildIncasareClientMap(String nrAct, String explicatii, String data, String total, String client, String chitantaPath) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("actCasa", nrAct);
        result.put("Explicatii", explicatii);
        result.put("Data", data);
        result.put("Total", total);
        result.put("Client", client);
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String nodeTitle = result.get("Client") + " " + result.get("actCasa") + " " + result.get("Total");
        String nodeDescription = "";
        for (Object o : result.keySet()) {
            String s = (String)o;
            Object o1 = result.get(s);
            if (o1 instanceof String) {
                String valoare = (String)o1;
                nodeDescription = nodeDescription + s + " : " + valoare + "<br/>";
                continue;
            }
            if (o1 instanceof Date) {
                String date = formatSimple.format((Date)o1);
                nodeDescription = nodeDescription + s + " : " + date + "<br/>";
                continue;
            }
            if (!(o1 instanceof Double)) continue;
            Double d = FloatUtils.roundDouble((Double)o1, VpConfig.getInstance().facturareRoundDecimals);
            nodeDescription = nodeDescription + s + " : " + String.valueOf(d) + "<br/>";
        }
        if (chitantaPath != "") {
            result.put("chitantaPath", chitantaPath);
            Vector<String> nodeFiles = new Vector<String>();
            nodeFiles.add(chitantaPath);
            result.put("node_files", nodeFiles);
        }
        result.put("node_title", nodeTitle);
        result.put("node_description", nodeDescription);
        return result;
    }

    public Map builIncasareFortataMap(String nrAct, String explicatii, String data, String total, String anexa) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("actCasa", nrAct);
        result.put("Explicatii", explicatii);
        result.put("Data", data);
        result.put("Total", total);
        result.put("Anexa", anexa);
        Double totalD = FloatUtils.roundDouble(new Double(total), VpConfig.getInstance().facturareRoundDecimals);
        String nodeTitle = "Incasare " + nrAct + " " + anexa + " " + total;
        String nodeDescription = "";
        nodeDescription = nodeDescription + "actCasa : " + nrAct + "<br/>";
        nodeDescription = nodeDescription + "Anexa : " + anexa + "<br/>";
        nodeDescription = nodeDescription + "Explicatii : " + explicatii + "<br/>";
        nodeDescription = nodeDescription + "Data : " + data + "<br/>";
        nodeDescription = nodeDescription + "Total : " + total + "<br/>";
        result.put("node_title", nodeTitle);
        result.put("node_description", nodeDescription);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegCasaEntry(RegistruCasaEntry toRemove) {
        try {
            this.getRegCasaDao().deleteRegCasaEntry(toRemove.getId());
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegCasaEntry(String act, String anexa, String expl, double incasare, double plata, int idCont, Date data, Vector facturiEmise, Vector facturiPrimite, boolean fiscal, int idTva) {
        try {
            this.getRegCasaDao().addEntry(idCont, act, anexa, expl, incasare, plata, data, fiscal ? 1 : 0, idTva);
            int idEntry = this.pool.getIdentityLocal();
            if (plata != 0.0) {
                for (int i = 0; i < facturiPrimite.size(); ++i) {
                    PlatiEntry o = (PlatiEntry)facturiPrimite.elementAt(i);
                    this.getRegCasaDao().addFisaPlata(idEntry, o.getIdFactura(), -1, o.getSuma());
                }
            } else if (incasare != 0.0) {
                for (int i = 0; i < facturiEmise.size(); ++i) {
                    PlatiEntry o = (PlatiEntry)facturiEmise.elementAt(i);
                    this.getRegCasaDao().addFisaPlata(idEntry, -1, o.getIdFactura(), o.getSuma());
                    int idFisaPlata = this.pool.getIdentityLocal();
                    Hashtable h = o.getDetaliereIncasari();
                    for (Object o1 : h.keySet()) {
                        int idFacturaEmisaEntry = (Integer)o1;
                        double h1 = (Double)h.get(idFacturaEmisaEntry);
                        this.getRegCasaDao().addDetaliereIncasare(idFisaPlata, idFacturaEmisaEntry, h1);
                    }
                }
            }
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addPlata(String actCasa, String anexa, String explain, double total, int tipRegistru, Date data, Vector facturiPrimite, boolean fiscal, int idTva) {
        this.addRegCasaEntry(actCasa, anexa, explain, 0.0, total, tipRegistru, data, new Vector(), facturiPrimite, fiscal, idTva);
    }

    public Map buildMapForPlata(String actCasa, String expl, Date data, double total, String anexa, String cont) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("actCasa", actCasa);
        result.put("Nume", expl);
        result.put("Data", data);
        result.put("Total", total);
        result.put("Anexa", anexa);
        result.put("Cont", cont);
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String nodeTitle = "Plata " + expl + " " + actCasa + " " + total;
        String nodeDescription = "";
        for (Object o : result.keySet()) {
            String s = (String)o;
            Object o1 = result.get(s);
            if (o1 instanceof String) {
                String valoare = (String)o1;
                nodeDescription = nodeDescription + s + " : " + valoare + "<br/>";
                continue;
            }
            if (o1 instanceof Date) {
                String date = formatSimple.format((Date)o1);
                nodeDescription = nodeDescription + s + " : " + date + "<br/>";
                continue;
            }
            if (!(o1 instanceof Double)) continue;
            Double d = FloatUtils.roundDouble((Double)o1, VpConfig.getInstance().facturareRoundDecimals);
            nodeDescription = nodeDescription + s + " : " + String.valueOf(d) + "<br/>";
        }
        result.put("node_title", nodeTitle);
        result.put("node_description", nodeDescription);
        return result;
    }

    public Map buildMapForPlataFortat(String actCasa, String expl, Date data, double total, String anexa) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("actCasa", actCasa);
        result.put("Nume", expl);
        result.put("Data", data);
        result.put("Total", total);
        result.put("Anexa", anexa);
        return result;
    }

    public Vector<RegistruCasaEntry> getRegistruCasa(Date start, Date stop, int idCont, int what) {
        int ficus = -1;
        switch (what) {
            case 2: {
                ficus = 1;
                break;
            }
            case 3: {
                ficus = 0;
            }
        }
        Vector<RegistruCasaEntry> result = new Vector<RegistruCasaEntry>();
        try {
            double sold = this.getRegCasaDao().getSoldLaData(start, idCont, ficus);
            RegistruCasaEntry re = new RegistruCasaEntry("", "", "Sold start", sold, 0.0, start, false, false, -1, "");
            re.setSold(sold);
            result.add(re);
            Vector tranzactii = this.getRegCasaDao().getTranzactii(start, stop, idCont, ficus);
            for (int i = 0; i < tranzactii.size(); ++i) {
                RegistruCasaEntry o = (RegistruCasaEntry)tranzactii.elementAt(i);
                o.setSold(sold += o.getIncasari() - o.getPlati());
                result.add(o);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }

    private String preparePrintRegistruCasa(Vector items, String contName, String data, double incasari, double plati, double soldVechi, double soldNou) throws IOException {
        String socEscaped = TextUtils.escapeForXML(this.config.getString("societate"));
        String foFile = ContaPrint.makeRegCasaFoFile(items, socEscaped, data, contName, incasari, plati, soldVechi, soldNou);
        return foFile;
    }

    public void printRegistruCasa(Vector items, String contName, String data, double incasari, double plati, double soldVechi, double soldNou) {
        try {
            String foFile = this.preparePrintRegistruCasa(items, contName, data, incasari, plati, soldVechi, soldNou);
            PrintLogic.getInstance().printPdf(foFile, 1);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void previewRegistruCasa(Vector items, String contName, String data, double incasari, double plati, double soldVechi, double soldNou) {
        try {
            String foFile = this.preparePrintRegistruCasa(items, contName, data, incasari, plati, soldVechi, soldNou);
            PrintLogic.getInstance().printPreview(foFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public double getTotalAmanunt(Collection data) {
        double result = 0.0;
        for (NirEntryFull element : data) {
            result += element.getValoareaLaPretAmanuntFaraTva();
        }
        return result;
    }

    public double getTotalAmanuntTva(Collection data) {
        double result = 0.0;
        for (NirEntryFull element : data) {
            result += element.getTvaTotalAmanunt();
        }
        return result;
    }

    public double getTotalAdaos(Collection data) {
        double result = 0.0;
        for (NirEntryFull element : data) {
            result += element.getTotalAdaos();
        }
        return result;
    }

    public double getTotalAmanuntGeneral(Collection data) {
        double result = 0.0;
        for (NirEntryFull element : data) {
            result += element.getValoareaLaPretAmanuntCuTva();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIntrariFurnizori(Hashtable criteria, int whatToPrint) {
        try {
            String grupare;
            Tva tvaFilter;
            boolean groupByTva;
            Date s1 = (Date)criteria.get(Constants.START_KEY);
            Date s2 = (Date)criteria.get(Constants.STOP_KEY);
            Timestamp t1 = new Timestamp(s1.getTime());
            Timestamp t2 = new Timestamp(s2.getTime());
            Integer idMagazie = (Integer)criteria.get("id_magazie");
            Integer tipProdus = (Integer)criteria.get("finit_ingredient");
            String idsStocks = this.stockLogic.getStockSqlInSequenceForBalanta(tipProdus, true, this.pool.requestConnection().getConnection(), (Tag)criteria.get(""));
            int idSocietateaNoastra = -1;
            Object societateObj = criteria.get("Societate");
            if (societateObj != null) {
                ClientPersJuridica societatea = (ClientPersJuridica)societateObj;
                idSocietateaNoastra = societatea.getIdPersJuridica();
            }
            int comandaType = -1;
            StockLogic.COMANDA_TYPE comandaType1 = (StockLogic.COMANDA_TYPE)((Object)criteria.get("Comanda Type"));
            if (comandaType1 != null) {
                comandaType = comandaType1.getIdTip();
            }
            boolean bl = groupByTva = (tvaFilter = (Tva)criteria.get(LangRoAll.tva)) != null;
            if (!groupByTva && (grupare = (String)criteria.get(Constants.GRUPARE_KEY)) != null && grupare.equalsIgnoreCase("Dupa TVA")) {
                groupByTva = true;
            }
            Vector<IntrariFurnizoriEntry> result = this.getFacturiDao().getIntrariFurnizori(idMagazie, t1, t2, whatToPrint, idSocietateaNoastra, idsStocks, this.pool.requestConnection().getConnection(), comandaType, tvaFilter, groupByTva);
            for (int i = 0; i < result.size(); ++i) {
                IntrariFurnizoriEntry intrariFurnizoriEntry = result.elementAt(i);
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(intrariFurnizoriEntry.getIdFurnizor());
                intrariFurnizoriEntry.setFurnizor(c.toString());
                ClientPersJuridica cpj = (ClientPersJuridica)c;
                intrariFurnizoriEntry.setCui(cpj.getCui());
            }
            Vector<IntrariFurnizoriEntry> vector = result;
            return vector;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<FacturiEntry> getFacturi(Hashtable criteria, int whatToPrint) {
        Vector<FacturiEntry> result = new Vector();
        try {
            result = this.getFacturiNoCommit(criteria, whatToPrint);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<FacturiEntry> getFacturiNoCommit(Hashtable criteria, int whatToPrint) throws SQLException {
        Vector<Object> result = new Vector();
        Object furnizorObj = criteria.get("facturi_furnizor_key");
        int furnizor = -1;
        if (furnizorObj != null) {
            furnizor = (Integer)furnizorObj;
        }
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        Timestamp t1 = new Timestamp(s1.getTime());
        Timestamp t2 = new Timestamp(s2.getTime());
        int idSocietateaNoastra = -1;
        Object societateObj = criteria.get("Societate");
        if (societateObj != null) {
            ClientPersJuridica societatea = (ClientPersJuridica)societateObj;
            idSocietateaNoastra = societatea.getIdPersJuridica();
        }
        int tipFactura = -1;
        TIP_DOCUMENT_NIR tip_document_nir = (TIP_DOCUMENT_NIR)((Object)criteria.get("Tip Factura"));
        if (tip_document_nir != null) {
            tipFactura = tip_document_nir.getTip();
        }
        int comandaType = -1;
        StockLogic.COMANDA_TYPE comandaType1 = (StockLogic.COMANDA_TYPE)((Object)criteria.get("Comanda Type"));
        if (comandaType1 != null) {
            comandaType = comandaType1.getIdTip();
        }
        result = this.getFacturiDao().getFacturi(furnizor, t1, t2, whatToPrint, idSocietateaNoastra, tipFactura, comandaType);
        for (int i = 0; i < result.size(); ++i) {
            FacturiEntry intrariFurnizoriEntry = (FacturiEntry)result.elementAt(i);
            int idFurnizor = intrariFurnizoriEntry.getIdFurnizor();
            Client c = ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
            if (idFurnizor <= 0 || c == null) continue;
            intrariFurnizoriEntry.setFurnizor(c.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFacturiNeplatite(int idFurnizor, int whatToPrint) {
        Vector result = new Vector();
        try {
            result = this.getFacturiDao().getFacturiNeplatitePtFurnizor(idFurnizor, whatToPrint);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector getRaportIntrariNoCommit(Hashtable criteria, int whatToPrint, boolean setFurnizor) throws SQLException {
        Vector<Object> result = new Vector();
        int idStock = (Integer)criteria.get("id_stock_key");
        int idFurnizor = (Integer)criteria.get("facturi_furnizor_key");
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        Timestamp t1 = new Timestamp(s1.getTime());
        Timestamp t2 = new Timestamp(s2.getTime());
        int idSocietateaNoastra = -1;
        Object societateObj = criteria.get("Societate");
        if (societateObj != null) {
            ClientPersJuridica societatea = (ClientPersJuridica)societateObj;
            idSocietateaNoastra = societatea.getIdPersJuridica();
        }
        int comandaType = -1;
        StockLogic.COMANDA_TYPE comandaType1 = (StockLogic.COMANDA_TYPE)((Object)criteria.get("Comanda Type"));
        if (comandaType1 != null) {
            comandaType = comandaType1.getIdTip();
        }
        int idTag = -1;
        Tag tag = (Tag)criteria.get("");
        if (tag != null) {
            idTag = tag.getId();
        }
        int idMagazie = -1;
        Integer idMag = (Integer)criteria.get("id_magazie");
        if (idMag != null) {
            idMagazie = idMag;
        }
        result = this.getCommonsDao().getRaportIntrari(idStock, idFurnizor, t1, t2, whatToPrint, idSocietateaNoastra, comandaType, idTag, idMagazie);
        if (setFurnizor) {
            for (int i = 0; i < result.size(); ++i) {
                RaportIntrariEntry intrariFurnizoriEntry = (RaportIntrariEntry)result.elementAt(i);
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(intrariFurnizoriEntry.getIdFurnizor());
                intrariFurnizoriEntry.setFurnizor(c.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRaportIntrari(Hashtable criteria, int whatToPrint) {
        try {
            Vector vector = this.getRaportIntrariNoCommit(criteria, whatToPrint, true);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Factura getFacturaByIdNoCommit(int idFactura) throws SQLException {
        Factura result = this.getFacturiDao().getByIdNoCommit(idFactura);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factura getFacturaById(int idFactura) {
        try {
            Factura result;
            Factura factura = result = this.getFacturaByIdNoCommit(idFactura);
            return factura;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Factura factura = null;
            return factura;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nir getNirByFacturaId(int idFactura) {
        try {
            Nir nir = this.getNirByFacturaIdNoCommit(idFactura);
            return nir;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Nir nir = null;
            return nir;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Nir getNirByFacturaIdNoCommit(int idFactura) throws SQLException {
        return this.getNiruriDao().getByFacturaId(idFactura);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ExportNirPlatforma> getExportNirPlatforma(Timestamp start, Timestamp stop) {
        Vector<Object> result = new Vector();
        try {
            result = this.getCommonsDao().getExportNirPlatforma(start, stop);
            for (int i = 0; i < result.size(); ++i) {
                ExportNirPlatforma intrariFurnizoriEntry = (ExportNirPlatforma)result.elementAt(i);
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(intrariFurnizoriEntry.getIdFurnizor());
                ClientPersJuridica cpj = (ClientPersJuridica)c;
                intrariFurnizoriEntry.setFurnizor(c.toString());
                intrariFurnizoriEntry.setCui(cpj.getCodFurnizor());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reprintNir(Component parent, int idFactura, String societate) {
        try {
            Nir r = this.getNiruriDao().getByFacturaId(idFactura);
            Vector<NirEntryFull> entries = this.getDataForNir(r.getId());
            this.reprintNir(parent, r.getId(), entries, societate);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void reprintNir(Component parent, int idNir, Vector items, String societate) {
        String foFile = this.prepareNirPrint(idNir, items, societate);
        if (foFile != null) {
            int printNir = Config.getInstance().getInt("printNir");
            if (printNir > 0) {
                int nrExemplare = Config.getInstance().getInt("niruriNrExemplare");
                if (printNir == 1) {
                    PrintLogic.getInstance().printPdf(foFile, nrExemplare);
                } else if (DialogUtils.confirmDialog(parent, "Tiparim nir", LangRoAll.confirmare)) {
                    PrintLogic.getInstance().printPdf(foFile, nrExemplare);
                }
            }
            String destination = this.pdfNir(foFile, idNir);
            DialogUtils.okDialog(parent, "Nirul a fost salvat pe disc la " + destination, "Nir salvat");
        } else {
            DialogUtils.errorDialog(parent, "Erori la salvare nir", "Nir nesalvat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printEticheteReceptieLot(Vector<NirEntryFull> items, int nrCopii) {
        try {
            for (NirEntryFull item : items) {
                int idLot = item.getIdLot();
                if (idLot <= 0) continue;
                Lot lot = this.stockLogic.getLotByIdNoCommit(idLot);
                item.setLot(lot);
                if (lot == null) continue;
                Hashtable<Constants.ETICHETA_LOT_FIELDS, String> map = new Hashtable<Constants.ETICHETA_LOT_FIELDS, String>();
                map.put(Constants.ETICHETA_LOT_FIELDS.PRODUS_NAME, item.getDenumireProdus());
                map.put(Constants.ETICHETA_LOT_FIELDS.PRODUS_BARCODE, item.getCodBare());
                map.put(Constants.ETICHETA_LOT_FIELDS.LOT_NR, lot.getNr());
                map.put(Constants.ETICHETA_LOT_FIELDS.LOT_EXPIRARE, Formatters.DATE_FORMAT_RO.format(lot.getExpirare()));
                map.put(Constants.ETICHETA_LOT_FIELDS.LOT_BARCODE, lot.getCodbare());
                PrintLogic.getInstance().printEtichetaBarcodeLot(map, nrCopii);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void printEticheteReceptieLot(Component parent, Vector<NirEntryFull> items) {
        int printNir = Config.getInstance().getInt("lotPrintEticheteAtNir");
        if (printNir > 0) {
            String s;
            boolean print = true;
            if (printNir == 2) {
                print = DialogUtils.confirmDialog(parent, "Tiparim etichete LOT", LangRoAll.confirmare);
            }
            if (print && Validators.correctInteger(s = DialogUtils.inputDialog(parent, "1", LangRoAll.numarCopii))) {
                int i = Integer.parseInt(s);
                this.printEticheteReceptieLot(items, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printEticheteReceptieA4(Component parent, Vector<NirEntryFull> items) {
        int printNir = Config.getInstance().getInt("printEticheteAtNir");
        String etichetePath = null;
        boolean somethingToDo = false;
        if (printNir > 0) {
            if (printNir == 1) {
                somethingToDo = true;
            } else if (DialogUtils.confirmDialog(parent, "Tiparim etichete", LangRoAll.confirmare)) {
                somethingToDo = true;
            }
        }
        if (somethingToDo) {
            Vector<PricePanelEntry> entries = null;
            try {
                String generatedCodBarePrefix = this.config.getStringNoCommit("barcodePrefix", "NULL");
                entries = new Vector<PricePanelEntry>();
                for (NirEntryFull nirEntryFull : items) {
                    String codBare1;
                    Product product = this.stockLogic.getProductForStockNoCommit(nirEntryFull.getIngredientId());
                    if (product == null || (codBare1 = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(product.getId())) == null || !codBare1.startsWith(generatedCodBarePrefix)) continue;
                    PricePanelEntry pe = new PricePanelEntry();
                    pe.setProduct(nirEntryFull.getDenumireProdus());
                    pe.setPret(nirEntryFull.getPpuvtva());
                    pe.setIdProduct(product.getId());
                    pe.setCodBare(codBare1);
                    pe.setCodIntern(product.getCod() + "");
                    pe.setMustPrint(true);
                    pe.setCopies((int)nirEntryFull.getCant());
                    entries.add(pe);
                }
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            etichetePath = RestLogic.getInstance().printEticheteRaftA4(entries, new PrintEticheteInterface(){

                @Override
                public int getCopyCount(PricePanelEntry currentItem) {
                    return currentItem.getCopies();
                }
            });
        }
        return etichetePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPretAchizitieForStock(int idStock, double quantity, boolean useCurrentLot) {
        double result = 0.0;
        try {
            result = this.getPretAchizitieForStockNoCommit(idStock, quantity, useCurrentLot);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public double getPretAchizitieForStockNoCommit(int idStock, double quantity, boolean useCurrentLot) throws SQLException {
        double result = -1.0;
        boolean pretOK = false;
        if (this.isGestiuneCMP()) {
            result = this.stockLogic.getPriceByCMP(idStock, DateUtils.getCurrentTimestamp());
        } else if (useCurrentLot) {
            result = this.stockLogic.getPretAchizitieLotCurentNoCommit(DateUtils.getCurrentTimestamp(), idStock, -1, quantity);
        }
        boolean bl = pretOK = result != -1.0;
        if (!pretOK) {
            result = this.getFacturaEntriesDao().getUltimulPretAchizitie(idStock);
        }
        return result;
    }

    private boolean isGestiuneCMP() throws SQLException {
        return this.config.getStringNoCommit("gestiuneTip").equalsIgnoreCase("cmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Magazie getLastMagazieIntrareForStock(int idStock) {
        try {
            int id = this.getNirEntriesDao().getLastMagazieIntrare(idStock);
            if (id > 0) {
                Magazie magazie = this.stockLogic.getMagazieById(id);
                return magazie;
            }
            Magazie magazie = null;
            return magazie;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Magazie magazie = null;
            return magazie;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void readFacturaXml(String xmlFile, ReceptieFromStockInterface inter, int idSocietateaNoastra) {
        try {
            SAXParser r = new SAXParser();
            ImportFacturaXmlHandler handler = new ImportFacturaXmlHandler(inter, this.stockLogic, idSocietateaNoastra);
            r.setContentHandler(handler);
            r.setErrorHandler(handler);
            r.parse(xmlFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public String exportFacturaXml(String outFile, Factura f, Nir nir) {
        try {
            StringBuffer result = this.prepareExportFacturaXml(f, nir);
            FileUtils.writeTextToFile(outFile, result.toString());
            return outFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    private StringBuffer prepareExportFacturaXml(Factura f, Nir nir) {
        StringBuffer result = new StringBuffer();
        Timestamp date = f.getDateadd();
        String data = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(date);
        String serie = f.getSerieFactura();
        int idFurnizor = f.getIdFurnizor();
        String auto = f.getAuto();
        double total = f.getTotal();
        double totaGen = f.getTotalGeneral();
        double totalTva = f.getTotalTva();
        result.append("<factura serie=\"" + serie + "\"" + " nr_nir=\"" + nir.getNumarNir() + "\"" + " data=\"" + data + "\"" + " id_furnizor=\"" + idFurnizor + "\"" + " auto=\"" + auto + "\"" + " total=\"" + total + "\"" + " total_tva=\"" + totalTva + "\"" + " total_general=\"" + totaGen + "\"" + " >\n");
        Vector<NirEntryFull> newData = this.getDataForNir(nir.getId());
        for (int i = 0; i < newData.size(); ++i) {
            NirEntryFull nirEntryFull = newData.elementAt(i);
            result.append("\t<stock ");
            result.append(" idStock=\"" + nirEntryFull.getIngredientId() + "\"");
            result.append(" idMagazie=\"" + nirEntryFull.getIdMagazie() + "\"");
            result.append(" cant=\"" + Utils.getString3Decimals(nirEntryFull.getCant()) + "\"");
            result.append(" pretAcz=\"" + Utils.getString3Decimals(nirEntryFull.getPpuc()) + "\"");
            result.append(" id_tva=\"" + nirEntryFull.getIdTva() + "\"");
            double ppuvTva = -1.0;
            if (!nirEntryFull.isFacturaOnly()) {
                ppuvTva = nirEntryFull.getPpuvtva();
            }
            result.append(" pretVz=\"" + Utils.getString3Decimals(ppuvTva) + "\" />\n");
        }
        result.append("</factura>");
        return result;
    }

    public boolean importNiruriFromFactura(String xmlFile, final Magazie magazieDefault, final EditNirPanel parent) {
        ReceptieFromStockInterface interface1 = new ReceptieFromStockInterface(){
            boolean okSoFar = true;

            @Override
            public Magazie getMagazieForStock(int magazieFromFile) {
                return magazieDefault;
            }

            @Override
            public void addNirItem(int idStock, String productName, String unitName, double cant, double ppuc, double pretCuTva, int idUnit, int idMagazie, String magazie, boolean incarcaStoc, double cotaTva, int idTva) {
                parent.addEntryFixedTva(idStock, productName, unitName, cant, ppuc, pretCuTva, idUnit, idMagazie, magazie, cotaTva, idTva);
            }

            @Override
            public void addNir(int nrNir, int idFurnizor, String auto, String serieFactura, Timestamp dataT, double total, double totalTva, double totalGeneral, int idSocietateaNoastra, int tipFactura, Timestamp scadenta) {
            }

            @Override
            public boolean okSoFar() {
                return this.okSoFar;
            }
        };
        try {
            SAXParser r = new SAXParser();
            ImportFacturaXmlHandler handler = new ImportFacturaXmlHandler(interface1, this.stockLogic, parent.getIdSocietateaNoastra());
            r.setContentHandler(handler);
            r.setErrorHandler(handler);
            r.parse(xmlFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
        return interface1.okSoFar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importNiruriFromXml(String xmlFile, int idSocietateaNoastra) {
        final Vector items = new Vector();
        ReceptieFromStockInterface interface1 = new ReceptieFromStockInterface(){
            boolean okSoFar = true;
            double tvaNoi = TvaLogic.getInstance().getCotaTva();

            @Override
            public Magazie getMagazieForStock(int magazieFromFile) {
                return ContaLogic.this.stockLogic.getMagazieById(magazieFromFile);
            }

            @Override
            public void addNirItem(int idStock, String productName, String unitName, double cant, double ppuc, double pretCuTva, int idUnit, int idMagazie, String magazie, boolean incarcaStoc, double cotaTva, int idTva) {
                try {
                    Product p = ContaLogic.this.stockLogic.getProductForStockNoCommit(idStock);
                    if (p != null) {
                        Categorie cat = NomeclaturaLogic.getInstance().getCategoryByIdNoCommit(p.getIdCategorie());
                        Tva t = TvaLogic.getInstance().getTvaByIdNoCommit(cat.getIdTva());
                        this.tvaNoi = t.getCota();
                    }
                    NirEntryFull toAdd = new NirEntryFull(-1, -1, idStock, productName, unitName, cant, ppuc, -1.0, -1.0, pretCuTva, this.tvaNoi, idUnit, this.tvaNoi, idMagazie, magazie, idTva);
                    toAdd.setNrCrt(items.size() + 1);
                    toAdd.compute();
                    items.add(toAdd);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                    this.okSoFar = false;
                }
            }

            @Override
            public void addNir(int nrNir, int idFurnizor, String auto, String serieFactura, Timestamp dataT, double total, double totalTva, double totalGeneral, int idSocietateaNoastra, int tipFactura, Timestamp scadenta) {
                try {
                    int idNir = ContaLogic.getInstance().addNirNoCommit(serieFactura, auto, dataT, idFurnizor, nrNir, items, false, new Vector(), true, idSocietateaNoastra, tipFactura, StockLogic.COMANDA_TYPE.EFECTUAT, scadenta);
                    ContaLogic.getInstance().closeNirNoCommit(idNir, 0.0, 0.0, 0.0, total, totalTva, totalGeneral);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                    this.okSoFar = false;
                }
                items.clear();
            }

            @Override
            public boolean okSoFar() {
                return this.okSoFar;
            }
        };
        this.readFacturaXml(xmlFile, interface1, idSocietateaNoastra);
        try {
            if (interface1.okSoFar()) {
                this.pool.commit();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean exportFacturiToXml(Vector data, String outFile) {
        StringBuffer xmlBuf = new StringBuffer();
        xmlBuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlBuf.append("<document>\n");
        for (int i = 0; i < data.size(); ++i) {
            FacturiEntry fe = (FacturiEntry)data.elementAt(i);
            Factura f = this.getFacturaById(fe.getIdFactura());
            Nir n = this.getNirByFacturaId(f.getId());
            StringBuffer line = this.prepareExportFacturaXml(f, n);
            xmlBuf.append(line);
            xmlBuf.append('\n');
        }
        xmlBuf.append("</document>\n");
        try {
            FileUtils.writeTextToFile(outFile, xmlBuf.toString(), "UTF-8");
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Integer> getProduseForFurnizor(int idFurnizor, int idStoc) {
        try {
            Vector<Integer> vector = this.getCommonsDao().getProdusePerFurnizor(idFurnizor, idStoc);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Integer> vector = new Vector<Integer>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void platesteFactura(int idFactura, int status) {
        try {
            this.getFacturiDao().setFacturaPlatita(idFactura, status);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stergeFacturaFaraNir(int idFactura) {
        try {
            this.getFacturiDao().delete(idFactura);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFacturaCuNir(int idFactura) {
        try {
            Nir n = this.getNiruriDao().getByFacturaId(idFactura);
            if (n != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void notifyFacturaFaraNir(String nume, double totalGeneral, Timestamp newData, String serieFactura, TipCheltuiala tipCheltuiala) {
        Hashtable<String, Object> o = new Hashtable<String, Object>();
        o.put("Total", totalGeneral);
        o.put("Data", newData);
        o.put("Furnizor", nume);
        o.put("Serie", serieFactura);
        String furnizor = nume;
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String data = formatSimple.format(newData);
        totalGeneral = FloatUtils.roundDouble(totalGeneral, VpConfig.getInstance().facturareRoundDecimals);
        String nodeTitle = "Alte Facturi " + furnizor + " " + serieFactura + " " + totalGeneral;
        String nodeDescription = "";
        nodeDescription = nodeDescription + "Furnizor : " + furnizor + "<br/>";
        nodeDescription = nodeDescription + "Data : " + data + "<br/>";
        nodeDescription = nodeDescription + "Total : " + totalGeneral + "<br/>";
        if (tipCheltuiala != null) {
            nodeDescription = nodeDescription + "TipCheltuiala : " + tipCheltuiala.getNume() + " cont " + tipCheltuiala.getCont();
        }
        o.put("node_title", nodeTitle);
        o.put("node_description", nodeDescription);
        GenericListenersLogic.getInstance().notifyObjectListeners(89, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFacturaFaraNir(int idFurnizor, String serieFactura, Timestamp newData, int idTva, double total, double totalTva, double totalGeneral, int idTipCheltuiala, boolean fiscal, int idSocietateaNoastra, int tipFactura, StockLogic.COMANDA_TYPE comandaType, Timestamp scadenta) {
        try {
            int idFactura = this.addFacturaNoCommit(idFurnizor, serieFactura, newData, "", false, idTipCheltuiala, fiscal, idSocietateaNoastra, tipFactura, scadenta);
            newData = this.documentInterface.getTimeDocument(2, newData);
            int idDoc = this.documentInterface.facturaAdded(idFactura, newData, "Factura " + serieFactura, fiscal, comandaType);
            Factura f = this.getFacturaById(idFactura);
            f.setTotal(total);
            f.setTotalGeneral(totalGeneral);
            f.setTotalTva(totalTva);
            this.getFacturiDao().update(f);
            this.pool.commit();
            int n = idFactura;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFacturaFaraNir(Factura toUpdate) {
        try {
            this.getFacturiDao().update(toUpdate);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNoteContabileRegCasa(Timestamp start, Timestamp stop) {
        Vector<NotaContabila> result = new Vector<NotaContabila>();
        try {
            Vector tipRegistre = this.getAllTipRegistru(AdministrationPanel.loggedUser.getLanguage());
            Vector clientTvaLaIncasare = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_tvaincasare", -1);
            boolean tvaLaIncasareEnabled = this.config.getBooleanNoCommit("contaTvaLaIncasareEnabled");
            String contTvaNeexigibilAdaosIncasare = this.config.getStringNoCommit("contaTvaLaIncasareContTvaNeexigibil");
            String contaContTvaDeductibil = this.config.getStringNoCommit("contaContTvaDeductibil");
            for (int i = 0; i < tipRegistre.size(); ++i) {
                TipRegistru tipRegistru = (TipRegistru)tipRegistre.elementAt(i);
                if (!Validators.correctString(tipRegistru.getCont())) continue;
                Vector<RegistruCasaEntry> regCasa = this.getRegistruCasa(start, stop, tipRegistru.getId(), 2);
                for (int j = 0; j < regCasa.size(); ++j) {
                    RegistruCasaEntry registruCasaEntry = regCasa.elementAt(j);
                    int idFurnizor = this.getFacturiDao().getIdFurnizori(registruCasaEntry.getId());
                    Client f = ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
                    if (f == null) continue;
                    ClientPersJuridica cpj = (ClientPersJuridica)f;
                    boolean partenerCuTvaLaIncasare = clientTvaLaIncasare.contains(cpj);
                    TvaLaIncasareInterface inter = this.getTvaLaIncasareInterface(partenerCuTvaLaIncasare, tvaLaIncasareEnabled);
                    Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(registruCasaEntry.getIdCotaTva());
                    if (tva == null) continue;
                    double procent = tva.getCota();
                    Vector<NotaContabila> noteContabile = inter.getNoteContabileRegistruCasa(registruCasaEntry, contTvaNeexigibilAdaosIncasare, cpj, tipRegistru.getCont(), procent, contaContTvaDeductibil);
                    result.addAll(noteContabile);
                }
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (Exception e) {
                Logger.logException(this, e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    private TvaLaIncasareInterface getTvaLaIncasareInterface(boolean partenerCuTvaLaIncasare, boolean tvaLaIncasareEnabled) {
        if (tvaLaIncasareEnabled || partenerCuTvaLaIncasare) {
            return new TvaLaIncasareSeAplicaImpl();
        }
        return new TvaLaIncasareNUSeAplicaImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNoteContabileNiruri(Timestamp start, Timestamp stop) {
        Vector<NotaContabila> result = new Vector<NotaContabila>();
        try {
            Vector<Magazie> magazii = this.stockLogic.getMagazii();
            Vector clientTvaLaIncasare = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_tvaincasare", -1);
            boolean tvaLaIncasareEnabled = this.config.getBooleanNoCommit("contaTvaLaIncasareEnabled");
            String contTvaNeexigibilAdaosIncasare = this.config.getStringNoCommit("contaTvaLaIncasareContTvaNeexigibil");
            String contaContTvaDeductibil = this.config.getStringNoCommit("contaContTvaDeductibil");
            for (int i = 0; i < magazii.size(); ++i) {
                Magazie magazie = magazii.elementAt(i);
                Vector<IntrariFurnizoriEntry> intrari = this.getFacturiDao().getIntrariFurnizori(magazie.getId(), start, stop, 2, -1, null, this.pool.requestConnection().getConnection(), -1, null, true);
                for (int j = 0; j < intrari.size(); ++j) {
                    IntrariFurnizoriEntry intrariFurnizoriEntry = intrari.elementAt(j);
                    Client f = ClientLogic.getInstance().getClientByIdNoCommit(intrariFurnizoriEntry.getIdFurnizor());
                    ClientPersJuridica cpj = (ClientPersJuridica)f;
                    boolean partenerCuTvaLaIncasare = clientTvaLaIncasare.contains(cpj);
                    TvaLaIncasareInterface inter = this.getTvaLaIncasareInterface(partenerCuTvaLaIncasare, tvaLaIncasareEnabled);
                    Vector<NotaContabila> noteContabileNiruri = inter.getNoteContabileNiruri(intrariFurnizoriEntry, magazie, contTvaNeexigibilAdaosIncasare, cpj, contaContTvaDeductibil);
                    result.addAll(noteContabileNiruri);
                }
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector getInvoicedCollectedCategories(Hashtable criteria) {
        String tip = (String)criteria.get(TIP_COLECTAT_KEY);
        if (tip.equalsIgnoreCase(COLLECTAT_IN_LUNA_RESPECTIVA)) {
            return this.getInvoicedCollectedCategories(criteria, new GetTotalIncasariCategoriesInterface(){

                @Override
                public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAsHash(Timestamp start, Timestamp stop, int idCategorie) throws SQLException {
                    return ContaLogic.this.getTotalIncasariInPerioadaForCategorieAsHash(start, stop, idCategorie);
                }
            });
        }
        return this.getInvoicedCollectedCategories(criteria, new GetTotalIncasariCategoriesInterface(){

            @Override
            public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAsHash(Timestamp start, Timestamp stop, int idCategorie) throws SQLException {
                return ContaLogic.this.getTotalIncasariAferentePerioadaForCategorieNoCommit(start, stop, idCategorie);
            }
        });
    }

    private double[] getInvoiceCollectedForCategories(Categorie categorie, Timestamp[][] months, int i, GetTotalIncasariCategoriesInterface inter, int idClientForced) throws SQLException {
        double[] result = this.getInvoiceCollectedForCategoriesEndOfRecurse(categorie, months, i, inter, idClientForced);
        Vector copii = NomeclaturaLogic.getInstance().getCategoriiCopil(categorie);
        for (int j = 0; j < copii.size(); ++j) {
            Categorie categorie1 = (Categorie)copii.elementAt(j);
            double[] result1 = this.getInvoiceCollectedForCategories(categorie1, months, i, inter, idClientForced);
            result[0] = result[0] + result1[0];
            result[1] = result[1] + result1[1];
            result[2] = result[2] + result1[2];
            result[3] = result[3] + result1[3];
            result[4] = result[4] + result1[4];
            result[5] = result[5] + result1[5];
        }
        return result;
    }

    private double[] getInvoiceCollectedForCategoriesEndOfRecurse(Categorie categorie, Timestamp[][] months, int i, GetTotalIncasariCategoriesInterface inter, int idClientForced) throws SQLException {
        Hashtable<Integer, ro.atreides.facturi.AgedDebtorsEntry> facturat = FacturiLogic.getInstance().getTotalFacturatCategoriesNoCommit(months[i][0], months[i][1], categorie.getId());
        if (i == 1) {
            System.out.println("ianuarie");
        }
        double tvaInvoiced = 0.0;
        double invoicedFaraTva = 0.0;
        double invoicedCuTVA = 0.0;
        double collectedTva = 0.0;
        double collectedFaraTva = 0.0;
        double collectedCuTva = 0.0;
        for (Integer idClient : facturat.keySet()) {
            if (idClientForced > 0 && idClient != idClientForced) continue;
            tvaInvoiced += facturat.get(idClient).getTotalTva();
            invoicedFaraTva += facturat.get(idClient).getTotalFaraTva();
            invoicedCuTVA += facturat.get(idClient).getTotalCuTva();
        }
        Hashtable<FacturatKey, FacturatEntry> collectedHash = inter.getTotalIncasariAsHash(months[i][0], months[i][1], categorie.getId());
        for (FacturatKey key : collectedHash.keySet()) {
            int idClient = key.getIdClient();
            if (idClientForced > 0 && idClient != idClientForced) continue;
            double cotaTvaFacturat = key.getCotaTva();
            double collectedNowWithTva = collectedHash.get(key).getTotalFacturat();
            double collectedNowTva = collectedNowWithTva / (1.0 + cotaTvaFacturat) * cotaTvaFacturat;
            double collectedNowFaraTVA = collectedNowWithTva / (1.0 + cotaTvaFacturat);
            collectedTva += collectedNowTva;
            collectedFaraTva += collectedNowFaraTVA;
            collectedCuTva += collectedNowWithTva;
        }
        double[] result = new double[]{invoicedCuTVA, invoicedFaraTva, tvaInvoiced, collectedCuTva, collectedFaraTva, collectedTva};
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getInvoicedCollectedCategories(Hashtable criteria, GetTotalIncasariCategoriesInterface inter) {
        Vector<InvoicedCollectedEntryCategorii> result = new Vector<InvoicedCollectedEntryCategorii>();
        String an = (String)criteria.get(AN_RAPORT_KEY);
        int idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
        Vector categories = NomeclaturaLogic.getInstance().getCategoriiPrincipale();
        double allTotalInvoiced = 0.0;
        double allTotalCollected = 0.0;
        double allTVAInvoiced = 0.0;
        double allTVACollected = 0.0;
        Vector<Double> totalsInvoiced = new Vector<Double>();
        Vector<Double> totalsCollected = new Vector<Double>();
        Vector<Double> totalsRatio = new Vector<Double>();
        for (int i = 0; i < categories.size(); ++i) {
            totalsInvoiced.add(0.0);
            totalsCollected.add(0.0);
        }
        try {
            Timestamp[][] months = DateUtils.getMonthsInYear(an);
            for (int i = 0; i < months.length; ++i) {
                String period = DateUtils.getHumanDate(i, Integer.parseInt(an));
                double totalInvoicedFaraTVA = 0.0;
                double totalInvoicedCuTVA = 0.0;
                double totalTVAInvoiced = 0.0;
                double totalCollectedFaraTVA = 0.0;
                double totalCollectedCuTVA = 0.0;
                double totalTVACollected = 0.0;
                Vector<Double> invoicedValues = new Vector<Double>();
                Vector<Double> collectedValues = new Vector<Double>();
                Vector<Double> ratioValues = new Vector<Double>();
                for (int j = 0; j < categories.size(); ++j) {
                    Categorie categorie = (Categorie)categories.elementAt(j);
                    if (categorie.getId() == 3) {
                        System.out.println("others");
                    }
                    double[] values = this.getInvoiceCollectedForCategories(categorie, months, i, inter, idClient);
                    totalInvoicedCuTVA += values[0];
                    totalInvoicedFaraTVA += values[1];
                    totalTVAInvoiced += values[2];
                    totalCollectedCuTVA += values[3];
                    totalCollectedFaraTVA += values[4];
                    totalTVACollected += values[5];
                    double f = (Double)totalsInvoiced.elementAt(j);
                    totalsInvoiced.setElementAt(f += values[1], j);
                    f = (Double)totalsCollected.elementAt(j);
                    totalsCollected.setElementAt(f += values[4], j);
                    double ratio = 100.0 * values[4] / values[1];
                    invoicedValues.add(values[1]);
                    collectedValues.add(values[4]);
                    ratioValues.add(ratio);
                }
                InvoicedCollectedEntryCategorii entryInvoiced = new InvoicedCollectedEntryCategorii(period + ": Facturat", totalInvoicedCuTVA, totalTVAInvoiced, invoicedValues);
                InvoicedCollectedEntryCategorii entryCollected = new InvoicedCollectedEntryCategorii(period + ": Incasat", totalCollectedCuTVA, totalTVACollected, collectedValues);
                double totalRatio = 100.0 * totalCollectedCuTVA / totalInvoicedCuTVA;
                double tvaRatio = 100.0 * totalTVACollected / totalTVAInvoiced;
                InvoicedCollectedEntryCategorii entryRatio = new InvoicedCollectedEntryCategorii(period + ": Ratio", totalRatio, tvaRatio, ratioValues);
                result.add(entryInvoiced);
                result.add(entryCollected);
                result.add(entryRatio);
                allTotalInvoiced += totalInvoicedCuTVA;
                allTotalCollected += totalCollectedCuTVA;
                allTVACollected += totalTVACollected;
                allTVAInvoiced += totalTVAInvoiced;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        InvoicedCollectedEntryCategorii entryInvoiced = new InvoicedCollectedEntryCategorii("TOTAL " + an + ": Facturat", allTotalInvoiced, allTVAInvoiced, totalsInvoiced);
        InvoicedCollectedEntryCategorii entryCollected = new InvoicedCollectedEntryCategorii("TOTAL " + an + ": Incasat", allTotalCollected, allTVACollected, totalsCollected);
        double allTotalRatio = allTotalCollected * 100.0 / allTotalInvoiced;
        double allTvaRatio = allTVACollected * 100.0 / allTVAInvoiced;
        for (int i = 0; i < categories.size(); ++i) {
            double collected = (Double)totalsCollected.elementAt(i);
            double invoiced = (Double)totalsInvoiced.elementAt(i);
            double ratio = 100.0 * collected / invoiced;
            totalsRatio.add(ratio);
        }
        InvoicedCollectedEntryCategorii entryRatio = new InvoicedCollectedEntryCategorii("TOTAL " + an + ": Ratio", allTotalRatio, allTvaRatio, totalsRatio);
        result.add(entryInvoiced);
        result.add(entryCollected);
        result.add(entryRatio);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<FacturatKey, FacturatEntry> getTotalIncasariInPerioadaForCategorieAsHash(Timestamp start, Timestamp stop, int idCategorie) {
        try {
            Hashtable<FacturatKey, FacturatEntry> hashtable = this.getRegCasaDao().getTotalIncasariInPerioadaForCategorie(start, stop, idCategorie);
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<FacturatKey, FacturatEntry> hashtable = new Hashtable<FacturatKey, FacturatEntry>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAferentePerioadaForCategorieNoCommit(Timestamp start, Timestamp stop, int idCategorie) throws SQLException {
        return this.getRegCasaDao().getTotalIncasariAferentePerioadaForCategorie(start, stop, idCategorie);
    }

    private Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaDataNoCommit(Timestamp start, Timestamp stop, int idCategorie, Timestamp incasariStop) throws SQLException {
        return this.getRegCasaDao().getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData(start, stop, incasariStop, idCategorie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFinanciarResumeReport(Hashtable criteria) {
        Vector<ResumeEntry> result = new Vector<ResumeEntry>();
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        Timestamp t1 = new Timestamp(stop.getTime());
        try {
            Vector aged = this.getAgedDebtors(t1);
            result.addAll(aged);
            ResumeEntry space = new ResumeEntry();
            space.addEmptyCell(9);
            result.add(space);
            Vector area2 = this.getAgedDebtorsArea2(stop);
            result.addAll(area2);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    private Vector getAgedDebtorsArea2(Date stop) throws SQLException {
        Vector<ResumeEntry> result = new Vector<ResumeEntry>();
        double[] gradRiskA = this.getArea2ForGradRisk("a", stop, totalDatoriiA);
        double[] gradRiskB = this.getArea2ForGradRisk("b", stop, totalDatoriiB);
        double[] gradRiskC = this.getArea2ForGradRisk("c", stop, totalDatoriiC);
        double total0 = gradRiskA[0] + gradRiskB[0] + gradRiskC[0];
        double total1 = gradRiskA[1] + gradRiskB[1] + gradRiskC[1];
        double total2 = gradRiskA[2] + gradRiskB[2] + gradRiskC[2];
        double total3 = gradRiskA[3] + gradRiskB[3] + gradRiskC[3];
        double total4 = gradRiskA[4] + gradRiskB[4] + gradRiskC[4];
        double total5 = gradRiskA[5] + gradRiskB[5] + gradRiskC[5];
        double total6 = gradRiskA[6] + gradRiskB[6] + gradRiskC[6];
        double total7 = total6 * 100.0 / totalDatoriiGeneral;
        String month = Formatters.MONTH_YEAR_HUMAN_FORMAT.format(stop);
        ResumeEntry linia1 = new ResumeEntry();
        linia1.addCell("Grad Risk");
        linia1.addCell("Inv last 12 months");
        linia1.addCell("Col last 12 months");
        linia1.addCell("Col % last 12 months");
        linia1.addCell("Inv " + month);
        linia1.addCell("Col " + month);
        linia1.addCell("Col % " + month);
        linia1.addCell("Garantii");
        linia1.addCell("% of total debt");
        result.add(linia1);
        ResumeEntry linia2 = new ResumeEntry();
        linia2.addCell("A");
        linia2.addCell(Utils.getString2Decimals(gradRiskA[0]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[1]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[2]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[3]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[4]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[5]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[6]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[7]));
        result.add(linia2);
        ResumeEntry linia3 = new ResumeEntry();
        linia3.addCell("B");
        linia3.addCell(Utils.getString2Decimals(gradRiskB[0]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[1]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[2]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[3]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[4]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[5]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[6]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[7]));
        result.add(linia3);
        ResumeEntry linia4 = new ResumeEntry();
        linia4.addCell("C");
        linia4.addCell(Utils.getString2Decimals(gradRiskC[0]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[1]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[2]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[3]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[4]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[5]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[6]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[7]));
        result.add(linia4);
        ResumeEntry linia5 = new ResumeEntry();
        linia5.addCell("TOTAL A+B+C");
        linia5.addCell(Utils.getString2Decimals(total0));
        linia5.addCell(Utils.getString2Decimals(total1));
        linia5.addCell(Utils.getString2Decimals(total2));
        linia5.addCell(Utils.getString2Decimals(total3));
        linia5.addCell(Utils.getString2Decimals(total4));
        linia5.addCell(Utils.getString2Decimals(total5));
        linia5.addCell(Utils.getString2Decimals(total6));
        linia5.addCell(Utils.getString10Decimals(total7));
        result.add(linia5);
        return result;
    }

    private double[] getArea2ForGradRisk(String gradRisk, Date stop, double totalDatoriiForGradRisk) throws SQLException {
        double[] result = new double[8];
        Vector clienti = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_risk_" + gradRisk, -1);
        Date d2 = stop;
        double invoicedLastYear = 0.0;
        double collectedLastYear = 0.0;
        double invoicedLastMonth = 0.0;
        double collectedLastMonth = 0.0;
        double totalGarantii = 0.0;
        Date d1 = DateUtils.addYearsToDate(d2, -1);
        Hashtable<Integer, FacturatEntry> totalInvoicedForClient = FacturiLogic.getInstance().getTotalFacturat(new Timestamp(d1.getTime()), new Timestamp(d2.getTime()), -1);
        Hashtable<Integer, FacturatEntry> totalCollectedForClient = this.getTotalIncasariInPerioada(new Timestamp(d1.getTime()), new Timestamp(d2.getTime()), -1);
        d1 = DateUtils.addMonthsToDate(d2, -1);
        Hashtable<Integer, FacturatEntry> totalInvoicedForClient2 = FacturiLogic.getInstance().getTotalFacturat(new Timestamp(d1.getTime()), new Timestamp(d2.getTime()), -1);
        Hashtable<Integer, FacturatEntry> totalCollectedForClient2 = this.getTotalIncasariInPerioada(new Timestamp(d1.getTime()), new Timestamp(d2.getTime()), -1);
        for (int i = 0; i < clienti.size(); ++i) {
            Client client = (Client)clienti.elementAt(i);
            invoicedLastYear += totalInvoicedForClient.get(client.getId()).getTotalFacturat();
            collectedLastYear += totalCollectedForClient.get(client.getId()).getTotalFacturat();
            invoicedLastMonth += totalInvoicedForClient2.get(client.getId()).getTotalFacturat();
            collectedLastMonth += totalCollectedForClient2.get(client.getId()).getTotalFacturat();
            if (!(client instanceof ClientPersJuridica)) continue;
            ClientPersJuridica pj = (ClientPersJuridica)client;
            totalGarantii += pj.getGarantie();
        }
        result[0] = invoicedLastYear;
        result[1] = collectedLastYear;
        result[2] = collectedLastYear * 100.0 / invoicedLastYear;
        result[3] = invoicedLastMonth;
        result[4] = collectedLastMonth;
        result[5] = collectedLastMonth * 100.0 / invoicedLastMonth;
        result[6] = totalGarantii;
        result[7] = totalGarantii * 100.0 / totalDatoriiForGradRisk;
        return result;
    }

    private Vector getAgedDebtors(Timestamp stop) throws SQLException {
        Vector<ResumeEntry> result = new Vector<ResumeEntry>();
        int prag1 = this.config.getInt("resumeReportNrZilePrag1");
        int prag2 = this.config.getInt("resumeReportNrZilePrag2");
        double[] gradRiskA = this.getAgedDebtorsForGradRisk("a", stop, prag1, prag2);
        double[] gradRiskB = this.getAgedDebtorsForGradRisk("b", stop, prag1, prag2);
        double[] gradRiskC = this.getAgedDebtorsForGradRisk("c", stop, prag1, prag2);
        double totalClienti = gradRiskA[0] + gradRiskB[0] + gradRiskC[0];
        double totalLunaTrecuta = gradRiskA[1] + gradRiskB[1] + gradRiskC[1];
        double totalDatoriiNoi = gradRiskA[2] + gradRiskB[2] + gradRiskC[2];
        double totalDatoriiMedii = gradRiskA[3] + gradRiskB[3] + gradRiskC[3];
        double totalDatoriiVechi = gradRiskA[4] + gradRiskB[4] + gradRiskC[4];
        double totalLunaAsta = gradRiskA[5] + gradRiskB[5] + gradRiskC[5];
        double procentA = gradRiskA[5] * 100.0 / totalLunaAsta;
        double procentB = gradRiskB[5] * 100.0 / totalLunaAsta;
        double procentC = gradRiskC[5] * 100.0 / totalLunaAsta;
        ResumeEntry linia1 = new ResumeEntry();
        linia1.addCell("Grad Risk");
        linia1.addCell("Nr clienti");
        Date d2 = DateUtils.getStartOfMonth(stop);
        d2 = DateUtils.addMillisToDate(d2, -1L);
        linia1.addCell("Due at " + Formatters.DATE_FORMAT_RO.format(d2));
        linia1.addCell("0 - " + prag1 + " days");
        linia1.addCell(prag1 + " - " + prag2 + " days");
        linia1.addCell("> " + prag2 + " days");
        linia1.addCell("Total due");
        linia1.addCell("% of total due");
        linia1.addCell(" ");
        result.add(linia1);
        ResumeEntry linia2 = new ResumeEntry();
        linia2.addCell("A");
        linia2.addCell(Utils.getString2Decimals(gradRiskA[0]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[1]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[2]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[3]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[4]));
        linia2.addCell(Utils.getString2Decimals(gradRiskA[5]));
        linia2.addCell(Utils.getString2Decimals(procentA));
        linia2.addCell(" ");
        result.add(linia2);
        ResumeEntry linia3 = new ResumeEntry();
        linia3.addCell("B");
        linia3.addCell(Utils.getString2Decimals(gradRiskB[0]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[1]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[2]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[3]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[4]));
        linia3.addCell(Utils.getString2Decimals(gradRiskB[5]));
        linia3.addCell(Utils.getString2Decimals(procentB));
        linia3.addCell(" ");
        result.add(linia3);
        ResumeEntry linia4 = new ResumeEntry();
        linia4.addCell("C");
        linia4.addCell(Utils.getString2Decimals(gradRiskC[0]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[1]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[2]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[3]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[4]));
        linia4.addCell(Utils.getString2Decimals(gradRiskC[5]));
        linia4.addCell(Utils.getString2Decimals(procentC));
        linia4.addCell(" ");
        result.add(linia4);
        ResumeEntry linia5 = new ResumeEntry();
        linia5.addCell("TOTAL A+B+C");
        linia5.addCell(Utils.getString2Decimals(totalClienti));
        linia5.addCell(Utils.getString2Decimals(totalLunaTrecuta));
        linia5.addCell(Utils.getString2Decimals(totalDatoriiNoi));
        linia5.addCell(Utils.getString2Decimals(totalDatoriiMedii));
        linia5.addCell(Utils.getString2Decimals(totalDatoriiVechi));
        linia5.addCell(Utils.getString2Decimals(totalLunaAsta));
        linia5.addCell("100");
        linia5.addCell(" ");
        result.add(linia5);
        totalDatoriiA = gradRiskA[5];
        totalDatoriiB = gradRiskB[5];
        totalDatoriiC = gradRiskC[5];
        totalDatoriiGeneral = totalDatoriiA + totalDatoriiB + totalDatoriiC;
        return result;
    }

    private double[] getAgedDebtorsForGradRisk(String gradRisk, Date stopDate, int prag1, int prag2) throws SQLException {
        double deColectatLaStop;
        double datoriiVechi;
        double datoriiMedii;
        double datoriiNoi;
        double datoriiLunaTrecuta;
        double[] result = new double[6];
        Vector clienti = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_risk_" + gradRisk, -1);
        int nrClienti = clienti.size();
        result[0] = nrClienti;
        Date d1 = DateUtils.getStartOfCentury();
        Date d2 = DateUtils.getStartOfMonth(stopDate);
        d2 = DateUtils.addMillisToDate(d2, -1L);
        Timestamp t1 = new Timestamp(d1.getTime());
        Timestamp t2 = new Timestamp(d2.getTime());
        result[1] = datoriiLunaTrecuta = this.getResumeDatorii(t1, t2, clienti);
        d1 = DateUtils.addDaysToDate(stopDate, -prag1);
        d2 = stopDate;
        t1 = new Timestamp(d1.getTime());
        t2 = new Timestamp(d2.getTime());
        result[2] = datoriiNoi = this.getResumeDatorii(t1, t2, clienti);
        d1 = DateUtils.addDaysToDate(stopDate, -prag2);
        d2 = DateUtils.addDaysToDate(stopDate, -prag1);
        t1 = new Timestamp(d1.getTime());
        t2 = new Timestamp(d2.getTime());
        result[3] = datoriiMedii = this.getResumeDatorii(t1, t2, clienti);
        d1 = DateUtils.getStartOfCentury();
        d2 = DateUtils.addDaysToDate(stopDate, -prag2);
        t1 = new Timestamp(d1.getTime());
        t2 = new Timestamp(d2.getTime());
        result[4] = datoriiVechi = this.getResumeDatorii(t1, t2, clienti);
        d1 = DateUtils.getStartOfCentury();
        d2 = stopDate;
        t1 = new Timestamp(d1.getTime());
        t2 = new Timestamp(d2.getTime());
        result[5] = deColectatLaStop = this.getResumeDatorii(t1, t2, clienti);
        return result;
    }

    private double getResumeDatorii(Timestamp startDate, Timestamp stopDate, Vector clients) throws SQLException {
        double totalInvoiced = 0.0;
        double totalCollected = 0.0;
        Hashtable<Integer, FacturatEntry> totalInvoicedForClient = FacturiLogic.getInstance().getTotalFacturat(startDate, stopDate, -1);
        Hashtable<Integer, FacturatEntry> totalCollectedForClient = this.getTotalIncasariAferentePerioada(startDate, stopDate, -1);
        for (int i = 0; i < clients.size(); ++i) {
            Client client = (Client)clients.elementAt(i);
            totalInvoiced += totalInvoicedForClient.get(client.getId()).getTotalFacturat();
            totalCollected += totalCollectedForClient.get(client.getId()).getTotalFacturat();
        }
        return totalInvoiced - totalCollected;
    }

    public Vector getAgedDebtorsReport(Hashtable criteria) {
        final Date stopDate = (Date)criteria.get(Constants.STOP_KEY);
        GetTotalIncasariCategoriesInterface inter = null;
        String tip = (String)criteria.get(TIP_COLECTAT_KEY);
        inter = tip.equalsIgnoreCase(COLLECTAT_PANA_LA_DATA) ? new GetTotalIncasariCategoriesInterface(){

            @Override
            public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAsHash(Timestamp start, Timestamp stop, int idCategorie) throws SQLException {
                if (ContaLogic.this.config.getBooleanNoCommit("agedDebtorsUseCategories")) {
                    return ContaLogic.this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaDataNoCommit(start, stop, idCategorie, new Timestamp(stopDate.getTime()));
                }
                return ContaLogic.this.getRegCasaDao().getTotalIncasariAferentePerioada(start, stop, new Timestamp(stopDate.getTime()), -1);
            }
        } : new GetTotalIncasariCategoriesInterface(){

            @Override
            public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAsHash(Timestamp start, Timestamp stop, int idCategorie) throws SQLException {
                if (ContaLogic.this.config.getBooleanNoCommit("agedDebtorsUseCategories")) {
                    return ContaLogic.this.getTotalIncasariAferentePerioadaForCategorieNoCommit(start, stop, idCategorie);
                }
                return ContaLogic.this.getRegCasaDao().getTotalIncasariAferentePerioada(start, stop, DateUtils.getEndOfDays(), -1);
            }
        };
        return this.getAgedDebtorsReport(stopDate, inter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getAgedDebtorsReport(Date stopDate, GetTotalIncasariCategoriesInterface inter) {
        try {
            Vector<AgedDebtorsEntry> result = new Vector<AgedDebtorsEntry>();
            Vector allClients = this.getClientiNeRedadiati(-1);
            Vector categories = NomeclaturaLogic.getInstance().getCategoriiPrincipale();
            Date d1 = DateUtils.addDaysToDate(stopDate, -30);
            Date d2 = stopDate;
            Hashtable<Integer, FacturatEntry> _0_30h = this.getAgedDebtorsDatorii(d1, d2, inter);
            d1 = DateUtils.addDaysToDate(stopDate, -60);
            d2 = DateUtils.addDaysToDate(stopDate, -30);
            Hashtable<Integer, FacturatEntry> _31_60h = this.getAgedDebtorsDatorii(d1, d2, inter);
            d1 = DateUtils.addDaysToDate(stopDate, -90);
            d2 = DateUtils.addDaysToDate(stopDate, -60);
            Hashtable<Integer, FacturatEntry> _61_90h = this.getAgedDebtorsDatorii(d1, d2, inter);
            d1 = DateUtils.addDaysToDate(stopDate, -120);
            d2 = DateUtils.addDaysToDate(stopDate, -90);
            Hashtable<Integer, FacturatEntry> _91_120h = this.getAgedDebtorsDatorii(d1, d2, inter);
            d1 = DateUtils.addDaysToDate(stopDate, -180);
            d2 = DateUtils.addDaysToDate(stopDate, -120);
            Hashtable<Integer, FacturatEntry> _121_180h = this.getAgedDebtorsDatorii(d1, d2, inter);
            d1 = DateUtils.getStartOfCentury();
            d2 = DateUtils.addDaysToDate(stopDate, -180);
            Hashtable<Integer, FacturatEntry> over180h = this.getAgedDebtorsDatorii(d1, d2, inter);
            d1 = DateUtils.getStartOfCentury();
            d2 = stopDate;
            Hashtable<Integer, FacturatEntry> totalh = this.getAgedDebtorsDatorii(d1, d2, inter);
            Map<Integer, Double> totalsCategories = Collections.synchronizedMap(new LinkedHashMap());
            for (int j = 0; j < categories.size(); ++j) {
                Categorie cat = (Categorie)categories.get(j);
                totalsCategories.put(cat.getId(), 0.0);
            }
            Date tvaChangeDate = DateUtils.getDate("2010-07-01 00:00:00", Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT);
            Hashtable<Integer, Map<Integer, Double>> categoriesResults = new Hashtable<Integer, Map<Integer, Double>>();
            Hashtable<Integer, Double> totalDueFaraTvaH = new Hashtable<Integer, Double>();
            d1 = DateUtils.getStartOfCentury();
            d2 = stopDate;
            if (tvaChangeDate.after(d1)) {
                this.processAgedDebtorsCategories(categories, d1, tvaChangeDate, allClients, categoriesResults, totalsCategories, totalDueFaraTvaH, inter);
            }
            if (tvaChangeDate.before(d2)) {
                this.processAgedDebtorsCategories(categories, tvaChangeDate, d2, allClients, categoriesResults, totalsCategories, totalDueFaraTvaH, inter);
            }
            double Ttva = 0.0;
            double Ttotal = 0.0;
            double T_0_30 = 0.0;
            double T_121_180 = 0.0;
            double T_31_60 = 0.0;
            double T_61_90 = 0.0;
            double T_91_120 = 0.0;
            double Tover180 = 0.0;
            for (int i = 0; i < allClients.size(); ++i) {
                Client client = (Client)allClients.elementAt(i);
                int idClient = client.getId();
                double _0_30 = 0.0;
                double _121_180 = 0.0;
                double _31_60 = 0.0;
                double _61_90 = 0.0;
                double _91_120 = 0.0;
                double over180 = 0.0;
                double total = 0.0;
                if (_0_30h.get(idClient) != null) {
                    _0_30 = _0_30h.get(idClient).getTotalFacturat();
                }
                if (_121_180h.get(idClient) != null) {
                    _121_180 = _121_180h.get(idClient).getTotalFacturat();
                }
                if (_31_60h.get(idClient) != null) {
                    _31_60 = _31_60h.get(idClient).getTotalFacturat();
                }
                if (_61_90h.get(idClient) != null) {
                    _61_90 = _61_90h.get(idClient).getTotalFacturat();
                }
                if (_91_120h.get(idClient) != null) {
                    _91_120 = _91_120h.get(idClient).getTotalFacturat();
                }
                if (over180h.get(idClient) != null) {
                    over180 = over180h.get(idClient).getTotalFacturat();
                }
                if (totalh.get(idClient) != null) {
                    total = totalh.get(idClient).getTotalFacturat();
                }
                double tva = 0.0;
                double totalDueFaraTva = 0.0;
                if (totalDueFaraTvaH.get(idClient) != null) {
                    totalDueFaraTva = totalDueFaraTvaH.get(idClient);
                }
                tva = total - totalDueFaraTva;
                Map<Integer, Double> c1 = categoriesResults.get(idClient);
                if (c1 != null) {
                    Vector<Double> cat1 = new Vector<Double>();
                    for (Double aDouble : c1.values()) {
                        cat1.add(aDouble);
                    }
                    AgedDebtorsEntry ade = new AgedDebtorsEntry(client.toString(), total, tva, cat1, _0_30, _121_180, _31_60, _61_90, _91_120, over180);
                    Ttva += tva;
                    Ttotal += total;
                    T_0_30 += _0_30;
                    T_121_180 += _121_180;
                    T_31_60 += _31_60;
                    T_61_90 += _61_90;
                    T_91_120 += _91_120;
                    Tover180 += over180;
                    if (total == 0.0 && _0_30 == 0.0 && _31_60 == 0.0 && _61_90 == 0.0 && _91_120 == 0.0 && _121_180 == 0.0 && over180 == 0.0) continue;
                    result.add(ade);
                    continue;
                }
                System.out.println("null !! ciudat !!");
            }
            AgedDebtorsEntry ade = new AgedDebtorsEntry("TOTAL", Ttotal, Ttva, new Vector<Double>(totalsCategories.values()), T_0_30, T_121_180, T_31_60, T_61_90, T_91_120, Tover180);
            result.add(ade);
            Vector<AgedDebtorsEntry> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void processAgedDebtorsCategories(Vector<Categorie> categories, Date start, Date stop, Vector<Client> allClients, Hashtable<Integer, Map<Integer, Double>> categoriesResults, Map<Integer, Double> totalsCategories, Hashtable<Integer, Double> totalDueFaraTvaH, GetTotalIncasariCategoriesInterface inter) throws SQLException {
        for (int j = 0; j < categories.size(); ++j) {
            Categorie categorie = categories.elementAt(j);
            Hashtable<Integer, ro.atreides.facturi.InvoicedCollectedEntry> values = this.getAgedDebtorsReportForCategorie(start, stop, categorie, inter);
            for (Client client : allClients) {
                ro.atreides.facturi.InvoicedCollectedEntry ic;
                int idClient = client.getId();
                Map<Integer, Double> resultsForClient = categoriesResults.get(idClient);
                if (resultsForClient == null) {
                    resultsForClient = Collections.synchronizedMap(new LinkedHashMap());
                    categoriesResults.put(idClient, resultsForClient);
                }
                if (resultsForClient.get(categorie.getId()) == null) {
                    resultsForClient.put(categorie.getId(), 0.0);
                }
                if ((ic = values.get(idClient)) == null) continue;
                double diff = ic.getInvoiced() - ic.getCollected();
                double totalDueFaraTva = 0.0;
                if (totalDueFaraTvaH.get(idClient) != null) {
                    totalDueFaraTva = totalDueFaraTvaH.get(idClient);
                }
                totalDueFaraTvaH.put(idClient, totalDueFaraTva += diff);
                double oldVal = resultsForClient.get(categorie.getId());
                double newVal = diff + oldVal;
                resultsForClient.put(categorie.getId(), newVal);
                double newTotal = totalsCategories.get(categorie.getId());
                totalsCategories.put(categorie.getId(), newTotal += diff);
            }
        }
    }

    private Hashtable<Integer, ro.atreides.facturi.InvoicedCollectedEntry> getAgedDebtorsReportForCategorie(Date d1, Date d2, Categorie categorie, GetTotalIncasariCategoriesInterface inter) throws SQLException {
        Hashtable<Integer, ro.atreides.facturi.InvoicedCollectedEntry> result = this.getAgedDebtorsReportCategorieEndOfRecurse(d1, d2, categorie, inter);
        Vector copii = NomeclaturaLogic.getInstance().getCategoriiCopil(categorie);
        for (int j = 0; j < copii.size(); ++j) {
            Categorie categorie1 = (Categorie)copii.elementAt(j);
            Hashtable<Integer, ro.atreides.facturi.InvoicedCollectedEntry> result1 = this.getAgedDebtorsReportForCategorie(d1, d2, categorie1, inter);
            for (Integer idClient : result1.keySet()) {
                ro.atreides.facturi.InvoicedCollectedEntry partial = result1.get(idClient);
                if (partial == null) continue;
                ro.atreides.facturi.InvoicedCollectedEntry total = result.get(idClient);
                if (total == null) {
                    total = new ro.atreides.facturi.InvoicedCollectedEntry();
                    result.put(idClient, total);
                }
                total.setCollected(total.getCollected() + partial.getCollected());
                total.setInvoiced(total.getInvoiced() + partial.getInvoiced());
            }
        }
        return result;
    }

    private Hashtable<Integer, ro.atreides.facturi.InvoicedCollectedEntry> getAgedDebtorsReportCategorieEndOfRecurse(Date d1, Date d2, Categorie categorie, GetTotalIncasariCategoriesInterface inter) throws SQLException {
        Hashtable<Integer, ro.atreides.facturi.AgedDebtorsEntry> invoicedArray = FacturiLogic.getInstance().getTotalFacturatCategoriesNoCommit(new Timestamp(d1.getTime()), new Timestamp(d2.getTime()), categorie.getId());
        Hashtable<FacturatKey, FacturatEntry> collectedCuTVA1 = inter.getTotalIncasariAsHash(new Timestamp(d1.getTime()), new Timestamp(d2.getTime()), categorie.getId());
        Hashtable<Integer, ro.atreides.facturi.InvoicedCollectedEntry> result = new Hashtable<Integer, ro.atreides.facturi.InvoicedCollectedEntry>();
        Hashtable<Integer, Integer> allClients = new Hashtable<Integer, Integer>();
        for (Integer idClient : invoicedArray.keySet()) {
            allClients.put(idClient, idClient);
        }
        for (FacturatKey facturatKey : collectedCuTVA1.keySet()) {
            allClients.put(facturatKey.getIdClient(), facturatKey.getIdClient());
        }
        for (Integer idClient : allClients.keySet()) {
            double invoicedFaraTVA = 0.0;
            double collectedFaraTVA = 0.0;
            ro.atreides.facturi.AgedDebtorsEntry invoicedEntry = invoicedArray.get(idClient);
            if (invoicedEntry != null) {
                invoicedFaraTVA = invoicedEntry.getTotalFaraTva();
            }
            Vector<FacturatKey> validKeys = new Vector<FacturatKey>();
            for (FacturatKey key : collectedCuTVA1.keySet()) {
                if (key.getIdClient() != idClient.intValue()) continue;
                validKeys.add(key);
            }
            for (FacturatKey key : validKeys) {
                FacturatEntry colectatEntry = collectedCuTVA1.get(key);
                double colectat = colectatEntry.getTotalFacturat();
                double cotaTva = key.getCotaTva();
                double colectatNowFaraTva = colectat / (1.0 + cotaTva);
                collectedFaraTVA += colectatNowFaraTva;
            }
            ro.atreides.facturi.InvoicedCollectedEntry ic = new ro.atreides.facturi.InvoicedCollectedEntry();
            ic.setCollected(collectedFaraTVA);
            ic.setInvoiced(invoicedFaraTVA);
            result.put(idClient, ic);
        }
        return result;
    }

    private Hashtable<Integer, FacturatEntry> getAgedDebtorsDatorii(Date d1, Date d2, GetTotalIncasariCategoriesInterface inter) throws SQLException {
        Timestamp t1 = new Timestamp(d1.getTime());
        Timestamp t2 = new Timestamp(d2.getTime());
        Hashtable<Integer, FacturatEntry> totalInvoicedForClient = FacturiLogic.getInstance().getTotalFacturatNoCommit(t1, t2, -1);
        Hashtable<FacturatKey, FacturatEntry> totalCollectedForClient = inter.getTotalIncasariAsHash(t1, t2, -1);
        Hashtable<Integer, Integer> allClients = new Hashtable<Integer, Integer>();
        for (Integer idClient : totalInvoicedForClient.keySet()) {
            allClients.put(idClient, idClient);
        }
        for (FacturatKey facturatKey : totalCollectedForClient.keySet()) {
            allClients.put(facturatKey.getIdClient(), facturatKey.getIdClient());
        }
        Hashtable<Integer, FacturatEntry> result = new Hashtable<Integer, FacturatEntry>();
        for (Integer idClient : allClients.keySet()) {
            double facturat = 0.0;
            double colectat = 0.0;
            FacturatEntry facturatFE = totalInvoicedForClient.get(idClient);
            if (facturatFE != null) {
                facturat = facturatFE.getTotalFacturat();
            }
            Vector<FacturatKey> validKeys = new Vector<FacturatKey>();
            for (FacturatKey key : totalCollectedForClient.keySet()) {
                if (key.getIdClient() != idClient.intValue()) continue;
                validKeys.add(key);
            }
            for (FacturatKey key : validKeys) {
                FacturatEntry colectatEntry = totalCollectedForClient.get(key);
                double colectat1 = colectatEntry.getTotalFacturat();
                colectat += colectat1;
            }
            double val = facturat - colectat;
            FacturatEntry fe = new FacturatEntry();
            fe.setIdClient(idClient);
            fe.setTotalFacturat(val);
            result.put(idClient, fe);
        }
        return result;
    }

    public Vector getInvoicedCollected(Hashtable criteria) {
        String tip = (String)criteria.get(TIP_COLECTAT_KEY);
        if (tip.equalsIgnoreCase(COLLECTAT_IN_LUNA_RESPECTIVA)) {
            return this.getInvoicedCollectedInLunaRespectiva(criteria);
        }
        return this.getInvoicedCollectedAferentLuniiRespective(criteria);
    }

    private Vector getInvoicedCollectedAferentLuniiRespective(Hashtable criteria) {
        Vector<InvoicedCollectedEntry> result = new Vector<InvoicedCollectedEntry>();
        String an = (String)criteria.get(AN_RAPORT_KEY);
        int idClientForced = (Integer)criteria.get(Constants.CLIENT_KEY);
        Timestamp[][] months = DateUtils.getMonthsInYear(an);
        for (int i = 0; i < months.length; ++i) {
            Hashtable<Integer, FacturatEntry> totalInvoiced = FacturiLogic.getInstance().getTotalFacturat(months[i][0], months[i][1], -1);
            Hashtable<Integer, FacturatEntry> totalCollected = this.getTotalIncasariAferentePerioada(months[i][0], months[i][1], -1);
            String period = DateUtils.getHumanDate(i, Integer.parseInt(an));
            double totalInvoicedD = 0.0;
            for (Integer idClient : totalInvoiced.keySet()) {
                if (idClientForced > 0 && idClient != idClientForced) continue;
                double d = totalInvoiced.get(idClient).getTotalFacturat();
                totalInvoicedD += d;
            }
            double totalCollectedD = 0.0;
            for (Integer idClient : totalCollected.keySet()) {
                if (idClientForced > 0 && idClient != idClientForced) continue;
                double d = totalCollected.get(idClient).getTotalFacturat();
                totalCollectedD += d;
            }
            InvoicedCollectedEntry e = new InvoicedCollectedEntry(totalInvoicedD, totalCollectedD, period);
            result.add(e);
        }
        return result;
    }

    private Vector getInvoicedCollectedInLunaRespectiva(Hashtable criteria) {
        Vector<InvoicedCollectedEntry> result = new Vector<InvoicedCollectedEntry>();
        String an = (String)criteria.get(AN_RAPORT_KEY);
        int idClientForced = (Integer)criteria.get(Constants.CLIENT_KEY);
        Timestamp[][] months = DateUtils.getMonthsInYear(an);
        for (int i = 0; i < months.length; ++i) {
            Hashtable<Integer, FacturatEntry> totalInvoiced = FacturiLogic.getInstance().getTotalFacturat(months[i][0], months[i][1], -1);
            Hashtable<Integer, FacturatEntry> totalCollected = this.getTotalIncasariInPerioada(months[i][0], months[i][1], -1);
            double totalInvoicedD = 0.0;
            for (Integer idClient : totalInvoiced.keySet()) {
                if (idClientForced > 0 && idClient != idClientForced) continue;
                double d = totalInvoiced.get(idClient).getTotalFacturat();
                totalInvoicedD += d;
            }
            double totalCollectedD = 0.0;
            for (Integer idClient : totalCollected.keySet()) {
                if (idClientForced > 0 && idClient != idClientForced) continue;
                double d = totalCollected.get(idClient).getTotalFacturat();
                totalCollectedD += d;
            }
            String period = DateUtils.getHumanDate(i, Integer.parseInt(an));
            InvoicedCollectedEntry e = new InvoicedCollectedEntry(totalInvoicedD, totalCollectedD, period);
            result.add(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<Integer, FacturatEntry> getTotalIncasariAferentePerioada(Timestamp start, Timestamp stop, int idClient) {
        try {
            Hashtable<Integer, FacturatEntry> result = new Hashtable<Integer, FacturatEntry>();
            Hashtable<FacturatKey, FacturatEntry> entries = this.getRegCasaDao().getTotalIncasariAferentePerioada(start, stop, DateUtils.getEndOfDays(), idClient);
            for (FacturatEntry entry : entries.values()) {
                int idClientNow = entry.getIdClient();
                FacturatEntry resultEntry = (FacturatEntry)result.get(idClientNow);
                if (resultEntry == null) {
                    resultEntry = new FacturatEntry();
                    result.put(idClientNow, resultEntry);
                }
                resultEntry.setTotalFacturat(resultEntry.getTotalFacturat() + entry.getTotalFacturat());
            }
            Hashtable<Integer, FacturatEntry> i$ = result;
            return i$;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, FacturatEntry> hashtable = new Hashtable<Integer, FacturatEntry>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<Integer, FacturatEntry> getTotalIncasariInPerioada(Timestamp start, Timestamp stop, int idClient) {
        try {
            Hashtable<Integer, FacturatEntry> hashtable = this.getRegCasaDao().getTotalIncasariInPerioada(start, stop, idClient);
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, FacturatEntry> hashtable = new Hashtable<Integer, FacturatEntry>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIncasariInPerioada(Hashtable criteria, int what) {
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        Timestamp t1 = new Timestamp(s1.getTime());
        Timestamp t2 = new Timestamp(s2.getTime());
        int idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
        try {
            Vector result = this.getRegCasaDao().getIncasariInPerioada(t1, t2, idClient, what);
            for (int i = 0; i < result.size(); ++i) {
                IncasariClientiEntry incasariClientiEntry = (IncasariClientiEntry)result.elementAt(i);
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(incasariClientiEntry.getIdClient());
                incasariClientiEntry.setClient(c.toString());
            }
            Vector vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPlatiInPerioada(Hashtable criteria, int what) {
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        Timestamp t1 = new Timestamp(s1.getTime());
        Timestamp t2 = new Timestamp(s2.getTime());
        int idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
        try {
            Vector result = this.getRegCasaDao().getPlatiInPerioada(t1, t2, idClient, what);
            for (int i = 0; i < result.size(); ++i) {
                IncasariClientiEntry incasariClientiEntry = (IncasariClientiEntry)result.elementAt(i);
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(incasariClientiEntry.getIdClient());
                incasariClientiEntry.setClient(c.toString());
            }
            Vector vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Client> getFurnizori(int status) {
        Vector<Client> fur = ClientLogic.getInstance().getPartnersInGroup(1, status);
        Collections.sort(fur, new Comparator(){

            public int compare(Object o1, Object o2) {
                Client c1 = (Client)o1;
                Client c2 = (Client)o2;
                return c1.toString().compareToIgnoreCase(c2.toString());
            }
        });
        return fur;
    }

    public Vector getClienti(int status) {
        Vector<Client> fur = ClientLogic.getInstance().getPartnersInGroup(2, status);
        Collections.sort(fur, new Comparator(){

            public int compare(Object o1, Object o2) {
                Client c1 = (Client)o1;
                Client c2 = (Client)o2;
                return c1.toString().compareToIgnoreCase(c2.toString());
            }
        });
        return fur;
    }

    public Vector getClientiNeRedadiati(int status) {
        Vector<Client> fur1 = ClientLogic.getInstance().getPartnersInGroup(2, status);
        Vector radiati = ClientLogic.getInstance().getPartnersInGroup("pers_juridice_groups_radiate", status);
        Vector<Client> fur2 = new Vector<Client>();
        for (Client client1 : fur1) {
            if (radiati.contains(client1)) continue;
            fur2.add(client1);
        }
        Collections.sort(fur2, new Comparator(){

            public int compare(Object o1, Object o2) {
                Client c1 = (Client)o1;
                Client c2 = (Client)o2;
                return c1.toString().compareToIgnoreCase(c2.toString());
            }
        });
        return fur2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFurnizoriActiviInPerioada(Timestamp start, Timestamp stop) {
        Vector<Client> allFurnizori = ClientLogic.getInstance().getPartnersInGroup(1, -1);
        try {
            Vector<ClientPersJuridica> result = new Vector<ClientPersJuridica>();
            for (Client furnizor : allFurnizori) {
                boolean activ = this.isFurnizorulActivInPerioadaNoCommit(start, stop, furnizor.getId());
                if (!activ) continue;
                ClientPersJuridica clientPersJuridica = (ClientPersJuridica)furnizor;
                result.add(clientPersJuridica);
            }
            Vector<ClientPersJuridica> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getClientiActiviInPerioada(Timestamp start, Timestamp stop) {
        Vector<Client> allClients = ClientLogic.getInstance().getPartnersInGroup(2, -1);
        try {
            Vector<ClientPersJuridica> result = new Vector<ClientPersJuridica>();
            for (int i = 0; i < allClients.size(); ++i) {
                ClientPersJuridica clientPersJuridica;
                boolean activ;
                Client c = allClients.elementAt(i);
                if (!(c instanceof ClientPersJuridica) || !(activ = this.isClientulActivInPerioadaNoCommit(start, stop, (clientPersJuridica = (ClientPersJuridica)c).getId()))) continue;
                result.add(clientPersJuridica);
            }
            Vector<ClientPersJuridica> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean isFurnizorulActivInPerioadaNoCommit(Timestamp start, Timestamp stop, int idFurnizor) throws SQLException {
        boolean activCuNiruri = this.getCommonsDao().areFurnizorulFacturiInPerioada(start, stop, idFurnizor);
        boolean activCuRegCasa = this.getRegCasaDao().areFurnizorulPlatiInPerioada(start, stop, idFurnizor);
        return activCuNiruri || activCuRegCasa;
    }

    public boolean isClientulActivInPerioadaNoCommit(Timestamp start, Timestamp stop, int idClient) throws SQLException {
        boolean activCuNiruri = this.getCommonsDao().areClientulFacturiEmiseInPerioada(start, stop, idClient);
        boolean activCuRegCasa = this.getRegCasaDao().areClientulPlatiInPerioada(start, stop, idClient);
        return activCuNiruri || activCuRegCasa;
    }

    public boolean adaugaIncasareBonFiscalNoCommit(Plata plata, int idLocatie, int nrNota, Date data, String explicatii) throws SQLException {
        TipRegistru tr = this.getRegCasaDao().getTipRegistruForTipPlataAndLocatie(plata.getIdTipPlata(), idLocatie, 1);
        if (tr != null) {
            this.addIncasare(plata.getSuma(), "BF " + nrNota, "", explicatii, tr.getId(), data, new Vector(), true, -1);
            return true;
        }
        return false;
    }

    public boolean adaugaIncasareNoCommit(Plata plata, int idLocatie, String tipDocument, String nrDocument, Date data, String anexa, String explicatii, Vector<PlatiEntry> facturiEmisePlatite) throws SQLException {
        TipRegistru tr = this.getRegCasaDao().getTipRegistruForTipPlataAndLocatie(plata.getIdTipPlata(), idLocatie, 1);
        if (tr != null) {
            this.addIncasare(plata.getSuma(), tipDocument + " " + nrDocument, anexa, explicatii, tr.getId(), data, facturiEmisePlatite, true, -1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipCheltuiala getTipCheltuialaById(int id) {
        try {
            TipCheltuiala tipCheltuiala = this.getCommonsDao().getTipCheltuialaById(id);
            return tipCheltuiala;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipCheltuiala tipCheltuiala = null;
            return tipCheltuiala;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllTipCheltuiala() {
        Vector result = new Vector();
        try {
            result = this.getCommonsDao().getAllTipCheltuiala();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTipCheltuiala(String cont, String nume) {
        try {
            this.getCommonsDao().addTipCheltuiala(cont, nume);
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllTipVenit() {
        Vector result = new Vector();
        try {
            result = this.getCommonsDao().getAllTipVenit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTipVenit(String cont, String nume) {
        try {
            this.getCommonsDao().addTipVenit(cont, nume);
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importNirProductFromExcel(String um, String magazia, String numeProdus, double pretVanzare, String codBare, String categoria, int idUnit, int currentLine, int idSectie, Sectie first, Tva tva) {
        int idStock = -1;
        try {
            Stock s = this.stockLogic.getStockByNameNoCommit(numeProdus);
            if (s == null) {
                idStock = this.stockLogic.addStockNoCommit(numeProdus, idUnit, 0.0, 0.0, pretVanzare, true);
            } else {
                idStock = s.getId();
                this.stockLogic.updateStockNoCommit(idStock, numeProdus, idUnit, s.getWarningLevel(), s.getCriticalLevel(), true);
            }
            boolean isProdusFinit = this.stockLogic.isProdusFinitNoCommit(idStock);
            if (s != null && isProdusFinit) {
                Product p = this.stockLogic.getProductForStockNoCommit(idStock);
                this.stockLogic.updatePriceForStockNoCommit(idStock, pretVanzare);
                NomeclaturaLogic.getInstance().updateProductNoCommit(p, pretVanzare, new Vector());
            } else if (pretVanzare > 0.0) {
                int idCategorie = -1;
                Categorie sc = NomeclaturaLogic.getInstance().getCategoryByNameNoCommit(categoria);
                if (sc == null) {
                    Categorie cat = NomeclaturaLogic.getInstance().newCategoryNoCommit(idSectie, categoria, Color.WHITE.getRGB(), first.getId() + "", tva.getId(), false, 0.0);
                    idCategorie = cat.getId();
                } else {
                    idCategorie = sc.getId();
                }
                int cod = NomeclaturaLogic.getInstance().getNextProductCodeNoCommit();
                Vector<String> barcodes = new Vector<String>();
                barcodes.add(codBare);
                this.stockLogic.addProdusFinitNoCommit(numeProdus, idStock, idCategorie, cod, false, true, null, codBare, barcodes);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return idStock;
    }

    public Vector getSituatieParteneri(Hashtable criteria, int whatToPrint) {
        Vector<SituatieParteneriEntry> result = new Vector<SituatieParteneriEntry>();
        Vector persJuridice = ClientLogic.getInstance().getPersJuridiceViewEntry(criteria);
        for (int i = 0; i < persJuridice.size(); ++i) {
            PersJuridicaViewEntry persJuridicaViewEntry = (PersJuridicaViewEntry)persJuridice.elementAt(i);
            double totalFacturiEmise = 0.0;
            double deIncasat = 0.0;
            int idPartener = persJuridicaViewEntry.getClientObject().getId();
            Vector<FacturiNeplatiteEntry> facturiNeplatiteClienti = FacturiLogic.getInstance().getFacturiNeplatite(idPartener, whatToPrint);
            for (int j = 0; j < facturiNeplatiteClienti.size(); ++j) {
                FacturiNeplatiteEntry facturiNeplatiteEntry = facturiNeplatiteClienti.elementAt(j);
                totalFacturiEmise += facturiNeplatiteEntry.getTotal();
                deIncasat += facturiNeplatiteEntry.getDePlata();
            }
            double totalFacturiPrimite = 0.0;
            double dePlata = 0.0;
            Vector facturiNeplatiteFurnizori = ContaLogic.getInstance().getFacturiNeplatite(idPartener, whatToPrint);
            for (int j = 0; j < facturiNeplatiteFurnizori.size(); ++j) {
                FacturiNeplatiteEntry facturiNeplatiteEntry = (FacturiNeplatiteEntry)facturiNeplatiteFurnizori.elementAt(j);
                totalFacturiPrimite += facturiNeplatiteEntry.getTotal();
                dePlata += facturiNeplatiteEntry.getDePlata();
            }
            SituatieParteneriEntry se = new SituatieParteneriEntry();
            se.setFacturiEmise(totalFacturiEmise);
            se.setDeincasat(deIncasat);
            se.setPartener(persJuridicaViewEntry.getClientObject().toString());
            se.setFacturiPrimite(totalFacturiPrimite);
            se.setDeplata(dePlata);
            se.setBalantaFacturi(totalFacturiEmise - totalFacturiPrimite);
            se.setBalantaPlati(deIncasat - dePlata);
            result.add(se);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNrNirTaken(int nr, int idSocietateaNoastra) {
        try {
            boolean bl = this.getNiruriDao().isNrNirTaken(nr, idSocietateaNoastra);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastNirNr(int idSocietateaNoastra) {
        try {
            int n = this.getNiruriDao().getLastNrNir(idSocietateaNoastra);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    @Override
    public boolean isStockInDeposit(int idStock, int idMagazie) {
        if (this.checkStockInterface != null) {
            return this.checkStockInterface.isStockInDeposit(idStock, idMagazie);
        }
        return true;
    }

    public void setCheckStockInterface(CheckStockInDepositInterface checkStockInterface) {
        this.checkStockInterface = checkStockInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getProfitabilitateFacturi(Hashtable criteria, int what) {
        Vector<ProfitReportPanelEntry> result = new Vector<ProfitReportPanelEntry>();
        try {
            Date startDate = (Date)criteria.get(Constants.START_KEY);
            Date stopDate = (Date)criteria.get(Constants.STOP_KEY);
            Timestamp s1 = new Timestamp(startDate.getTime());
            Timestamp s2 = new Timestamp(stopDate.getTime());
            criteria.put(Constants.STATUS_FACTURA_KEY, -1);
            Vector<FacturiEmiseView> facturiEmise = FacturiLogic.getInstance().getFacturiEmise(criteria, what);
            for (int i = 0; i < facturiEmise.size(); ++i) {
                FacturiEmiseView fev = facturiEmise.elementAt(i);
                ProfitReportPanelEntry pe = new ProfitReportPanelEntry();
                pe.setClient(fev.getClient());
                pe.setData(Formatters.DATE_FORMAT_RO.format(fev.getData()));
                pe.setNrFactura(fev.getSerieNumar());
                double tva = fev.getTva();
                pe.setVzTva(fev.getTotal() + tva);
                pe.setVzFrTva(fev.getTotal());
                Vector<ProfitFacturiReportEntryDetalii> detaliiMagazii = new Vector<ProfitFacturiReportEntryDetalii>();
                Vector<Magazie> magazii = StockLogic.getInstance().getMagazii();
                for (int j = 0; j < magazii.size(); ++j) {
                    Magazie m = magazii.elementAt(j);
                    ProfitFacturiReportEntryDetalii ped = new ProfitFacturiReportEntryDetalii();
                    double vz = 0.0;
                    vz = this.getCommonsDao().getValoareVzCuTvaForFactura(fev.getIdFactura(), m.getId());
                    ped.setValVz(vz /= 1.0 + tva);
                    double consum = 0.0;
                    consum = this.getCommonsDao().getValoareConsumLaData(m.getId(), fev.getData());
                    ped.setValIesire(consum);
                    ped.compute();
                    detaliiMagazii.add(ped);
                }
                pe.setDetaliiMagazii(detaliiMagazii);
                result.add(pe);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePreturiAchizitieDinViitor(Vector<NirEntryFull> entries, Timestamp date) {
        try {
            for (NirEntryFull entry : entries) {
                double pret;
                if (entry.getPpuc() != 0.0 || !((pret = this.getCommonsDao().getPretAchizitieInViitorForStock(entry.getIngredientId(), date)) > 0.0)) continue;
                entry.setPpuc(pret);
                entry.compute();
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean isPlatitorTva(int idPartner) {
        return ClientLogic.getInstance().isPartnerInGroup(idPartner, GROUP_PLATITOR_TVA_KEY);
    }

    public boolean exportFacturaToJSON(FacturiEntry fe, String file) {
        System.out.println(file);
        Factura f = this.getFacturaById(fe.getIdFactura());
        Nir n = this.getNirByFacturaId(f.getId());
        Vector<NirEntryFull> dataForNir = this.getDataForNir(n.getId());
        Client client = ClientLogic.getInstance().getClientById(f.getIdFurnizor());
        ClientPersJuridica furnizor = (ClientPersJuridica)client;
        System.out.println(furnizor.getCui());
        System.out.println("Serie factura: " + f.getSerieFactura());
        Gson gson = new Gson();
        VariabileIntrareNir variabileIntrareNir = new VariabileIntrareNir();
        Vector<InformationBean> header = new Vector<InformationBean>();
        header.add(new InformationBean("cui", furnizor.getCui()));
        header.add(new InformationBean("document", f.getSerieFactura()));
        Vector<DateIntrare> dateIntrare = new Vector<DateIntrare>();
        for (NirEntryFull nirEntryFull : dataForNir) {
            DateIntrare data1 = new DateIntrare();
            Vector<InformationBean> element = new Vector<InformationBean>();
            element.add(new InformationBean("valoareTotalaFaraTva", nirEntryFull.getValoareCumparare() + ""));
            element.add(new InformationBean("valoareTvaAchizitie", nirEntryFull.getTvaFurnizorTotal() + ""));
            element.add(new InformationBean("pretVanzareCuTva", nirEntryFull.getValoareaLaPretAmanuntCuTva() + ""));
            element.add(new InformationBean("valoareAdaosComercial", nirEntryFull.getTotalAdaos() + ""));
            element.add(new InformationBean("valoareTvaVanzare", nirEntryFull.getTvaTotalAmanunt() + ""));
            data1.setProdus(element);
            dateIntrare.add(data1);
        }
        variabileIntrareNir.setHeader(header);
        variabileIntrareNir.setDateIntrare(dateIntrare);
        String fileContent = gson.toJson(variabileIntrareNir);
        try {
            FileUtils.writeTextToFile(file, fileContent.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
        return true;
    }

    public boolean exportFacturaNirToJSON(Vector<FacturiEntry> data, String dataStart, String dataStop) {
        System.out.println(dataStart + " " + dataStop);
        String directories = "export/dever/NIR";
        File dir = new File(directories + File.separator + dataStart + " - " + dataStop);
        dir.mkdirs();
        for (FacturiEntry fe : data) {
            Factura f = this.getFacturaById(fe.getIdFactura());
            Nir n = this.getNirByFacturaId(f.getId());
            Vector<NirEntryFull> dataForNir = this.getDataForNir(n.getId());
            Client client = ClientLogic.getInstance().getClientById(f.getIdFurnizor());
            ClientPersJuridica furnizor = (ClientPersJuridica)client;
            System.out.println(furnizor.getCui());
            System.out.println("Serie factura: " + f.getSerieFactura());
            Gson gson = new Gson();
            VariabileIntrareNir variabileIntrareNir = new VariabileIntrareNir();
            Vector<InformationBean> header = new Vector<InformationBean>();
            header.add(new InformationBean("cui", furnizor.getCui()));
            header.add(new InformationBean("document", f.getSerieFactura()));
            header.add(new InformationBean("dataDocument", f.getDateadd().toString()));
            header.add(new InformationBean("tipDocument", "nir"));
            Vector<DateIntrare> dateIntrare = new Vector<DateIntrare>();
            for (NirEntryFull nirEntryFull : dataForNir) {
                DateIntrare data1 = new DateIntrare();
                Vector<InformationBean> element = new Vector<InformationBean>();
                element.add(new InformationBean("valoareTotalaFaraTva", nirEntryFull.getValoareCumparare() + ""));
                element.add(new InformationBean("valoareTvaAchizitie", nirEntryFull.getTvaFurnizorTotal() + ""));
                element.add(new InformationBean("pretVanzareCuTva", nirEntryFull.getValoareaLaPretAmanuntCuTva() + ""));
                element.add(new InformationBean("valoareAdaosComercial", nirEntryFull.getTotalAdaos() + ""));
                element.add(new InformationBean("valoareTvaVanzare", nirEntryFull.getTvaTotalAmanunt() + ""));
                data1.setProdus(element);
                dateIntrare.add(data1);
            }
            variabileIntrareNir.setHeader(header);
            variabileIntrareNir.setDateIntrare(dateIntrare);
            String fileContent = gson.toJson(variabileIntrareNir);
            String filename = dir + File.separator + "NIR_" + n.getNumarNir() + "_" + f.getSerieFactura() + "_" + furnizor.getCui() + ".json";
            try {
                FileUtils.writeTextToFile(filename, fileContent.toString());
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                return false;
            }
        }
        return true;
    }

    public boolean exportFacturiEmiseToJSON(Vector<FacturiEmiseView> facturi, Date start, Date stop) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        String startString = formatter.format(start);
        String stopString = formatter.format(stop);
        String directories = "export/dever/EMISE";
        File dir = new File(directories + File.separator + startString + " - " + stopString);
        dir.mkdirs();
        for (FacturiEmiseView few : facturi) {
            VariabileIntrareNir variabileIntrare = new VariabileIntrareNir();
            Vector<InformationBean> header = new Vector<InformationBean>();
            header.add(new InformationBean("cui", few.getCui()));
            header.add(new InformationBean("client", few.getClient()));
            header.add(new InformationBean("document", few.getSerieNumar()));
            header.add(new InformationBean("dataDocument", few.getData().toString()));
            header.add(new InformationBean("tipDocument", "emisa"));
            Vector<DateIntrare> dateIntrare = new Vector<DateIntrare>();
            Vector facturiItems = FacturiLogic.getInstance().getFacturiItems(few.getIdFactura());
            for (FacturaItemView item : facturiItems) {
                DateIntrare intrari = new DateIntrare();
                Vector<InformationBean> element = new Vector<InformationBean>();
                element.add(new InformationBean("pretVanzareFaraTva", item.getPpuFaraTva() + ""));
                element.add(new InformationBean("cantitate", item.getCantitate() + ""));
                element.add(new InformationBean("valoareTotalaFaraTva", item.getValoare() + ""));
                element.add(new InformationBean("valoareTva", item.getValoareTva() + ""));
                element.add(new InformationBean("valoareCuTva", item.getValoareCuTva() + ""));
                element.add(new InformationBean("cotaTva", item.getCotaTva() + ""));
                intrari.setProdus(element);
                dateIntrare.add(intrari);
            }
            variabileIntrare.setHeader(header);
            variabileIntrare.setDateIntrare(dateIntrare);
            Gson gson = new Gson();
            String fileContent = gson.toJson(variabileIntrare);
            String filename = dir + File.separator + "EMISA_" + few.getSerieNumar() + "_" + few.getClient() + "_" + few.getCui() + ".json";
            try {
                FileUtils.writeTextToFile(filename, fileContent.toString());
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                return false;
            }
        }
        return true;
    }

    public Map<Integer, Double> getTvaForIntrariNoCommit(Date start, Date stop) throws SQLException {
        Map<Integer, Double> allItems = this.getCommonsDao().getIntrariForIngredient(-1, new Timestamp(start.getTime()), new Timestamp(stop.getTime()));
        return allItems;
    }

    public static enum TIP_DOCUMENT_NIR {
        Factura(1),
        BonFiscal(2),
        BorderouAchizitii(3);

        private int tip;

        private TIP_DOCUMENT_NIR(int tip) {
            this.tip = tip;
        }

        public int getTip() {
            return this.tip;
        }
    }
}

