/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.RegistruCasaEntry;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.deversoft.drivers.datecs.gen3.noarch.Validators;

public class ContaPrint {
    private static String replaceInTotalLine(double valoareFactura, double tvaFactura, double totalFactura, double totalAmanunt, double totalAdaos, double totalTva, String linie, String totalString) {
        linie = linie.replaceAll("%%nr%%", "");
        linie = linie.replaceAll("%%produs%%", totalString);
        linie = linie.replaceAll("%%um%%", "");
        linie = linie.replaceAll("%%cant%%", "");
        linie = linie.replaceAll("%%ppuc%%", "");
        linie = linie.replaceAll("%%valCump%%", Utils.getString2DecimalsNoTrunc(valoareFactura));
        linie = linie.replaceAll("%%tvaPerUm%%", "");
        linie = linie.replaceAll("%%totalTVA%%", Utils.getString2DecimalsNoTrunc(tvaFactura));
        linie = linie.replaceAll("%%totalFactura%%", Utils.getString2DecimalsNoTrunc(totalFactura));
        linie = linie.replaceAll("%%adaos%%", "");
        linie = linie.replaceAll("%%suma%%", Utils.getString2DecimalsNoTrunc(totalAdaos));
        linie = linie.replaceAll("%%ppuvtva%%", "");
        linie = linie.replaceAll("%%ppu%%", "");
        linie = linie.replaceAll("%%tvaac%%", "");
        linie = totalAmanunt == -1.0 ? linie.replaceAll("%%val%%", "") : linie.replaceAll("%%val%%", Utils.getString2DecimalsNoTrunc(totalAmanunt));
        linie = linie.replaceAll("%%tvatotalUM%%", "");
        linie = linie.replaceAll("%%totalTVAFull%%", Utils.getString2DecimalsNoTrunc(totalTva));
        return linie;
    }

    public static String makeFoFile(Collection<NirEntryFull> nirItems, String model, Config config, Nir nir, Factura factura, Client fur, ContaLogic logic, String societate) throws IOException {
        String modelFile = "conf" + File.separator + config.getString("nirModel");
        String lineFile = "conf" + File.separator + config.getString("nirLine");
        String totalLineFile = "conf" + File.separator + config.getString("nirTotalLine");
        String comisia = Config.getInstance().getString("comisiaReceptie");
        String foFile = FileUtils.readFileToString(modelFile);
        String date = "";
        Hashtable<String, Vector<NirEntryFull>> hashPerTva = new Hashtable<String, Vector<NirEntryFull>>();
        Hashtable<String, Vector<NirEntryFull>> hashPerMagazii = new Hashtable<String, Vector<NirEntryFull>>();
        Hashtable<String, Vector<NirEntryFull>> hashMagaziiTva = new Hashtable<String, Vector<NirEntryFull>>();
        int i = 1;
        for (NirEntryFull e : nirItems) {
            String linie = FileUtils.readFileToString(lineFile);
            linie = linie.replaceAll("%%nr%%", i + "");
            String secondLineResult = "";
            String sLine = e.getSecondLine();
            if (Validators.correctString(sLine)) {
                secondLineResult = sLine + " ";
            }
            if (e.getIdLot() > 0) {
                Date lotExp;
                Lot lot = StockLogic.getInstance().getLotByIdCommit(e.getIdLot());
                String lotNr = lot.getNr();
                if (Validators.correctString(lotNr)) {
                    secondLineResult = secondLineResult + "LOT " + lotNr + " ";
                }
                if ((lotExp = lot.getExpirare()) != null) {
                    secondLineResult = secondLineResult + "Expira " + Formatters.DATE_FORMAT_RO.format(lotExp);
                }
            }
            if (Validators.correctString(secondLineResult)) {
                secondLineResult = " ( " + secondLineResult.substring(0, secondLineResult.length()) + " )";
            }
            String productEscaped = TextUtils.escapeForXML(e.getDenumireProdus() + secondLineResult);
            linie = linie.replaceAll("%%produs%%", " " + productEscaped);
            String umEscaped = TextUtils.escapeForXML(e.getUm());
            linie = linie.replaceAll("%%um%%", umEscaped);
            String magazie = TextUtils.escapeForXML(e.getMagazie());
            linie = linie.replaceAll("%%mag%%", magazie);
            linie = linie.replaceAll("%%cant%%", Utils.getString3DecimalsNoTrunc(e.getCant()));
            linie = linie.replaceAll("%%ppuc%%", Utils.getString2DecimalsNoTrunc(e.getPpuc()));
            linie = linie.replaceAll("%%valCump%%", Utils.getString2DecimalsNoTrunc(e.getValoareCumparare()));
            linie = linie.replaceAll("%%tvaPerUm%%", Utils.getString2DecimalsNoTrunc(e.getTvaPerUm()));
            linie = linie.replaceAll("%%totalTVA%%", Utils.getString2DecimalsNoTrunc(e.getTvaFurnizorTotal()));
            linie = linie.replaceAll("%%totalFactura%%", Utils.getString2DecimalsNoTrunc(e.getTotalFactura()));
            linie = linie.replaceAll("%%comisiaReceptie%%", comisia);
            if (e.isFacturaOnly()) {
                linie = linie.replaceAll("%%adaos%%", "");
                linie = linie.replaceAll("%%suma%%", "");
                linie = linie.replaceAll("%%ppuvtva%%", "");
                linie = linie.replaceAll("%%valAmanuntCuTVA%%", "");
                linie = linie.replaceAll("%%ppu%%", "");
                linie = linie.replaceAll("%%tvaac%%", "");
                linie = linie.replaceAll("%%val%%", "");
                linie = linie.replaceAll("%%tvatotalUM%%", "");
                linie = linie.replaceAll("%%totalTVAFull%%", "");
            } else {
                linie = linie.replaceAll("%%adaos%%", Utils.getString2DecimalsNoTrunc(e.getAdaosProcent()));
                linie = linie.replaceAll("%%suma%%", Utils.getString2DecimalsNoTrunc(e.getTotalAdaos()));
                linie = linie.replaceAll("%%ppuvtva%%", Utils.getString2DecimalsNoTrunc(e.getPpuvtva()));
                linie = linie.replaceAll("%%valAmanuntCuTVA%%", Utils.getString2DecimalsNoTrunc(e.getValoareaLaPretAmanuntCuTva()));
                linie = linie.replaceAll("%%ppu%%", Utils.getString2DecimalsNoTrunc(e.getPpuv()));
                linie = linie.replaceAll("%%tvaac%%", Utils.getString2DecimalsNoTrunc(e.getTvaAferentAdaosComercial()));
                linie = linie.replaceAll("%%val%%", Utils.getString2DecimalsNoTrunc(e.getValoareaLaPretAmanuntCuTva()));
                linie = linie.replaceAll("%%tvatotalUM%%", Utils.getString2DecimalsNoTrunc(e.getTvaPerUMAmanunt()));
                linie = linie.replaceAll("%%totalTVAFull%%", Utils.getString2DecimalsNoTrunc(e.getTvaTotalAmanunt()));
            }
            date = date + linie + "\n";
            ContaPrint.addDataToHashes(hashPerTva, hashPerMagazii, hashMagaziiTva, e);
            ++i;
        }
        String serieEscaped = TextUtils.escapeForXML(factura.getSerieFactura());
        foFile = foFile.replaceAll("%%factura%%", serieEscaped);
        String linieTotalOriginala = FileUtils.readFileToString(totalLineFile);
        double valoareFactura = factura.getTotal();
        double tvaFactura = factura.getTotalTva();
        double totalFactura = factura.getTotalGeneral();
        double totalAmanunt = logic.getTotalAmanuntGeneral(nirItems);
        double totalAdaos = logic.getTotalAdaos(nirItems);
        double totalTva = logic.getTotalAmanuntTva(nirItems);
        String linieTotal = ContaPrint.replaceInTotalLine(valoareFactura, tvaFactura, totalFactura, totalAmanunt, totalAdaos, totalTva, linieTotalOriginala, LangRoAll.total);
        String magaziiTvaTotalLine = ContaPrint.buildNewLineFromHash(hashMagaziiTva, linieTotalOriginala, true, true);
        String magaziiTotalLine = ContaPrint.buildNewLineFromHash(hashPerMagazii, linieTotalOriginala, false, false);
        String tvaTotalLine = ContaPrint.buildNewLineFromHash(hashPerTva, linieTotalOriginala, false, true);
        date = date + magaziiTvaTotalLine + "\n";
        date = date + ContaPrint.getEmptyLine(linieTotalOriginala) + "\n";
        date = date + magaziiTotalLine + "\n";
        date = date + ContaPrint.getEmptyLine(linieTotalOriginala) + "\n";
        date = date + tvaTotalLine + "\n";
        date = date + ContaPrint.getEmptyLine(linieTotalOriginala) + "\n";
        date = date + linieTotal + "\n";
        foFile = foFile.replaceAll("%%date%%", date);
        int nrNir = nir.getNumarNir();
        String nr = nrNir > 0 ? nrNir + "" : "";
        String nrNirEscaped = TextUtils.escapeForXML(nr);
        foFile = foFile.replaceAll("%%nr_nir%%", nrNirEscaped);
        String data = Formatters.DATE_FORMAT_RO.format(factura.getDateadd());
        foFile = foFile.replaceAll("%%data%%", data);
        String furName = fur.toString();
        String furNameEscaped = TextUtils.escapeForXML(furName);
        foFile = foFile.replaceAll("%%furnizor%%", furNameEscaped);
        String autoEscaped = TextUtils.escapeForXML(factura.getAuto());
        foFile = foFile.replaceAll("%%auto%%", autoEscaped);
        String societateEscaped = TextUtils.escapeForXML(societate);
        foFile = foFile.replaceAll("%%societate%%", societateEscaped);
        String filename = FileUtils.getTempDir() + File.separator + model + ".fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(foFile);
        fw.close();
        return filename;
    }

    private static void addDataToHashes(Hashtable<String, Vector<NirEntryFull>> hashPerTva, Hashtable<String, Vector<NirEntryFull>> hashPerMagazii, Hashtable<String, Vector<NirEntryFull>> hashMagaziiTva, NirEntryFull e) {
        ContaPrint.addToHash(hashPerTva, e.getIdTva() + "", e);
        ContaPrint.addToHash(hashPerMagazii, e.getMagazie(), e);
        ContaPrint.addToHash(hashMagaziiTva, e.getMagazie() + "_" + e.getIdTva(), e);
    }

    private static void addToHash(Hashtable<String, Vector<NirEntryFull>> hash, String key, NirEntryFull e) {
        Vector<NirEntryFull> vect = hash.get(key);
        if (vect != null) {
            vect.add(e);
        } else {
            vect = new Vector();
            vect.add(e);
        }
        hash.put(key, vect);
    }

    private static String buildNewLineFromHash(Hashtable<String, Vector<NirEntryFull>> dataHash, String line, boolean withMagazii, boolean withTva) {
        String result = "";
        ArrayList<String> sortedKeys = new ArrayList<String>(dataHash.keySet());
        Collections.sort(sortedKeys);
        for (String s : sortedKeys) {
            double valoare = new Double(0.0);
            double tva = new Double(0.0);
            double total = new Double(0.0);
            double totalAmanunt = new Double(0.0);
            double totalAdaos = new Double(0.0);
            double totalTva = new Double(0.0);
            Vector<NirEntryFull> nirEntryFulls = dataHash.get(s);
            for (NirEntryFull n : nirEntryFulls) {
                valoare += n.getValoareCumparare();
                tva += n.getTvaFurnizorTotal();
                total += n.getTotalFactura();
                totalAmanunt += n.getValoareaLaPretAmanuntCuTva();
                totalAdaos += n.getTotalAdaos();
                totalTva += n.getTvaTotalAmanunt();
            }
            if (withMagazii) {
                String[] split = s.split("_");
                String magazie = split[0];
                Integer idTvaStr = Integer.parseInt(split[1]);
                Tva tvaById = TvaLogic.getInstance().getTvaById(idTvaStr);
                String lineStr = ContaPrint.replaceInTotalLine(valoare, tva, total, totalAmanunt, totalAdaos, totalTva, line, magazie.replaceAll(" ", ".") + "-" + tvaById.toString() + "%");
                result = result + lineStr + "\n";
                continue;
            }
            if (withTva) {
                Tva tvaById = TvaLogic.getInstance().getTvaById(new Integer(s));
                String lineStr = ContaPrint.replaceInTotalLine(valoare, tva, total, totalAmanunt, totalAdaos, totalTva, line, "Tva-" + tvaById.toString() + "%");
                result = result + lineStr + "\n";
                continue;
            }
            String lineStr = ContaPrint.replaceInTotalLine(valoare, tva, total, totalAmanunt, totalAdaos, totalTva, line, s.replaceAll(" ", "."));
            result = result + lineStr;
        }
        return result;
    }

    private static String getEmptyLine(String linie) {
        linie = linie.replaceAll("%%nr%%", "");
        linie = linie.replaceAll("%%produs%%", "-");
        linie = linie.replaceAll("%%um%%", "");
        linie = linie.replaceAll("%%cant%%", "");
        linie = linie.replaceAll("%%ppuc%%", "");
        linie = linie.replaceAll("%%valCump%%", "-");
        linie = linie.replaceAll("%%tvaPerUm%%", "");
        linie = linie.replaceAll("%%totalTVA%%", "-");
        linie = linie.replaceAll("%%totalFactura%%", "-");
        linie = linie.replaceAll("%%adaos%%", "");
        linie = linie.replaceAll("%%suma%%", "-");
        linie = linie.replaceAll("%%ppuvtva%%", "");
        linie = linie.replaceAll("%%ppu%%", "");
        linie = linie.replaceAll("%%tvaac%%", "");
        linie = linie.replaceAll("%%val%%", "-");
        linie = linie.replaceAll("%%tvatotalUM%%", "");
        linie = linie.replaceAll("%%totalTVAFull%%", "-");
        return linie;
    }

    public static String makeRegCasaFoFile(Vector items, String societate, String data, String casaName, double incasari, double plati, double soldVechi, double soldNou) throws IOException {
        String modelFile = "conf" + File.separator + "regcasa.txt";
        String lineFile = "conf" + File.separator + "linieRegCasa.txt";
        String foFile = FileUtils.readFileToString(modelFile);
        String date = "";
        int i = 1;
        for (RegistruCasaEntry entry : items) {
            String linie = FileUtils.readFileToString(lineFile);
            String explicatii = TextUtils.escapeForXML(entry.getExplicatii());
            linie = linie.replaceAll("%%nr%%", i + "");
            linie = linie.replaceAll("%%actcasa%%", entry.getNrActCasa());
            linie = linie.replaceAll("%%anexa%%", entry.getNrAnexa());
            linie = linie.replaceAll("%%explain%%", explicatii);
            double incasare = entry.getIncasari();
            double plata = entry.getPlati();
            linie = incasare > 0.0 ? linie.replaceAll("%%incasare%%", Utils.getString2Decimals(incasare)) : linie.replaceAll("%%incasare%%", "");
            linie = plata > 0.0 ? linie.replaceAll("%%plata%%", Utils.getString2Decimals(plata)) : linie.replaceAll("%%plata%%", "");
            linie = linie.replaceAll("%%data%%", entry.getDataAsString());
            date = date + linie + "\n";
            ++i;
        }
        foFile = foFile.replaceAll("%%data%%", data);
        foFile = foFile.replaceAll("%%societatea%%", societate);
        foFile = foFile.replaceAll("%%casa%%", casaName);
        foFile = foFile.replaceAll("%%entries%%", date);
        foFile = foFile.replaceAll("%%totalincasari%%", Utils.getString2Decimals(incasari));
        foFile = foFile.replaceAll("%%totalplati%%", Utils.getString2Decimals(plati));
        foFile = foFile.replaceAll("%%soldIeri%%", Utils.getString2Decimals(soldVechi));
        foFile = foFile.replaceAll("%%total%%", Utils.getString2Decimals(soldNou));
        String filename = FileUtils.getTempDir() + File.separator + "regcasa.fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(foFile);
        fw.close();
        return filename;
    }
}

