/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.ReceptieFromStockInterface;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.units.UnitsLogic;

public class ImportFacturaXmlHandler
extends DefaultHandler {
    private ReceptieFromStockInterface receptieInterface;
    private StockLogic logic;
    private Date d1;
    private String serie;
    private String auto;
    private double total;
    private double totalTva;
    private double totalGeneral;
    private int nrNir;
    private int idTva;
    private int idFurnizor;
    private int idSocietateaNoastra;

    public ImportFacturaXmlHandler(ReceptieFromStockInterface receptieInterface, StockLogic logic, int idSocietateaNoastra) {
        this.receptieInterface = receptieInterface;
        this.logic = logic;
        this.idSocietateaNoastra = idSocietateaNoastra;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("produs") && this.receptieInterface.okSoFar()) {
            String codBare = attributes.getValue("codbare");
            Product p = NomeclaturaLogic.getInstance().getProductByCodBare(codBare);
            if (p != null) {
                int idStock = this.logic.getStockInterface().getIdStock(p.getId());
                Stock s = this.logic.getStockById(idStock);
                if (s != null) {
                    int idUnit = s.getIdUnit();
                    Unit u = UnitsLogic.getInstance().getUnitById(idUnit);
                    double cant = Utils.parseDouble(attributes.getValue("cantitate"));
                    double valoarecutva = Utils.parseDouble(attributes.getValue("valoarecutva"));
                    double cotaTva = Utils.parseDouble(attributes.getValue("cotatva"));
                    double pretFaraTva = valoarecutva / cant / (1.0 + cotaTva);
                    double pretVz = ContaLogic.getInstance().getInter().getPriceForProduct(p.getId());
                    String numeMagazie = "";
                    int idMagazie = -1;
                    Magazie m = this.receptieInterface.getMagazieForStock(idMagazie);
                    if (m != null) {
                        idMagazie = m.getId();
                        numeMagazie = m.getLabel();
                    }
                    this.receptieInterface.addNirItem(idStock, s.getLabel(), u.getLabel(), cant, pretFaraTva, pretVz, idUnit, idMagazie, numeMagazie, true, cotaTva, 1);
                } else {
                    Logger.logWarning(this, "Nu am gasit Stockul pt produsul cu codul de bare " + codBare);
                }
            } else {
                Logger.logWarning(this, "Nu am gasit produsul cu codul de bare " + codBare);
            }
        }
        if (qName.equalsIgnoreCase("stock") && this.receptieInterface.okSoFar()) {
            int idStock = Integer.parseInt(attributes.getValue("idStock"));
            int idMagazie = Integer.parseInt(attributes.getValue("idMagazie"));
            double cant = Utils.parseDouble(attributes.getValue("cant"));
            double pretAcz = Utils.parseDouble(attributes.getValue("pretAcz"));
            double pretVz = Utils.parseDouble(attributes.getValue("pretVz"));
            Stock s = this.logic.getStockById(idStock);
            int idUnit = s.getIdUnit();
            Unit u = UnitsLogic.getInstance().getUnitById(idUnit);
            Magazie m = this.logic.getMagazieById(idMagazie);
            this.receptieInterface.addNirItem(idStock, s.getLabel(), u.getLabel(), cant, pretAcz, pretVz, idUnit, idMagazie, m.getLabel(), true, -1.0, 1);
        }
        if (qName.equalsIgnoreCase("factura") && this.receptieInterface.okSoFar()) {
            String dataS = attributes.getValue("data");
            try {
                this.d1 = Formatters.DATE_TIME_AND_SECONDS_FORMAT.parse(dataS);
                this.serie = attributes.getValue("serie");
                this.auto = attributes.getValue("auto");
                this.total = Utils.parseDouble(attributes.getValue("total"));
                this.totalTva = Utils.parseDouble(attributes.getValue("total_tva"));
                this.totalGeneral = Utils.parseDouble(attributes.getValue("total_general"));
                this.nrNir = Integer.parseInt(attributes.getValue("nr_nir"));
                this.idTva = Integer.parseInt(attributes.getValue("id_tva"));
                this.idFurnizor = Integer.parseInt(attributes.getValue("id_furnizor"));
            }
            catch (ParseException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("factura") && this.receptieInterface.okSoFar()) {
            this.receptieInterface.addNir(this.nrNir, this.idFurnizor, this.auto, this.serie, new Timestamp(this.d1.getTime()), this.total, this.totalTva, this.totalGeneral, this.idSocietateaNoastra, -1, new Timestamp(this.d1.getTime()));
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }
}

