/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate;

import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.Lot;
import ro.atreides.utils.ExportedByXml;
import ro.atreides.utils.FloatUtils;

public class NirEntryFull
implements ExportedByXml {
    private int ingredientId;
    private int idNirEntry;
    private int idFacturaEntry;
    private int idUnit;
    private int idMagazie;
    private int idTva;
    private int nrCrt;
    private String denumireProdus;
    private String um;
    private double cant;
    private double ppuc;
    private double valoareCumparare;
    private double tvaPerUm;
    private double tvaFurnizorTotal;
    private double totalFactura;
    private double adaosProcent;
    private double adaosProcentOriginal;
    private double adaosSuma;
    private double totalAdaos;
    private double tvaAferentAdaosComercial;
    private double valoareaLaPretAmanuntFaraTva;
    private double valoareaLaPretAmanuntCuTva;
    private double tvaPerUMAmanunt;
    private double tvaTotalAmanunt;
    private String codBare = "";
    private String secondLine = "";
    private double ppuv;
    private double ppuvOriginal;
    private double ppuvtva;
    private double ppuvtvaOriginal;
    private double tvaNoi;
    private boolean facturaOnly;
    private String magazie;
    private Lot lot;
    private int idLot;
    private int positionForEdit;

    public NirEntryFull() {
    }

    public NirEntryFull(int idNirEntry, int idFacturaEntry, int ingredientId, String denumireProdus, String um, double cant, double ppuc, double adaos, double ppuv, double ppuvtva, double totalTvaFurnizor, int idUnit, double tvaNoi, int idMagazie, String magazie, int idTva) {
        this.idNirEntry = idNirEntry;
        this.idFacturaEntry = idFacturaEntry;
        this.ingredientId = ingredientId;
        this.denumireProdus = denumireProdus;
        this.um = um;
        this.tvaFurnizorTotal = totalTvaFurnizor;
        this.idUnit = idUnit;
        this.tvaNoi = tvaNoi;
        this.adaosProcent = adaos;
        this.ppuc = ppuc;
        this.ppuv = ppuv;
        this.ppuvtva = ppuvtva;
        this.cant = cant;
        this.ppuvtvaOriginal = this.ppuvtva;
        this.ppuvOriginal = this.ppuv;
        this.adaosProcentOriginal = this.adaosProcent;
        this.idMagazie = idMagazie;
        this.magazie = magazie;
        this.idTva = idTva;
    }

    public String getMagazie() {
        return this.magazie;
    }

    public void setMagazie(String magazie) {
        this.magazie = magazie;
    }

    public int getIdMagazie() {
        return this.idMagazie;
    }

    public void setIdMagazie(int idMagazie) {
        this.idMagazie = idMagazie;
    }

    public int getIngredientId() {
        return this.ingredientId;
    }

    public void compute() {
        this.facturaOnly = false;
        boolean backCompute = true;
        if (this.adaosProcent != -1.0) {
            backCompute = false;
        } else if (this.ppuv != -1.0) {
            this.ppuvtva = this.ppuv * (1.0 + this.tvaNoi);
            backCompute = true;
        } else if (this.ppuvtva != -1.0) {
            double deimpartit = this.ppuvtva * 100.0;
            double impartitor = this.tvaNoi * 100.0 + 100.0;
            this.ppuv = deimpartit / impartitor;
            backCompute = true;
        } else {
            this.facturaOnly = true;
            this.ppuvtva = 0.0;
        }
        this.valoareCumparare = this.ppuc * this.cant;
        this.valoareCumparare = FloatUtils.roundFloat(this.valoareCumparare, VpConfig.getInstance().nirRoundDecimals);
        this.tvaFurnizorTotal = FloatUtils.roundFloat(this.tvaFurnizorTotal, VpConfig.getInstance().nirRoundDecimals);
        this.tvaPerUm = this.tvaFurnizorTotal / this.cant;
        this.totalFactura = this.valoareCumparare + this.tvaFurnizorTotal;
        this.totalFactura = FloatUtils.roundFloat(this.totalFactura, VpConfig.getInstance().nirRoundDecimals);
        if (!this.facturaOnly) {
            if (!backCompute) {
                this.adaosSuma = this.ppuc * this.adaosProcent;
                this.totalAdaos = this.adaosSuma * this.cant;
                this.ppuv = this.ppuc + this.adaosSuma;
                this.tvaAferentAdaosComercial = this.adaosSuma * this.tvaNoi;
                this.ppuvtva = this.tvaPerUm + this.ppuv + this.tvaAferentAdaosComercial;
                this.tvaPerUMAmanunt = this.tvaPerUm + this.tvaAferentAdaosComercial;
            } else {
                this.adaosSuma = this.ppuv - this.ppuc;
                this.totalAdaos = this.adaosSuma * this.cant;
                this.adaosProcent = this.ppuc > 0.0 ? this.adaosSuma / this.ppuc : 0.0;
                this.tvaAferentAdaosComercial = this.adaosSuma * this.tvaNoi;
                this.tvaPerUMAmanunt = this.tvaAferentAdaosComercial + this.tvaPerUm;
            }
            this.valoareaLaPretAmanuntCuTva = this.cant * this.ppuvtva;
            this.valoareaLaPretAmanuntFaraTva = this.cant * this.ppuv;
            this.tvaTotalAmanunt = this.cant * this.tvaPerUMAmanunt;
        }
    }

    public double getTotalAdaos() {
        return this.totalAdaos;
    }

    public void setTotalAdaos(double totalAdaos) {
        this.totalAdaos = totalAdaos;
    }

    public boolean isFacturaOnly() {
        return this.facturaOnly;
    }

    public int getIdUnit() {
        return this.idUnit;
    }

    public double getAdaosProcent() {
        return this.adaosProcent;
    }

    public double getAdaosSuma() {
        return this.adaosSuma;
    }

    public double getCant() {
        return this.cant;
    }

    public String getDenumireProdus() {
        return this.denumireProdus;
    }

    public double getPpuc() {
        return this.ppuc;
    }

    public double getPpuvtva() {
        return this.ppuvtva;
    }

    public double getTotalFactura() {
        return this.totalFactura;
    }

    public double getTvaPerUm() {
        return this.tvaPerUm;
    }

    public double getTvaFurnizorTotal() {
        return this.tvaFurnizorTotal;
    }

    public String getUm() {
        return this.um;
    }

    public double getValoareCumparare() {
        return this.valoareCumparare;
    }

    public int getNrCrt() {
        return this.nrCrt;
    }

    public void setNrCrt(int nrCrt) {
        this.nrCrt = nrCrt;
    }

    public double getPpuv() {
        return this.ppuv;
    }

    public double getTvaAferentAdaosComercial() {
        return this.tvaAferentAdaosComercial;
    }

    public double getTvaPerUMAmanunt() {
        return this.tvaPerUMAmanunt;
    }

    public double getTvaTotalAmanunt() {
        return this.tvaTotalAmanunt;
    }

    public double getValoareaLaPretAmanuntCuTva() {
        return this.valoareaLaPretAmanuntCuTva;
    }

    public double getValoareaLaPretAmanuntFaraTva() {
        return this.valoareaLaPretAmanuntFaraTva;
    }

    public double getAdaosProcentOriginal() {
        return this.adaosProcentOriginal;
    }

    public double getPpuvOriginal() {
        return this.ppuvOriginal;
    }

    public double getPpuvtvaOriginal() {
        return this.ppuvtvaOriginal;
    }

    public String getCodBare() {
        return this.codBare;
    }

    public void setCodBare(String codBare) {
        this.codBare = codBare;
    }

    public void setIngredientId(int ingredientId) {
        this.ingredientId = ingredientId;
    }

    public void setPpuc(double ppuc) {
        this.ppuc = ppuc;
    }

    public void setUm(String um) {
        this.um = um;
    }

    public int getIdTva() {
        return this.idTva;
    }

    public String getSecondLine() {
        return this.secondLine;
    }

    public void setSecondLine(String secondLine) {
        this.secondLine = secondLine;
    }

    public void setDenumireProdus(String denumireProdus) {
        this.denumireProdus = denumireProdus;
    }

    public void setIdUnit(int idUnit) {
        this.idUnit = idUnit;
    }

    public void setCant(double cant) {
        this.cant = cant;
    }

    public Lot getLot() {
        return this.lot;
    }

    public void setLot(Lot lot) {
        this.lot = lot;
    }

    public int getIdLot() {
        return this.idLot;
    }

    public void setIdLot(int idLot) {
        this.idLot = idLot;
    }

    public int getPositionForEdit() {
        return this.positionForEdit;
    }

    public void setPositionForEdit(int positionForEdit) {
        this.positionForEdit = positionForEdit;
    }
}

