/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.RaportIntrariEntry;
import ro.atreides.contabilitate.TipCheltuiala;
import ro.atreides.contabilitate.TipVenit;
import ro.atreides.contabilitate.export.platforma.ExportNirPlatforma;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.sql.SqlUtils;

public class CommonsDao
implements DaoInterface {
    private PreparedStatement getFullNirByBirId;
    private PreparedStatement getIntrariForIngredient;
    private PreparedStatement getNiruriPlatforma;
    private PreparedStatement getTotalAczForFactura;
    private PreparedStatement getTotalVzForFactura;
    private PreparedStatement getProdusePerFurnizor;
    private PreparedStatement areFurnizorulNiruriInPerioada;
    private PreparedStatement areClientulFacturiEmiseInPerioada;
    private PreparedStatement getAllTipCheltuiala;
    private PreparedStatement getAllTipCheltuialaById;
    private PreparedStatement addTipCheltuiala;
    private PreparedStatement getAllTipVenit;
    private PreparedStatement addTipVenit;
    private PreparedStatement getValoareForFacturaSiMagazie;
    private PreparedStatement getValoareDescarcareFactura;
    private PreparedStatement getPretAchizitieInViitorForStock;
    private Connection conn;

    public CommonsDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConn() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getValoareForFacturaSiMagazie = this.conn.prepareStatement("select sum(quantity * sell_price) as valoare from facturi_emise_items where id_factura = ? and id_magazie = ?");
        this.getValoareDescarcareFactura = this.conn.prepareStatement("select sum(val_iesita_pa) from fisa_magazie where id_magazie = ? and time_document = ?");
        this.getAllTipCheltuialaById = this.conn.prepareStatement("select * from tip_cheltuiala where id = ?");
        this.getAllTipCheltuiala = this.conn.prepareStatement("select * from tip_cheltuiala");
        this.getAllTipVenit = this.conn.prepareStatement("select * from tip_venit");
        this.addTipCheltuiala = this.conn.prepareStatement("insert into tip_cheltuiala ( analitic, label ) values ( ? , ? )");
        this.addTipVenit = this.conn.prepareStatement("insert into tip_venit ( analitic, label ) values ( ? , ? )");
        this.areFurnizorulNiruriInPerioada = this.conn.prepareStatement("select count(id) from facturi where status = 1 and id_furnizor = ? and dateadd >= ? and dateadd < ?");
        this.areClientulFacturiEmiseInPerioada = this.conn.prepareStatement("select count(id) from facturi_emise where status = 1 and id_client = ? and dateadd >= ? and dateadd < ?");
        String select = "select nir_entries.adaos_nou as adaos, nir_entries.ppuvtva_nou as ppuvtva, nir_entries.ppuv_nou as ppuv, messages.label as UM, stocks.label as denumire, stocks.id as ingredientId, factura_entries.cantitate_2 as cantitate, factura_entries.ppuc_nou as ppuc, tva.cota as cota, nir_entries.id as id_nir_entry, magazii.label as magazie, factura_entries.id as id_factura_entry, units.id as id_unit, tva.cota as tvaNir, nir_entries.id_magazie, factura_entries.id_tva, coalesce(loturi.id, -1) as id_lot from niruri inner join nir_entries on niruri.id = nir_entries.id_nir inner join factura_entries on nir_entries.id_factura_entry = factura_entries.id  inner join units on factura_entries.um = units.id  inner join stocks on (factura_entries.id_ingredient = stocks.id ) inner join facturi on factura_entries.id_factura = facturi.id  inner join tva on factura_entries.id_tva = tva.id  inner join keys on units.id_key = keys.id inner join messages on ( keys.id = messages.id_key and messages.id_lang = ? ) inner join magazii on nir_entries.id_magazie = magazii.id left outer join loturi on factura_entries.id_lot = loturi.id where niruri.id = ? order by nir_entries";
        this.getFullNirByBirId = this.conn.prepareStatement(select);
        this.getIntrariForIngredient = this.conn.prepareStatement("select ppuc_nou as ppuc, cantitate_2 as cantitate, ppuvtva_nou as ppuvtva, tva.cota as tvareceptie, factura_entries.id_ingredient as stock_id from factura_entries inner join facturi on factura_entries.id_factura = facturi.id inner join nir_entries on factura_entries.id = nir_entries.id_Factura_entry inner join tva on factura_entries.id_tva = tva.id where (id_ingredient = ? or ? = -1) and dateadd >= ? and dateadd <= ?  and facturi.status = 1 order by dateadd desc");
        this.getNiruriPlatforma = this.conn.prepareStatement("select distinct tva.cota as cota_tva, facturi.id as id_Factura, magazii.label as magazie, magazii.id as id_magazie, facturi.dateadd as data_factura, niruri.nr_nir as nr_nir, id_furnizor, tva.id as id_tva from facturi inner join factura_entries on facturi.id = factura_entries.id_factura inner join niruri on niruri.id_factura = facturi.id inner join nir_entries on niruri.id = nir_entries.id_nir inner join magazii on nir_entries.id_magazie = magazii.id inner join tva on factura_entries.id_tva = tva.id where facturi.dateadd >= ? and facturi.dateadd < ? order by facturi.dateadd, facturi.id, niruri.nr_nir, magazii.label");
        this.getTotalAczForFactura = this.conn.prepareStatement(" select sum(ppuc_nou * cantitate_2) as total_f_tva from factura_entries inner join nir_entries on factura_entries.id = nir_entries.id_factura_entry where id_factura = ? and nir_entries.id_magazie = ?");
        this.getTotalVzForFactura = this.conn.prepareStatement("select sum(ppuvtva_nou * cantitate_2) as total_vz from nir_entries inner join factura_entries on nir_entries.id_factura_entry = factura_entries.id where factura_entries.id_factura = ? and nir_entries.id_magazie = ?");
        this.getProdusePerFurnizor = this.conn.prepareStatement("select distinct id_ingredient, stocks.label from facturi inner join factura_entries on facturi.id = factura_entries.id_factura inner join stocks on factura_entries.id_ingredient = stocks.id where (id_furnizor = ? or ? = -1) and (id_ingredient = ? or ? = -1 ) and stocks.status = 1");
        this.getPretAchizitieInViitorForStock = this.conn.prepareStatement("select val_intrata_pa / intrata as pret_achizitie from fisa_magazie where id_stock = ? and time_document > ? and intrata > 0 and val_intrata_pa > 0 order by time_document limit 1");
    }

    public double getPretAchizitieInViitorForStock(int idStock, Timestamp greaterThan) throws SQLException {
        double result = -1.0;
        this.getPretAchizitieInViitorForStock.setInt(1, idStock);
        this.getPretAchizitieInViitorForStock.setTimestamp(2, greaterThan);
        ResultSet rs = this.getPretAchizitieInViitorForStock.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public boolean areFurnizorulFacturiInPerioada(Timestamp start, Timestamp stop, int idFurnizor) throws SQLException {
        int count = 0;
        this.areFurnizorulNiruriInPerioada.setInt(1, idFurnizor);
        this.areFurnizorulNiruriInPerioada.setTimestamp(2, start);
        this.areFurnizorulNiruriInPerioada.setTimestamp(3, stop);
        ResultSet rs = this.areFurnizorulNiruriInPerioada.executeQuery();
        if (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        return count > 0;
    }

    public boolean areClientulFacturiEmiseInPerioada(Timestamp start, Timestamp stop, int idClient) throws SQLException {
        int count = 0;
        this.areClientulFacturiEmiseInPerioada.setInt(1, idClient);
        this.areClientulFacturiEmiseInPerioada.setTimestamp(2, start);
        this.areClientulFacturiEmiseInPerioada.setTimestamp(3, stop);
        ResultSet rs = this.areClientulFacturiEmiseInPerioada.executeQuery();
        if (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        return count > 0;
    }

    public Vector<Integer> getProdusePerFurnizor(int idFurnizor, int idStock) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getProdusePerFurnizor.setInt(1, idFurnizor);
        this.getProdusePerFurnizor.setInt(2, idFurnizor);
        this.getProdusePerFurnizor.setInt(3, idStock);
        this.getProdusePerFurnizor.setInt(4, idStock);
        ResultSet rs = this.getProdusePerFurnizor.executeQuery();
        while (rs.next()) {
            int id = rs.getInt(1);
            result.add(id);
        }
        rs.close();
        return result;
    }

    private double getTotalAczFactura(int idFactura, int idMagazie) throws SQLException {
        this.getTotalAczForFactura.setInt(1, idFactura);
        this.getTotalAczForFactura.setInt(2, idMagazie);
        ResultSet rs = this.getTotalAczForFactura.executeQuery();
        double totalFTva = 0.0;
        if (rs.next()) {
            totalFTva = rs.getDouble("total_f_tva");
        }
        rs.close();
        return totalFTva;
    }

    private double getTotalVzNir(int idFactura, int idMagazie) throws SQLException {
        double vz = 0.0;
        this.getTotalVzForFactura.setInt(1, idFactura);
        this.getTotalVzForFactura.setInt(2, idMagazie);
        ResultSet rs = this.getTotalVzForFactura.executeQuery();
        if (rs.next()) {
            vz = rs.getDouble("total_vz");
        }
        rs.close();
        return vz;
    }

    public Vector<ExportNirPlatforma> getExportNirPlatforma(Timestamp startDate, Timestamp stopDate) throws SQLException {
        Vector<ExportNirPlatforma> result = new Vector<ExportNirPlatforma>();
        this.getNiruriPlatforma.setTimestamp(1, startDate);
        this.getNiruriPlatforma.setTimestamp(2, stopDate);
        ResultSet rs = this.getNiruriPlatforma.executeQuery();
        while (rs.next()) {
            ExportNirPlatforma enp = new ExportNirPlatforma();
            enp.setIdNir(rs.getInt("id_factura"));
            enp.setMagazie(rs.getString("magazie"));
            enp.setIdMagazie(rs.getInt("id_magazie"));
            enp.setNrNir(rs.getString("nr_nir"));
            double cota = rs.getDouble("cota_tva");
            enp.setCota(cota);
            Date d = new Date(rs.getTimestamp("data_factura").getTime());
            enp.setDataFacturii(d);
            enp.setDataExpirarii(d);
            enp.setIdTva(rs.getInt("id_tva"));
            enp.setIdFurnizor(rs.getInt("id_furnizor"));
            result.add(enp);
        }
        rs.close();
        for (int i = 0; i < result.size(); ++i) {
            ExportNirPlatforma exportNirPlatforma = result.elementAt(i);
            double totalAcz = this.getTotalAczFactura(exportNirPlatforma.getIdNir(), exportNirPlatforma.getIdMagazie());
            double totalTva = FloatUtils.roundFloat(exportNirPlatforma.getCota() * totalAcz, 2);
            double vz = this.getTotalVzNir(exportNirPlatforma.getIdNir(), exportNirPlatforma.getIdMagazie());
            exportNirPlatforma.setTotalFTva(totalAcz);
            exportNirPlatforma.setTotalTva(totalTva);
            if (!(totalAcz > 0.0 && vz >= 0.0) && (!(totalAcz < 0.0) || !(vz <= 0.0))) continue;
            exportNirPlatforma.setValVz(vz);
        }
        return result;
    }

    public Vector<RaportIntrariEntry> getRaportIntrari(int idIngredient, int idFurnizor, Timestamp startDate, Timestamp stopDate, int whatToPrint, int idSocietateaNoastra, int comandaType, int idTag, int idMagazie) throws SQLException {
        Vector<RaportIntrariEntry> result = new Vector<RaportIntrariEntry>();
        int ficus = -1;
        switch (whatToPrint) {
            case 2: {
                ficus = 1;
                break;
            }
            case 3: {
                ficus = 0;
            }
        }
        String s = "select facturi.dateadd as data_factura, facturi.serie_factura as factura, niruri.nr_nir as nr_nir, factura_entries.ppuc_nou as pret_cumparare, nir_entries.ppuvtva_nou as pret_vanzare, stocks.label as nume_stock, factura_entries.ppuc_nou * factura_entries.cantitate_2 as valoare_cumparare, (factura_entries.ppuc_nou * factura_entries.cantitate_2 *tva_c.cota) as tva_cumparare, nir_entries.ppuvtva_nou * factura_entries.cantitate_2 as valoare_vanzare, factura_entries.cantitate_2 as cantitate, produse_finite.id as id_produs_finit, coalesce( (case when nir_entries.ppuvtva_nou < 0 then 0 else nir_entries.ppuvtva_nou end) * factura_entries.cantitate_2 / (1 + tva_v.cota) * tva_v.cota , 0) as tva_vanzare, (nir_entries.ppuvtva_nou * factura_entries.cantitate_2 - coalesce( (case when nir_entries.ppuvtva_nou < 0 then 0 else nir_entries.ppuvtva_nou end) * factura_entries.cantitate_2 / (1 + tva_v.cota) * tva_v.cota , 0)) - (factura_entries.ppuc_nou * factura_entries.cantitate_2) as adaos,  stocks.id as id_stock, id_furnizor, magazii.label as magazie from nir_entries inner join niruri on nir_entries.id_nir = niruri.id inner join factura_entries on nir_entries.id_factura_entry = factura_entries.id inner join facturi on factura_entries.id_factura = facturi.id inner join tva tva_c on factura_entries.id_tva = tva_c.id inner join stocks on factura_entries.id_ingredient = stocks.id inner join documente on facturi.id = documente.id_factura inner join magazii on magazii.id = nir_entries.id_magazie left outer join produse_finite on stocks.id = produse_finite.id_stock left outer join products on produse_finite.id_product = products.id  left outer join subcategories on products.id_subcategory = subcategories.id  left outer join tva tva_v on tva_v.id = subcategories.id_tva  where 1 = 1 " + (ficus > 0 ? " and documente.fiscal = " + ficus : "") + (idIngredient > 0 ? " and stocks.id = " + idIngredient : "") + (idFurnizor > 0 ? " and id_furnizor = " + idFurnizor : "") + (idSocietateaNoastra > 0 ? " and facturi.id_societatea_noastra = " + idSocietateaNoastra : "") + (comandaType > 0 ? " and documente.comanda_type = " + comandaType : "") + (idTag > 0 ? " and stocks.id in ( select id_stock from stocks_Tags where stocks_tags.id_Tag = " + idTag + " and stocks_tags.id_stock = stocks.id ) " : "") + " and facturi.dateadd >= '" + startDate + "' and facturi.dateadd < '" + stopDate + "'" + " and ( nir_entries.id_magazie = " + idMagazie + " or " + idMagazie + " = " + -1 + ") " + " order by stocks.label, id_furnizor";
        ResultSet rs = SqlUtils.executeQuery(s, this.conn);
        while (rs.next()) {
            RaportIntrariEntry e = new RaportIntrariEntry();
            e.setData(rs.getString("data_factura"));
            e.setDateadd(rs.getTimestamp("data_factura"));
            e.setFactura(rs.getString("factura"));
            e.setNrNir(rs.getString("nr_nir"));
            e.setIdFurnizor(rs.getInt("id_furnizor"));
            e.setIdStock(rs.getInt("id_stock"));
            e.setPretCumparare(rs.getDouble("pret_cumparare"));
            e.setStock(rs.getString("nume_stock"));
            e.setValoareCumparare(rs.getDouble("valoare_cumparare"));
            e.setCantitate(rs.getDouble("cantitate"));
            e.setTvaCumparare(rs.getDouble("tva_cumparare"));
            e.setMagazie(rs.getString("magazie"));
            int idFinit = rs.getInt("id_produs_finit");
            double sellPrice = 0.0;
            double sellValue = 0.0;
            double tvaVanzare = 0.0;
            double adaos = 0.0;
            boolean produsFinit = false;
            if (idFinit > 0) {
                sellPrice = rs.getDouble("pret_vanzare");
                sellValue = rs.getDouble("valoare_vanzare");
                tvaVanzare = rs.getDouble("tva_vanzare");
                adaos = rs.getDouble("adaos");
                produsFinit = true;
            }
            e.setProdusFinit(produsFinit);
            e.setValoareVanzare(sellValue);
            e.setPretVanzare(sellPrice);
            e.setTvaVanzare(tvaVanzare);
            e.setAdaos(adaos);
            result.add(e);
        }
        rs.close();
        return result;
    }

    private NirEntryFull getFullNirFromResultSet(ResultSet rs) throws SQLException {
        double cantitate = rs.getDouble("cantitate");
        double ppuc = rs.getDouble("ppuc");
        double totalTvaFurnizor = rs.getDouble("cota") * cantitate * ppuc;
        NirEntryFull f = new NirEntryFull(rs.getInt("id_nir_entry"), rs.getInt("id_factura_entry"), rs.getInt("ingredientId"), rs.getString("denumire"), rs.getString("UM"), cantitate, ppuc, rs.getDouble("adaos"), rs.getDouble("ppuv"), rs.getDouble("ppuvtva"), totalTvaFurnizor, rs.getInt("id_unit"), FloatUtils.roundFloat(rs.getDouble("tvaNir"), 2), rs.getInt("id_magazie"), rs.getString("magazie"), rs.getInt("id_tva"));
        f.setIdLot(rs.getInt("id_lot"));
        return f;
    }

    public Vector<NirEntryFull> getByNirId(int idNir, int idLang) throws SQLException {
        Vector<NirEntryFull> result = new Vector<NirEntryFull>();
        this.getFullNirByBirId.setInt(1, idLang);
        this.getFullNirByBirId.setInt(2, idNir);
        ResultSet rs = this.getFullNirByBirId.executeQuery();
        while (rs.next()) {
            NirEntryFull f = this.getFullNirFromResultSet(rs);
            result.add(f);
        }
        rs.close();
        return result;
    }

    public Map<Integer, Double> getIntrariForIngredient(int idIngredient, Timestamp start, Timestamp stop) throws SQLException {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        this.getIntrariForIngredient.setInt(1, idIngredient);
        this.getIntrariForIngredient.setInt(2, idIngredient);
        this.getIntrariForIngredient.setTimestamp(3, start);
        this.getIntrariForIngredient.setTimestamp(4, stop);
        ResultSet rs = this.getIntrariForIngredient.executeQuery();
        while (rs.next()) {
            double cotaTva = rs.getDouble("tvareceptie");
            int stock_id = rs.getInt("stock_id");
            Double tvaForStock = (Double)result.get(stock_id);
            if (tvaForStock != null) continue;
            tvaForStock = cotaTva;
            result.put(stock_id, tvaForStock);
        }
        rs.close();
        return result;
    }

    public TipCheltuiala getTipCheltuialaById(int id) throws SQLException {
        TipCheltuiala result = null;
        this.getAllTipCheltuialaById.setInt(1, id);
        ResultSet rs = this.getAllTipCheltuialaById.executeQuery();
        if (rs.next()) {
            result = new TipCheltuiala(rs.getInt("id"), rs.getString("analitic"), rs.getString("label"));
        }
        rs.close();
        return result;
    }

    public Vector getAllTipCheltuiala() throws SQLException {
        Vector<TipCheltuiala> result = new Vector<TipCheltuiala>();
        ResultSet rs = this.getAllTipCheltuiala.executeQuery();
        while (rs.next()) {
            TipCheltuiala tc = new TipCheltuiala(rs.getInt("id"), rs.getString("analitic"), rs.getString("label"));
            result.add(tc);
        }
        rs.close();
        return result;
    }

    public void addTipCheltuiala(String analitic, String label) throws SQLException {
        this.addTipCheltuiala.setString(1, analitic);
        this.addTipCheltuiala.setString(2, label);
        this.addTipCheltuiala.execute();
    }

    public Vector getAllTipVenit() throws SQLException {
        Vector<TipVenit> result = new Vector<TipVenit>();
        ResultSet rs = this.getAllTipVenit.executeQuery();
        while (rs.next()) {
            TipVenit tc = new TipVenit(rs.getInt("id"), rs.getString("analitic"), rs.getString("label"));
            result.add(tc);
        }
        rs.close();
        return result;
    }

    public void addTipVenit(String analitic, String label) throws SQLException {
        this.addTipVenit.setString(1, analitic);
        this.addTipVenit.setString(2, label);
        this.addTipVenit.execute();
    }

    public double getValoareVzCuTvaForFactura(int idFactura, int idMagazie) throws SQLException {
        double result = 0.0;
        this.getValoareForFacturaSiMagazie.setInt(1, idFactura);
        this.getValoareForFacturaSiMagazie.setInt(2, idMagazie);
        ResultSet rs = this.getValoareForFacturaSiMagazie.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public double getValoareConsumLaData(int idMagazie, Timestamp data) throws SQLException {
        double result = 0.0;
        this.getValoareDescarcareFactura.setInt(1, idMagazie);
        this.getValoareDescarcareFactura.setTimestamp(2, data);
        ResultSet rs = this.getValoareDescarcareFactura.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }
}

