/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ro.atreides.contabilitate.FacturaEntry;
import ro.atreides.utils.db.DaoInterface;

public class FacturaEntriesDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement delete;
    private PreparedStatement deleteAll;
    private PreparedStatement deleteByFacturaId;
    private PreparedStatement getUltimulPretAchizitie;
    private Connection conn;

    public FacturaEntriesDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConn() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.add = this.conn.prepareStatement("insert into factura_entries ( id_factura, id_ingredient, um, cantitate_2, ppuc_nou, ingredient_name, um_name, id_tva, id_lot ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.delete = this.conn.prepareStatement("delete from factura_entries where id = ?");
        this.deleteAll = this.conn.prepareStatement("delete from factura_entries");
        this.deleteByFacturaId = this.conn.prepareStatement("delete from factura_entries where id_factura = ?");
        this.getUltimulPretAchizitie = this.conn.prepareStatement("select ppuc_nou from factura_entries inner join facturi on factura_entries.id_factura = facturi.id where id_ingredient = ? order by dateadd desc");
    }

    public double getUltimulPretAchizitie(int idStock) throws SQLException {
        double result = 0.0;
        this.getUltimulPretAchizitie.setInt(1, idStock);
        ResultSet rs = this.getUltimulPretAchizitie.executeQuery();
        if (rs.next()) {
            result = rs.getDouble("ppuc_nou");
        }
        rs.close();
        return result;
    }

    public void deleteByFacturaId(int idFactura) throws SQLException {
        this.deleteByFacturaId.setInt(1, idFactura);
        this.deleteByFacturaId.execute();
    }

    public void deleteAll() throws SQLException {
        this.deleteAll.execute();
    }

    public void add(FacturaEntry fur) throws SQLException {
        this.add.setInt(1, fur.getIdFactura());
        this.add.setInt(2, fur.getIdProduct());
        this.add.setInt(3, fur.getIdUnit());
        this.add.setDouble(4, fur.getCantitate());
        this.add.setDouble(5, fur.getPpuc());
        this.add.setString(6, fur.getProduct());
        this.add.setString(7, fur.getUnit());
        this.add.setInt(8, fur.getIdTva());
        if (fur.getIdLot() > 0) {
            this.add.setInt(9, fur.getIdLot());
        } else {
            this.add.setNull(9, 4);
        }
        this.add.execute();
    }

    public void delete(int idFacturaEntry) throws SQLException {
        this.delete.setInt(1, idFacturaEntry);
        this.delete.execute();
    }
}

