/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.contabilitate.NirEntry;
import ro.atreides.utils.db.DaoInterface;

public class NirEntriesDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement selectAll;
    private PreparedStatement delete;
    private PreparedStatement getByNirId;
    private PreparedStatement deleteAllNirEntries;
    private PreparedStatement deleteByNirId;
    private PreparedStatement getByFacturaEntryId;
    private PreparedStatement getLastMagazieIntrare;
    private PreparedStatement getById;
    private Connection conn;

    public Connection getConn() {
        return this.conn;
    }

    public NirEntriesDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.add = this.conn.prepareStatement("insert into nir_entries ( id_nir, id_factura_entry, adaos_nou, ppuv_nou, ppuvtva_nou, id_magazie) values ( ?, ?, ?, ?, ?, ?)");
        this.selectAll = this.conn.prepareStatement("select * from nir_entries");
        this.delete = this.conn.prepareStatement("delete from nir_entries where id = ?");
        this.getByNirId = this.conn.prepareStatement("select * from nir_entries where id_nir = ?");
        this.deleteAllNirEntries = this.conn.prepareStatement("delete from nir_entries");
        this.deleteByNirId = this.conn.prepareStatement("delete from nir_entries where id_nir = ?");
        this.getByFacturaEntryId = this.conn.prepareStatement("select * from nir_entries where id_factura_entry = ?");
        this.getById = this.conn.prepareStatement("select * from nir_entries where id = ?");
        this.getLastMagazieIntrare = this.conn.prepareStatement("select id_magazie from nir_entries where id_factura_entry = (select max(id) from factura_entries where id_ingredient = ?)");
    }

    public int getLastMagazieIntrare(int idStock) throws SQLException {
        int result = -1;
        this.getLastMagazieIntrare.setInt(1, idStock);
        ResultSet rs = this.getLastMagazieIntrare.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void deleteByNirId(int idNir) throws SQLException {
        this.deleteByNirId.setInt(1, idNir);
        this.deleteByNirId.execute();
    }

    public void deleteAll() throws SQLException {
        this.deleteAllNirEntries.execute();
    }

    public void add(NirEntry fur) throws SQLException {
        this.add.setInt(1, fur.getIdNir());
        this.add.setInt(2, fur.getIdFacturaEntry());
        this.add.setDouble(3, fur.getAdaos());
        this.add.setDouble(4, fur.getPpu());
        this.add.setDouble(5, fur.getPputva());
        this.add.setInt(6, fur.getIdMagazie());
        this.add.execute();
    }

    public void delete(int idNirEntry) throws SQLException {
        this.delete.setInt(1, idNirEntry);
        this.delete.execute();
    }

    private NirEntry getFromResultSet(ResultSet rs) throws SQLException {
        NirEntry f = new NirEntry(rs.getInt("id"), rs.getInt("id_nir"), rs.getInt("id_factura_entry"), rs.getDouble("adaos_nou"), rs.getDouble("ppuv_nou"), rs.getDouble("ppuvtva_nou"), rs.getInt("id_magazie"));
        return f;
    }

    public Vector getAll() throws SQLException {
        Vector<NirEntry> result = new Vector<NirEntry>();
        ResultSet rs = this.selectAll.executeQuery();
        while (rs.next()) {
            NirEntry f = this.getFromResultSet(rs);
            result.add(f);
        }
        rs.close();
        return result;
    }

    public NirEntry getById(int idNirEntry) throws SQLException {
        NirEntry result = null;
        this.getById.setInt(1, idNirEntry);
        ResultSet rs = this.getById.executeQuery();
        if (rs.next()) {
            NirEntry f;
            result = f = this.getFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public NirEntry getByFacturaEntryId(int idFacturaEntry) throws SQLException {
        NirEntry result = null;
        this.getByFacturaEntryId.setInt(1, idFacturaEntry);
        ResultSet rs = this.getByFacturaEntryId.executeQuery();
        if (rs.next()) {
            NirEntry f;
            result = f = this.getFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector getByNirId(int idNir) throws SQLException {
        Vector<NirEntry> result = new Vector<NirEntry>();
        this.getByNirId.setInt(1, idNir);
        ResultSet rs = this.getByNirId.executeQuery();
        while (rs.next()) {
            NirEntry f = this.getFromResultSet(rs);
            result.add(f);
        }
        rs.close();
        return result;
    }
}

