/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.contabilitate.IncasariClientiEntry;
import ro.atreides.contabilitate.RegistruCasaEntry;
import ro.atreides.contabilitate.TipRegistru;
import ro.atreides.facturi.FacturatEntry;
import ro.atreides.facturi.FacturatKey;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.db.DaoInterface;

public class RegCasaDao
implements DaoInterface {
    private PreparedStatement addEntry;
    private PreparedStatement getEntries;
    private PreparedStatement deleteEntry;
    private PreparedStatement deleteAllEntries;
    private PreparedStatement getAllTipRegistru;
    private PreparedStatement getSoldLaData;
    private PreparedStatement addFisaPlata;
    private PreparedStatement addDetaliereIncasari;
    private PreparedStatement getTotalIncasariInPerioada;
    private PreparedStatement getTotalIncasariAferentePerioada;
    private PreparedStatement getIncasariInPerioada;
    private PreparedStatement getPlatiInPerioada;
    private PreparedStatement getTotalIncasariInPerioadaForCategorie;
    private PreparedStatement getTotalIncasariAferentePerioadaForCategorie;
    private PreparedStatement getTipRegistruForTipPlataAndLocatie;
    private PreparedStatement getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData;
    private PreparedStatement areFurnizorulActeCasaInPerioada;
    private PreparedStatement areClientulActeCasaInPerioada;
    private Connection conn;

    public Connection getConn() {
        return this.conn;
    }

    public RegCasaDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getTipRegistruForTipPlataAndLocatie = this.conn.prepareStatement("select tip_regcasa.id as id_registru, messages.label as label_registru, cont from tip_regcasa inner join keys on tip_regcasa.id_key = keys.id inner join messages on messages.id_key = keys.id where messages.id_lang = ? and id_tip_plata = ? and (id_locatie = ? or ? = -1)");
        this.getTotalIncasariAferentePerioadaForCategorie = this.conn.prepareStatement("select sum(facturi_emise_plati.platit) as total_plati, id_client,  (valoare_tva / quantity / SELL_PRICE_FARA_TVA) as cota_tva  from facturi_emise_plati inner join fisa_plati on facturi_emise_plati.id_fisa_plati = fisa_plati.id inner join facturi_emise_items on facturi_emise_plati.id_facturi_emise_items = facturi_emise_items.id inner join facturi_emise on facturi_emise_items.id_factura = facturi_emise.id inner join products on facturi_emise_items.id_product = products.id where facturi_emise.dateadd >= ? and facturi_emise.dateadd < ? and facturi_emise.status = 1 and (products.id_subcategory = ? or ? = -1) group by id_client, valoare_tva / quantity / SELL_PRICE_FARA_TVA");
        this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData = this.conn.prepareStatement("select sum(facturi_emise_plati.platit) as total_plati, id_client,  (valoare_tva / quantity / SELL_PRICE_FARA_TVA) as cota_tva  from facturi_emise_plati inner join fisa_plati on facturi_emise_plati.id_fisa_plati = fisa_plati.id inner join facturi_emise_items on facturi_emise_plati.id_facturi_emise_items = facturi_emise_items.id inner join facturi_emise on facturi_emise_items.id_factura = facturi_emise.id inner join products on facturi_emise_items.id_product = products.id inner join regcasa on fisa_plati.id_regcasa = regcasa.id where facturi_emise.dateadd >= ? and facturi_emise.dateadd < ? and facturi_emise.status = 1 and regcasa.data < ? and (products.id_subcategory = ? or ? = -1) group by id_client, valoare_tva / quantity / SELL_PRICE_FARA_TVA");
        this.getTotalIncasariInPerioadaForCategorie = this.conn.prepareStatement("select sum(facturi_emise_plati.platit) as total_plati, id_client,  (valoare_tva / quantity / SELL_PRICE_FARA_TVA) as cota_tva  from facturi_emise_plati inner join fisa_plati on facturi_emise_plati.id_fisa_plati = fisa_plati.id inner join regcasa on fisa_plati.id_regcasa = regcasa.id inner join facturi_emise_items on facturi_emise_plati.id_facturi_emise_items = facturi_emise_items.id inner join facturi_emise on facturi_emise_items.id_factura = facturi_emise.id inner join products on facturi_emise_items.id_product = products.id where regcasa.data >= ? and regcasa.data < ? and facturi_emise.status = 1 and (products.id_subcategory = ? or ? = -1) group by id_client, valoare_tva / quantity / SELL_PRICE_FARA_TVA");
        this.getTotalIncasariAferentePerioada = this.conn.prepareStatement("select sum(fisa_plati.suma) as total_plati, id_client from regcasa inner join fisa_plati on regcasa.id = fisa_plati.id_regcasa inner join facturi_emise on fisa_plati.id_factura_emisa = facturi_emise.id where facturi_emise.dateadd >= ? and facturi_emise.dateadd < ? and (facturi_emise.id_client = ? or ? = -1) and facturi_emise.status = 1 and regcasa.data < ?  group by id_client");
        this.getTotalIncasariInPerioada = this.conn.prepareStatement("select sum(fisa_plati.suma) as total_plati, id_client  from regcasa inner join fisa_plati on regcasa.id = fisa_plati.id_regcasa inner join facturi_emise on fisa_plati.id_factura_emisa = facturi_emise.id where regcasa.data >= ? and regcasa.data < ? and (facturi_emise.id_client = ? or ? = -1) and facturi_emise.status = 1 group by id_client");
        this.getIncasariInPerioada = this.conn.prepareStatement("select fisa_plati.suma as total_plati, facturi_emise.id_client as id_client, regcasa.data as data, facturi_emise.numar as numar  from regcasa inner join fisa_plati on regcasa.id = fisa_plati.id_regcasa inner join facturi_emise on fisa_plati.id_factura_emisa = facturi_emise.id where ( fiscal = ? or ? = -1) and regcasa.data >= ? and regcasa.data < ? and (facturi_emise.id_client = ? or ? = -1) and facturi_emise.status = 1");
        this.getPlatiInPerioada = this.conn.prepareStatement("select fisa_plati.suma as total_plati, facturi.id_furnizor as id_furnizor, regcasa.data as data, facturi.serie_factura as serie  from regcasa inner join fisa_plati on regcasa.id = fisa_plati.id_regcasa inner join facturi on fisa_plati.id_factura = facturi.id where ( fiscal = ? or ? = -1) and regcasa.data >= ? and regcasa.data < ? and (facturi.id_furnizor = ? or ? = -1) and facturi.status = 1");
        this.addEntry = this.conn.prepareStatement("insert into regcasa (id_cont, data, act_casa, anexa, explicatii, incasare, plata, fiscal, id_tva) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.getEntries = this.conn.prepareStatement("select regcasa.id,id_cont,data,act_casa,anexa,explicatii,incasare,plata,fiscal,coalesce(id_tva, -1) as id_tva_bun, messages.label as nume_cont from regcasa inner join tip_regcasa on regcasa.id_cont = tip_regcasa.id inner join keys on tip_regcasa.id_key= keys.id inner join messages on (keys.id = messages.id_key and id_lang = 1 ) where (id_cont = ? or ? = -1) and data >= ? and data <= ? and ( fiscal = ? or ? = -1) order by data");
        this.deleteEntry = this.conn.prepareStatement("delete from regcasa where id = ?");
        this.deleteAllEntries = this.conn.prepareStatement("delete from regcasa where id_cont = ?");
        this.getAllTipRegistru = this.conn.prepareStatement("select tip_regcasa.id as id_registru, messages.label as label_registru, cont from tip_regcasa inner join keys on tip_regcasa.id_key = keys.id inner join messages on messages.id_key = keys.id where messages.id_lang = ?");
        this.getSoldLaData = this.conn.prepareStatement("select sum(incasare - plata) from regcasa where data < ? and (id_cont = ? or ? = -1) and ( fiscal = ? or ? = -1)");
        this.addFisaPlata = this.conn.prepareStatement("insert into fisa_plati (id_regcasa, id_factura, id_factura_emisa, suma)  values ( ?, ?, ?, ?)");
        this.addDetaliereIncasari = this.conn.prepareStatement("insert into facturi_emise_plati (id_facturi_emise_items, id_fisa_plati, platit ) values ( ?, ? , ? ) ");
        this.areFurnizorulActeCasaInPerioada = this.conn.prepareStatement("select count(regcasa.id) from regcasa inner join fisa_plati on regcasa.id = fisa_plati.id_regcasa inner join facturi on fisa_plati.id_factura = facturi.id where facturi.id_furnizor = ? and regcasa.data >= ? and regcasa.data < ?");
        this.areClientulActeCasaInPerioada = this.conn.prepareStatement("select count(regcasa.id) from regcasa inner join fisa_plati on regcasa.id = fisa_plati.id_regcasa inner join facturi_emise on fisa_plati.id_factura_emisa = facturi_emise.id where facturi_emise.id_client = ? and regcasa.data >= ? and regcasa.data < ?");
    }

    public Vector getIncasariInPerioada(Timestamp start, Timestamp stop, int idClient, int what) throws SQLException {
        Vector<IncasariClientiEntry> result = new Vector<IncasariClientiEntry>();
        int f1 = -1;
        switch (what) {
            case 2: {
                f1 = 1;
                break;
            }
            case 3: {
                f1 = 0;
                break;
            }
        }
        this.getIncasariInPerioada.setInt(1, f1);
        this.getIncasariInPerioada.setInt(2, f1);
        this.getIncasariInPerioada.setTimestamp(3, start);
        this.getIncasariInPerioada.setTimestamp(4, stop);
        this.getIncasariInPerioada.setInt(5, idClient);
        this.getIncasariInPerioada.setInt(6, idClient);
        ResultSet rs = this.getIncasariInPerioada.executeQuery();
        while (rs.next()) {
            Timestamp ts = rs.getTimestamp("data");
            String d = Formatters.DATE_FORMAT_RO.format(ts);
            IncasariClientiEntry ice = new IncasariClientiEntry(rs.getInt("id_client"), rs.getString("numar"), d, rs.getDouble("total_plati"));
            result.add(ice);
        }
        rs.close();
        return result;
    }

    public Vector getPlatiInPerioada(Timestamp start, Timestamp stop, int idFurnizor, int what) throws SQLException {
        Vector<IncasariClientiEntry> result = new Vector<IncasariClientiEntry>();
        int f1 = -1;
        switch (what) {
            case 2: {
                f1 = 1;
                break;
            }
            case 3: {
                f1 = 0;
                break;
            }
        }
        this.getPlatiInPerioada.setInt(1, f1);
        this.getPlatiInPerioada.setInt(2, f1);
        this.getPlatiInPerioada.setTimestamp(3, start);
        this.getPlatiInPerioada.setTimestamp(4, stop);
        this.getPlatiInPerioada.setInt(5, idFurnizor);
        this.getPlatiInPerioada.setInt(6, idFurnizor);
        ResultSet rs = this.getPlatiInPerioada.executeQuery();
        while (rs.next()) {
            Timestamp ts = rs.getTimestamp("data");
            String d = Formatters.DATE_FORMAT_RO.format(ts);
            IncasariClientiEntry ice = new IncasariClientiEntry(rs.getInt("id_furnizor"), rs.getString("serie"), d, rs.getDouble("total_plati"));
            result.add(ice);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, FacturatEntry> getTotalIncasariInPerioada(Timestamp start, Timestamp stop, int idClient) throws SQLException {
        Hashtable<Integer, FacturatEntry> result = new Hashtable<Integer, FacturatEntry>();
        this.getTotalIncasariInPerioada.setTimestamp(1, start);
        this.getTotalIncasariInPerioada.setTimestamp(2, stop);
        this.getTotalIncasariInPerioada.setInt(3, idClient);
        this.getTotalIncasariInPerioada.setInt(4, idClient);
        ResultSet rs = this.getTotalIncasariInPerioada.executeQuery();
        while (rs.next()) {
            FacturatEntry fe = new FacturatEntry();
            int idClient1 = rs.getInt("id_client");
            fe.setIdClient(idClient1);
            fe.setTotalFacturat(rs.getDouble(1));
            result.put(idClient1, fe);
        }
        rs.close();
        return result;
    }

    public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariInPerioadaForCategorie(Timestamp start, Timestamp stop, int idCategory) throws SQLException {
        Hashtable<FacturatKey, FacturatEntry> result = new Hashtable<FacturatKey, FacturatEntry>();
        this.getTotalIncasariInPerioadaForCategorie.setTimestamp(1, start);
        this.getTotalIncasariInPerioadaForCategorie.setTimestamp(2, stop);
        this.getTotalIncasariInPerioadaForCategorie.setInt(3, idCategory);
        this.getTotalIncasariInPerioadaForCategorie.setInt(4, idCategory);
        ResultSet rs = this.getTotalIncasariInPerioadaForCategorie.executeQuery();
        while (rs.next()) {
            double totalFacturat = rs.getDouble(1);
            if (Double.isNaN(totalFacturat)) continue;
            FacturatEntry fe = new FacturatEntry();
            int idClient1 = rs.getInt("id_client");
            fe.setIdClient(idClient1);
            fe.setTotalFacturat(totalFacturat);
            FacturatKey key = new FacturatKey();
            key.setCotaTva(FloatUtils.roundDouble(rs.getDouble("cota_tva"), 2));
            key.setIdClient(idClient1);
            result.put(key, fe);
        }
        rs.close();
        return result;
    }

    public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAferentePerioadaForCategorie(Timestamp start, Timestamp stop, int idCategory) throws SQLException {
        Hashtable<FacturatKey, FacturatEntry> result = new Hashtable<FacturatKey, FacturatEntry>();
        this.getTotalIncasariAferentePerioadaForCategorie.setTimestamp(1, start);
        this.getTotalIncasariAferentePerioadaForCategorie.setTimestamp(2, stop);
        this.getTotalIncasariAferentePerioadaForCategorie.setInt(3, idCategory);
        this.getTotalIncasariAferentePerioadaForCategorie.setInt(4, idCategory);
        ResultSet rs = this.getTotalIncasariAferentePerioadaForCategorie.executeQuery();
        while (rs.next()) {
            FacturatEntry fe = new FacturatEntry();
            int idClient1 = rs.getInt("id_client");
            fe.setIdClient(idClient1);
            fe.setTotalFacturat(rs.getDouble(1));
            FacturatKey key = new FacturatKey();
            key.setCotaTva(FloatUtils.roundDouble(rs.getDouble("cota_tva"), 2));
            key.setIdClient(idClient1);
            result.put(key, fe);
        }
        rs.close();
        return result;
    }

    public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData(Timestamp start, Timestamp stop, Timestamp stopIncasari, int idCategory) throws SQLException {
        Hashtable<FacturatKey, FacturatEntry> result = new Hashtable<FacturatKey, FacturatEntry>();
        this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData.setTimestamp(1, start);
        this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData.setTimestamp(2, stop);
        this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData.setTimestamp(3, stopIncasari);
        this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData.setInt(4, idCategory);
        this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData.setInt(5, idCategory);
        ResultSet rs = this.getTotalIncasariAferentePerioadaForCategorieCuPlatiPanaLaData.executeQuery();
        while (rs.next()) {
            FacturatEntry fe = new FacturatEntry();
            int idClient1 = rs.getInt("id_client");
            fe.setIdClient(idClient1);
            fe.setTotalFacturat(rs.getDouble(1));
            FacturatKey key = new FacturatKey();
            key.setCotaTva(FloatUtils.roundDouble(rs.getDouble("cota_tva"), 2));
            key.setIdClient(idClient1);
            result.put(key, fe);
        }
        rs.close();
        return result;
    }

    public Hashtable<FacturatKey, FacturatEntry> getTotalIncasariAferentePerioada(Timestamp start, Timestamp stop, Timestamp stopPlati, int idClient) throws SQLException {
        Hashtable<FacturatKey, FacturatEntry> result = new Hashtable<FacturatKey, FacturatEntry>();
        this.getTotalIncasariAferentePerioada.setTimestamp(1, start);
        this.getTotalIncasariAferentePerioada.setTimestamp(2, stop);
        this.getTotalIncasariAferentePerioada.setInt(3, idClient);
        this.getTotalIncasariAferentePerioada.setInt(4, idClient);
        this.getTotalIncasariAferentePerioada.setTimestamp(5, stopPlati);
        ResultSet rs = this.getTotalIncasariAferentePerioada.executeQuery();
        while (rs.next()) {
            FacturatEntry fe = new FacturatEntry();
            int idClient1 = rs.getInt("id_client");
            fe.setIdClient(idClient1);
            fe.setTotalFacturat(rs.getDouble(1));
            FacturatKey key = new FacturatKey();
            key.setCotaTva(0.0);
            key.setIdClient(idClient1);
            result.put(key, fe);
        }
        return result;
    }

    public boolean areFurnizorulPlatiInPerioada(Timestamp start, Timestamp stop, int idFurnizor) throws SQLException {
        int count = 0;
        this.areFurnizorulActeCasaInPerioada.setInt(1, idFurnizor);
        this.areFurnizorulActeCasaInPerioada.setTimestamp(2, start);
        this.areFurnizorulActeCasaInPerioada.setTimestamp(3, stop);
        ResultSet rs = this.areFurnizorulActeCasaInPerioada.executeQuery();
        if (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        return count > 0;
    }

    public boolean areClientulPlatiInPerioada(Timestamp start, Timestamp stop, int idCLient) throws SQLException {
        int count = 0;
        this.areClientulActeCasaInPerioada.setInt(1, idCLient);
        this.areClientulActeCasaInPerioada.setTimestamp(2, start);
        this.areClientulActeCasaInPerioada.setTimestamp(3, stop);
        ResultSet rs = this.areClientulActeCasaInPerioada.executeQuery();
        if (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        return count > 0;
    }

    public double getSoldLaData(Date start, int idCont, int what) throws SQLException {
        double result = 0.0;
        this.getSoldLaData.setTimestamp(1, new Timestamp(start.getTime()));
        this.getSoldLaData.setInt(2, idCont);
        this.getSoldLaData.setInt(3, idCont);
        this.getSoldLaData.setInt(4, what);
        this.getSoldLaData.setInt(5, what);
        ResultSet rs = this.getSoldLaData.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public Vector getAllTipRegistru(int idLanguage) throws SQLException {
        Vector<TipRegistru> result = new Vector<TipRegistru>();
        this.getAllTipRegistru.setInt(1, idLanguage);
        ResultSet rs = this.getAllTipRegistru.executeQuery();
        while (rs.next()) {
            TipRegistru tr = this.getTipRegistruFromResultSet(rs);
            result.add(tr);
        }
        rs.close();
        return result;
    }

    public TipRegistru getTipRegistruForTipPlataAndLocatie(int idTipPlata, int idLocatie, int idLanguage) throws SQLException {
        TipRegistru result = null;
        this.getTipRegistruForTipPlataAndLocatie.setInt(1, idLanguage);
        this.getTipRegistruForTipPlataAndLocatie.setInt(2, idTipPlata);
        this.getTipRegistruForTipPlataAndLocatie.setInt(3, idLocatie);
        this.getTipRegistruForTipPlataAndLocatie.setInt(4, idLocatie);
        ResultSet rs = this.getTipRegistruForTipPlataAndLocatie.executeQuery();
        if (rs.next()) {
            result = this.getTipRegistruFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    private TipRegistru getTipRegistruFromResultSet(ResultSet rs) throws SQLException {
        TipRegistru tr = new TipRegistru();
        tr.setId(rs.getInt("id_registru"));
        tr.setLabel(rs.getString("label_registru"));
        tr.setCont(rs.getString("cont"));
        return tr;
    }

    public void deleteAllRegistru(int tipCont) throws SQLException {
        this.deleteAllEntries.setInt(1, tipCont);
        this.deleteAllEntries.execute();
    }

    public Vector getTranzactii(Date start, Date stop, int idCont, int what) throws SQLException {
        Vector<RegistruCasaEntry> result = new Vector<RegistruCasaEntry>();
        this.getEntries.setInt(1, idCont);
        this.getEntries.setInt(2, idCont);
        this.getEntries.setTimestamp(3, new Timestamp(start.getTime()));
        this.getEntries.setTimestamp(4, new Timestamp(stop.getTime()));
        this.getEntries.setInt(5, what);
        this.getEntries.setInt(6, what);
        ResultSet rs = this.getEntries.executeQuery();
        while (rs.next()) {
            Timestamp d = rs.getTimestamp("data");
            double incasare = rs.getDouble("incasare");
            double plata = rs.getDouble("plata");
            boolean isIncasare = incasare > 0.0;
            boolean isPlata = plata > 0.0;
            int idCotaTva = rs.getInt("id_tva_bun");
            RegistruCasaEntry re = new RegistruCasaEntry(rs.getInt("id"), rs.getInt("id_cont"), rs.getString("act_casa"), rs.getString("anexa"), rs.getString("explicatii"), incasare, plata, d, isIncasare, isPlata, idCotaTva, rs.getString("nume_cont"));
            result.add(re);
        }
        rs.close();
        return result;
    }

    public void addEntry(int idCont, String act, String anexa, String expl, double incasari, double plati, Date data, int fiscal, int idTva) throws SQLException {
        this.addEntry.setInt(1, idCont);
        this.addEntry.setTimestamp(2, new Timestamp(data.getTime()));
        this.addEntry.setString(3, act);
        this.addEntry.setString(4, anexa);
        this.addEntry.setString(5, expl);
        this.addEntry.setDouble(6, incasari);
        this.addEntry.setDouble(7, plati);
        this.addEntry.setInt(8, fiscal);
        if (idTva > 0) {
            this.addEntry.setInt(9, idTva);
        } else {
            this.addEntry.setNull(9, 4);
        }
        this.addEntry.execute();
    }

    public void addFisaPlata(int idRegCasa, int idFacturaPrimita, int idFacturaEmisa, double suma) throws SQLException {
        this.addFisaPlata.setInt(1, idRegCasa);
        if (idFacturaPrimita <= 0) {
            this.addFisaPlata.setNull(2, 4);
        } else {
            this.addFisaPlata.setInt(2, idFacturaPrimita);
        }
        if (idFacturaEmisa <= 0) {
            this.addFisaPlata.setNull(3, 4);
        } else {
            this.addFisaPlata.setInt(3, idFacturaEmisa);
        }
        this.addFisaPlata.setDouble(4, suma);
        this.addFisaPlata.execute();
    }

    public void deleteRegCasaEntry(int id) throws SQLException {
        this.deleteEntry.setInt(1, id);
        this.deleteEntry.execute();
    }

    public void addDetaliereIncasare(int idFisaPlata, int idFacturaEmisaEntry, double suma) throws SQLException {
        this.addDetaliereIncasari.setInt(1, idFacturaEmisaEntry);
        this.addDetaliereIncasari.setInt(2, idFisaPlata);
        this.addDetaliereIncasari.setDouble(3, suma);
        this.addDetaliereIncasari.execute();
    }
}

