/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.export.saga;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.FacturiEntry;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.export.NotaContabila;
import ro.atreides.contabilitate.saga.SagaExportLogic;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.TipArticol;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ContaExportMapping;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ProductPriceInterface;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.dbf.DBFException;
import ro.atreides.utils.dbf.DBFField;
import ro.atreides.utils.dbf.DBFWriter;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class ExportSaga {
    public static void exportNoteContabile(Vector noteContabile, String filename) throws DBFException, IOException {
        DBFField[] fields = new DBFField[9];
        int i = 0;
        fields[i] = new DBFField();
        fields[i].setName("NDP");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(10);
        fields[++i] = new DBFField();
        fields[i].setName("CONT_D");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(20);
        fields[++i] = new DBFField();
        fields[i].setName("CONT_C");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(20);
        fields[++i] = new DBFField();
        fields[i].setName("SUMA");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(15);
        fields[i].setDecimalCount(2);
        fields[++i] = new DBFField();
        fields[i].setName("CURS");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(15);
        fields[i].setDecimalCount(4);
        fields[++i] = new DBFField();
        fields[i].setName("SUMA_VAL");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(14);
        fields[i].setDecimalCount(2);
        fields[++i] = new DBFField();
        fields[i].setName("DATA");
        fields[i].setDataType((byte)68);
        fields[++i] = new DBFField();
        fields[i].setName("EXPLICATIE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(48);
        fields[++i] = new DBFField();
        fields[i].setName("GRUPA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        DBFWriter writer = new DBFWriter();
        writer.setFields(fields);
        for (NotaContabila fur : noteContabile) {
            Object[] data = new Object[]{fur.getNumarArticolContabil(), fur.getContDebitor(), fur.getContCreditor(), fur.getSuma(), 0.0, 0.0, fur.getData(), fur.getExplicatie(), fur.getGrupa()};
            writer.addRecord(data);
        }
        FileOutputStream fos = new FileOutputStream(filename);
        writer.write(fos);
        fos.close();
    }

    public static void exportFurnizori(Vector furnizori, String filename) throws DBFException, IOException {
        DBFField[] fields = new DBFField[10];
        int i = 0;
        fields[i] = new DBFField();
        fields[i].setName("COD");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(8);
        fields[++i] = new DBFField();
        fields[i].setName("DENUMIRE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(48);
        fields[++i] = new DBFField();
        fields[i].setName("COD_FISCAL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(13);
        fields[++i] = new DBFField();
        fields[i].setName("ANALITIC");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("ZS");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(3);
        fields[++i] = new DBFField();
        fields[i].setName("ADRESA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(48);
        fields[++i] = new DBFField();
        fields[i].setName("BANCA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(48);
        fields[++i] = new DBFField();
        fields[i].setName("CONT_BANCA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("FILIALA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("GRUPA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        DBFWriter writer = new DBFWriter();
        writer.setFields(fields);
        for (ClientPersJuridica cpj : furnizori) {
            Object[] data = new Object[10];
            String nume = cpj.toString().toUpperCase();
            if (!Validators.correctString(nume)) {
                Logger.logWarning("Export Saga", "Nume furnizor lipsa");
                continue;
            }
            String cod = cpj.getCodFurnizor().toUpperCase();
            if (!Validators.correctString(cod)) {
                Logger.logWarning("Export Saga", "Cod furnizor lipsa : " + nume);
                continue;
            }
            String cui = cpj.getCui().toUpperCase();
            if (!Validators.correctString(cui)) {
                Logger.logWarning("Export Saga", "CUI furnizor lipsa : " + nume);
                continue;
            }
            String analitic = cpj.getAnaliticFurnizor();
            if (!Validators.correctString(analitic)) {
                Logger.logWarning("Export Saga", "Analitic furnizor lipsa : " + nume);
                continue;
            }
            String adresa = cpj.getAddress1().toUpperCase();
            String banca = cpj.getBank().toUpperCase();
            String iban = cpj.getBankIban().toUpperCase();
            String filiala = "-";
            String grupa = "-";
            Double scadenta = cpj.getNrZileScadenta();
            data[0] = cod;
            data[1] = nume;
            data[2] = cui;
            data[3] = analitic;
            data[4] = scadenta;
            data[5] = adresa;
            data[6] = banca;
            data[7] = iban;
            data[8] = filiala;
            data[9] = grupa;
            writer.addRecord(data);
        }
        FileOutputStream fos = new FileOutputStream(filename);
        writer.write(fos);
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Stock> exportProduseFinite(Vector articole, String filename, ProductPriceInterface priceInterface) throws DBFException, IOException {
        Vector<Stock> missingTvaMateriiPrime = new Vector<Stock>();
        DBFField[] fields = new DBFField[10];
        int i = 0;
        fields[i] = new DBFField();
        fields[i].setName("COD");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("DENUMIRE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(60);
        fields[++i] = new DBFField();
        fields[i].setName("UM");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(5);
        fields[++i] = new DBFField();
        fields[i].setName("TVA");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(5);
        fields[i].setDecimalCount(2);
        fields[++i] = new DBFField();
        fields[i].setName("TIP");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(2);
        fields[++i] = new DBFField();
        fields[i].setName("DEN_TIP");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("PRET_VANZ");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(15);
        fields[i].setDecimalCount(4);
        fields[++i] = new DBFField();
        fields[i].setName("PRET_V_TVA");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(15);
        fields[i].setDecimalCount(4);
        fields[++i] = new DBFField();
        fields[i].setName("COD_BARE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("CANT_MIN");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(14);
        fields[i].setDecimalCount(3);
        DBFWriter writer = new DBFWriter();
        writer.setFields(fields);
        try {
            Map<Integer, Double> tvaMateriiPrime = ContaLogic.getInstance().getTvaForIntrariNoCommit(DateUtils.getStartOfDays(), DateUtils.getEndOfDays());
            for (Stock stock : articole) {
                Product p;
                Object[] data = new Object[10];
                ContaExportMapping mapping = ExportSaga.getMappingForStockIdWithAdding(stock.getId(), stock.getLabel());
                if (mapping == null) {
                    ConnectionPool.getInstance().rollBack();
                    Vector<Stock> vector = null;
                    return vector;
                }
                String s1 = mapping.getExternalCode();
                s1 = Utils.getStringMaxSize(8, s1, Character.valueOf('0'), true);
                data[0] = s1;
                data[1] = stock.getLabel().toUpperCase();
                Unit u = UnitsLogic.getInstance().getUnitByIdNoCommit(stock.getIdUnit());
                data[2] = u.getLabel();
                data[9] = stock.getWarningLevel();
                int idTipArticol = stock.getIdTipArticol();
                TipArticol tipArt = StockLogic.getInstance().getTipArticolByIdNoCommit(idTipArticol);
                if (tipArt == null || idTipArticol <= 1) {
                    missingTvaMateriiPrime.add(stock);
                    Logger.logDebug("SagaExportArticole", "TipArticolNesetatSauLipsa|" + stock.getLabel() + "|" + stock.getId());
                }
                if ((p = StockLogic.getInstance().getProductForStockNoCommit(stock.getId())) != null) {
                    String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProdNoCommit(p.getId());
                    Categorie c = NomeclaturaLogic.getInstance().getCategoryByIdNoCommit(p.getIdCategorie());
                    double pretVzCuTva = priceInterface.getPriceForProductNoCommit(p.getId());
                    int idTva = c.getIdTva();
                    Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(idTva);
                    double cota = tva.getCota();
                    data[3] = FloatUtils.roundDouble(cota * 100.0, 0);
                    data[4] = tipArt.getCod();
                    data[5] = "Marfuri";
                    double pretVzFaraTva = pretVzCuTva / (1.0 + cota);
                    data[6] = pretVzFaraTva;
                    data[7] = pretVzCuTva;
                    data[8] = codBare;
                    writer.addRecord(data);
                    continue;
                }
                Double tvaForCurrentStock = mapping.getTva();
                if ((tvaForCurrentStock == null || tvaForCurrentStock < 0.0) && (tvaForCurrentStock = tvaMateriiPrime.get(stock.getId())) != null) {
                    ContaLogic.getInstance().getWinmentorExportInterface().updateMappingTvaByIdStock(tvaForCurrentStock, stock.getId());
                }
                if (tvaForCurrentStock != null && tvaForCurrentStock >= 0.0) {
                    data[3] = FloatUtils.roundDoubleUp(tvaForCurrentStock * 100.0, 0);
                    data[4] = tipArt.getCod();
                    data[5] = tipArt.getNume();
                    data[8] = "";
                    writer.addRecord(data);
                    continue;
                }
                Logger.logDebug("SagaExportArticole", "LipsaCotaTva|" + stock.getLabel() + "|" + stock.getId());
                missingTvaMateriiPrime.add(stock);
            }
            ConnectionPool.getInstance().commit();
        }
        catch (SQLException e) {
            Logger.logException("ExportSaga", (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException("ExportSaga", (Exception)e1);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
        FileOutputStream fos = new FileOutputStream(filename);
        writer.write(fos);
        fos.close();
        return missingTvaMateriiPrime;
    }

    public static void exportClienti(Vector<Client> furnizori, String filename) throws DBFException, IOException {
        DBFField[] fields = new DBFField[25];
        int i = 0;
        fields[i] = new DBFField();
        fields[i].setName("COD");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(5);
        fields[++i] = new DBFField();
        fields[i].setName("DENUMIRE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(48);
        fields[++i] = new DBFField();
        fields[i].setName("COD_FISCAL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("REG_COM");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("ANALITIC");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("ZS");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(3);
        fields[++i] = new DBFField();
        fields[i].setName("DISCOUNT");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(5);
        fields[i].setDecimalCount(2);
        fields[++i] = new DBFField();
        fields[i].setName("ADRESA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(48);
        fields[++i] = new DBFField();
        fields[i].setName("JUDET");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("BANCA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("CONT_BANCA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("DELEGAT");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("BI_SERIE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(2);
        fields[++i] = new DBFField();
        fields[i].setName("BI_NUMAR");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(8);
        fields[++i] = new DBFField();
        fields[i].setName("BI_POL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("MASINA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("INF_SUPL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(100);
        fields[++i] = new DBFField();
        fields[i].setName("AGENT");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(4);
        fields[++i] = new DBFField();
        fields[i].setName("DEN_AGENT");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("GRUPA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("TIP_TERT");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(1);
        fields[++i] = new DBFField();
        fields[i].setName("TARA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(2);
        fields[++i] = new DBFField();
        fields[i].setName("TEL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(20);
        fields[++i] = new DBFField();
        fields[i].setName("EMAIL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(100);
        fields[++i] = new DBFField();
        fields[i].setName("IS_TVA");
        fields[i].setDataType((byte)76);
        fields[i].setFieldLength(1);
        DBFWriter writer = new DBFWriter();
        writer.setFields(fields);
        for (Client client : furnizori) {
            if (client instanceof ClientPersFizica) continue;
            ClientPersJuridica cpj = (ClientPersJuridica)client;
            Object[] data = new Object[25];
            String nume = cpj.toString();
            if (!Validators.correctString(nume)) {
                Logger.logWarning("Export Saga", "Nume client lipsa");
                continue;
            }
            String cod = cpj.getCodClient();
            if (!Validators.correctString(cod)) {
                Logger.logWarning("Export Saga", "Cod client lipsa : " + nume);
                continue;
            }
            String cui = cpj.getCui();
            if (!Validators.correctString(cui)) {
                Logger.logWarning("Export Saga", "CUI client lipsa : " + nume);
                continue;
            }
            String analitic = cpj.getAnaliticClient();
            if (!Validators.correctString(analitic)) {
                Logger.logWarning("Export Saga", "Analitic client lipsa : " + nume);
                continue;
            }
            String adresa = cpj.getAddress1();
            Double scadenta = cpj.getNrZileScadenta();
            data[0] = cod;
            data[1] = nume;
            data[2] = cui;
            data[3] = cpj.getJ();
            data[4] = analitic;
            data[5] = scadenta;
            data[6] = 0.0;
            data[7] = adresa;
            data[8] = "";
            data[9] = cpj.getBank();
            data[10] = cpj.getBankIban();
            data[11] = "";
            data[12] = "";
            data[13] = "";
            data[14] = "";
            data[15] = "";
            data[16] = "";
            data[17] = "";
            data[18] = "";
            data[19] = "";
            data[20] = "I";
            data[21] = "RO";
            data[22] = cpj.getTelefoane(",");
            data[23] = cpj.getEmail();
            data[24] = true;
            writer.addRecord(data);
        }
        FileOutputStream fos = new FileOutputStream(filename);
        writer.write(fos);
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBonuriConsum(String filename, Date start, Date stop) throws DBFException, IOException {
        DBFField[] fields = new DBFField[20];
        int i = 0;
        fields[i] = new DBFField();
        fields[i].setName("DATA");
        fields[i].setDataType((byte)68);
        fields[++i] = new DBFField();
        fields[i].setName("NR");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(10);
        fields[++i] = new DBFField();
        fields[i].setName("GESTIUNE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(4);
        fields[++i] = new DBFField();
        fields[i].setName("DEN_GEST");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("EXPLICATIE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(48);
        fields[++i] = new DBFField();
        fields[i].setName("COMANDA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("DEN_TIP");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(36);
        fields[++i] = new DBFField();
        fields[i].setName("DENUMIRE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(60);
        fields[++i] = new DBFField();
        fields[i].setName("COD");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("UM");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(5);
        fields[++i] = new DBFField();
        fields[i].setName("CANTITATE");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(14);
        fields[i].setDecimalCount(3);
        fields[++i] = new DBFField();
        fields[i].setName("PRET");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(15);
        fields[i].setDecimalCount(4);
        fields[++i] = new DBFField();
        fields[i].setName("VALOARE");
        fields[i].setDataType((byte)78);
        fields[i].setFieldLength(15);
        fields[i].setDecimalCount(2);
        fields[++i] = new DBFField();
        fields[i].setName("IS_PROD");
        fields[i].setDataType((byte)76);
        fields[i].setFieldLength(1);
        fields[++i] = new DBFField();
        fields[i].setName("PLAN");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(1);
        fields[++i] = new DBFField();
        fields[i].setName("SECTOR");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(1);
        fields[++i] = new DBFField();
        fields[i].setName("SURSA");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(1);
        fields[++i] = new DBFField();
        fields[i].setName("CATEGORIE");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(16);
        fields[++i] = new DBFField();
        fields[i].setName("CAPITOL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(1);
        fields[++i] = new DBFField();
        fields[i].setName("ARTICOL");
        fields[i].setDataType((byte)67);
        fields[i].setFieldLength(1);
        DBFWriter writer = new DBFWriter();
        writer.setFields(fields);
        try {
            Vector<Magazie> magazii = StockLogic.getInstance().getAllMagaziiNoCommit();
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            for (Date date : zile) {
                for (Magazie magazie : magazii) {
                    int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(SagaExportLogic.RegistreConstants.BON_CONSUM.getKey(), SagaExportLogic.RegistreConstants.BON_CONSUM.getNume(), true);
                    Hashtable<String, Object> searchCriteria = new Hashtable<String, Object>();
                    searchCriteria.put(Constants.START_KEY, start);
                    searchCriteria.put(Constants.STOP_KEY, stop);
                    searchCriteria.put("id_magazie", magazie.getId());
                    searchCriteria.put("finit_ingredient", -1);
                    searchCriteria.put("vanzare_achizitie", 2);
                    searchCriteria.put("Include produse sterse", 1);
                    Vector<TipDocument> allItems = StockLogic.getInstance().getDocumentInterface().getAllTipDocument();
                    String dbString = "";
                    for (TipDocument item : allItems) {
                        dbString = dbString + item.getTip();
                        dbString = dbString + ",";
                    }
                    if (dbString.length() > 0) {
                        dbString = dbString.substring(0, dbString.length() - 1);
                    }
                    searchCriteria.put("tip_document", dbString);
                    Vector<RaportGestiuneEntry> consumuri = StockLogic.getInstance().generateRaportGestiuneNoCommit(searchCriteria, true, 2);
                    for (RaportGestiuneEntry entry : consumuri) {
                        double cantIesita = entry.getCantIesita();
                        if (cantIesita == 0.0) {
                            System.out.println("Cant iesita is zero, ignore line");
                            continue;
                        }
                        double pret = entry.getValIesitaAcz() / cantIesita;
                        int idStoc = entry.getIdStoc();
                        if (idStoc == 0) {
                            System.out.println("id stoc is 0");
                        }
                        String denTip = Config.getInstance().getStringNoCommit("contaTipContabilMateriiPrime");
                        if (StockLogic.getInstance().isProdusFinitNoCommit(idStoc)) {
                            denTip = Config.getInstance().getStringNoCommit("contaTipContabilMarfuri");
                        }
                        String um = entry.getUm();
                        ContaExportMapping mapping = ExportSaga.getMappingForStockIdWithAdding(idStoc, entry.getProdus());
                        if (mapping == null) {
                            ConnectionPool.getInstance().rollBack();
                            return;
                        }
                        String codProdus = mapping.getExternalCode();
                        codProdus = Utils.getStringMaxSize(8, codProdus, Character.valueOf('0'), true);
                        String gestiune = magazie.getLabel();
                        String codGestiune = magazie.getContMateriiPrime();
                        if (!Validators.correctString(codGestiune)) {
                            codGestiune = gestiune;
                        }
                        Object[] data = new Object[]{date, nrDoc + "", codGestiune, gestiune, "", "", denTip, entry.getProdus(), codProdus, um, cantIesita, pret, entry.getValIesitaAcz(), false, "", "", "", "", "", ""};
                        writer.addRecord(data);
                    }
                }
            }
            FileOutputStream fos = new FileOutputStream(filename);
            writer.write(fos);
            fos.close();
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException("ExportSaga", e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException("ExportSaga", e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private static ContaExportMapping getMappingForStockIdWithAdding(int idStoc, String stocName) throws SQLException {
        ContaExportMapping mapping = ContaLogic.getInstance().getWinmentorExportInterface().getContaExportMappingForIdStock(idStoc);
        while (mapping == null) {
            Logger.logInfo("ExportSaga", "Nu am gasit codul extern pentru stoc : " + stocName + ", id " + idStoc);
            ContaLogic.getInstance().getWinmentorExportInterface().addContaExportMapping("", -1, idStoc);
            int idMapping = ConnectionPool.getInstance().getIdentityLocal();
            ContaLogic.getInstance().getWinmentorExportInterface().updateMappingById(idMapping + "", idMapping);
            mapping = ContaLogic.getInstance().getWinmentorExportInterface().getContaExportMappingForIdStock(idStoc);
        }
        return mapping;
    }

    private static ContaExportMapping getMappingForProductIdWithAdding(int idProduct, String productName) throws SQLException {
        ContaExportMapping mapping = ContaLogic.getInstance().getWinmentorExportInterface().getContaExportMappingForIdProduct(idProduct);
        while (mapping == null) {
            Logger.logInfo("ExportSaga", "Nu am gasit codul extern pentru product : " + productName + ", id " + idProduct);
            ContaLogic.getInstance().getWinmentorExportInterface().addContaExportMapping("", idProduct, -1);
            int idMapping = ConnectionPool.getInstance().getIdentityLocal();
            ContaLogic.getInstance().getWinmentorExportInterface().updateMappingById(idMapping + "", idMapping);
            mapping = ContaLogic.getInstance().getWinmentorExportInterface().getContaExportMappingForIdProduct(idProduct);
        }
        return mapping;
    }

    private static String exportSigleNir(Vector<Client> clientTvaLaIncasare, FacturiEntry facturiEntry, ContaLogic logic, boolean tvaLaIncasareEnabled) throws SQLException, IOException {
        String singleFacturaTemplateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "saga_factura_template.XML";
        String contentFacturaCurenta = FileUtils.readFileToString(singleFacturaTemplateFile);
        Factura f = logic.getFacturaById(facturiEntry.getIdFactura());
        Nir n = logic.getNirByFacturaId(f.getId());
        Vector<NirEntryFull> newData = logic.getDataForNirNoCommit(n.getId());
        int idFurnizor = f.getIdFurnizor();
        ClientPersJuridica cpj = (ClientPersJuridica)ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
        boolean partenerCuTvaLaIncasare = clientTvaLaIncasare.contains(cpj);
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizornume%%", TextUtils.escapeForXML(cpj.toString().toUpperCase()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizorcif%%", cpj.getCui().toUpperCase());
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizorJ%%", cpj.getJ().toUpperCase());
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizorcapital%%", "");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizoradresa%%", TextUtils.escapeForXML(cpj.getAddressAsString().toUpperCase()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizorbanca%%", TextUtils.escapeForXML(cpj.getBank().toUpperCase()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizoriban%%", cpj.getBankIban().toUpperCase());
        contentFacturaCurenta = contentFacturaCurenta.replace("%%furnizorinformatii%%", TextUtils.escapeForXML(""));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientnume%%", TextUtils.escapeForXML(""));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientcif%%", "");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientJ%%", "");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientcapital%%", "");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientadresa%%", TextUtils.escapeForXML(""));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientbanca%%", TextUtils.escapeForXML(""));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientiban%%", "");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%clientinformatii%%", TextUtils.escapeForXML(""));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturanumar%%", f.getSerieFactura().toUpperCase());
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturadata%%", Formatters.DOTTED_DATE_FORMAT_RO.format(f.getDateadd()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturascadenta%%", Formatters.DOTTED_DATE_FORMAT_RO.format(f.getDataScadenta()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturataxareinversa%%", "NU");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturatvaincasare%%", partenerCuTvaLaIncasare || tvaLaIncasareEnabled ? "DA" : "NU");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturainformatii%%", "");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturamoneda%%", "RON");
        contentFacturaCurenta = contentFacturaCurenta.replace("%%facturagreutate%%", "0.000");
        String items = "";
        int j = 1;
        for (NirEntryFull nirEntryFull : newData) {
            ContaExportMapping mapping = ExportSaga.getMappingForStockIdWithAdding(nirEntryFull.getIngredientId(), nirEntryFull.getDenumireProdus());
            if (mapping == null) {
                ConnectionPool.getInstance().rollBack();
                return null;
            }
            double qty = nirEntryFull.getCant();
            double ppuc = nirEntryFull.getPpuc();
            String itemTemplate = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "saga_factura_template_line.XML";
            String item = FileUtils.readFileToString(itemTemplate);
            item = item.replace("%%nr%%", j + "");
            int idMagazie = nirEntryFull.getIdMagazie();
            Magazie magazie = StockLogic.getInstance().getMagazieByIdNoCommit(idMagazie);
            String gestiune = magazie.getLabel();
            String cod = magazie.getContMateriiPrime();
            if (Validators.correctString(cod)) {
                gestiune = cod;
            }
            String s1 = mapping.getExternalCode();
            s1 = Utils.getStringMaxSize(8, s1, Character.valueOf('0'), true);
            item = item.replace("%%gestiune%%", TextUtils.escapeForXML(gestiune.toUpperCase()));
            item = item.replace("%%denumire%%", TextUtils.escapeForXML(nirEntryFull.getDenumireProdus().toUpperCase()));
            item = item.replace("%%codarticolf%%", TextUtils.escapeForXML(s1));
            item = item.replace("%%codarticolc%%", TextUtils.escapeForXML(s1));
            item = item.replace("%%codbare%%", TextUtils.escapeForXML(""));
            item = item.replace("%%suplimentare%%", TextUtils.escapeForXML(""));
            item = item.replace("%%um%%", TextUtils.escapeForXML(nirEntryFull.getUm()));
            item = item.replace("%%cantitate%%", Utils.getString3Decimals(qty));
            item = item.replace("%%pretftva%%", Utils.getString2Decimals(ppuc));
            item = item.replace("%%valoareftva%%", Utils.getString2Decimals(nirEntryFull.getValoareCumparare()));
            item = item.replace("%%tva%%", Utils.getString2Decimals(nirEntryFull.getTvaFurnizorTotal()));
            int idTva = nirEntryFull.getIdTva();
            Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(idTva);
            double number = FloatUtils.roundDouble(tva.getCota(), 2);
            item = item.replace("%%proctva%%", Utils.getStringXDecimals(number *= 100.0, 0));
            items = items + item;
            ++j;
        }
        contentFacturaCurenta = contentFacturaCurenta.replace("%%sumarvaloare%%", Utils.getString2Decimals(f.getTotal()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%sumartva%%", Utils.getString2Decimals(f.getTotalTva()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%sumartotal%%", Utils.getString2Decimals(f.getTotalGeneral()));
        contentFacturaCurenta = contentFacturaCurenta.replace("%%lines%%", items);
        return contentFacturaCurenta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportNiruri(String exportDir, Date start, Date stop) {
        try {
            Vector clientTvaLaIncasare = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_tvaincasare", -1);
            boolean tvaLaIncasareEnabled = Config.getInstance().getBooleanNoCommit("contaTvaLaIncasareEnabled");
            String cuiNoi = Config.getInstance().getStringNoCommit("cui");
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            String facturiMultipleTemplateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "saga_facturi_multiple_template.XML";
            String content = FileUtils.readFileToString(facturiMultipleTemplateFile);
            for (Date date : zile) {
                Hashtable<String, Comparable<Date>> criteria = new Hashtable<String, Comparable<Date>>();
                Date startDay = DateUtils.getStartOfDay(date);
                Date endDay = DateUtils.getEndOfDay(date);
                criteria.put(Constants.START_KEY, startDay);
                criteria.put(Constants.STOP_KEY, endDay);
                criteria.put("facturi_furnizor_key", Integer.valueOf(-1));
                ContaLogic logic = ContaLogic.getInstance();
                Vector<FacturiEntry> facturi = logic.getFacturiNoCommit(criteria, 2);
                if (facturi.size() > 0) {
                    StringBuffer facturiContent = new StringBuffer();
                    for (FacturiEntry facturiEntry : facturi) {
                        String contentFacturaCurenta = ExportSaga.exportSigleNir(clientTvaLaIncasare, facturiEntry, logic, tvaLaIncasareEnabled);
                        if (contentFacturaCurenta == null) {
                            boolean bl = false;
                            return bl;
                        }
                        facturiContent.append("\n\n\n");
                        facturiContent.append(contentFacturaCurenta);
                        facturiContent.append("\n\n\n");
                    }
                    String dailyContent = content.replace("%%facturi%%", facturiContent);
                    String nirFIle = exportDir + File.separator + "F_" + cuiNoi + "_" + Formatters.SAGA_EXPORTTIME_FORMAT.format(new Date()) + "_" + Formatters.DATE_FORMAT_RO.format(date) + ".xml";
                    FileUtils.writeTextToFile(nirFIle, dailyContent.toString());
                }
                ConnectionPool.getInstance().commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException("ExportSaga", e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException("ExportSaga", e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }
}

