/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.TipRegistru;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.facturi.IncasareDetaliataEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.PlatiEntry;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.AddingCombo;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateAndTimeChooser;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.addingcombo.AddingItemInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class FacturiClientiReport
extends AbstractReportPanel {
    private JComboBox clientiCombo;
    private JComboBox editFacturaClientiCombo;
    private JComboBox tva;
    private JComboBox cont;
    private AddingCombo contVenituri;
    private JLabel totalDeIncasatLabel;
    private JLabel totalIncasatLabel;
    private JLabel totalFacturiLabel;
    private JTabbedPane tabs;
    private DateAndTimeChooser plataChooser;
    private DateAndTimeChooser chooser;
    private JTextField valoarePlata;
    private JTextField detaliiPlata;
    private JTextField anexaPlati;
    private JTextField serieFactura;
    private JTextField total;
    private JTextField totalTVA;
    private JTextField totalGeneral;
    private JTextField actCasaPlati;
    private JButton salveaza;
    private JButton renunta;
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private Hashtable searchCriteria = new Hashtable();
    private Vector plati = new Vector();
    private int tvaId = -1;
    private Factura toEdit = null;
    public static final String[] columns = new String[]{LangRoAll.data, LangRoAll.factura, LangRoAll.total, LangRoAll.incasat, "De incasat", "Incasam acum"};

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Object client = this.clientiCombo.getSelectedItem();
        if (ComboUtils.anythingButAllSelected(this.clientiCombo)) {
            Client c = (Client)client;
            this.searchCriteria.put(Constants.CLIENT_KEY, c.getId());
            this.printCriteria.put(Constants.CLIENT_KEY, c.toString());
        } else {
            this.searchCriteria.put(Constants.CLIENT_KEY, -1);
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        return this.searchCriteria;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        int idCLient = (Integer)criteria.get(Constants.CLIENT_KEY);
        Vector<FacturiNeplatiteEntry> facturiNeplatite = FacturiLogic.getInstance().getFacturiNeplatite(idCLient, this.whatToPrint);
        return facturiNeplatite;
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, Formatters.DATE_FORMAT_RO.format(fe.getDate()));
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, fe.getFactura());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getTotal()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getPlatit()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getDePlata()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getPlatimAcum()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FacturiClientiReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Evidenta clienti";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(6), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(fe.getDate());
                    }
                    case 1: {
                        return fe.getFactura();
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getPlatit());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getDePlata());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.getPlatimAcum());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 5;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                String v = (String)aValue;
                FacturiNeplatiteEntry fne = (FacturiNeplatiteEntry)data.elementAt(rowIndex);
                if (Validators.correctDouble(v)) {
                    double f = Utils.parseDouble(v);
                    f = FloatUtils.roundDoubleUp(f, 2);
                    Hashtable detaliereIncasari = ContaLogic.getInstance().getDetalierePlataPerProduse(fne.getIdFactura(), f, FacturiClientiReport.this.whatToPrint);
                    fne.setDetaliereIncasari(detaliereIncasari);
                    fne.setPlatimAcum(f);
                    FacturiClientiReport.this.updateTotalIncasareCurenta();
                }
            }
        });
        return this.tm;
    }

    private JPanel getTotaluriPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total facturi"), c);
        ++c.gridx;
        this.totalFacturiLabel = new JLabel("");
        result.add((Component)this.totalFacturiLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.incasat), c);
        ++c.gridx;
        this.totalIncasatLabel = new JLabel("");
        result.add((Component)this.totalIncasatLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("De incasat"), c);
        ++c.gridx;
        this.totalDeIncasatLabel = new JLabel("");
        result.add((Component)this.totalDeIncasatLabel, c);
        return result;
    }

    private JPanel getEditFacturaPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 5;
        this.editFacturaClientiCombo = new JComboBox();
        result.add((Component)this.editFacturaClientiCombo, c);
        c.gridwidth = 1;
        final FacturiClientiReport parent = this;
        c.gridx += 5;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.tva), c);
        this.tva = new JComboBox();
        ++c.gridx;
        result.add((Component)this.tva, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tip venit"), c);
        this.contVenituri = new AddingCombo(new AddingItemInterface(){

            @Override
            public void addButtonPressed() {
                String s = DialogUtils.inputDialog(parent, "", "Tip cheltuiala noua");
                String cont = DialogUtils.inputDialog(parent, "", "Cont Analitic sau sintetic");
                if (!Validators.correctString(s)) {
                    DialogUtils.errorDialog(parent, "Nu ati ales tipul de venit", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctString(cont)) {
                    if (!DialogUtils.confirmDialog(parent, "Nu ati ales contul. Continuam", LangRoAll.confirmare)) {
                        return;
                    }
                    cont = "";
                }
                ContaLogic.getInstance().addTipVenit(cont, s);
                FacturiClientiReport.this.reloadTipVenit();
            }
        });
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.contVenituri, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Serie si nr"), c);
        this.serieFactura = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.serieFactura, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.chooser = new DateAndTimeChooser("Alege data", false);
        result.add((Component)this.chooser, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.salveaza = new JButton(LangRoAll.adauga);
        this.salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int idSocietateaNoastra = -1;
                if (!Validators.correctString(FacturiClientiReport.this.serieFactura.getText())) {
                    DialogUtils.errorDialog(parent, "Completati seria", LangRoAll.nuPotContinua);
                    FacturiClientiReport.this.serieFactura.requestFocus();
                    return;
                }
                double t1 = 0.0;
                String st1 = FacturiClientiReport.this.total.getText();
                if (!Validators.correctDouble(st1)) {
                    DialogUtils.errorDialog(parent, "Completati totalul", LangRoAll.nuPotContinua);
                    FacturiClientiReport.this.total.requestFocus();
                    return;
                }
                t1 = Utils.parseDouble(st1);
                double t2 = 0.0;
                String st2 = FacturiClientiReport.this.totalTVA.getText();
                if (!Validators.correctDouble(st2)) {
                    DialogUtils.errorDialog(parent, "Completati total TVA", LangRoAll.nuPotContinua);
                    FacturiClientiReport.this.totalTVA.requestFocus();
                    return;
                }
                t2 = Utils.parseDouble(st2);
                double t3 = 0.0;
                String st3 = FacturiClientiReport.this.totalGeneral.getText();
                if (!Validators.correctDouble(st3)) {
                    DialogUtils.errorDialog(parent, "Completati total general", LangRoAll.nuPotContinua);
                    FacturiClientiReport.this.totalGeneral.requestFocus();
                    return;
                }
                t3 = Utils.parseDouble(st3);
                String s = FacturiClientiReport.this.serieFactura.getText();
                if (!Validators.correctInteger(s)) {
                    DialogUtils.errorDialog(parent, "Numar factura incorect", LangRoAll.nuPotContinua);
                    FacturiClientiReport.this.serieFactura.setText("");
                    FacturiClientiReport.this.serieFactura.requestFocus();
                    return;
                }
                Client c = (Client)FacturiClientiReport.this.editFacturaClientiCombo.getSelectedItem();
                Date d = FacturiClientiReport.this.chooser.getDateAndTime();
                Timestamp time = new Timestamp(d.getTime());
                if (FacturiClientiReport.this.toEdit == null) {
                    FacturiLogic.getInstance().addFactura(c.getId(), t1, t2, t3, "", Integer.parseInt(s), time, new Vector(), -1, time, 3, new Vector(), "", "", false, FacturiClientiReport.this.whatToPrint, idSocietateaNoastra, StockLogic.COMANDA_TYPE.EFECTUAT);
                } else {
                    FacturiEmiseView fev = new FacturiEmiseView();
                    fev.setIdFactura(FacturiClientiReport.this.toEdit.getId());
                    fev.setData(time);
                    FacturiLogic.getInstance().updateFactura(fev, c.getId(), t1, t2, t3, "", Integer.parseInt(s), time, time, new Vector(), 3, fev.getStatusFactura(), "", "", false, FacturiClientiReport.this.whatToPrint, idSocietateaNoastra, StockLogic.COMANDA_TYPE.EFECTUAT);
                }
                Hashtable o = FacturiLogic.getInstance().buildMapForNotify(t2, t3, "", time, s, c);
                o.put("id_client_key", c.getId());
                GenericListenersLogic.getInstance().notifyObjectListeners(0, o);
                FacturiClientiReport.this.setFacturaToEdit(null);
                FacturiClientiReport.this.raport();
            }
        });
        result.add((Component)this.salveaza, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        this.total = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.total, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Total tva"), c);
        this.totalTVA = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.totalTVA, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Total general"), c);
        this.totalGeneral = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.totalGeneral, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 0.0;
        this.renunta = new JButton(LangRoAll.renunta);
        this.renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FacturiClientiReport.this.setFacturaToEdit(null);
            }
        });
        result.add((Component)this.renunta, c);
        return result;
    }

    private JPanel getAddIncasarePanel() {
        final JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Act casa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.actCasaPlati = new JTextField(25);
        result.add((Component)this.actCasaPlati, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Valoare incasare"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.valoarePlata = new JTextField(25);
        this.valoarePlata.setEditable(false);
        result.add((Component)this.valoarePlata, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.cont = new JComboBox();
        result.add((Component)this.cont, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.plataChooser = new DateAndTimeChooser("Alege data incasarii");
        result.add((Component)this.plataChooser, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Numar anexa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.anexaPlati = new JTextField(25);
        result.add((Component)this.anexaPlati, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Explicatii"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.detaliiPlata = new JTextField(25);
        result.add((Component)this.detaliiPlata, c);
        ++c.gridx;
        JButton tiparesteChitanta = new JButton("Tipareste chitanta");
        tiparesteChitanta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacturiClientiReport.this.addIncasare(result, new AddIncasareInterface(){

                    @Override
                    public void doAction(String numar, double total, String expl, Date d, Client client) {
                        FacturiLogic.getInstance().tiparesteChitanta(numar, Formatters.DATE_FORMAT_RO.format(d), client, expl, Utils.getString2DecimalsNoTrunc(total));
                    }
                }, true);
            }
        });
        result.add((Component)tiparesteChitanta, c);
        ++c.gridx;
        JButton renunta = new JButton(LangRoAll.renunta);
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacturiClientiReport.this.actCasaPlati.setText("");
                FacturiClientiReport.this.valoarePlata.setText("");
                FacturiClientiReport.this.detaliiPlata.setText("");
                FacturiClientiReport.this.anexaPlati.setText("");
                FacturiClientiReport.this.plati.clear();
                FacturiClientiReport.this.raport();
            }
        });
        result.add((Component)renunta, c);
        ++c.gridx;
        c.weightx = 1.0;
        JButton set = new JButton(LangRoAll.adauga);
        set.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacturiClientiReport.this.addIncasare(result, new AddIncasareInterface(){

                    @Override
                    public void doAction(String numar, double total, String expl, Date d, Client client) {
                        Map o = ContaLogic.getInstance().buildIncasareClientMap(numar, expl, Formatters.DATE_FORMAT_RO.format(d), Utils.getString2Decimals(total), client.toString(), "");
                        o.put("id_client_key", client.getId());
                        GenericListenersLogic.getInstance().notifyObjectListeners(98, o);
                    }
                }, false);
            }
        });
        result.add((Component)set, c);
        result.setBorder(new TitledBorder("Adauga incasare"));
        return result;
    }

    private void addIncasare(JPanel result, AddIncasareInterface inter, boolean useSeriiChitante) {
        try {
            double total = Utils.parseDouble(this.valoarePlata.getText());
            String ac = this.actCasaPlati.getText();
            String exp = this.detaliiPlata.getText();
            String an = this.anexaPlati.getText();
            Client c = null;
            Integer idClient = (Integer)this.searchCriteria.get(Constants.CLIENT_KEY);
            if (idClient != null) {
                c = ClientLogic.getInstance().getClientById(idClient);
            }
            if (c == null) {
                DialogUtils.errorDialog(result, "Alegeti un client si dati Raport", LangRoAll.nuPotContinua);
                return;
            }
            if (!ComboUtils.anythingButAllSelected(this.cont)) {
                DialogUtils.errorDialog(result, "Alegeti contul destinatie", LangRoAll.nuPotContinua);
                this.cont.requestFocus();
                return;
            }
            TipRegistru tr = (TipRegistru)this.cont.getSelectedItem();
            int idCont = tr.getId();
            Date d = this.plataChooser.getDateAndTime();
            if (d == null) {
                return;
            }
            if (useSeriiChitante) {
                boolean i;
                if (!this.actCasaPlati.getText().isEmpty() && !(i = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Chitantele folosesc generare automata! Ceea ce ati introdus la Act casa nu va fi luat in considerare. Continuati", LangRoAll.atentie))) {
                    return;
                }
                Hashtable<String, String> serieSiNumarHash = FacturiLogic.getInstance().getSerieSiNumarChitanteForUser(GuiUtils.currentFrame, AdministrationPanel.loggedUser.getLogin());
                if (serieSiNumarHash != null) {
                    String serieChitanta = serieSiNumarHash.get("serie_chitanta");
                    String numarChitanta = serieSiNumarHash.get("numar_chitanta");
                    ac = serieChitanta + " " + numarChitanta;
                } else {
                    return;
                }
            }
            if (total != 0.0) {
                boolean fiscal = true;
                fiscal = this.whatToPrint != 3;
                ContaLogic.getInstance().addIncasare(total, ac, an, exp, idCont, d, this.plati, fiscal, this.tvaId);
                inter.doAction(ac, total, an, d, c);
            }
            this.raport();
            this.actCasaPlati.setText("");
            this.valoarePlata.setText("");
            this.detaliiPlata.setText("");
            this.anexaPlati.setText("");
        }
        catch (NumberFormatException e1) {
            DialogUtils.errorDialog(result, "Valoare incorecta", LangRoAll.nuPotContinua);
        }
    }

    @Override
    public JPanel buildTotalPanel() {
        this.tabs = new JTabbedPane();
        this.tabs.add("Totaluri", this.getTotaluriPanel());
        this.tabs.add("Incasare", this.getAddIncasarePanel());
        this.tabs.add("Detalii factura", this.getEditFacturaPanel());
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)this.tabs, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clientiCombo = new JComboBox();
        result.add((Component)this.clientiCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        double totalFacturi = 0.0;
        double totalPlatit = 0.0;
        double totalDePlata = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            FacturiNeplatiteEntry o = (FacturiNeplatiteEntry)this.data.elementAt(i);
            totalFacturi += o.getTotal();
            totalPlatit += o.getPlatit();
            totalDePlata += o.getDePlata();
        }
        this.totalFacturiLabel.setText(Utils.getString2Decimals(totalFacturi));
        this.totalIncasatLabel.setText(Utils.getString2Decimals(totalPlatit));
        this.totalDeIncasatLabel.setText(Utils.getString2Decimals(totalDePlata));
    }

    private void updateTotalIncasareCurenta() {
        double totalPlataCurenta = 0.0;
        String detalii = "";
        this.plati.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            FacturiNeplatiteEntry o = (FacturiNeplatiteEntry)this.data.elementAt(i);
            if (Utils.isValueZero(o.getPlatimAcum())) continue;
            totalPlataCurenta += o.getPlatimAcum();
            detalii = detalii + o.getFactura() + "-" + Utils.getString2Decimals(o.getPlatimAcum()) + ", ";
            PlatiEntry pe = new PlatiEntry();
            pe.setIdFactura(o.getIdFactura());
            pe.setSuma(o.getPlatimAcum());
            Hashtable h = o.getDetaliereIncasari();
            pe.setDetaliereIncasari(h);
            this.plati.add(pe);
        }
        if (!Utils.isValueZero(totalPlataCurenta)) {
            this.valoarePlata.setText(Utils.getString2Decimals(totalPlataCurenta));
            this.anexaPlati.setText(detalii);
            String furnizor = (String)this.printCriteria.get(Constants.CLIENT_KEY);
            this.detaliiPlata.setText(furnizor);
        }
        this.tabs.setSelectedIndex(1);
    }

    private void setFacturaToEdit(FacturiNeplatiteEntry fe) {
        this.serieFactura.setText("");
        this.totalGeneral.setText("");
        this.total.setText("");
        this.totalTVA.setText("");
        this.chooser.today();
        this.salveaza.setText(LangRoAll.adauga);
        this.toEdit = null;
        this.contVenituri.getCombo().setSelectedIndex(0);
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.clientiCombo, (Collection)ContaLogic.getInstance().getClientiNeRedadiati(-1), false);
        ComboUtils.replaceItemsForCombo(this.editFacturaClientiCombo, (Collection)ContaLogic.getInstance().getClientiNeRedadiati(-1), false);
        ComboUtils.replaceItemsForCombo(this.tva, TvaLogic.getInstance().getTvas(), false);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 2: {
                        return FacturiClientiReport.this.totalFacturiLabel.getText();
                    }
                    case 3: {
                        return FacturiClientiReport.this.totalIncasatLabel.getText();
                    }
                    case 4: {
                        return FacturiClientiReport.this.totalDeIncasatLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return FacturiClientiReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FacturiClientiReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)row;
                switch (column) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(fe.getDate());
                    }
                    case 1: {
                        return fe.getFactura();
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getPlatit());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getDePlata());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.getPlatimAcum());
                    }
                }
                return null;
            }
        };
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(FacturiClientiReport.this.clientiCombo, (Collection)ContaLogic.getInstance().getClientiNeRedadiati(-1), false);
                ComboUtils.replaceItemsForCombo(FacturiClientiReport.this.editFacturaClientiCombo, (Collection)ContaLogic.getInstance().getClientiNeRedadiati(-1), false);
            }

            @Override
            public String getName() {
                return "FacturiClientiReport_clienti";
            }
        }, 42);
        Vector tipRegistre = ContaLogic.getInstance().getAllTipRegistru(AdministrationPanel.loggedUser.getLanguage());
        ComboUtils.replaceItemsForCombo(this.cont, (Collection)tipRegistre, false);
        FacturiClientiReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)FacturiClientiReport.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem plataIntegrala = new JMenuItem("Incasare integrala");
                popup.add(plataIntegrala);
                plataIntegrala.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        double platimAcum = fe.getDePlata();
                        fe.setPlatimAcum(platimAcum);
                        Hashtable detaliereIncasari = ContaLogic.getInstance().getDetalierePlataPerProduse(fe.getIdFactura(), platimAcum, FacturiClientiReport.this.whatToPrint);
                        fe.setDetaliereIncasari(detaliereIncasari);
                        FacturiClientiReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                        FacturiClientiReport.this.updateTotalIncasareCurenta();
                        popup.setVisible(false);
                    }
                });
                JMenuItem plataDetaliata = new JMenuItem("Incasare detaliata pe produse");
                popup.add(plataDetaliata);
                plataDetaliata.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final Hashtable platiDetaliate = new Hashtable();
                        AbstractListPanel produsePanel = new AbstractListPanel(){

                            @Override
                            public String[] buildColumns() {
                                return new String[]{LangRoAll.produs, LangRoAll.valoare, LangRoAll.incasat, "Incasam acum", "Rest"};
                            }

                            @Override
                            public Vector buildData() {
                                Vector produse = FacturiLogic.getInstance().getDetaliiIncasare(fe.getIdFactura(), this.whatToPrint);
                                return produse;
                            }

                            @Override
                            public Class[] buildTypes() {
                                return Utils.getStringClass(5);
                            }

                            @Override
                            public JPanel getBottomPanel() {
                                return null;
                            }

                            @Override
                            public AbstractTM buildTableModel() {
                                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                                    @Override
                                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                                        IncasareDetaliataEntry ide = (IncasareDetaliataEntry)data.elementAt(rowIndex);
                                        switch (columnIndex) {
                                            case 0: {
                                                return ide.getProdus();
                                            }
                                            case 1: {
                                                return Utils.getString2Decimals(ide.getValoare());
                                            }
                                            case 2: {
                                                return Utils.getString2Decimals(ide.getIncasat());
                                            }
                                            case 3: {
                                                return Utils.getString2Decimals(ide.getIncasamAcum());
                                            }
                                            case 4: {
                                                return Utils.getString2Decimals(ide.getRest());
                                            }
                                        }
                                        return null;
                                    }

                                    @Override
                                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                                        return columnIndex == 3;
                                    }

                                    @Override
                                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                                        String s;
                                        IncasareDetaliataEntry ide = (IncasareDetaliataEntry)data.elementAt(rowIndex);
                                        if (columnIndex == 3 && Validators.correctDouble(s = (String)aValue)) {
                                            double f = Utils.parseDouble(s);
                                            ide.setIncasamAcum(f);
                                            tm.fireTableDataChanged();
                                            platiDetaliate.put(ide.getIdEntry(), f);
                                        }
                                    }
                                });
                                return this.tm;
                            }

                            @Override
                            public void doStuff() {
                                this.display();
                            }
                        };
                        produsePanel.doStuff();
                        produsePanel.refreshTable();
                        JDialog dialog = DialogUtils.getJDialogOKButton(produsePanel, GuiUtils.currentFrame, "", 1.1);
                        dialog.setVisible(true);
                        double total = 0.0;
                        Vector v = new Vector(platiDetaliate.values());
                        for (int i = 0; i < v.size(); ++i) {
                            Double f = (Double)v.elementAt(i);
                            total += f.doubleValue();
                        }
                        fe.setPlatimAcum(total);
                        fe.setDetaliereIncasari(platiDetaliate);
                        FacturiClientiReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                        FacturiClientiReport.this.updateTotalIncasareCurenta();
                        popup.setVisible(false);
                    }
                });
                popup.setInvoker(FacturiClientiReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.reloadTipVenit();
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void reloadTipVenit() {
        ComboUtils.replaceItemsForCombo(this.contVenituri.getCombo(), ContaLogic.getInstance().getAllTipVenit());
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    static interface AddIncasareInterface {
        public void doAction(String var1, double var2, String var4, Date var5, Client var6);
    }
}

