/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.TipCheltuiala;
import ro.atreides.contabilitate.TipRegistru;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.PlatiEntry;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.AddingCombo;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateAndTimeChooser;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.addingcombo.AddingItemInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class FacturiFurnizoriReport
extends AbstractReportPanel {
    private JComboBox furnizoriCombo;
    private JComboBox editFacturaFurnizoriCombo;
    private JComboBox tva;
    private JComboBox cont;
    private AddingCombo contCheltuieli;
    private JLabel totalDePlataLabel;
    private JLabel totalPlatitLabel;
    private JLabel totalFacturiLabel;
    private JTabbedPane tabs;
    private DateAndTimeChooser plataChooser;
    private DateAndTimeChooser chooser;
    private JTextField valoarePlata;
    private JTextField detaliiPlata;
    private JTextField anexaPlati;
    private JTextField serieFactura;
    private JTextField total;
    private JTextField totalTVA;
    private JTextField totalGeneral;
    private JButton salveaza;
    private JButton renunta;
    private JButton adaugaPlataButton;
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private Vector plati = new Vector();
    private Factura toEdit = null;
    public static final String[] columns = new String[]{LangRoAll.data, LangRoAll.factura, LangRoAll.total, "Platit", "De plata", "Platim acum"};
    private JTextField actCasaPlati;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Integer> result = new Hashtable<String, Integer>();
        Object furnizor = this.furnizoriCombo.getSelectedItem();
        if (ComboUtils.anythingButAllSelected(this.furnizoriCombo)) {
            Client f = (Client)furnizor;
            result.put("Furnizor", f.getId());
            this.printCriteria.put("Furnizor", f.toString());
        } else {
            result.put("Furnizor", -1);
            this.printCriteria.remove("Furnizor");
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        int idFurnizor = (Integer)criteria.get("Furnizor");
        Vector facturiNeplatite = ContaLogic.getInstance().getFacturiNeplatite(idFurnizor, this.whatToPrint);
        return facturiNeplatite;
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, Formatters.DATE_FORMAT_RO.format(fe.getDate()));
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, fe.getFactura());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getTotal()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getPlatit()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getDePlata()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getPlatimAcum()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FacturiFurnizoriReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Evidenta furnizori";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(6), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(fe.getDate());
                    }
                    case 1: {
                        return fe.getFactura();
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getPlatit());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getDePlata());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.getPlatimAcum());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 5;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                String v = (String)aValue;
                FacturiNeplatiteEntry fne = (FacturiNeplatiteEntry)data.elementAt(rowIndex);
                if (Validators.correctDouble(v)) {
                    double f = Utils.parseDouble(v);
                    fne.setPlatimAcum(f);
                    FacturiFurnizoriReport.this.updateTotalPlataCurenta();
                }
            }
        });
        return this.tm;
    }

    private JPanel getTotaluriPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total facturi"), c);
        ++c.gridx;
        this.totalFacturiLabel = new JLabel("");
        result.add((Component)this.totalFacturiLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Platit"), c);
        ++c.gridx;
        this.totalPlatitLabel = new JLabel("");
        result.add((Component)this.totalPlatitLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("De plata"), c);
        ++c.gridx;
        this.totalDePlataLabel = new JLabel("");
        result.add((Component)this.totalDePlataLabel, c);
        return result;
    }

    private JPanel getEditFacturaPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Furnizor"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 5;
        this.editFacturaFurnizoriCombo = new JComboBox();
        result.add((Component)this.editFacturaFurnizoriCombo, c);
        c.gridwidth = 1;
        final FacturiFurnizoriReport parent = this;
        c.gridx += 5;
        c.gridwidth = 2;
        JButton adaugaSiPlateste = new JButton("Adauga si achita");
        adaugaSiPlateste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idFactura = FacturiFurnizoriReport.this.adauga(parent);
                if (idFactura > 0) {
                    int selRow = 0;
                    for (FacturiNeplatiteEntry factura : FacturiFurnizoriReport.this.tm.getData()) {
                        if (factura.getIdFactura() == idFactura) {
                            factura.setPlatimAcum(factura.getDePlata());
                            FacturiFurnizoriReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                            FacturiFurnizoriReport.this.actCasaPlati.setText(factura.getFactura());
                            FacturiFurnizoriReport.this.plataChooser.setDate(factura.getDate());
                            FacturiFurnizoriReport.this.updateTotalPlataCurenta();
                            TipCheltuiala tc = (TipCheltuiala)FacturiFurnizoriReport.this.contCheltuieli.getCombo().getSelectedItem();
                            FacturiFurnizoriReport.this.detaliiPlata.setText(tc.getNume());
                            FacturiFurnizoriReport.this.adaugaPlataButton.doClick();
                            FacturiFurnizoriReport.this.tabs.setSelectedIndex(2);
                            break;
                        }
                        ++selRow;
                    }
                }
            }
        });
        result.add((Component)adaugaSiPlateste, c);
        adaugaSiPlateste.setMnemonic('a');
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tip cheltuiala"), c);
        this.contCheltuieli = new AddingCombo(new AddingItemInterface(){

            @Override
            public void addButtonPressed() {
                String s = DialogUtils.inputDialog(parent, "", "Tip cheltuiala noua");
                String cont = DialogUtils.inputDialog(parent, "", "Cont Analitic sau sintetic");
                if (!Validators.correctString(s)) {
                    DialogUtils.errorDialog(parent, "Nu ati ales tipul de cheltuiala", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctString(cont)) {
                    if (!DialogUtils.confirmDialog(parent, "Nu ati ales contul. Continuam", LangRoAll.confirmare)) {
                        return;
                    }
                    cont = "";
                }
                ContaLogic.getInstance().addTipCheltuiala(cont, s);
                FacturiFurnizoriReport.this.reloadTipCheltuiala();
            }
        });
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.contCheltuieli, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Serie si nr"), c);
        this.serieFactura = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.serieFactura, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.chooser = new DateAndTimeChooser("Alege data", false);
        result.add((Component)this.chooser, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.salveaza = new JButton(LangRoAll.adauga);
        this.salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FacturiFurnizoriReport.this.adauga(parent);
            }
        });
        result.add((Component)this.salveaza, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.renunta = new JButton(LangRoAll.renunta);
        this.renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FacturiFurnizoriReport.this.setFacturaToEdit(null);
            }
        });
        result.add((Component)this.renunta, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Total general"), c);
        this.totalGeneral = new JTextField(10);
        this.totalGeneral.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String s = FacturiFurnizoriReport.this.totalGeneral.getText();
                if (Validators.correctString(s) && !Validators.correctDouble(s)) {
                    FacturiFurnizoriReport.this.totalGeneral.setText("");
                    FacturiFurnizoriReport.this.totalGeneral.requestFocus();
                }
            }
        });
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.totalGeneral, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.tva), c);
        this.tva = new JComboBox();
        this.tva.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                Tva tva1 = (Tva)FacturiFurnizoriReport.this.tva.getSelectedItem();
                double cota = tva1.getCota();
                String tS = FacturiFurnizoriReport.this.totalGeneral.getText();
                if (Validators.correctDouble(tS)) {
                    double tG = Utils.parseDouble(tS);
                    double valoareFaraTva = tG / (1.0 + cota);
                    double valTva = tG - valoareFaraTva;
                    FacturiFurnizoriReport.this.total.setText(Utils.getString2Decimals(valoareFaraTva));
                    FacturiFurnizoriReport.this.totalTVA.setText(Utils.getString2Decimals(valTva));
                }
            }
        });
        ++c.gridx;
        result.add((Component)this.tva, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Val fara Tva"), c);
        this.total = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.total, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Val Tva"), c);
        this.totalTVA = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.totalTVA, c);
        return result;
    }

    private int adauga(Component parent) {
        int idSocietateaNoastra = -1;
        if (!Validators.correctString(this.serieFactura.getText())) {
            DialogUtils.errorDialog(parent, "Completati seria", LangRoAll.nuPotContinua);
            this.serieFactura.requestFocus();
            return -1;
        }
        double t1 = 0.0;
        String st1 = this.total.getText();
        if (!Validators.correctDouble(st1)) {
            DialogUtils.errorDialog(parent, "Completati totalul", LangRoAll.nuPotContinua);
            this.total.requestFocus();
            return -1;
        }
        t1 = Utils.parseDouble(st1);
        double t2 = 0.0;
        String st2 = this.totalTVA.getText();
        if (!Validators.correctDouble(st2)) {
            DialogUtils.errorDialog(parent, "Completati total TVA", LangRoAll.nuPotContinua);
            this.totalTVA.requestFocus();
            return -1;
        }
        t2 = Utils.parseDouble(st2);
        double t3 = 0.0;
        String st3 = this.totalGeneral.getText();
        if (!Validators.correctDouble(st3)) {
            DialogUtils.errorDialog(parent, "Completati total general", LangRoAll.nuPotContinua);
            this.totalGeneral.requestFocus();
            return -1;
        }
        t3 = Utils.parseDouble(st3);
        String s = this.serieFactura.getText();
        Client f = (Client)this.editFacturaFurnizoriCombo.getSelectedItem();
        Tva t = (Tva)this.tva.getSelectedItem();
        Date d = this.chooser.getDateAndTime();
        Timestamp time = new Timestamp(d.getTime());
        int idTipCheltuiala = -1;
        TipCheltuiala tc = null;
        if (ComboUtils.anythingButAllSelected(this.contCheltuieli.getCombo())) {
            tc = (TipCheltuiala)this.contCheltuieli.getCombo().getSelectedItem();
            idTipCheltuiala = tc.getId();
        }
        int result = -1;
        if (this.toEdit == null) {
            boolean fiscal = true;
            fiscal = this.whatToPrint != 3;
            result = ContaLogic.getInstance().addFacturaFaraNir(f.getId(), s, time, t.getId(), t1, t2, t3, idTipCheltuiala, fiscal, idSocietateaNoastra, ContaLogic.TIP_DOCUMENT_NIR.Factura.getTip(), StockLogic.COMANDA_TYPE.EFECTUAT, time);
        } else {
            this.toEdit.setIdFurnizor(f.getId());
            this.toEdit.setSerieFactura(s);
            this.toEdit.setDateadd(time);
            this.toEdit.setTotal(t1);
            this.toEdit.setTotalTva(t2);
            this.toEdit.setTotalGeneral(t3);
            this.toEdit.setIdTipCheltuiala(idTipCheltuiala);
            ContaLogic.getInstance().updateFacturaFaraNir(this.toEdit);
            result = this.toEdit.getId();
        }
        this.setFacturaToEdit(null);
        this.raport();
        ContaLogic.getInstance().notifyFacturaFaraNir(f.toString(), t3, time, s, tc);
        return result;
    }

    private JPanel getAddPlataPanel() {
        final JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Act casa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.actCasaPlati = new JTextField(25);
        result.add((Component)this.actCasaPlati, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Valoare plata"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.valoarePlata = new JTextField(25);
        this.valoarePlata.setEditable(false);
        result.add((Component)this.valoarePlata, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.cont = new JComboBox();
        result.add((Component)this.cont, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.plataChooser = new DateAndTimeChooser("Alege data platii");
        result.add((Component)this.plataChooser, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Numar anexa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.anexaPlati = new JTextField(25);
        result.add((Component)this.anexaPlati, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Explicatii"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.detaliiPlata = new JTextField(25);
        result.add((Component)this.detaliiPlata, c);
        ++c.gridx;
        JButton renunta = new JButton(LangRoAll.renunta);
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacturiFurnizoriReport.this.actCasaPlati.setText("");
                FacturiFurnizoriReport.this.valoarePlata.setText("");
                FacturiFurnizoriReport.this.detaliiPlata.setText("");
                FacturiFurnizoriReport.this.anexaPlati.setText("");
                FacturiFurnizoriReport.this.plati.clear();
                FacturiFurnizoriReport.this.raport();
            }
        });
        result.add((Component)renunta, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.adaugaPlataButton = new JButton(LangRoAll.adauga);
        this.adaugaPlataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double total = Utils.parseDouble(FacturiFurnizoriReport.this.valoarePlata.getText());
                    String ac = FacturiFurnizoriReport.this.actCasaPlati.getText();
                    String exp = FacturiFurnizoriReport.this.detaliiPlata.getText();
                    String an = FacturiFurnizoriReport.this.anexaPlati.getText();
                    if (!ComboUtils.anythingButAllSelected(FacturiFurnizoriReport.this.cont)) {
                        DialogUtils.errorDialog(result, "Alegeti contul destinatie", LangRoAll.nuPotContinua);
                        FacturiFurnizoriReport.this.cont.requestFocus();
                        return;
                    }
                    TipRegistru tr = (TipRegistru)FacturiFurnizoriReport.this.cont.getSelectedItem();
                    int idCont = tr.getId();
                    Date d = FacturiFurnizoriReport.this.plataChooser.getDateAndTime();
                    if (d == null) {
                        return;
                    }
                    boolean fiscal = true;
                    fiscal = FacturiFurnizoriReport.this.whatToPrint != 3;
                    int tvaId = TvaLogic.getInstance().getTvas().get(0).getId();
                    ContaLogic.getInstance().addPlata(ac, an, exp, total, idCont, d, FacturiFurnizoriReport.this.plati, fiscal, tvaId);
                    Client client = (Client)FacturiFurnizoriReport.this.furnizoriCombo.getSelectedItem();
                    Map o = ContaLogic.getInstance().buildMapForPlata(ac, client.toString(), d, total, an, tr.toString());
                    GenericListenersLogic.getInstance().notifyObjectListeners(97, o);
                    FacturiFurnizoriReport.this.raport();
                    FacturiFurnizoriReport.this.actCasaPlati.setText("");
                    FacturiFurnizoriReport.this.valoarePlata.setText("");
                    FacturiFurnizoriReport.this.detaliiPlata.setText("");
                    FacturiFurnizoriReport.this.anexaPlati.setText("");
                }
                catch (NumberFormatException e1) {
                    DialogUtils.errorDialog(result, "Valoare incorecta", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)this.adaugaPlataButton, c);
        result.setBorder(new TitledBorder("Adauga plata"));
        return result;
    }

    @Override
    public JPanel buildTotalPanel() {
        this.tabs = new JTabbedPane();
        this.tabs.add("Totaluri", this.getTotaluriPanel());
        this.tabs.add("Plata", this.getAddPlataPanel());
        this.tabs.add("Detalii factura", this.getEditFacturaPanel());
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)this.tabs, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Furnizor"), c);
        ++c.gridx;
        this.furnizoriCombo = new JComboBox();
        result.add((Component)this.furnizoriCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        double totalFacturi = 0.0;
        double totalPlatit = 0.0;
        double totalDePlata = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            FacturiNeplatiteEntry o = (FacturiNeplatiteEntry)this.data.elementAt(i);
            totalFacturi += o.getTotal();
            totalPlatit += o.getPlatit();
            totalDePlata += o.getDePlata();
        }
        this.totalFacturiLabel.setText(Utils.getString2Decimals(totalFacturi));
        this.totalPlatitLabel.setText(Utils.getString2Decimals(totalPlatit));
        this.totalDePlataLabel.setText(Utils.getString2Decimals(totalDePlata));
    }

    private void updateTotalPlataCurenta() {
        double totalPlataCurenta = 0.0;
        String detalii = "";
        this.plati.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            FacturiNeplatiteEntry o = (FacturiNeplatiteEntry)this.data.elementAt(i);
            if (Utils.isValueZero(o.getPlatimAcum())) continue;
            totalPlataCurenta += o.getPlatimAcum();
            detalii = detalii + o.getFactura() + "-" + Utils.getString2Decimals(o.getPlatimAcum()) + ", ";
            PlatiEntry pe = new PlatiEntry();
            pe.setIdFactura(o.getIdFactura());
            pe.setSuma(o.getPlatimAcum());
            this.plati.add(pe);
        }
        if (!Utils.isValueZero(totalPlataCurenta)) {
            this.valoarePlata.setText(Utils.getString2Decimals(totalPlataCurenta));
            this.anexaPlati.setText(detalii);
            String furnizor = (String)this.printCriteria.get("Furnizor");
            this.detaliiPlata.setText(furnizor);
        }
        this.tabs.setSelectedIndex(1);
    }

    private void setFacturaToEdit(FacturiNeplatiteEntry fe) {
        if (fe != null) {
            Factura f = ContaLogic.getInstance().getFacturaById(fe.getIdFactura());
            this.serieFactura.setText(f.getSerieFactura());
            this.chooser.setDate(f.getDateadd());
            Client fur = ClientLogic.getInstance().getClientById(f.getIdFurnizor());
            this.editFacturaFurnizoriCombo.setSelectedItem(fur);
            this.salveaza.setText(LangRoAll.salveaza);
            this.total.setText(Utils.getString2Decimals(f.getTotal()));
            this.totalTVA.setText(Utils.getString2Decimals(f.getTotalTva()));
            this.totalGeneral.setText(Utils.getString2Decimals(f.getTotalGeneral()));
            TipCheltuiala tc = ContaLogic.getInstance().getTipCheltuialaById(f.getIdTipCheltuiala());
            if (tc != null) {
                this.contCheltuieli.getCombo().setSelectedItem(tc);
            }
            this.toEdit = f;
        } else {
            this.serieFactura.setText("");
            this.total.setText("");
            this.totalTVA.setText("");
            this.totalGeneral.setText("");
            this.salveaza.setText(LangRoAll.adauga);
            this.toEdit = null;
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.furnizoriCombo, ContaLogic.getInstance().getFurnizori(-1), false);
        ComboUtils.replaceItemsForCombo(this.editFacturaFurnizoriCombo, ContaLogic.getInstance().getFurnizori(-1), false);
        ComboUtils.replaceItemsForCombo(this.tva, TvaLogic.getInstance().getTvas(), false);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 2: {
                        return FacturiFurnizoriReport.this.totalFacturiLabel.getText();
                    }
                    case 3: {
                        return FacturiFurnizoriReport.this.totalPlatitLabel.getText();
                    }
                    case 4: {
                        return FacturiFurnizoriReport.this.totalDePlataLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return FacturiFurnizoriReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FacturiFurnizoriReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)row;
                switch (column) {
                    case 0: {
                        return Formatters.DATE_FORMAT_RO.format(fe.getDate());
                    }
                    case 1: {
                        return fe.getFactura();
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getPlatit());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getDePlata());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.getPlatimAcum());
                    }
                }
                return null;
            }
        };
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(FacturiFurnizoriReport.this.furnizoriCombo, ContaLogic.getInstance().getFurnizori(-1), false);
                ComboUtils.replaceItemsForCombo(FacturiFurnizoriReport.this.editFacturaFurnizoriCombo, ContaLogic.getInstance().getFurnizori(-1), false);
            }

            @Override
            public String getName() {
                return "FacturiFurnizoriReport_furnizori";
            }
        }, 42);
        Vector tipRegistre = ContaLogic.getInstance().getAllTipRegistru(AdministrationPanel.loggedUser.getLanguage());
        ComboUtils.replaceItemsForCombo(this.cont, (Collection)tipRegistre, false);
        final FacturiFurnizoriReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final FacturiNeplatiteEntry fe = (FacturiNeplatiteEntry)FacturiFurnizoriReport.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem plataIntegrala = new JMenuItem("Plata integrala");
                popup.add(plataIntegrala);
                plataIntegrala.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fe.setPlatimAcum(fe.getDePlata());
                        FacturiFurnizoriReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                        FacturiFurnizoriReport.this.updateTotalPlataCurenta();
                        popup.setVisible(false);
                    }
                });
                JMenuItem plataAnterioara = new JMenuItem("Plata anterioara");
                popup.add(plataAnterioara);
                plataAnterioara.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(parent, "Platile anterioare nu se inregistreaza in registru.\nAceasta operatie este ireversibila.\nContinuam", LangRoAll.confirmare)) {
                            ContaLogic.getInstance().platesteFactura(fe.getIdFactura(), 1);
                            FacturiFurnizoriReport.this.raport();
                            popup.setVisible(false);
                        }
                    }
                });
                JMenuItem modifica = new JMenuItem("Modifica factura");
                popup.add(modifica);
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean facturaCuNir = ContaLogic.getInstance().isFacturaCuNir(fe.getIdFactura());
                        if (facturaCuNir) {
                            DialogUtils.errorDialog(parent, "Facturile cu NIR se modifica din modulul de Niruri.", LangRoAll.nuPotContinua);
                        } else {
                            FacturiFurnizoriReport.this.setFacturaToEdit(fe);
                            FacturiFurnizoriReport.this.tabs.setSelectedIndex(2);
                        }
                        popup.setVisible(false);
                    }
                });
                JMenuItem sterge = new JMenuItem("Sterge factura");
                popup.add(sterge);
                sterge.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean facturaCuNir = ContaLogic.getInstance().isFacturaCuNir(fe.getIdFactura());
                        if (facturaCuNir) {
                            DialogUtils.errorDialog(parent, "Facturile cu NIR se sterg din modulul de Niruri.", LangRoAll.nuPotContinua);
                        } else if (DialogUtils.confirmDialog(parent, "Ati verificat registrele pentru factura de sters", LangRoAll.confirmare)) {
                            ContaLogic.getInstance().stergeFacturaFaraNir(fe.getIdFactura());
                            DialogUtils.okDialog(parent, "Operatie efectuata", LangRoAll.succes);
                            FacturiFurnizoriReport.this.raport();
                        }
                        popup.setVisible(false);
                    }
                });
                popup.setInvoker(FacturiFurnizoriReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.reloadTipCheltuiala();
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void reloadTipCheltuiala() {
        ComboUtils.replaceItemsForCombo(this.contCheltuieli.getCombo(), (Collection)ContaLogic.getInstance().getAllTipCheltuiala(), false);
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }
}

